/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.model.data.GradleProjectBuildScriptData;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleLog;

public final class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";

    private GradleUtil() {
    }

    @NotNull
    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, true, false, false, false, false).withExtensionFilter(GradleBundle.message("gradle.filter.label", new Object[0]), GradleConstants.BUILD_FILE_EXTENSIONS);
        if (fileChooserDescriptor2 == null) {
            GradleUtil.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor2;
    }

    public static boolean isGradleDefaultWrapperFilesExist(@Nullable String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    @Nullable
    public static WrapperConfiguration getWrapperConfiguration(@Nullable String gradleProjectPath) {
        Path wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
        if (wrapperPropertiesFile == null) {
            return null;
        }
        return GradleUtil.readWrapperConfiguration(wrapperPropertiesFile);
    }

    @NotNull
    public static WrapperConfiguration generateGradleWrapperConfiguration(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(1);
        }
        WrapperConfiguration configuration = new WrapperConfiguration();
        URI distributionUri = GradleUtil.getWrapperDistributionUri(gradleVersion);
        configuration.setDistribution(distributionUri);
        WrapperConfiguration wrapperConfiguration = configuration;
        if (wrapperConfiguration == null) {
            GradleUtil.$$$reportNull$$$0(2);
        }
        return wrapperConfiguration;
    }

    public static boolean writeWrapperConfiguration(@NotNull Path targetPath, @NotNull WrapperConfiguration wrapperConfiguration) {
        if (targetPath == null) {
            GradleUtil.$$$reportNull$$$0(3);
        }
        if (wrapperConfiguration == null) {
            GradleUtil.$$$reportNull$$$0(4);
        }
        Properties wrapperProperties = new Properties();
        GradleUtil.setFromWrapperConfiguration(wrapperConfiguration, wrapperProperties);
        return GradleUtil.writeGradleProperties(wrapperProperties, targetPath);
    }

    @Nullable
    public static WrapperConfiguration readWrapperConfiguration(@NotNull Path wrapperPropertiesFile) {
        Properties props;
        if (wrapperPropertiesFile == null) {
            GradleUtil.$$$reportNull$$$0(5);
        }
        if ((props = GradleUtil.readGradleProperties(wrapperPropertiesFile)) == null) {
            return null;
        }
        URI uri = GradleUtil.parseDistributionUri(props, wrapperPropertiesFile);
        if (uri == null) {
            return null;
        }
        WrapperConfiguration wrapperConfiguration = new WrapperConfiguration();
        GradleUtil.setToWrapperConfiguration(wrapperConfiguration, uri, props);
        return wrapperConfiguration;
    }

    public static void setToWrapperConfiguration(@NotNull WrapperConfiguration target, @NotNull URI disributionUri, @NotNull Properties source) {
        if (target == null) {
            GradleUtil.$$$reportNull$$$0(6);
        }
        if (disributionUri == null) {
            GradleUtil.$$$reportNull$$$0(7);
        }
        if (source == null) {
            GradleUtil.$$$reportNull$$$0(8);
        }
        target.setDistribution(disributionUri);
        GradleUtil.applyPropertyValue(source, "distributionPath", arg_0 -> ((WrapperConfiguration)target).setDistributionPath(arg_0));
        GradleUtil.applyPropertyValue(source, "distributionBase", arg_0 -> ((WrapperConfiguration)target).setDistributionBase(arg_0));
        GradleUtil.applyPropertyValue(source, "zipStorePath", arg_0 -> ((WrapperConfiguration)target).setZipPath(arg_0));
        GradleUtil.applyPropertyValue(source, "zipStoreBase", arg_0 -> ((WrapperConfiguration)target).setZipBase(arg_0));
    }

    public static void setFromWrapperConfiguration(@NotNull WrapperConfiguration source, @NotNull Properties target) {
        if (source == null) {
            GradleUtil.$$$reportNull$$$0(9);
        }
        if (target == null) {
            GradleUtil.$$$reportNull$$$0(10);
        }
        target.setProperty("distributionUrl", source.getDistribution().toString());
        target.setProperty("distributionBase", source.getDistributionBase());
        target.setProperty("distributionPath", source.getDistributionPath());
        target.setProperty("zipStoreBase", source.getZipBase());
        target.setProperty("zipStorePath", source.getZipPath());
    }

    @Nullable
    public static Properties readGradleProperties(@NotNull Path propertiesFile) {
        block11: {
            Properties properties;
            block10: {
                if (propertiesFile == null) {
                    GradleUtil.$$$reportNull$$$0(11);
                }
                BufferedReader reader2 = Files.newBufferedReader(propertiesFile, StandardCharsets.ISO_8859_1);
                try {
                    Properties props = new Properties();
                    props.load(reader2);
                    properties = props;
                    if (reader2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader2 != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException reader2) {
                        break block11;
                    }
                    catch (IOException e) {
                        GradleLog.LOG.warn(String.format("I/O exception on reading gradle properties file at '%s'", propertiesFile.toAbsolutePath()), (Throwable)e);
                    }
                }
                reader2.close();
            }
            return properties;
        }
        return null;
    }

    private static boolean writeGradleProperties(@NotNull Properties properties, @NotNull Path propertiesFile) {
        boolean bl;
        block10: {
            if (properties == null) {
                GradleUtil.$$$reportNull$$$0(12);
            }
            if (propertiesFile == null) {
                GradleUtil.$$$reportNull$$$0(13);
            }
            BufferedWriter writer = Files.newBufferedWriter(propertiesFile, StandardCharsets.ISO_8859_1, new OpenOption[0]);
            try {
                properties.store(writer, null);
                bl = true;
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    GradleLog.LOG.warn(String.format("I/O exception on writing Gradle properties into '%s'", propertiesFile.toAbsolutePath()), (Throwable)e);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    private static void applyPropertyValue(@NotNull Properties props, @NotNull String propertyName, @NotNull @NotNull Consumer<@NotNull String> valueConsumer) {
        String value;
        if (props == null) {
            GradleUtil.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            GradleUtil.$$$reportNull$$$0(15);
        }
        if (valueConsumer == null) {
            GradleUtil.$$$reportNull$$$0(16);
        }
        if (!StringUtil.isEmpty((String)(value = props.getProperty(propertyName)))) {
            valueConsumer.accept(value.trim());
        }
    }

    @Nullable
    private static URI parseDistributionUri(@NotNull Properties props, @NotNull Path propertiesFile) {
        String distributionUrl;
        if (props == null) {
            GradleUtil.$$$reportNull$$$0(17);
        }
        if (propertiesFile == null) {
            GradleUtil.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmpty((String)(distributionUrl = props.getProperty("distributionUrl")))) {
            GradleLog.LOG.warn(String.format("Wrapper 'distributionUrl' property does not exist in file '%s'", propertiesFile.toAbsolutePath()));
            return null;
        }
        try {
            URI source = new URI(distributionUrl);
            return source.getScheme() != null ? source : propertiesFile.resolveSibling(source.getSchemeSpecificPart()).toUri();
        }
        catch (URISyntaxException e) {
            GradleLog.LOG.warn(String.format("Unable to resolve Gradle distribution path '%s' in file '%s'", distributionUrl, propertiesFile.toAbsolutePath()));
            return null;
        }
    }

    @NotNull
    public static URI getWrapperDistributionUri(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(19);
        }
        String gradleServicesUrl = GradleEnvironment.Urls.GRADLE_SERVICES_URL;
        String distributionSource = gradleVersion.isSnapshot() ? "distributions-snapshots" : "distributions";
        String gradleVersionString = gradleVersion.getVersion();
        try {
            return new URI(String.format("%s/%s/gradle-%s-bin.zip", gradleServicesUrl, distributionSource, gradleVersionString));
        }
        catch (URISyntaxException e) {
            throw new ExternalSystemException((Throwable)e);
        }
    }

    @NotNull
    public static String getConfigPath(@NotNull GradleProject subProject, @NotNull String rootProjectPath) {
        block9: {
            String string;
            if (subProject == null) {
                GradleUtil.$$$reportNull$$$0(20);
            }
            if (rootProjectPath == null) {
                GradleUtil.$$$reportNull$$$0(21);
            }
            try {
                File file;
                GradleScript script = subProject.getBuildScript();
                if (script == null || (file = script.getSourceFile()) == null) break block9;
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                string = ExternalSystemApiUtil.toCanonicalPath((String)file.getPath());
            }
            catch (Exception script) {
                // empty catch block
            }
            if (string == null) {
                GradleUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = new Stack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        String string = buffer.toString();
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String getLastUsedGradleHome() {
        String string = PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static void storeLastUsedGradleHome(@Nullable String gradleHomePath) {
        PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path findDefaultWrapperPropertiesFile(@Nullable String gradleProjectPath) {
        Path gradleDir;
        if (gradleProjectPath == null) {
            return null;
        }
        Path file = Path.of(gradleProjectPath, new String[0]);
        Path path2 = gradleDir = Files.isRegularFile(file, new LinkOption[0]) ? file.resolveSibling("gradle") : file.resolve("gradle");
        if (!Files.isDirectory(gradleDir, new LinkOption[0])) {
            return null;
        }
        Path wrapperDir = gradleDir.resolve("wrapper");
        if (!Files.isDirectory(wrapperDir, new LinkOption[0])) {
            return null;
        }
        try (Stream<Path> pathsStream = Files.list(wrapperDir);){
            List<Path> candidates = pathsStream.filter(path -> FileUtilRt.extensionEquals((String)path.getFileName().toString(), (String)"properties") && Files.isRegularFile(path, new LinkOption[0])).toList();
            if (candidates.isEmpty()) {
                GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir);
                Path path3 = null;
                return path3;
            }
            if (candidates.size() != 1) {
                GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.size(), wrapperDir, StringUtil.join(candidates, (String)", ")));
                Path path4 = null;
                return path4;
            }
            Path path5 = candidates.get(0);
            return path5;
        }
        catch (IOException e) {
            GradleLog.LOG.warn("Couldn't list gradle wrapper directory " + wrapperDir, (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String determineRootProject(@NotNull String subProjectPath) {
        Path subProject;
        block7: {
            if (subProjectPath == null) {
                GradleUtil.$$$reportNull$$$0(25);
            }
            Path candidate = subProject = Paths.get(subProjectPath, new String[0]);
            while (true) {
                block8: {
                    if (candidate == null || candidate == candidate.getParent()) break block7;
                    if (!GradleUtil.containsGradleSettingsFile(candidate)) break block8;
                    String string = candidate.toString();
                    if (string == null) {
                        GradleUtil.$$$reportNull$$$0(26);
                    }
                    return string;
                }
                candidate = candidate.getParent();
                continue;
                break;
            }
            catch (IOException e) {
                GradleLog.LOG.warn("Failed to determine root Gradle project directory for [" + subProjectPath + "]", (Throwable)e);
            }
        }
        String string = Files.isDirectory(subProject, new LinkOption[0]) ? subProjectPath : subProject.getParent().toString();
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static boolean containsGradleSettingsFile(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);){
            boolean bl = stream.map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).anyMatch(name -> name.startsWith("settings.gradle"));
            return bl;
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Module module) {
        String projectPath;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(28);
        }
        if ((projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module)) == null) {
            return null;
        }
        Project project2 = module.getProject();
        return GradleUtil.findGradleModuleData(project2, projectPath);
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Project project2, @NotNull String projectPath) {
        if (project2 == null) {
            GradleUtil.$$$reportNull$$$0(29);
        }
        if (projectPath == null) {
            GradleUtil.$$$reportNull$$$0(30);
        }
        return ExternalSystemApiUtil.findModuleNode((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project2, @NotNull String projectPath) {
        DataNode moduleNode;
        if (project2 == null) {
            GradleUtil.$$$reportNull$$$0(31);
        }
        if (projectPath == null) {
            GradleUtil.$$$reportNull$$$0(32);
        }
        if ((moduleNode = ExternalSystemApiUtil.findModuleNode((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath)) == null) {
            return null;
        }
        return GradleUtil.findGradleModule(project2, (ModuleData)moduleNode.getData());
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project2, @NotNull ProjectData projectData) {
        if (project2 == null) {
            GradleUtil.$$$reportNull$$$0(33);
        }
        if (projectData == null) {
            GradleUtil.$$$reportNull$$$0(34);
        }
        return GradleUtil.findGradleModule(project2, projectData.getLinkedExternalProjectPath());
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project2, @NotNull ModuleData moduleData) {
        if (project2 == null) {
            GradleUtil.$$$reportNull$$$0(35);
        }
        if (moduleData == null) {
            GradleUtil.$$$reportNull$$$0(36);
        }
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project2);
        return modelsProvider.findIdeModule(moduleData);
    }

    @NotNull
    public static GradleVersion getGradleVersion(Project project2, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            String filePath = virtualFile.getPath();
            return GradleUtil.getGradleVersion(project2, filePath);
        }
        GradleVersion gradleVersion = GradleVersion.current();
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(37);
        }
        return gradleVersion;
    }

    @NotNull
    public static GradleVersion getGradleVersion(Project project2, String filePath) {
        GradleSettings settings;
        GradleProjectSettings projectSettings;
        GradleManager gradleManager;
        String externalProjectPath2;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (manager instanceof GradleManager && (externalProjectPath2 = (gradleManager = (GradleManager)manager).getAffectedExternalProjectPath(filePath, project2)) != null && (projectSettings = (GradleProjectSettings)(settings = GradleSettings.getInstance(project2)).getLinkedProjectSettings(externalProjectPath2)) != null) {
            GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
            if (gradleVersion == null) {
                GradleUtil.$$$reportNull$$$0(38);
            }
            return gradleVersion;
        }
        GradleVersion gradleVersion = GradleVersion.current();
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(39);
        }
        return gradleVersion;
    }

    public static boolean isSupportedImplementationScope(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            GradleUtil.$$$reportNull$$$0(40);
        }
        return GradleVersionUtil.isGradleAtLeast((GradleVersion)gradleVersion, (String)"3.4");
    }

    @Nullable
    public static VirtualFile getGradleBuildScriptSource(@NotNull Module module) {
        DataNode<ModuleData> moduleData;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(41);
        }
        if ((moduleData = GradleUtil.findGradleModuleData(module)) == null) {
            return null;
        }
        DataNode dataNode = ExternalSystemApiUtil.find(moduleData, GradleProjectBuildScriptData.KEY);
        if (dataNode == null) {
            return null;
        }
        File data = ((GradleProjectBuildScriptData)dataNode.getData()).getBuildScriptSource();
        if (data == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)data, (boolean)true);
    }

    public static void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        ContentRootData excludedContentRootData;
        DataNode contentRootDataDataNode;
        if (ideModule == null) {
            GradleUtil.$$$reportNull$$$0(42);
        }
        if ((contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) == null || !GradleUtil.isContentRootAncestor((ContentRootData)contentRootDataDataNode.getData(), ideaOutDir)) {
            excludedContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getPath());
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
        } else {
            excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
        }
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getPath());
    }

    public static void unexcludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        DataNode contentRootDataDataNode;
        if (ideModule == null) {
            GradleUtil.$$$reportNull$$$0(43);
        }
        if ((contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) != null && GradleUtil.isContentRootAncestor((ContentRootData)contentRootDataDataNode.getData(), ideaOutDir)) {
            ContentRootData excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
            excludedContentRootData.getPaths(ExternalSystemSourceType.EXCLUDED).removeIf(sourceRoot -> sourceRoot.getPath().equals(ideaOutDir.getPath()));
        }
    }

    private static boolean isContentRootAncestor(@NotNull ContentRootData data, @NotNull File ideaOutDir) {
        if (data == null) {
            GradleUtil.$$$reportNull$$$0(44);
        }
        if (ideaOutDir == null) {
            GradleUtil.$$$reportNull$$$0(45);
        }
        String canonicalIdeOutPath = FileUtil.toCanonicalPath((String)ideaOutDir.getPath());
        String canonicalRootPath = data.getRootPath();
        return FileUtil.isAncestor((String)canonicalRootPath, (String)canonicalIdeOutPath, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 25, 28, 29, 30, 31, 32, 33, 34, 35, 36, 40, 41, 42, 43, 44, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleUtil";
                break;
            }
            case 1: 
            case 19: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperPropertiesFile";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disributionUri";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConsumer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProject";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProjectPath";
                break;
            }
            case 28: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaOutDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleProjectFileChooserDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateGradleWrapperConfiguration";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastUsedGradleHome";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "determineRootProject";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateGradleWrapperConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeWrapperConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readWrapperConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setToWrapperConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFromWrapperConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readGradleProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeGradleProperties";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyPropertyValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseDistributionUri";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperDistributionUri";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getConfigPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "determineRootProject";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findGradleModuleData";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findGradleModule";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedImplementationScope";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildScriptSource";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "excludeOutDir";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "unexcludeOutDir";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isContentRootAncestor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 25, 28, 29, 30, 31, 32, 33, 34, 35, 36, 40, 41, 42, 43, 44, 45 -> new IllegalArgumentException(string);
        };
    }
}

