/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.FieldImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ModuleReferenceImpl;
import com.jetbrains.jdi.ObsoleteMethodImpl;
import com.jetbrains.jdi.SDE;
import com.jetbrains.jdi.TypeImpl;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ModuleReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class ReferenceTypeImpl
extends TypeImpl
implements ReferenceType {
    protected final long ref;
    private String signature = null;
    private volatile String baseSourceName = null;
    private String baseSourcePath = null;
    protected int modifiers = -1;
    private final Object cachesLock = new Object();
    private volatile SoftReference<Field[]> fieldsRef = null;
    private volatile SoftReference<Method[]> methodsRef = null;
    private volatile SoftReference<SDE> sdeRef = null;
    private ClassLoaderReference classLoader = null;
    private ClassObjectReference classObject = null;
    private int status = 0;
    private boolean isPrepared = false;
    private volatile boolean constantPoolInfoGotten = false;
    private volatile int constanPoolCount;
    private volatile SoftReference<byte[]> constantPoolBytesRef = null;
    private static final String ABSENT_BASE_SOURCE_NAME = "**ABSENT_BASE_SOURCE_NAME**";
    static final SDE NO_SDE_INFO_MARK = new SDE();
    private static final int INITIALIZED_OR_FAILED = 12;

    protected ReferenceTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm);
        this.ref = aRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noticeRedefineClass() {
        this.baseSourceName = null;
        this.baseSourcePath = null;
        this.modifiers = -1;
        Object object = this.cachesLock;
        synchronized (object) {
            this.fieldsRef = null;
            Method[] methods = this.getFromCache(this.methodsRef);
            if (methods != null) {
                for (Method method : methods) {
                    ((MethodImpl)method).noticeRedefineClass();
                }
            }
            this.methodsRef = null;
            this.sdeRef = null;
        }
        this.constantPoolInfoGotten = false;
    }

    Method getMethodMirror(long ref) {
        if (ref == 0L) {
            return new ObsoleteMethodImpl(this.vm, this);
        }
        for (Method value : this.methods()) {
            MethodImpl method = (MethodImpl)value;
            if (method.ref() != ref) continue;
            return method;
        }
        throw new IllegalArgumentException("Invalid method id: " + ref);
    }

    CompletableFuture<Method> getMethodMirrorAsync(long ref) {
        if (ref == 0L) {
            return CompletableFuture.completedFuture(new ObsoleteMethodImpl(this.vm, this));
        }
        return this.methodsAsync().thenApply(methods -> {
            for (Method value : methods) {
                MethodImpl method = (MethodImpl)value;
                if (method.ref() != ref) continue;
                return method;
            }
            throw new IllegalArgumentException("Invalid method id: " + ref);
        });
    }

    Field getFieldMirror(long ref) {
        for (Field value : this.fields()) {
            FieldImpl field = (FieldImpl)value;
            if (field.ref() != ref) continue;
            return field;
        }
        throw new IllegalArgumentException("Invalid field id: " + ref);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl other = (ReferenceTypeImpl)obj;
            return this.ref() == other.ref() && this.vm.equals(other.virtualMachine());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.ref());
    }

    @Override
    public int compareTo(ReferenceType object) {
        ReferenceTypeImpl other = (ReferenceTypeImpl)object;
        int comp = this.name().compareTo(other.name());
        if (comp == 0) {
            long rf2;
            long rf1 = this.ref();
            comp = rf1 == (rf2 = other.ref()) ? this.vm.sequenceNumber - ((VirtualMachineImpl)other.virtualMachine()).sequenceNumber : (rf1 < rf2 ? -1 : 1);
        }
        return comp;
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            try {
                this.setSignature(JDWP.ReferenceType.Signature.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).signature);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.signature;
    }

    @Override
    public String genericSignature() {
        JDWP.ReferenceType.SignatureWithGeneric result;
        if (!this.vm.canGet1_5LanguageFeatures()) {
            return null;
        }
        try {
            result = JDWP.ReferenceType.SignatureWithGeneric.process(this.vm, this);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.setSignature(result.signature);
        return result.genericSignature;
    }

    @Override
    public ClassLoaderReference classLoader() {
        if (this.classLoader == null) {
            try {
                ClassLoaderReferenceImpl res = JDWP.ReferenceType.ClassLoader.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).classLoader;
                this.classLoader = ReferenceTypeImpl.notnullize(res, ClassLoaderReferenceImpl.NULL);
                return res;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return ReferenceTypeImpl.nullize(this.classLoader, ClassLoaderReferenceImpl.NULL);
    }

    @Override
    public ModuleReference module() {
        try {
            ModuleReferenceImpl m = JDWP.ReferenceType.Module.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).module;
            return this.vm.getModule(m.ref());
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public boolean isPublic() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 1) > 0;
    }

    @Override
    public boolean isProtected() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 4) > 0;
    }

    @Override
    public boolean isPrivate() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 2) > 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public boolean isAbstract() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 0x400) > 0;
    }

    @Override
    public boolean isFinal() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 0x10) > 0;
    }

    @Override
    public boolean isStatic() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 8) > 0;
    }

    @Override
    public boolean isPrepared() {
        if (this.status == 0) {
            this.updateStatus();
        }
        return this.isPrepared;
    }

    @Override
    public boolean isVerified() {
        if ((this.status & 1) == 0) {
            this.updateStatus();
        }
        return (this.status & 1) != 0;
    }

    @Override
    public boolean isInitialized() {
        if ((this.status & 0xC) == 0) {
            this.updateStatus();
        }
        return (this.status & 4) != 0;
    }

    @Override
    public boolean failedToInitialize() {
        if ((this.status & 0xC) == 0) {
            this.updateStatus();
        }
        return (this.status & 8) != 0;
    }

    private Field[] readFields(JDWP.ReferenceType.Fields.FieldInfo[] jdwpFields) {
        return (Field[])Arrays.stream(jdwpFields).map(fi -> new FieldImpl(this.vm, this, fi.fieldID, fi.name, fi.signature, null, fi.modBits)).toArray(Field[]::new);
    }

    private Field[] readFieldsWithGenerics(JDWP.ReferenceType.FieldsWithGeneric.FieldInfo[] jdwpFields) {
        return (Field[])Arrays.stream(jdwpFields).map(fi -> new FieldImpl(this.vm, this, fi.fieldID, fi.name, fi.signature, fi.genericSignature, fi.modBits)).toArray(Field[]::new);
    }

    public CompletableFuture<List<Field>> fieldsAsync() {
        Field[] fields = this.getFromCache(this.fieldsRef);
        if (fields != null) {
            return CompletableFuture.completedFuture(this.unmodifiableList(fields));
        }
        CompletionStage array = this.vm.canGet1_5LanguageFeatures() ? JDWP.ReferenceType.FieldsWithGeneric.processAsync(this.vm, this).thenApply(r -> this.readFieldsWithGenerics(r.declared)) : JDWP.ReferenceType.Fields.processAsync(this.vm, this).thenApply(r -> this.readFields(r.declared));
        return ((CompletableFuture)array).thenApply(res -> {
            res = this.tryToCache(this.fieldsRef, res, v -> {
                this.fieldsRef = v;
            });
            return this.unmodifiableList((T[])res);
        });
    }

    @Override
    public List<Field> fields() {
        Field[] fields = this.getFromCache(this.fieldsRef);
        if (fields == null) {
            if (this.vm.canGet1_5LanguageFeatures()) {
                JDWP.ReferenceType.FieldsWithGeneric.FieldInfo[] jdwpFields;
                try {
                    jdwpFields = JDWP.ReferenceType.FieldsWithGeneric.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                fields = this.readFieldsWithGenerics(jdwpFields);
            } else {
                JDWP.ReferenceType.Fields.FieldInfo[] jdwpFields;
                try {
                    jdwpFields = JDWP.ReferenceType.Fields.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                fields = this.readFields(jdwpFields);
            }
            fields = this.tryToCache(this.fieldsRef, fields, v -> {
                this.fieldsRef = v;
            });
        }
        return this.unmodifiableList(fields);
    }

    abstract List<? extends ReferenceType> inheritedTypes();

    abstract CompletableFuture<List<? extends ReferenceType>> inheritedTypesAsync();

    void addVisibleFields(List<Field> visibleList, Map<String, Field> visibleTable, List<String> ambiguousNames) {
        for (Field field : this.visibleFields()) {
            String name = field.name();
            if (ambiguousNames.contains(name)) continue;
            Field duplicate = visibleTable.get(name);
            if (duplicate == null) {
                visibleList.add(field);
                visibleTable.put(name, field);
                continue;
            }
            if (field.equals(duplicate)) continue;
            ambiguousNames.add(name);
            visibleTable.remove(name);
            visibleList.remove(duplicate);
        }
    }

    @Override
    public List<Field> visibleFields() {
        ArrayList<Field> visibleList = new ArrayList<Field>();
        HashMap<String, Field> visibleTable = new HashMap<String, Field>();
        ArrayList<String> ambiguousNames = new ArrayList<String>();
        for (ReferenceType referenceType : this.inheritedTypes()) {
            ReferenceTypeImpl type = (ReferenceTypeImpl)referenceType;
            type.addVisibleFields(visibleList, visibleTable, ambiguousNames);
        }
        ArrayList<Field> retList = new ArrayList<Field>(this.fields());
        for (Field field : retList) {
            Field hidden = (Field)visibleTable.get(field.name());
            if (hidden == null) continue;
            visibleList.remove(hidden);
        }
        retList.addAll(visibleList);
        return retList;
    }

    void addAllFields(List<Field> fieldList, Set<ReferenceType> typeSet) {
        if (!typeSet.contains(this)) {
            typeSet.add(this);
            fieldList.addAll(this.fields());
            for (ReferenceType referenceType : this.inheritedTypes()) {
                ReferenceTypeImpl type = (ReferenceTypeImpl)referenceType;
                type.addAllFields(fieldList, typeSet);
            }
        }
    }

    CompletableFuture<List<Field>> addAllFieldsAsync(List<Field> fieldList, Set<ReferenceType> typeSet) {
        return this.collectRecursively(ReferenceTypeImpl::fieldsAsync, fieldList, typeSet);
    }

    CompletableFuture<List<Method>> addAllMethodsAsync(List<Method> methodList, Set<ReferenceType> typeSet) {
        return this.collectRecursively(ReferenceTypeImpl::methodsAsync, methodList, typeSet);
    }

    private <T> CompletableFuture<List<T>> collectRecursively(Function<ReferenceTypeImpl, CompletableFuture<List<T>>> func, List<T> list, Set<ReferenceType> typeSet) {
        if (!typeSet.contains(this)) {
            typeSet.add(this);
            return ((CompletableFuture)((CompletableFuture)func.apply(this).thenAccept(list::addAll)).thenCompose(__ -> this.inheritedTypesAsync())).thenCompose(types -> {
                CompletionStage<List<Object>> res = CompletableFuture.completedFuture(list);
                for (ReferenceType referenceType : types) {
                    res = res.thenCombine((CompletionStage)((ReferenceTypeImpl)referenceType).collectRecursively(func, list, typeSet), (f, f2) -> list);
                }
                return res;
            });
        }
        return CompletableFuture.completedFuture(list);
    }

    @Override
    public List<Field> allFields() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<ReferenceType> typeSet = new HashSet<ReferenceType>();
        this.addAllFields(fieldList, typeSet);
        return fieldList;
    }

    public CompletableFuture<List<Field>> allFieldsAsync() {
        List<Field> fieldList = Collections.synchronizedList(new ArrayList());
        Set<ReferenceType> typeSet = Collections.synchronizedSet(new HashSet());
        return this.addAllFieldsAsync(fieldList, typeSet);
    }

    @Override
    public Field fieldByName(String fieldName) {
        List<Field> searchList = this.visibleFields();
        for (Field f : searchList) {
            if (!f.name().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    private Method[] readMethods(JDWP.ReferenceType.Methods.MethodInfo[] jdwpMethods) {
        return (Method[])Arrays.stream(jdwpMethods).map(mi -> MethodImpl.createMethodImpl(this.vm, this, mi.methodID, mi.name, mi.signature, null, mi.modBits)).toArray(Method[]::new);
    }

    private Method[] readMethodsWithGeneric(JDWP.ReferenceType.MethodsWithGeneric.MethodInfo[] jdwpMethods) {
        return (Method[])Arrays.stream(jdwpMethods).map(mi -> MethodImpl.createMethodImpl(this.vm, this, mi.methodID, mi.name, mi.signature, mi.genericSignature, mi.modBits)).toArray(Method[]::new);
    }

    public CompletableFuture<List<Method>> methodsAsync() {
        Method[] methods = this.getFromCache(this.methodsRef);
        if (methods != null) {
            return CompletableFuture.completedFuture(this.unmodifiableList(methods));
        }
        CompletionStage array = !this.vm.canGet1_5LanguageFeatures() ? JDWP.ReferenceType.Methods.processAsync(this.vm, this).thenApply(m -> this.readMethods(m.declared)) : JDWP.ReferenceType.MethodsWithGeneric.processAsync(this.vm, this).thenApply(m -> this.readMethodsWithGeneric(m.declared));
        return ((CompletableFuture)array).thenApply(res -> {
            res = this.tryToCache(this.methodsRef, res, n -> {
                this.methodsRef = n;
            });
            return this.unmodifiableList((T[])res);
        });
    }

    @Override
    public List<Method> methods() {
        Method[] methods = this.getFromCache(this.methodsRef);
        if (methods == null) {
            if (!this.vm.canGet1_5LanguageFeatures()) {
                JDWP.ReferenceType.Methods.MethodInfo[] declared;
                try {
                    declared = JDWP.ReferenceType.Methods.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                methods = this.readMethods(declared);
            } else {
                JDWP.ReferenceType.MethodsWithGeneric.MethodInfo[] declared;
                try {
                    declared = JDWP.ReferenceType.MethodsWithGeneric.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                methods = this.readMethodsWithGeneric(declared);
            }
            methods = this.tryToCache(this.methodsRef, methods, n -> {
                this.methodsRef = n;
            });
        }
        return this.unmodifiableList(methods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getFromCache(SoftReference<T> cache) {
        Object object = this.cachesLock;
        synchronized (object) {
            return ReferenceTypeImpl.dereference(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T tryToCache(SoftReference<T> cache, T value, Consumer<SoftReference<T>> setter) {
        Object object = this.cachesLock;
        synchronized (object) {
            T current = ReferenceTypeImpl.dereference(cache);
            if (current != null) {
                return current;
            }
            setter.accept(this.vm.createSoftReference(value));
            return value;
        }
    }

    void addToMethodMap(Map<String, Method> methodMap, List<Method> methodList) {
        for (Method method : methodList) {
            methodMap.put(method.name().concat(method.signature()), method);
        }
    }

    abstract void addVisibleMethods(Map<String, Method> var1, Set<InterfaceType> var2);

    @Override
    public List<Method> visibleMethods() {
        HashMap<String, Method> map = new HashMap<String, Method>();
        this.addVisibleMethods(map, new HashSet<InterfaceType>());
        List<Method> list = this.allMethods();
        list.retainAll(new HashSet(map.values()));
        return list;
    }

    @Override
    public abstract List<Method> allMethods();

    public CompletableFuture<List<Method>> allMethodsAsync() {
        List<Method> methodList = Collections.synchronizedList(new ArrayList());
        Set<ReferenceType> typeSet = Collections.synchronizedSet(new HashSet());
        return this.addAllMethodsAsync(methodList, typeSet);
    }

    @Override
    public List<Method> methodsByName(String name) {
        List<Method> methods = this.visibleMethods();
        ArrayList<Method> retList = new ArrayList<Method>(methods.size());
        for (Method candidate : methods) {
            if (!candidate.name().equals(name)) continue;
            retList.add(candidate);
        }
        retList.trimToSize();
        return retList;
    }

    @Override
    public List<Method> methodsByName(String name, String signature) {
        List<Method> methods = this.visibleMethods();
        ArrayList<Method> retList = new ArrayList<Method>(methods.size());
        for (Method candidate : methods) {
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature)) continue;
            retList.add(candidate);
        }
        retList.trimToSize();
        return retList;
    }

    InterfaceType[] getInterfaces() {
        try {
            return JDWP.ReferenceType.Interfaces.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).interfaces;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    CompletableFuture<InterfaceType[]> getInterfacesAsync() {
        return JDWP.ReferenceType.Interfaces.processAsync(this.vm, this).thenApply(r -> r.interfaces);
    }

    <T> List<T> unmodifiableList(T[] array) {
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    @Override
    public List<ReferenceType> nestedTypes() {
        ArrayList<ReferenceType> nested = new ArrayList<ReferenceType>();
        String outername = this.name();
        int outerlen = outername.length();
        this.vm.forEachClass(refType -> {
            char c;
            String name = refType.name();
            int len = name.length();
            if (len > outerlen && name.startsWith(outername) && ((c = name.charAt(outerlen)) == '$' || c == '#')) {
                nested.add((ReferenceType)refType);
            }
        });
        return nested;
    }

    public CompletableFuture<Value> getValueAsync(Field sig) {
        return this.getValuesAsync(Collections.singletonList(sig)).thenApply(m -> (Value)m.get(sig));
    }

    @Override
    public Value getValue(Field sig) {
        return this.getValues(Collections.singletonList(sig)).get(sig);
    }

    void validateFieldAccess(Field field) {
        ReferenceTypeImpl declType = (ReferenceTypeImpl)field.declaringType();
        if (!declType.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid field");
        }
    }

    void validateFieldSet(Field field) {
        this.validateFieldAccess(field);
        if (field.isFinal()) {
            throw new IllegalArgumentException("Cannot set value of final field");
        }
    }

    public CompletableFuture<Map<Field, Value>> getValuesAsync(List<? extends Field> theFields) {
        this.validateMirrors(theFields);
        int size = theFields.size();
        JDWP.ReferenceType.GetValues.Field[] queryFields = new JDWP.ReferenceType.GetValues.Field[size];
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)theFields.get(i);
            this.validateFieldAccess(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Attempt to use non-static field with ReferenceType");
            }
            queryFields[i] = new JDWP.ReferenceType.GetValues.Field(field.ref());
        }
        return JDWP.ReferenceType.GetValues.processAsync(this.vm, this, queryFields).thenApply(r -> {
            ValueImpl[] values = r.values;
            if (size != values.length) {
                throw new InternalException("Wrong number of values returned from target VM");
            }
            HashMap<FieldImpl, ValueImpl> map = new HashMap<FieldImpl, ValueImpl>(size);
            for (int i = 0; i < size; ++i) {
                FieldImpl field = (FieldImpl)theFields.get(i);
                map.put(field, values[i]);
            }
            return map;
        });
    }

    @Override
    public Map<Field, Value> getValues(List<? extends Field> theFields) {
        ValueImpl[] values;
        this.validateMirrors(theFields);
        int size = theFields.size();
        JDWP.ReferenceType.GetValues.Field[] queryFields = new JDWP.ReferenceType.GetValues.Field[size];
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)theFields.get(i);
            this.validateFieldAccess(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Attempt to use non-static field with ReferenceType");
            }
            queryFields[i] = new JDWP.ReferenceType.GetValues.Field(field.ref());
        }
        HashMap<Field, Value> map = new HashMap<Field, Value>(size);
        try {
            values = JDWP.ReferenceType.GetValues.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this, (JDWP.ReferenceType.GetValues.Field[])queryFields).values;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        if (size != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)theFields.get(i);
            map.put(field, values[i]);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassObjectReference classObject() {
        if (this.classObject == null) {
            ReferenceTypeImpl referenceTypeImpl = this;
            synchronized (referenceTypeImpl) {
                if (this.classObject == null) {
                    try {
                        this.classObject = JDWP.ReferenceType.ClassObject.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).classObject;
                    }
                    catch (JDWPException exc) {
                        throw exc.toJDIException();
                    }
                }
            }
        }
        return this.classObject;
    }

    SDE.Stratum stratum(String stratumID) {
        SDE sde = this.sourceDebugExtensionInfo();
        if (!sde.isValid()) {
            sde = NO_SDE_INFO_MARK;
        }
        return sde.stratum(stratumID);
    }

    CompletableFuture<SDE.Stratum> stratumAsync(String stratumID) {
        return this.sourceDebugExtensionInfoAsync().thenApply(sde -> {
            if (!sde.isValid()) {
                sde = NO_SDE_INFO_MARK;
            }
            return sde.stratum(stratumID);
        });
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return this.sourceNames(this.vm.getDefaultStratum()).get(0);
    }

    public CompletableFuture<String> sourceNameAsync() {
        return this.sourceNamesAsync(this.vm.getDefaultStratum()).thenApply(strings -> (String)strings.get(0));
    }

    @Override
    public List<String> sourceNames(String stratumID) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(stratumID);
        if (stratum.isJava()) {
            return List.of(this.baseSourceName());
        }
        return stratum.sourceNames(this);
    }

    public CompletableFuture<List<String>> sourceNamesAsync(String stratumID) {
        return this.stratumAsync(stratumID).thenCompose(stratum -> {
            if (stratum.isJava()) {
                return this.baseSourceNameAsync().thenApply(List::of);
            }
            return CompletableFuture.completedFuture(stratum.sourceNames(this));
        });
    }

    @Override
    public List<String> sourcePaths(String stratumID) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(stratumID);
        if (stratum.isJava()) {
            return List.of(this.baseSourceDir() + this.baseSourceName());
        }
        return stratum.sourcePaths(this);
    }

    public boolean hasMappedLineTo(String stratumID, int njplsLine, Predicate<String> sourcePathFilter) {
        SDE sde = this.sourceDebugExtensionInfo();
        return this.hasMappedLineTo(sde, stratumID, sourcePathFilter, njplsLine);
    }

    public CompletableFuture<Boolean> hasMappedLineToAsync(String stratumID, int njplsLine, Predicate<String> sourcePathFilter) {
        return this.sourceDebugExtensionInfoAsync().thenApply(sde -> this.hasMappedLineTo((SDE)sde, stratumID, sourcePathFilter, njplsLine));
    }

    private boolean hasMappedLineTo(SDE sde, String stratumID, Predicate<String> sourcePathFilter, int njplsLine) {
        List<String> availableStrata = sde.availableStrata();
        if (!availableStrata.contains(stratumID)) {
            return false;
        }
        SDE.Stratum stratum = sde.stratum(stratumID);
        List<String> sourcePaths = stratum.sourcePaths(this);
        for (String sourcePath : sourcePaths) {
            if (!sourcePathFilter.test(sourcePath) || !stratum.hasMappedLineTo(this, sourcePath, njplsLine)) continue;
            return true;
        }
        return false;
    }

    String baseSourceName() throws AbsentInformationException {
        String bsn = this.baseSourceName;
        if (bsn == null) {
            try {
                bsn = JDWP.ReferenceType.SourceFile.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).sourceFile;
            }
            catch (JDWPException exc) {
                if (exc.errorCode() == 101) {
                    bsn = ABSENT_BASE_SOURCE_NAME;
                }
                throw exc.toJDIException();
            }
            this.baseSourceName = bsn;
        }
        if (bsn == ABSENT_BASE_SOURCE_NAME) {
            throw new AbsentInformationException();
        }
        return bsn;
    }

    CompletableFuture<String> baseSourceNameAsync() {
        String bsn = this.baseSourceName;
        if (bsn == null) {
            return ((CompletableFuture)JDWP.ReferenceType.SourceFile.processAsync(this.vm, this).exceptionally(throwable -> {
                if (JDWPException.isOfType(throwable, 101)) {
                    this.baseSourceName = ABSENT_BASE_SOURCE_NAME;
                    throw new CompletionException(new AbsentInformationException());
                }
                throw (RuntimeException)throwable;
            })).thenApply(s -> {
                this.baseSourceName = s.sourceFile;
                return s.sourceFile;
            });
        }
        if (bsn == ABSENT_BASE_SOURCE_NAME) {
            return CompletableFuture.failedFuture(new AbsentInformationException());
        }
        return CompletableFuture.completedFuture(bsn);
    }

    String baseSourcePath() throws AbsentInformationException {
        Object bsp = this.baseSourcePath;
        if (bsp == null) {
            this.baseSourcePath = bsp = this.baseSourceDir() + this.baseSourceName();
        }
        return bsp;
    }

    String baseSourceDir() {
        int nextIndex;
        String typeName = this.name();
        StringBuilder sb = new StringBuilder(typeName.length() + 10);
        int index = 0;
        while ((nextIndex = typeName.indexOf(46, index)) > 0) {
            sb.append(typeName, index, nextIndex);
            sb.append(File.separatorChar);
            index = nextIndex + 1;
        }
        return sb.toString();
    }

    @Override
    public String sourceDebugExtension() throws AbsentInformationException {
        if (!this.vm.canGetSourceDebugExtension()) {
            throw new UnsupportedOperationException();
        }
        SDE sde = this.sourceDebugExtensionInfo();
        if (sde == NO_SDE_INFO_MARK) {
            throw new AbsentInformationException();
        }
        return sde.sourceDebugExtension;
    }

    private SDE sourceDebugExtensionInfo() {
        if (!this.vm.canGetSourceDebugExtension()) {
            return NO_SDE_INFO_MARK;
        }
        SDE sde = this.getFromCache(this.sdeRef);
        if (sde == null) {
            String extension;
            block4: {
                extension = null;
                try {
                    extension = JDWP.ReferenceType.SourceDebugExtension.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).extension;
                }
                catch (JDWPException exc) {
                    if (exc.errorCode() == 101) break block4;
                    this.sdeRef = this.vm.createSoftReference(NO_SDE_INFO_MARK);
                    throw exc.toJDIException();
                }
            }
            sde = extension == null ? NO_SDE_INFO_MARK : new SDE(extension);
            sde = this.tryToCache(this.sdeRef, sde, v -> {
                this.sdeRef = v;
            });
        }
        return sde;
    }

    private CompletableFuture<SDE> sourceDebugExtensionInfoAsync() {
        if (!this.vm.canGetSourceDebugExtension()) {
            return CompletableFuture.completedFuture(NO_SDE_INFO_MARK);
        }
        SDE sde = this.getFromCache(this.sdeRef);
        if (sde != null) {
            return CompletableFuture.completedFuture(sde);
        }
        return ((CompletableFuture)JDWP.ReferenceType.SourceDebugExtension.processAsync(this.vm, this).exceptionally(throwable -> {
            if (!JDWPException.isOfType(throwable, 101)) {
                throw (RuntimeException)throwable;
            }
            return null;
        })).thenApply(e -> {
            SDE res = e == null ? NO_SDE_INFO_MARK : new SDE(e.extension);
            res = this.tryToCache(this.sdeRef, res, v -> {
                this.sdeRef = v;
            });
            return res;
        });
    }

    @Override
    public List<String> availableStrata() {
        SDE sde = this.sourceDebugExtensionInfo();
        return sde.isValid() ? sde.availableStrata() : List.of("Java");
    }

    public CompletableFuture<List<String>> availableStrataAsync() {
        return this.sourceDebugExtensionInfoAsync().thenApply(sde -> sde.isValid() ? sde.availableStrata() : List.of("Java"));
    }

    @Override
    public String defaultStratum() {
        SDE sdei = this.sourceDebugExtensionInfo();
        if (sdei.isValid()) {
            return sdei.defaultStratumId;
        }
        return "Java";
    }

    @Override
    public int modifiers() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return this.modifiers;
    }

    @Override
    public List<Location> allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    public CompletableFuture<List<Location>> allLineLocationsAsync() {
        return this.allLineLocationsAsync(this.vm.getDefaultStratum(), null);
    }

    @Override
    public List<Location> allLineLocations(String stratumID, String sourceName) throws AbsentInformationException {
        boolean someAbsent = false;
        SDE.Stratum stratum = this.stratum(stratumID);
        ArrayList<Location> list = new ArrayList<Location>();
        for (Method value : this.methods()) {
            MethodImpl method = (MethodImpl)value;
            try {
                list.addAll(method.allLineLocations(stratum, sourceName));
            }
            catch (AbsentInformationException exc) {
                someAbsent = true;
            }
        }
        if (someAbsent && list.size() == 0) {
            throw new AbsentInformationException();
        }
        return list;
    }

    public CompletableFuture<List<Location>> allLineLocationsAsync(String stratumID, String sourceName) {
        return ((CompletableFuture)this.methodsAsync().thenCombine(this.stratumAsync(stratumID), (methods, stratum) -> methods.stream().map(method -> ((MethodImpl)method).allLineLocationsAsync((SDE.Stratum)stratum, sourceName)).collect(Collectors.toList()))).thenCompose(futures -> CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).handle((__, ___) -> {
            boolean someAbsent = false;
            ArrayList list = new ArrayList();
            for (CompletableFuture future : futures) {
                try {
                    list.addAll((Collection)future.join());
                }
                catch (Exception e) {
                    someAbsent = true;
                }
            }
            if (someAbsent && list.size() == 0) {
                throw new CompletionException(new AbsentInformationException());
            }
            return list;
        }));
    }

    @Override
    public List<Location> locationsOfLine(int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, lineNumber);
    }

    public CompletableFuture<List<Location>> locationsOfLineAsync(int lineNumber) {
        return this.locationsOfLineAsync(this.vm.getDefaultStratum(), null, lineNumber);
    }

    @Override
    public List<Location> locationsOfLine(String stratumID, String sourceName, int lineNumber) throws AbsentInformationException {
        boolean someAbsent = false;
        boolean somePresent = false;
        List<Method> methods = this.methods();
        SDE.Stratum stratum = this.stratum(stratumID);
        ArrayList<Location> list = new ArrayList<Location>();
        for (Method value : methods) {
            MethodImpl method = (MethodImpl)value;
            if (method.isAbstract() || method.isNative()) continue;
            try {
                list.addAll(method.locationsOfLine(stratum, sourceName, lineNumber));
                somePresent = true;
            }
            catch (AbsentInformationException exc) {
                someAbsent = true;
            }
        }
        if (someAbsent && !somePresent) {
            throw new AbsentInformationException();
        }
        return list;
    }

    public CompletableFuture<List<Location>> locationsOfLineAsync(String stratumID, String sourceName, int lineNumber) {
        return ((CompletableFuture)this.methodsAsync().thenCombine(this.stratumAsync(stratumID), (methods, stratum) -> methods.stream().filter(method -> !method.isAbstract() && !method.isNative()).map(method -> ((MethodImpl)method).locationsOfLineAsync((SDE.Stratum)stratum, sourceName, lineNumber)).collect(Collectors.toList()))).thenCompose(futures -> CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).handle((__, ___) -> {
            boolean someAbsent = false;
            boolean somePresent = false;
            ArrayList list = new ArrayList();
            for (CompletableFuture future : futures) {
                try {
                    list.addAll((Collection)future.join());
                    somePresent = true;
                }
                catch (Exception e) {
                    someAbsent = true;
                }
            }
            if (someAbsent && !somePresent) {
                throw new CompletionException(new AbsentInformationException());
            }
            return list;
        }));
    }

    @Override
    public List<ObjectReference> instances(long maxInstances) {
        if (!this.vm.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        if (maxInstances < 0L) {
            throw new IllegalArgumentException("maxInstances is less than zero: " + maxInstances);
        }
        int intMax = maxInstances > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxInstances;
        try {
            return Arrays.asList(JDWP.ReferenceType.Instances.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this, (int)intMax).instances);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    private int[] getClassFileVersion() {
        JDWP.ReferenceType.ClassFileVersion classFileVersion;
        if (!this.vm.canGetClassFileVersion()) {
            throw new UnsupportedOperationException();
        }
        try {
            classFileVersion = JDWP.ReferenceType.ClassFileVersion.process(this.vm, this);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                return new int[]{0, 0};
            }
            throw exc.toJDIException();
        }
        return new int[]{classFileVersion.majorVersion, classFileVersion.minorVersion};
    }

    @Override
    public int majorVersion() {
        return this.getClassFileVersion()[0];
    }

    @Override
    public int minorVersion() {
        return this.getClassFileVersion()[1];
    }

    private byte[] getConstantPoolInfo() {
        JDWP.ReferenceType.ConstantPool jdwpCPool;
        byte[] cpbytes;
        if (!this.vm.canGetConstantPool()) {
            throw new UnsupportedOperationException();
        }
        if (this.constantPoolInfoGotten) {
            if (this.constantPoolBytesRef == null) {
                return null;
            }
            cpbytes = this.constantPoolBytesRef.get();
            if (cpbytes != null) {
                return cpbytes;
            }
        }
        try {
            jdwpCPool = JDWP.ReferenceType.ConstantPool.process(this.vm, this);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                this.constanPoolCount = 0;
                this.constantPoolBytesRef = null;
                this.constantPoolInfoGotten = true;
                return null;
            }
            throw exc.toJDIException();
        }
        this.constanPoolCount = jdwpCPool.count;
        cpbytes = jdwpCPool.bytes;
        this.constantPoolBytesRef = this.vm.createSoftReference(cpbytes);
        this.constantPoolInfoGotten = true;
        return cpbytes;
    }

    private CompletableFuture<byte[]> getConstantPoolInfoAsync() {
        if (!this.vm.canGetConstantPool()) {
            return CompletableFuture.failedFuture(new UnsupportedOperationException());
        }
        if (this.constantPoolInfoGotten) {
            if (this.constantPoolBytesRef == null) {
                return CompletableFuture.completedFuture(null);
            }
            byte[] cpbytes = this.constantPoolBytesRef.get();
            if (cpbytes != null) {
                return CompletableFuture.completedFuture(cpbytes);
            }
        }
        return JDWP.ReferenceType.ConstantPool.processAsync(this.vm, this).handle((jdwpCPool, e) -> {
            if (e != null) {
                if (JDWPException.isOfType(e, 101)) {
                    this.constanPoolCount = 0;
                    this.constantPoolBytesRef = null;
                    this.constantPoolInfoGotten = true;
                    return null;
                }
                throw (RuntimeException)e;
            }
            this.constanPoolCount = jdwpCPool.count;
            byte[] cpbytes = jdwpCPool.bytes;
            this.constantPoolBytesRef = this.vm.createSoftReference(cpbytes);
            this.constantPoolInfoGotten = true;
            return cpbytes;
        });
    }

    @Override
    public int constantPoolCount() {
        this.getConstantPoolInfo();
        return this.constanPoolCount;
    }

    public CompletableFuture<Integer> constantPoolCountAsync() {
        return this.getConstantPoolInfoAsync().thenApply(bytes -> this.constanPoolCount);
    }

    @Override
    public byte[] constantPool() {
        byte[] cpbytes = this.getConstantPoolInfo();
        if (cpbytes != null) {
            return (byte[])cpbytes.clone();
        }
        return null;
    }

    public CompletableFuture<byte[]> constantPoolAsync() {
        return this.getConstantPoolInfoAsync().thenApply(bytes -> {
            if (bytes != null) {
                return (byte[])bytes.clone();
            }
            return null;
        });
    }

    void getModifiers() {
        if (this.modifiers != -1) {
            return;
        }
        try {
            this.modifiers = JDWP.ReferenceType.Modifiers.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).modBits;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    void decodeStatus(int status) {
        this.status = status;
        if ((status & 2) != 0) {
            this.isPrepared = true;
        }
    }

    void updateStatus() {
        try {
            this.decodeStatus(JDWP.ReferenceType.Status.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).status);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    void markPrepared() {
        this.isPrepared = true;
    }

    long ref() {
        return this.ref;
    }

    int indexOf(Method method) {
        return this.methods().indexOf(method);
    }

    int indexOf(Field field) {
        return this.fields().indexOf(field);
    }

    abstract boolean isAssignableTo(ReferenceType var1);

    boolean isAssignableFrom(ReferenceType type) {
        return ((ReferenceTypeImpl)type).isAssignableTo(this);
    }

    boolean isAssignableFrom(ObjectReference object) {
        return object == null || this.isAssignableFrom(object.referenceType());
    }

    void setStatus(int status) {
        this.decodeStatus(status);
    }

    void setSignature(String signature) {
        if (!Objects.equals(this.signature, signature)) {
            this.vm.cacheTypeBySignature(this, signature);
        }
        this.signature = signature;
    }

    private static boolean isOneDimensionalPrimitiveArray(String signature) {
        JNITypeParser sig = new JNITypeParser(signature);
        if (sig.isArray()) {
            JNITypeParser componentSig = new JNITypeParser(sig.componentSignature());
            return componentSig.isPrimitive();
        }
        return false;
    }

    Type findType(String signature) throws ClassNotLoadedException {
        ClassLoaderReferenceImpl loader;
        JNITypeParser sig = new JNITypeParser(signature);
        Type type = sig.isVoid() ? this.vm.theVoidType() : (sig.isPrimitive() ? this.vm.primitiveTypeMirror(sig.jdwpTag()) : ((loader = (ClassLoaderReferenceImpl)this.classLoader()) == null || ReferenceTypeImpl.isOneDimensionalPrimitiveArray(signature) ? this.vm.findBootType(signature) : loader.findType(signature)));
        return type;
    }

    String loaderString() {
        if (this.classLoader() != null) {
            return "loaded by " + this.classLoader().toString();
        }
        return "no class loader";
    }

    static <T> T notnullize(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static <T> T nullize(T value, T defaultValue) {
        return (T)(value != defaultValue ? value : null);
    }

    static <T> T dereference(Reference<T> ref) {
        return ref == null ? null : (T)ref.get();
    }
}

