/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.diff;

import com.intellij.collaboration.ui.codereview.diff.AddCommentGutterIconRenderer;
import com.intellij.collaboration.ui.codereview.diff.DiffEditorGutterIconRendererFactory;
import com.intellij.collaboration.ui.codereview.diff.IconVisibilityController;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.util.Disposer;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Deprecated with the move to ViewModel-based approach")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/collaboration/ui/codereview/diff/EditorRangesController;", "", "gutterIconRendererFactory", "Lcom/intellij/collaboration/ui/codereview/diff/DiffEditorGutterIconRendererFactory;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/collaboration/ui/codereview/diff/DiffEditorGutterIconRendererFactory;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "commentableLines", "Lit/unimi/dsi/fastutil/ints/IntSet;", "kotlin.jvm.PlatformType", "Lit/unimi/dsi/fastutil/ints/IntSet;", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "markCommentableLines", "", "range", "Lcom/intellij/diff/util/LineRange;", "intellij.platform.collaborationTools"})
public class EditorRangesController {
    @NotNull
    private final DiffEditorGutterIconRendererFactory gutterIconRendererFactory;
    @NotNull
    private final EditorEx editor;
    private final IntSet commentableLines;
    @NotNull
    private final Set<RangeHighlighterEx> highlighters;

    public EditorRangesController(@NotNull DiffEditorGutterIconRendererFactory gutterIconRendererFactory, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)gutterIconRendererFactory, (String)"gutterIconRendererFactory");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.gutterIconRendererFactory = gutterIconRendererFactory;
        this.editor = editor;
        this.commentableLines = IntSets.synchronize((IntSet)((IntSet)new IntOpenHashSet()));
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.highlighters = set;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable listenerDisposable = disposable;
        this.editor.getMarkupModel().addMarkupModelListener(listenerDisposable, new MarkupModelListener(){

            public void afterRemoved(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                GutterIconRenderer gutterIconRenderer = highlighter.getGutterIconRenderer();
                AddCommentGutterIconRenderer addCommentGutterIconRenderer = gutterIconRenderer instanceof AddCommentGutterIconRenderer ? (AddCommentGutterIconRenderer)gutterIconRenderer : null;
                if (addCommentGutterIconRenderer == null) {
                    return;
                }
                AddCommentGutterIconRenderer iconRenderer = addCommentGutterIconRenderer;
                Disposer.dispose((Disposable)iconRenderer);
                commentableLines.remove(iconRenderer.getLine());
                highlighters.remove(highlighter);
            }
        });
        IconVisibilityController iconVisibilityController = new IconVisibilityController(this.highlighters);
        this.editor.addEditorMouseListener((EditorMouseListener)iconVisibilityController);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)iconVisibilityController);
        EditorUtil.disposeWithEditor((Editor)((Editor)this.editor), (Disposable)listenerDisposable);
    }

    protected final void markCommentableLines(@NotNull LineRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int n = range.end;
        for (int i = range.start; i < n; ++i) {
            if (!this.commentableLines.add(i)) continue;
            int start = this.editor.getDocument().getLineStartOffset(i);
            int end = this.editor.getDocument().getLineEndOffset(i);
            RangeHighlighterEx rangeHighlighterEx = this.editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, start, end, 6000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> EditorRangesController.markCommentableLines$lambda$1(arg_0 -> EditorRangesController.markCommentableLines$lambda$0(this, i, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
            this.highlighters.add(rangeHighlighterEx);
        }
    }

    private static final Unit markCommentableLines$lambda$0(EditorRangesController this$0, int $i, RangeHighlighterEx highlighter) {
        highlighter.setGutterIconRenderer((GutterIconRenderer)this$0.gutterIconRendererFactory.createCommentRenderer($i));
        return Unit.INSTANCE;
    }

    private static final void markCommentableLines$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

