/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.util.Url;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t26\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\u00060\u000bJ\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\b\u001a\u00020\tJ\\\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u001226\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\u00060\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirerHttp;", "", "<init>", "()V", "requestToken", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "url", "Lcom/intellij/util/Url;", "credentialsProvider", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "body", "Ljava/net/http/HttpHeaders;", "headers", "Ljava/net/http/HttpResponse;", "convertToAcquireCredentialsResult", "httpResponse", "intellij.platform.collaborationTools.auth"})
@SourceDebugExtension(value={"SMAP\nOAuthCredentialsAcquirerHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthCredentialsAcquirerHttp.kt\ncom/intellij/collaboration/auth/services/OAuthCredentialsAcquirerHttp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class OAuthCredentialsAcquirerHttp {
    @NotNull
    public static final OAuthCredentialsAcquirerHttp INSTANCE = new OAuthCredentialsAcquirerHttp();

    private OAuthCredentialsAcquirerHttp() {
    }

    @NotNull
    public final <T extends Credentials> OAuthCredentialsAcquirer.AcquireCredentialsResult<T> requestToken(@NotNull Url url, @NotNull Function2<? super String, ? super HttpHeaders, ? extends T> credentialsProvider) {
        HttpResponse<String> httpResponse;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        try {
            httpResponse = this.requestToken(url);
        }
        catch (IOException e) {
            return new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error("Cannot exchange token: " + e.getMessage());
        }
        HttpResponse<String> response2 = httpResponse;
        return this.convertToAcquireCredentialsResult(response2, (arg_0, arg_1) -> OAuthCredentialsAcquirerHttp.requestToken$lambda$0(credentialsProvider, arg_0, arg_1));
    }

    @NotNull
    public final HttpResponse<String> requestToken(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        String tokenUrl = string;
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(tokenUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"send(...)");
        return httpResponse;
    }

    @NotNull
    public final <T extends Credentials> OAuthCredentialsAcquirer.AcquireCredentialsResult<T> convertToAcquireCredentialsResult(@NotNull HttpResponse<String> httpResponse, @NotNull Function2<? super String, ? super HttpHeaders, ? extends T> credentialsProvider) {
        OAuthCredentialsAcquirer.AcquireCredentialsResult acquireCredentialsResult;
        Intrinsics.checkNotNullParameter(httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        if (httpResponse.statusCode() == 200) {
            String string = httpResponse.body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
            HttpHeaders httpHeaders = httpResponse.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
            Credentials creds = (Credentials)credentialsProvider.invoke((Object)string, (Object)httpHeaders);
            acquireCredentialsResult = new OAuthCredentialsAcquirer.AcquireCredentialsResult.Success<Credentials>(creds);
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = httpResponse.body();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = "No token provided";
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifEmpty(...)");
            String string = (String)charSequence;
            acquireCredentialsResult = new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error(string);
        }
        return acquireCredentialsResult;
    }

    private static final Credentials requestToken$lambda$0(Function2 $credentialsProvider, String body, HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return (Credentials)$credentialsProvider.invoke((Object)body, (Object)headers);
    }
}

