/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.injection;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class InjectedLanguageManager {
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = Key.create("FRANKENSTEIN_INJECTION");

    public static InjectedLanguageManager getInstance(@NotNull Project project) {
        if (project == null) {
            InjectedLanguageManager.$$$reportNull$$$0(0);
        }
        return (InjectedLanguageManager)project.getService(InjectedLanguageManager.class);
    }

    public abstract PsiLanguageInjectionHost getInjectionHost(@NotNull FileViewProvider var1);

    @Nullable
    public abstract PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement var1);

    @NotNull
    public abstract TextRange injectedToHost(@NotNull PsiElement var1, @NotNull TextRange var2);

    public abstract int injectedToHost(@NotNull PsiElement var1, int var2);

    public abstract int injectedToHost(@NotNull PsiElement var1, int var2, boolean var3);

    @TestOnly
    public abstract void registerMultiHostInjector(@NotNull MultiHostInjector var1, @NotNull Disposable var2);

    @NotNull
    public abstract String getUnescapedText(@NotNull PsiElement var1);

    @Contract(pure=true)
    public int mapInjectedOffsetToUnescaped(@NotNull PsiFile injectedFile, int injectedOffset) {
        if (injectedFile == null) {
            InjectedLanguageManager.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    @Contract(pure=true)
    public int mapUnescapedOffsetToInjected(@NotNull PsiFile injectedFile, int offset) {
        if (injectedFile == null) {
            InjectedLanguageManager.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public abstract List<TextRange> intersectWithAllEditableFragments(@NotNull PsiFile var1, @NotNull TextRange var2);

    public boolean isInjectedFragment(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            InjectedLanguageManager.$$$reportNull$$$0(3);
        }
        return this.isInjectedViewProvider(injectedFile.getViewProvider());
    }

    public abstract boolean isInjectedViewProvider(@NotNull FileViewProvider var1);

    @Nullable
    public abstract PsiElement findInjectedElementAt(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract List<Pair<PsiElement, TextRange>> getInjectedPsiFiles(@NotNull PsiElement var1);

    public boolean hasInjections(@NotNull PsiElement host) {
        if (host == null) {
            InjectedLanguageManager.$$$reportNull$$$0(4);
        }
        return this.getInjectedPsiFiles(host) != null;
    }

    public abstract void dropFileCaches(@NotNull PsiFile var1);

    public abstract PsiFile getTopLevelFile(@NotNull PsiElement var1);

    @NotNull
    public abstract List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile var1, @NotNull TextRange var2);

    public abstract void enumerate(@NotNull PsiElement var1, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor var2);

    public abstract void enumerateEx(@NotNull PsiElement var1, @NotNull PsiFile var2, boolean var3, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor var4);

    @NotNull
    public abstract List<TextRange> getNonEditableFragments(@NotNull DocumentWindow var1);

    public abstract boolean mightHaveInjectedFragmentAtOffset(@NotNull Document var1, int var2);

    @NotNull
    public abstract DocumentWindow freezeWindow(@NotNull DocumentWindow var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/injection/InjectedLanguageManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mapInjectedOffsetToUnescaped";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mapUnescapedOffsetToInjected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectedFragment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInjections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

