/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.ExternalizableGraphElement;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JvmProtoMemberValueExternalizer;
import org.jetbrains.jps.dependency.java.TypeRepr;

public abstract class AnnotationInstance
implements ExternalizableGraphElement {
    private final TypeRepr.ClassType annotationClass;
    private final Object contentHash;

    protected AnnotationInstance(@NotNull TypeRepr.ClassType annotClass, Object contentHash) {
        if (annotClass == null) {
            AnnotationInstance.$$$reportNull$$$0(0);
        }
        this.annotationClass = annotClass;
        this.contentHash = contentHash;
    }

    protected AnnotationInstance(GraphDataInput in) throws IOException {
        this.annotationClass = new TypeRepr.ClassType(in.readUTF());
        this.contentHash = JvmProtoMemberValueExternalizer.read(in);
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        out.writeUTF(this.annotationClass.getJvmName());
        JvmProtoMemberValueExternalizer.write(out, this.contentHash);
    }

    @NotNull
    public TypeRepr.ClassType getAnnotationClass() {
        TypeRepr.ClassType classType = this.annotationClass;
        if (classType == null) {
            AnnotationInstance.$$$reportNull$$$0(1);
        }
        return classType;
    }

    public Object getContentHash() {
        return this.contentHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInstance that = (AnnotationInstance)o;
        return this.annotationClass.equals(that.annotationClass) && Objects.equals(this.contentHash, that.contentHash);
    }

    public int hashCode() {
        int result = this.annotationClass.hashCode();
        result = 31 * result + Objects.hashCode(this.contentHash);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/AnnotationInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/AnnotationInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Diff<V extends AnnotationInstance>
    implements Difference {
        private final V myPast;
        final /* synthetic */ AnnotationInstance this$0;

        public Diff(V past) {
            this.this$0 = this$0;
            this.myPast = past;
        }

        @Override
        public boolean unchanged() {
            return !this.contentHashChanged();
        }

        public boolean contentHashChanged() {
            return !Objects.deepEquals(((AnnotationInstance)this.myPast).getContentHash(), this.this$0.contentHash);
        }
    }
}

