/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.java.JavadocSnippetsSkipFilter;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class JavaSourceRootDescriptor
extends BuildRootDescriptor {
    private final FileFilter myFilterForExcludedPatterns;
    @NotNull
    public final File root;
    @NotNull
    public final Path rootFile;
    @NotNull
    public final ModuleBuildTarget target;
    public final boolean isGeneratedSources;
    public final boolean isTemp;
    private final String myPackagePrefix;
    private final Set<Path> myExcludes;

    @Deprecated
    @ApiStatus.Internal
    public JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        if (root == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(0);
        }
        if (target == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(1);
        }
        if (packagePrefix == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(2);
        }
        if (excludes == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(3);
        }
        this(root, target, isGenerated, isTemp, packagePrefix, JavaSourceRootDescriptor.convertExcludes(excludes), FileFilters.EVERYTHING, true);
    }

    @NotNull
    public static JavaSourceRootDescriptor createJavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<Path> excludes, @NotNull FileFilter filterForExcludedPatterns) {
        if (root == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(4);
        }
        if (target == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(5);
        }
        if (packagePrefix == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(6);
        }
        if (excludes == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(7);
        }
        if (filterForExcludedPatterns == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(8);
        }
        return new JavaSourceRootDescriptor(root, target, isGenerated, isTemp, packagePrefix, excludes, filterForExcludedPatterns, true);
    }

    public JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<File> excludes, @NotNull FileFilter filterForExcludedPatterns) {
        if (root == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(9);
        }
        if (target == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(10);
        }
        if (packagePrefix == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(11);
        }
        if (excludes == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(12);
        }
        if (filterForExcludedPatterns == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(13);
        }
        this(root, target, isGenerated, isTemp, packagePrefix, JavaSourceRootDescriptor.convertExcludes(excludes), filterForExcludedPatterns, true);
    }

    private static Set<Path> convertExcludes(@NotNull Set<File> excludes) {
        if (excludes == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(14);
        }
        Set result = FileCollectionFactory.createCanonicalPathSet();
        for (File exclude : excludes) {
            result.add(exclude.toPath());
        }
        return result;
    }

    private JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<Path> excludes, @NotNull FileFilter filterForExcludedPatterns, boolean ignored) {
        if (root == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(15);
        }
        if (target == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(16);
        }
        if (packagePrefix == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(17);
        }
        if (excludes == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(18);
        }
        if (filterForExcludedPatterns == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(19);
        }
        this.root = root;
        this.rootFile = root.toPath().toAbsolutePath().normalize();
        this.target = target;
        this.isGeneratedSources = isGenerated;
        this.isTemp = isTemp;
        this.myPackagePrefix = packagePrefix;
        this.myExcludes = excludes;
        this.myFilterForExcludedPatterns = filterForExcludedPatterns;
    }

    public String toString() {
        return "RootDescriptor{target='" + this.target + "', root=" + this.rootFile + ", generated=" + this.isGeneratedSources + "}";
    }

    @Override
    @NotNull
    public Set<Path> getExcludedRoots() {
        Set<Path> set = this.myExcludes;
        if (set == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    @NotNull
    public String getRootId() {
        String string = FileUtilRt.toSystemIndependentName((String)this.rootFile.toString());
        if (string == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    public File getRootFile() {
        File file = this.root;
        if (file == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(23);
        }
        return file;
    }

    @NotNull
    public ModuleBuildTarget getTarget() {
        ModuleBuildTarget moduleBuildTarget = this.target;
        if (moduleBuildTarget == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(24);
        }
        return moduleBuildTarget;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.target.getModule().getProject()).getCompilerExcludes();
        FileFilter baseFilter = BuilderRegistry.getInstance().getModuleBuilderFileFilter();
        JavadocSnippetsSkipFilter snippetsSkipFilter = new JavadocSnippetsSkipFilter(this.getRootFile());
        FileFilter fileFilter = file -> baseFilter.accept(file) && !excludes.isExcluded(file) && snippetsSkipFilter.accept(file) && this.myFilterForExcludedPatterns.accept(file);
        if (fileFilter == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(25);
        }
        return fileFilter;
    }

    @Override
    public boolean isGenerated() {
        return this.isGeneratedSources;
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterForExcludedPatterns";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePrefix";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootId";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createJavaSourceRootDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertExcludes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

