/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.task.ExecuteRunConfigurationTask;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleBaseApplicationEnvironmentProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleInitScriptParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "Lcom/intellij/execution/application/ApplicationConfiguration;", "<init>", "()V", "isApplicable", "", "task", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "generateInitScript", "", "params", "Lorg/jetbrains/plugins/gradle/execution/build/GradleInitScriptParameters;", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleApplicationEnvironmentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleApplicationEnvironmentProvider.kt\norg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n14#2:57\n*S KotlinDebug\n*F\n+ 1 GradleApplicationEnvironmentProvider.kt\norg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider\n*L\n53#1:57\n*E\n"})
public class GradleApplicationEnvironmentProvider
extends GradleBaseApplicationEnvironmentProvider<ApplicationConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean isApplicable(@NotNull ExecuteRunConfigurationTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return Intrinsics.areEqual(task.getRunProfile().getClass(), ApplicationConfiguration.class);
    }

    @Override
    @Nullable
    public String generateInitScript(@NotNull GradleInitScriptParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ShortenCommandLine shortenCommandLine = params.getConfiguration().getShortenCommandLine();
        boolean useManifestJar = shortenCommandLine == ShortenCommandLine.MANIFEST;
        boolean useArgsFile = shortenCommandLine == ShortenCommandLine.ARGS_FILE;
        boolean useClasspathFile = shortenCommandLine == ShortenCommandLine.CLASSPATH_FILE;
        String intelliJRtPath = null;
        if (useClasspathFile) {
            try {
                intelliJRtPath = FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(Class.forName("com.intellij.rt.execution.CommandLineWrapper")));
            }
            catch (Throwable t) {
                LOG.warn("Unable to use classpath file", t);
                useClasspathFile = false;
            }
        }
        return GradleInitScriptUtil.loadApplicationInitScript((String)params.getGradleTaskPath(), (String)params.getRunAppTaskName(), (String)params.getMainClass(), (String)params.getJavaExePath(), (String)params.getSourceSetName(), (String)params.getParams(), (String)intelliJRtPath, (String)params.getWorkingDirectory(), (boolean)useManifestJar, (boolean)useArgsFile, (boolean)useClasspathFile);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleApplicationEnvironmentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

