/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.diff.DiffDialogHints;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.views.DirectoryChange;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DirectoryHistoryDialog
extends HistoryDialog<DirectoryHistoryDialogModel> {
    private AsyncChangesTreeImpl<Change> myChangesTree;
    private JScrollPane myChangesTreeScrollPane;
    private ActionToolbar myToolBar;

    public DirectoryHistoryDialog(Project p, IdeaGateway gw, VirtualFile f) {
        this(p, gw, f, true);
    }

    protected DirectoryHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f, boolean doInit) {
        if (p == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(0);
        }
        super(p, gw, f, doInit);
    }

    @Override
    protected DirectoryHistoryDialogModel createModel(LocalHistoryFacade vcs) {
        return new DirectoryHistoryDialogModel(this.myProject, this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Pair<JComponent, Dimension> createDiffPanel(JPanel root, ExcludingTraversalPolicy traversalPolicy) {
        this.initChangesTree(root);
        JPanel p = new JPanel(new BorderLayout());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("DirectoryHistoryDiffPanel", this.createChangesTreeActions(), true);
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(this.myToolBar, this.myChangesTree);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)toolbarPanel, "Center");
        if (this.showSearchField()) {
            SearchTextField search = this.createSearchBox(root);
            topPanel.add((Component)search, "East");
            traversalPolicy.exclude((Component)search.getTextEditor());
        }
        p.add((Component)topPanel, "North");
        this.myChangesTreeScrollPane = ScrollPaneFactory.createScrollPane(this.myChangesTree);
        p.add((Component)this.myChangesTreeScrollPane, "Center");
        return Pair.create((Object)p, (Object)topPanel.getPreferredSize());
    }

    protected boolean showSearchField() {
        return true;
    }

    @Override
    protected void setDiffBorder(Border border) {
        this.myChangesTreeScrollPane.setBorder(border);
    }

    @NotNull
    private SearchTextField createSearchBox(JPanel root) {
        final SearchTextField field = new SearchTextField(this.getDimensionKey() + ".searchHistory");
        field.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((DirectoryHistoryDialogModel)DirectoryHistoryDialog.this.myModel).myFilter() == null) {
                    LocalHistoryCounter.INSTANCE.logFilterUsed(LocalHistoryCounter.Kind.Directory);
                }
                DirectoryHistoryDialog.this.scheduleRevisionsUpdate(m -> {
                    m.setFilter(field.getText());
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!DirectoryHistoryDialog.this.isDisposed()) {
                            field.addCurrentTextToHistory();
                        }
                    });
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/views/DirectoryHistoryDialog$1", "textChanged"));
            }
        });
        DumbAwareAction.create(e -> field.requestFocusInWindow()).registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)root, (Disposable)this);
        SearchTextField searchTextField = field;
        if (searchTextField == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(1);
        }
        return searchTextField;
    }

    private void initChangesTree(JComponent root) {
        this.myChangesTree = new AsyncChangesTreeImpl.Changes(this.myProject, false, false);
        this.myChangesTree.setDoubleClickAndEnterKeyHandler(() -> new ShowDifferenceAction().performIfEnabled());
        new ShowDifferenceAction().registerCustomShortcutSet(root, null);
        this.myChangesTree.installPopupHandler(this.createChangesTreeActions());
    }

    @NotNull
    private ActionGroup createChangesTreeActions() {
        DefaultActionGroup result = new DefaultActionGroup();
        result.add((AnAction)new ShowDifferenceAction());
        result.add((AnAction)new RevertSelectionAction());
        result.add((AnAction)Separator.getInstance());
        result.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup defaultActionGroup = result;
        if (defaultActionGroup == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @Override
    protected void updateActions() {
        super.updateActions();
        this.myToolBar.updateActionsImmediately();
    }

    @Override
    protected Runnable doUpdateDiffs(@NotNull DirectoryHistoryDialogModel model) {
        if (model == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(3);
        }
        List<Change> changes = model.getChanges();
        return () -> this.myChangesTree.setChangesToDisplay((Collection)changes);
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.localHistory.show.folder";
    }

    @NotNull
    private List<DirectoryChange> getDisplayedChanges() {
        List list = this.myChangesTree.getDisplayedChanges();
        if (list == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<DirectoryChange> getSelectedChanges() {
        List list = this.myChangesTree.getSelectedChanges();
        if (list == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/views/DirectoryHistoryDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/views/DirectoryHistoryDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchBox";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangesTreeActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedChanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateDiffs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    private final class ShowDifferenceAction
    extends ActionOnSelection {
        ShowDifferenceAction() {
            super(LocalHistoryBundle.message("action.show.difference", new Object[0]), AllIcons.Actions.Diff);
            this.setShortcutSet(CommonShortcuts.getDiff());
        }

        @Override
        protected void doPerform(DirectoryHistoryDialogModel model, List<DirectoryChange> selected) {
            LocalHistoryCounter.INSTANCE.logActionInvoked(LocalHistoryCounter.ActionKind.Diff, LocalHistoryCounter.Kind.Directory);
            HashSet<DirectoryChange> selectedSet = new HashSet<DirectoryChange>(selected);
            int index = 0;
            ArrayList<DirectoryChange> changes = new ArrayList<DirectoryChange>();
            for (DirectoryChange change : this.iterFileChanges()) {
                if (selectedSet.contains((Object)change)) {
                    index = changes.size();
                }
                changes.add(change);
            }
            ShowDiffAction.showDiffForChange((Project)DirectoryHistoryDialog.this.myProject, changes, (int)index, (ShowDiffContext)new ShowDiffContext(DiffDialogHints.FRAME));
        }

        @NotNull
        private List<DirectoryChange> iterFileChanges() {
            List list = ContainerUtil.filter(DirectoryHistoryDialog.this.getDisplayedChanges(), each -> each.canShowFileDifference());
            if (list == null) {
                ShowDifferenceAction.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        protected boolean isEnabledFor(DirectoryHistoryDialogModel model, List<DirectoryChange> changes) {
            return ContainerUtil.exists(DirectoryHistoryDialog.this.getDisplayedChanges(), each -> each.canShowFileDifference());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/ui/views/DirectoryHistoryDialog$ShowDifferenceAction", "iterFileChanges"));
        }
    }

    private final class RevertSelectionAction
    extends ActionOnSelection {
        RevertSelectionAction() {
            super(LocalHistoryBundle.message("action.revert.selection", new Object[0]), AllIcons.Actions.Rollback);
        }

        @Override
        protected void doPerform(@NotNull DirectoryHistoryDialogModel model, @NotNull List<DirectoryChange> selected) {
            if (model == null) {
                RevertSelectionAction.$$$reportNull$$$0(0);
            }
            if (selected == null) {
                RevertSelectionAction.$$$reportNull$$$0(1);
            }
            LocalHistoryCounter.INSTANCE.logActionInvoked(LocalHistoryCounter.ActionKind.RevertChanges, LocalHistoryCounter.Kind.Directory);
            ArrayList<Difference> diffs = new ArrayList<Difference>();
            for (DirectoryChange each : selected) {
                diffs.add(each.getDifference());
            }
            DirectoryHistoryDialog.this.revert(model.createRevisionReverter(diffs));
        }

        @Override
        protected boolean isEnabledFor(@NotNull DirectoryHistoryDialogModel model, List<DirectoryChange> changes) {
            if (model == null) {
                RevertSelectionAction.$$$reportNull$$$0(2);
            }
            return model.isRevertEnabled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/history/integration/ui/views/DirectoryHistoryDialog$RevertSelectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doPerform";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class ActionOnSelection
    extends HistoryDialog.MyAction {
        ActionOnSelection(String name, Icon icon) {
            super(DirectoryHistoryDialog.this, name, null, icon);
        }

        protected void doPerform(DirectoryHistoryDialogModel model) {
            this.doPerform(model, DirectoryHistoryDialog.this.getSelectedChanges());
        }

        protected abstract void doPerform(DirectoryHistoryDialogModel var1, List<DirectoryChange> var2);

        protected boolean isEnabled(DirectoryHistoryDialogModel model) {
            List<DirectoryChange> changes = DirectoryHistoryDialog.this.getSelectedChanges();
            if (changes.isEmpty()) {
                return false;
            }
            return this.isEnabledFor(model, changes);
        }

        protected boolean isEnabledFor(DirectoryHistoryDialogModel model, List<DirectoryChange> changes) {
            return true;
        }
    }
}

