/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.CoverageInfoCollector;
import com.intellij.coverage.analysis.JavaCoverageAnnotator;
import com.intellij.coverage.analysis.JavaCoverageClassesAnnotator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.coverage.view.CoverageClassStructure;
import com.intellij.coverage.xml.XMLReportAnnotatorKt;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.report.XMLProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/coverage/xml/XMLReportAnnotator;", "Lcom/intellij/coverage/analysis/JavaCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createRenewRequest", "Ljava/lang/Runnable;", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "dataManager", "Lcom/intellij/coverage/CoverageDataManager;", "annotate", "", "collector", "Lcom/intellij/coverage/analysis/CoverageInfoCollector;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageName", "", "fileName", "sourceRoots", "", "getCoverageForClass", "Lcom/intellij/coverage/analysis/PackageAnnotator$ClassCoverageInfo;", "classInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$ClassInfo;", "Companion", "intellij.java.coverage"})
@SourceDebugExtension(value={"SMAP\nXMLReportAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLReportAnnotator.kt\ncom/intellij/coverage/xml/XMLReportAnnotator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n10072#2:115\n10494#2,5:116\n381#3,7:121\n381#3,7:128\n381#3,7:135\n381#3,7:146\n1485#4:142\n1510#4,3:143\n1513#4,3:153\n1863#4,2:157\n216#5:156\n217#5:159\n*S KotlinDebug\n*F\n+ 1 XMLReportAnnotator.kt\ncom/intellij/coverage/xml/XMLReportAnnotator\n*L\n35#1:115\n35#1:116,5\n41#1:121,7\n51#1:128,7\n53#1:135,7\n59#1:146,7\n59#1:142\n59#1:143,3\n59#1:153,3\n61#1:157,2\n59#1:156\n59#1:159\n*E\n"})
public final class XMLReportAnnotator
extends JavaCoverageAnnotator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public XMLReportAnnotator(@Nullable Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        return () -> XMLReportAnnotator.createRenewRequest$lambda$0(this, suite, dataManager);
    }

    /*
     * WARNING - void declaration
     */
    public final void annotate(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull CoverageInfoCollector collector) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv22;
        CoverageSuite[] $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        HashMap classCoverage = new HashMap();
        HashMap flattenPackageCoverage = new HashMap();
        HashMap flattenDirectoryCoverage = new HashMap();
        Module[] moduleArray = (Module[])dataManager.doInReadActionIfProjectOpen(() -> XMLReportAnnotator.annotate$lambda$1(suite));
        if (moduleArray == null) {
            moduleArray = new Module[]{};
        }
        Module[] moduleArray2 = moduleArray;
        int $i$f$flatMap = 0;
        void var10_9 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv22).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv22[i];
            boolean bl = false;
            Set<VirtualFile> set = JavaCoverageClassesAnnotator.getSourceRoots((Module)it);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getSourceRoots(...)");
            list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        HashSet sourceRoots = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        for (CoverageSuite xmlSuite : suite.getSuites()) {
            XMLProjectData xmlReport;
            if (!(xmlSuite instanceof XMLReportSuite) || ((XMLReportSuite)xmlSuite).getReportData() == null) continue;
            for (XMLProjectData.ClassInfo classInfo : xmlReport.getClasses()) {
                Object object;
                Object object2;
                PackageAnnotator.PackageCoverageInfo answer$iv;
                String packageName;
                Object object3;
                void $this$getOrPut$iv;
                list$iv$iv = classCoverage;
                String key$iv = classInfo.name;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageAnnotator.ClassCoverageInfo answer$iv2 = new PackageAnnotator.ClassCoverageInfo();
                    $this$getOrPut$iv.put(key$iv, answer$iv2);
                    object3 = answer$iv2;
                } else {
                    object3 = value$iv;
                }
                PackageAnnotator.ClassCoverageInfo currentCoverage = (PackageAnnotator.ClassCoverageInfo)object3;
                Intrinsics.checkNotNull((Object)classInfo);
                PackageAnnotator.ClassCoverageInfo thisSuiteCoverage = this.getCoverageForClass(classInfo);
                PackageAnnotator.ClassCoverageInfo coverage = XMLReportAnnotatorKt.access$minus(thisSuiteCoverage, currentCoverage);
                currentCoverage.append(coverage);
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.getPackageName((String)classInfo.name), (String)"getPackageName(...)");
                VirtualFile virtualFile = this.findFile(packageName, classInfo.fileName, sourceRoots);
                Map $this$getOrPut$iv2 = flattenPackageCoverage;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(packageName);
                if (value$iv2 == null) {
                    boolean bl = false;
                    answer$iv = new PackageAnnotator.PackageCoverageInfo();
                    $this$getOrPut$iv2.put(packageName, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                ((PackageAnnotator.PackageCoverageInfo)object2).append(coverage);
                if (virtualFile == null) continue;
                $this$getOrPut$iv2 = flattenDirectoryCoverage;
                $i$f$getOrPut2 = false;
                value$iv2 = $this$getOrPut$iv2.get(virtualFile);
                if (value$iv2 == null) {
                    boolean bl = false;
                    answer$iv = new PackageAnnotator.PackageCoverageInfo();
                    $this$getOrPut$iv2.put(virtualFile, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((PackageAnnotator.PackageCoverageInfo)object).append(coverage);
            }
        }
        Set set = classCoverage.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Object $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable $this$flatMapTo$iv$iv22 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = AnalysisUtils.getSourceToplevelFQName((String)it.getKey());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv2 = (List)object;
            list$iv$iv2.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String className = (String)entry.getKey();
            List classes = (List)entry.getValue();
            PackageAnnotator.ClassCoverageInfo coverage = new PackageAnnotator.ClassCoverageInfo();
            Iterable $this$forEach$iv2 = classes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry it = (Map.Entry)element$iv2;
                boolean bl3 = false;
                coverage.append((PackageAnnotator.ClassCoverageInfo)it.getValue());
            }
            collector.addClass(className, coverage);
        }
        JavaCoverageClassesAnnotator.annotatePackages(flattenPackageCoverage, collector);
        JavaCoverageClassesAnnotator.annotateDirectories(flattenDirectoryCoverage, collector, sourceRoots);
    }

    private final VirtualFile findFile(String packageName, String fileName, Collection<? extends VirtualFile> sourceRoots) {
        if (fileName == null) {
            return null;
        }
        String path = XMLReportSuite.Companion.getPath(packageName, fileName);
        for (VirtualFile virtualFile : sourceRoots) {
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(path);
            if (virtualFile2 == null) continue;
            VirtualFile file = virtualFile2;
            return file.getParent();
        }
        return null;
    }

    private final PackageAnnotator.ClassCoverageInfo getCoverageForClass(XMLProjectData.ClassInfo classInfo) {
        PackageAnnotator.ClassCoverageInfo coverage = new PackageAnnotator.ClassCoverageInfo();
        coverage.totalBranchCount = classInfo.coveredBranches + classInfo.missedBranches;
        coverage.coveredBranchCount = classInfo.coveredBranches;
        coverage.totalMethodCount = classInfo.coveredMethods + classInfo.missedMethods;
        coverage.coveredMethodCount = classInfo.coveredMethods;
        coverage.totalClassCount = coverage.totalMethodCount > 0 ? 1 : 0;
        coverage.coveredClassCount = classInfo.coveredMethods > 0 ? 1 : 0;
        coverage.totalLineCount = classInfo.coveredLines + classInfo.missedLines;
        coverage.fullyCoveredLineCount = classInfo.coveredLines;
        return coverage;
    }

    private static final void createRenewRequest$lambda$0(XMLReportAnnotator this$0, CoverageSuitesBundle $suite, CoverageDataManager $dataManager) {
        this$0.annotate($suite, $dataManager, new JavaCoverageAnnotator.JavaCoverageInfoCollector(this$0));
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.myStructure = new CoverageClassStructure(project, this$0, $suite);
        Disposer.register((Disposable)((Disposable)this$0), (Disposable)this$0.myStructure);
        $dataManager.triggerPresentationUpdate();
    }

    private static final Module[] annotate$lambda$1(CoverageSuitesBundle $suite) {
        Project project = $suite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ModuleManager.Companion.getInstance(project).getModules();
    }

    @JvmStatic
    @NotNull
    public static final XMLReportAnnotator getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/coverage/xml/XMLReportAnnotator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/coverage/xml/XMLReportAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final XMLReportAnnotator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(XMLReportAnnotator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (XMLReportAnnotator)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

