/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongGauge;
import io.opentelemetry.api.incubator.metrics.ExtendedLongGaugeBuilder;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkLongGauge
extends AbstractInstrument
implements ExtendedLongGauge {
    private final MeterSharedState meterSharedState;
    private final WriteableMetricStorage storage;

    private SdkLongGauge(InstrumentDescriptor descriptor, MeterSharedState meterSharedState, WriteableMetricStorage storage) {
        super(descriptor);
        this.meterSharedState = meterSharedState;
        this.storage = storage;
    }

    @Override
    public void set(long value, Attributes attributes) {
        this.storage.recordLong(value, attributes, Context.current());
    }

    @Override
    public void set(long value, Attributes attributes, Context context) {
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void set(long increment) {
        this.set(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.meterSharedState.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkLongGaugeBuilder
    implements ExtendedLongGaugeBuilder {
        private final InstrumentBuilder builder;

        SdkLongGaugeBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.LONG, meterProviderSharedState, sharedState).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongGauge build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkLongGauge(x$0, x$1, x$2));
        }

        @Override
        public ExtendedLongGaugeBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        @Override
        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

