/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinFileIndexBase;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.lang.manifest.ManifestFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016J\u001a\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinStdlibIndex;", "Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinFileIndexBase;", "<init>", "()V", "getName", "Lcom/intellij/util/indexing/ID;", "Lorg/jetbrains/kotlin/name/FqName;", "Ljava/lang/Void;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getVersion", "", "INDEXER", "Companion", "kotlin.base.indices"})
@SourceDebugExtension(value={"SMAP\nKotlinStdlibIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibIndex.kt\norg/jetbrains/kotlin/idea/vfilefinder/KotlinStdlibIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class KotlinStdlibIndex
extends KotlinFileIndexBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataIndexer<FqName, Void, FileContent> INDEXER = this.indexer((Function1<? super FileContent, FqName>)((Function1)KotlinStdlibIndex::INDEXER$lambda$1));
    @NotNull
    private static final ID<FqName, Void> NAME;
    @NotNull
    private static final FqName KOTLIN_STDLIB_NAME;
    @NotNull
    private static final FqName STANDARD_LIBRARY_DEPENDENCY_NAME;
    @NotNull
    private static final String LIBRARY_NAME_MANIFEST_ATTRIBUTE = "Implementation-Title";
    @NotNull
    private static final String STDLIB_TAG_MANIFEST_ATTRIBUTE = "Kotlin-Runtime-Component";

    @NotNull
    public ID<FqName, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<FqName, Void, FileContent> getIndexer() {
        return this.INDEXER;
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{ManifestFileType.INSTANCE, PlainTextFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    public int getVersion() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FqName INDEXER$lambda$1(FileContent fileContent) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        if (fileContent.getFileType() instanceof ManifestFileType) {
            Manifest manifest = new Manifest(new ByteArrayInputStream(fileContent.getContent()));
            Attributes attributes = manifest.getMainAttributes();
            if (attributes.getValue(STDLIB_TAG_MANIFEST_ATTRIBUTE) == null) {
                return null;
            }
            String string = attributes.getValue(LIBRARY_NAME_MANIFEST_ATTRIBUTE);
            if (string == null) {
                return null;
            }
            String libraryName = string;
            fqName2 = new FqName(libraryName);
        } else if (Intrinsics.areEqual((Object)fileContent.getFileName(), (Object)"manifest")) {
            Object object;
            Properties properties = new Properties();
            Closeable attributes = new ByteArrayInputStream(fileContent.getContent());
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)attributes;
                boolean bl = false;
                properties.load(it);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)attributes, (Throwable)throwable);
            }
            object = MapsKt.getValue((Map)properties, (Object)"unique_name");
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                return null;
            }
            String libraryName = string;
            fqName2 = new FqName(libraryName);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    static {
        ID iD = ID.create((String)"org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndex");
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        NAME = iD;
        KOTLIN_STDLIB_NAME = new FqName("kotlin-stdlib");
        STANDARD_LIBRARY_DEPENDENCY_NAME = new FqName("kotlin-stdlib-common");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinStdlibIndex$Companion;", "", "<init>", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "Lorg/jetbrains/kotlin/name/FqName;", "Ljava/lang/Void;", "getNAME", "()Lcom/intellij/util/indexing/ID;", "KOTLIN_STDLIB_NAME", "getKOTLIN_STDLIB_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "STANDARD_LIBRARY_DEPENDENCY_NAME", "getSTANDARD_LIBRARY_DEPENDENCY_NAME", "LIBRARY_NAME_MANIFEST_ATTRIBUTE", "", "STDLIB_TAG_MANIFEST_ATTRIBUTE", "kotlin.base.indices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<FqName, Void> getNAME() {
            return NAME;
        }

        @NotNull
        public final FqName getKOTLIN_STDLIB_NAME() {
            return KOTLIN_STDLIB_NAME;
        }

        @NotNull
        public final FqName getSTANDARD_LIBRARY_DEPENDENCY_NAME() {
            return STANDARD_LIBRARY_DEPENDENCY_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

