/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0004J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/util/DialogWithEditor;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "initialText", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "init", "", "createEditor", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "dispose", "kotlin.idea"})
public class DialogWithEditor
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final String initialText;
    @NotNull
    private final Editor editor;

    public DialogWithEditor(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        super(project, true);
        this.project = project;
        this.initialText = initialText;
        this.editor = this.createEditor();
        this.init();
        this.setTitle(title);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    protected final void init() {
        super.init();
    }

    private final Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNull((Object)editorFactory);
        EditorFactory editorFactory2 = editorFactory;
        LightVirtualFile virtualFile = new LightVirtualFile("dummy.kt", (FileType)KotlinFileType.INSTANCE, (CharSequence)this.initialText);
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        Editor editor = editorFactory2.createEditor(document2, this.project, (FileType)KotlinFileType.INSTANCE, false);
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings settings2 = editorSettings;
        settings2.setVirtualSpace(false);
        settings2.setLineMarkerAreaShown(false);
        settings2.setFoldingOutlineShown(false);
        settings2.setRightMarginShown(false);
        settings2.setAdditionalPageAtBottom(false);
        settings2.setAdditionalLinesCount(2);
        settings2.setAdditionalColumnsCount(12);
        boolean bl = editor instanceof EditorEx;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        ((EditorEx)editor).getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, ((EditorEx)editor).getColorsScheme().getDefaultBackground());
        return editor;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.editor.getComponent(), "Center");
        return panel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    protected void dispose() {
        super.dispose();
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNull((Object)editorFactory);
        editorFactory.releaseEditor(this.editor);
    }
}

