/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticFileRenamer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticFileRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenamer", "Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticFileRenamer;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "isEnabled", "setEnabled", "", "enabled", "getOptionName", "kotlin.refactorings.common"})
public class AutomaticFileRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof KtNamedFunction) && !(element instanceof KtVariableDeclaration)) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return false;
        }
        KtFile file = ktFile2;
        Object object = CollectionsKt.singleOrNull((List)file.getDeclarations());
        KtNamedDeclaration ktNamedDeclaration = object instanceof KtNamedDeclaration ? (KtNamedDeclaration)object : null;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        return Intrinsics.areEqual((Object)declaration.getName(), (Object)file.getVirtualFile().getNameWithoutExtension()) && Intrinsics.areEqual((Object)element, (Object)declaration);
    }

    @NotNull
    public AutomaticFileRenamer createRenamer(@NotNull PsiElement element, @NotNull String newName, @NotNull Collection<? extends UsageInfo> usages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return new AutomaticFileRenamer((KtFile)psiFile, newName);
    }

    public boolean isEnabled() {
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRenameFileNames();
    }

    public void setEnabled(boolean enabled) {
        KotlinCommonRefactoringSettings.Companion.getInstance().setRenameFileNames(enabled);
    }

    @Nullable
    public String getOptionName() {
        return KotlinBundle.message((String)"rename.file", (Object[])new Object[0]);
    }
}

