/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveDeclarationDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSource;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSourceKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/KotlinChangePackageRefactoring;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "run", "", "newFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.idea"})
public final class KotlinChangePackageRefactoring {
    @NotNull
    private final KtFile file;
    @NotNull
    private final Project project;

    public KotlinChangePackageRefactoring(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        Project project = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    public final void run(@NotNull FqName newFqName) {
        Intrinsics.checkNotNullParameter((Object)newFqName, (String)"newFqName");
        KtPackageDirective ktPackageDirective = this.file.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        FqName fqName2 = packageDirective.getFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqName(...)");
        FqName currentFqName = fqName2;
        KotlinMoveSource kotlinMoveSource = KotlinMoveSourceKt.KotlinMoveSource(this.file);
        PsiDirectory psiDirectory = this.file.getContainingDirectory();
        Intrinsics.checkNotNull((Object)psiDirectory);
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        MoveKotlinDeclarationsProcessor declarationProcessor = new MoveKotlinDeclarationsProcessor(new MoveDeclarationsDescriptor(this.project, kotlinMoveSource, new KotlinMoveTarget.Directory(newFqName, virtualFile), KotlinMoveDeclarationDelegate.TopLevel.INSTANCE, KotlinRefactoringSettings.Companion.getInstance().MOVE_SEARCH_IN_COMMENTS, KotlinRefactoringSettings.Companion.getInstance().MOVE_SEARCH_FOR_TEXT, false, null, false, null, false, false, 4032, null), null, false, 6, null);
        String string = RefactoringBundle.message((String)"progress.text");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        List list2 = (List)ProgressUtilsKt.runSynchronouslyWithProgress(this.project, string, true, () -> KotlinChangePackageRefactoring.run$lambda$1(declarationProcessor));
        if (list2 == null) {
            return;
        }
        List declarationUsages = list2;
        MoveContainerChangeInfo changeInfo = new MoveContainerChangeInfo(new MoveContainerInfo.Package(currentFqName), new MoveContainerInfo.Package(newFqName));
        List<UsageInfo> internalUsages = MoveUtilKt.getInternalReferencesToUpdateOnPackageNameChange((KtElement)this.file, changeInfo);
        Object[] objectArray = new Object[]{newFqName};
        ApplicationUtilsKt.executeCommand$default(this.project, KotlinBundle.message((String)"text.change.file.package.to.0", (Object[])objectArray), null, () -> KotlinChangePackageRefactoring.run$lambda$3(declarationProcessor, declarationUsages, packageDirective, newFqName, internalUsages, this), 2, null);
    }

    private static final List run$lambda$1$lambda$0(MoveKotlinDeclarationsProcessor $declarationProcessor) {
        return ArraysKt.toList((Object[])$declarationProcessor.findUsages());
    }

    private static final List run$lambda$1(MoveKotlinDeclarationsProcessor $declarationProcessor) {
        return (List)ActionsKt.runReadAction(() -> KotlinChangePackageRefactoring.run$lambda$1$lambda$0($declarationProcessor));
    }

    private static final Unit run$lambda$3$lambda$2(KtPackageDirective $packageDirective, FqName $newFqName, List $internalUsages, KotlinChangePackageRefactoring this$0) {
        $packageDirective.setFqName(FqNameUtils.quoteIfNeeded($newFqName));
        MoveUtilKt.postProcessMoveUsages$default($internalUsages, null, null, 6, null);
        DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests$default(this$0.project, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$3(MoveKotlinDeclarationsProcessor $declarationProcessor, List $declarationUsages, KtPackageDirective $packageDirective, FqName $newFqName, List $internalUsages, KotlinChangePackageRefactoring this$0) {
        ActionsKt.runWriteAction(() -> KotlinChangePackageRefactoring.run$lambda$3$lambda$2($packageDirective, $newFqName, $internalUsages, this$0));
        $declarationProcessor.execute($declarationUsages);
        return Unit.INSTANCE;
    }
}

