/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.internal.statistic.collectors.fus.LangCustomRuleValidator;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.inline.ElementType;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\u00020\u000b*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010\u001d\u001a\u00020\u000b*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineRefactoringFUSCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "elementType", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/ElementType;", "languageFrom", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "languageTo", "isCrossLang", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "pluginInfo", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "event", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "log", "", "Lcom/intellij/lang/Language;", "isCrossLanguage", "", "elementFrom", "Lcom/intellij/psi/PsiElement;", "type", "Lorg/jetbrains/kotlin/psi/KtElement;", "getType", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/refactoring/inline/ElementType;", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/idea/refactoring/inline/ElementType;", "kotlin.refactorings.common"})
public final class KotlinInlineRefactoringFUSCollector
extends CounterUsagesCollector {
    @NotNull
    public static final KotlinInlineRefactoringFUSCollector INSTANCE = new KotlinInlineRefactoringFUSCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("kotlin.ide.refactoring.inline", 4, null, 4, null);
    @NotNull
    private static final EnumEventField<ElementType> elementType = EventFields.Enum$default((String)"element_type", ElementType.class, null, (int)4, null);
    @NotNull
    private static final StringEventField languageFrom = EventFields.StringValidatedByCustomRule((String)"language_from", LangCustomRuleValidator.class);
    @NotNull
    private static final StringEventField languageTo = EventFields.StringValidatedByCustomRule((String)"language_to", LangCustomRuleValidator.class);
    @NotNull
    private static final BooleanEventField isCrossLang = EventFields.Boolean((String)"is_cross_lang");
    @NotNull
    private static final PrimitiveEventField<PluginInfo> pluginInfo = EventFields.PluginInfo;
    @NotNull
    private static final VarargEventId event;

    private KotlinInlineRefactoringFUSCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final EventLogGroup getGROUP() {
        return GROUP;
    }

    private final void log(ElementType elementType, Language languageFrom, Language languageTo, boolean isCrossLanguage) {
        EventPair[] eventPairArray = new EventPair[]{KotlinInlineRefactoringFUSCollector.elementType.with((Object)elementType), KotlinInlineRefactoringFUSCollector.languageFrom.with((Object)languageFrom.getID()), KotlinInlineRefactoringFUSCollector.languageTo.with((Object)languageTo.getID()), isCrossLang.with((Object)isCrossLanguage), pluginInfo.with((Object)PluginInfoDetectorKt.getPluginInfo(KotlinInlineRefactoringFUSCollector.class))};
        event.log(eventPairArray);
    }

    public final void log(@NotNull PsiElement elementFrom, @NotNull Language languageTo, boolean isCrossLanguage) {
        Intrinsics.checkNotNullParameter((Object)elementFrom, (String)"elementFrom");
        Intrinsics.checkNotNullParameter((Object)languageTo, (String)"languageTo");
        ElementType elementType = elementFrom instanceof KtElement ? this.getType((KtElement)elementFrom) : this.getType(elementFrom);
        Language language = elementFrom.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        this.log(elementType, language, languageTo, isCrossLanguage);
    }

    private final ElementType getType(KtElement $this$type) {
        KtElement ktElement = $this$type;
        return ktElement instanceof KtConstructor ? ElementType.CONSTRUCTOR : (ktElement instanceof KtFunctionLiteral ? ElementType.LAMBDA_EXPRESSION : (ktElement instanceof KtNamedFunction ? (((KtNamedFunction)$this$type).getNameIdentifier() == null ? ElementType.ANONYMOUS_FUNCTION : ElementType.FUNCTION) : (ktElement instanceof KtTypeAlias ? ElementType.TYPE_ALIAS : (ktElement instanceof KtProperty ? (((KtProperty)$this$type).isLocal() ? ElementType.LOCAL_VARIABLE : ElementType.PROPERTY) : ElementType.UNKNOWN))));
    }

    private final ElementType getType(PsiElement $this$type) {
        if (!Intrinsics.areEqual((Object)$this$type.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
            return ElementType.UNKNOWN;
        }
        PsiElement psiElement = $this$type;
        return psiElement instanceof PsiMethod ? (((PsiMethod)$this$type).isConstructor() ? ElementType.CONSTRUCTOR : ElementType.FUNCTION) : (psiElement instanceof PsiField ? ElementType.PROPERTY : ElementType.UNKNOWN);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{elementType, languageFrom, languageTo, isCrossLang, pluginInfo};
        event = GROUP.registerVarargEvent("Launched", eventFieldArray);
    }
}

