/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInliner.CodeInliner;
import org.jetbrains.kotlin.idea.codeInliner.UsageReplacementStrategyKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.OperatorToFunctionConverter;
import org.jetbrains.kotlin.idea.intentions.LambdaToAnonymousFunctionIntention;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinDeclarationInlineProcessor;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineAnonymousFunctionProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineNamedFunctionProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.CodeToInline;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacadeKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineAnonymousFunctionProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinDeclarationInlineProcessor;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "function", "usage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "usages", "([Lcom/intellij/usageView/UsageInfo;)V", "Companion", "kotlin.idea"})
public final class KotlinInlineAnonymousFunctionProcessor
extends AbstractKotlinDeclarationInlineProcessor<KtFunction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtExpression usage;

    public KotlinInlineAnonymousFunctionProcessor(@NotNull KtFunction function, @NotNull KtExpression usage, @Nullable Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((KtDeclaration)function, editor, project);
        this.usage = usage;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)this.usage)};
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        Companion.performRefactoring(this.usage, this.getEditor());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J'\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000b\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineAnonymousFunctionProcessor$Companion;", "", "<init>", "()V", "findCallExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "performRefactoring", "", "usage", "editor", "Lcom/intellij/openapi/editor/Editor;", "findFunction", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "convertFunctionToAnonymousFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "showErrorHint", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinInlineAnonymousFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInlineAnonymousFunctionProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineAnonymousFunctionProcessor$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,135:1\n119#2:136\n*S KotlinDebug\n*F\n+ 1 KotlinInlineAnonymousFunctionProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineAnonymousFunctionProcessor$Companion\n*L\n60#1:136\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtExpression findCallExpression(@NotNull KtFunction function) {
            Object object;
            KtExpression psiElement;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            PsiElement psiElement2 = (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)function)), Companion::findCallExpression$lambda$0));
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
            KtExpression ktExpression = psiElement = psiElement3 instanceof KtExpression ? (KtExpression)psiElement3 : null;
            if (ktExpression != null) {
                PsiElement it = psiElement3 = ktExpression;
                boolean bl = false;
                object = it instanceof KtCallExpression || it instanceof KtQualifiedExpression && KotlinInlineAnonymousFunctionProcessorKt.access$isInvokeCall(((KtQualifiedExpression)it).getSelectorExpression()) ? psiElement3 : null;
            } else {
                object = null;
            }
            return object;
        }

        public final void performRefactoring(@NotNull KtExpression usage, @Nullable Editor editor) {
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Project project = usage.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            KtExpression ktExpression = usage;
            if (ktExpression instanceof KtQualifiedExpression) {
                psiElement = (PsiElement)((KtQualifiedExpression)usage).getSelectorExpression();
            } else if (ktExpression instanceof KtCallExpression) {
                psiElement = ((KtSimpleNameExpression)OperatorToFunctionConverter.INSTANCE.convert(usage).getSecond()).getParent();
            } else {
                return;
            }
            PsiElement psiElement2 = psiElement;
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            KtCallExpression invokeCallExpression = (KtCallExpression)psiElement2;
            KtExpression ktExpression2 = invokeCallExpression.getCalleeExpression();
            if (ktExpression2 != null) {
                KtExpression $this$safeAs$iv = ktExpression2;
                boolean $i$f$safeAs = false;
                KtExpression ktExpression3 = $this$safeAs$iv;
                if (!(ktExpression3 instanceof KtReferenceExpression)) {
                    ktExpression3 = null;
                }
                if ((ktExpression2 = (KtReferenceExpression)ktExpression3) != null) {
                    KtExpression it = ktExpression2;
                    boolean bl = false;
                    UsageReplacementStrategyKt.unwrapSpecialUsageOrNull((KtReferenceExpression)it);
                }
            }
            PsiElement psiElement3 = invokeCallExpression.getParent();
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)psiElement3;
            KtFunction ktFunction = this.findFunction(qualifiedExpression);
            if (ktFunction == null) {
                this.showErrorHint(project2, editor, KotlinBundle.message((String)"refactoring.the.function.not.found", (Object[])new Object[0]));
                return;
            }
            KtFunction function = ktFunction;
            KtNamedFunction ktNamedFunction = this.convertFunctionToAnonymousFunction(function);
            if (ktNamedFunction == null) {
                this.showErrorHint(project2, editor, KotlinBundle.message((String)"refactoring.the.function.cannot.be.converted.to.anonymous.function", (Object[])new Object[0]));
                return;
            }
            KtNamedFunction namedFunction = ktNamedFunction;
            CodeToInline codeToInline = KotlinInlineNamedFunctionProcessorKt.createCodeToInlineForFunction$default(namedFunction, editor, false, 4, null);
            if (codeToInline == null) {
                return;
            }
            CodeToInline codeToInline2 = codeToInline;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)invokeCallExpression, BodyResolveMode.PARTIAL_WITH_CFA);
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)invokeCallExpression), (BindingContext)context2);
            if (resolvedCall == null) {
                this.showErrorHint(project2, editor, KotlinBundle.message((String)"refactoring.the.invocation.cannot.be.resolved", (Object[])new Object[0]));
                return;
            }
            ResolvedCall resolvedCall2 = resolvedCall;
            LanguageVersionSettings languageVersionSettings = ResolutionFacadeKt.getLanguageVersionSettings(ResolutionUtils.getResolutionFacade((KtElement)invokeCallExpression));
            new CodeInliner(languageVersionSettings, null, context2, (ResolvedCall<? extends CallableDescriptor>)resolvedCall2, (KtElement)invokeCallExpression, false, codeToInline2).doInline();
        }

        private final KtFunction findFunction(KtQualifiedExpression qualifiedExpression) {
            KtElement expression = KotlinUtilsKt.deparenthesize((KtElement)((KtElement)qualifiedExpression.getReceiverExpression()));
            return expression instanceof KtLambdaExpression ? (KtFunction)((KtLambdaExpression)expression).getFunctionLiteral() : (expression instanceof KtNamedFunction ? (KtFunction)expression : null);
        }

        private final KtNamedFunction convertFunctionToAnonymousFunction(KtFunction function) {
            Object object;
            KtFunction ktFunction = function;
            if (ktFunction instanceof KtNamedFunction) {
                object = (KtNamedFunction)function;
            } else if (ktFunction instanceof KtFunctionLiteral) {
                PsiElement psiElement = ((KtFunctionLiteral)function).getParent();
                KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
                if (ktLambdaExpression == null) {
                    return null;
                }
                KtLambdaExpression lambdaExpression = ktLambdaExpression;
                DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)function);
                FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                if (functionDescriptor == null) {
                    return null;
                }
                FunctionDescriptor descriptor2 = functionDescriptor;
                psiElement = LambdaToAnonymousFunctionIntention.Holder.convertLambdaToFunction$default(LambdaToAnonymousFunctionIntention.Holder.INSTANCE, lambdaExpression, descriptor2, null, null, null, null, null, 124, null);
                object = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            } else {
                object = null;
            }
            return object;
        }

        private final void showErrorHint(Project project, Editor editor, String message2) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)KotlinBundle.message((String)"title.inline.function", (Object[])new Object[0]), (String)"refactoring.inlineMethod");
        }

        private static final boolean findCallExpression$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof KtParenthesizedExpression || it instanceof KtLambdaExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

