/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.platform.backend.observation.Observation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;
import org.jetbrains.kotlin.idea.quickfix.AbstractChangeFeatureSupportLevelFix;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 O2\u00020\u0001:\u0001OB+\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0003H\u0014J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0003H$J \u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010+\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H$J(\u0010.\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0016J(\u00103\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J(\u00104\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00105\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0014J8\u00106\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u00107\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0005H\u0004J4\u00109\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010:\u001a\u0004\u0018\u00010\u00032\b\u0010;\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0005H\u0016J0\u0010?\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0017J(\u0010H\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010>\u001a\u00020\u0005H\u0016J,\u0010M\u001a\u0004\u0018\u00010A2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\b\b\u0001\u0010N\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "testArtifactId", "", "addJunit", "", "name", "presentableText", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPresentableText", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleSourceRootGroup;", "isApplicable", "module", "Lcom/intellij/openapi/module/Module;", "checkKotlinPlugin", "hasKotlinPlugin", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureAndGetConfiguredModules", "", "queueSyncIfNeeded", "queueSyncAndWaitForProjectToBeConfigured", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMinimumSupportedVersion", "isKotlinModule", "isRelevantGoal", "goalName", "createExecutions", "pomFile", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getStdlibArtifactId", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "configureModule", "file", "Lcom/intellij/psi/PsiFile;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "changePomFile", "configurePlugin", "plugin", "createExecution", "executionId", "isTest", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "forTests", "addLibraryDependency", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "changeMavenFeatureConfiguration", "messageTitle", "Companion", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nKotlinMavenConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMavenConfigurator.kt\norg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1#2:368\n1755#3,3:369\n1755#3,2:372\n1755#3,3:374\n1757#3:377\n*S KotlinDebug\n*F\n+ 1 KotlinMavenConfigurator.kt\norg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator\n*L\n92#1:369,3\n102#1:372,2\n103#1:374,3\n102#1:377\n*E\n"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String testArtifactId;
    private final boolean addJunit;
    @NotNull
    private final String name;
    @NotNull
    private final String presentableText;
    @NotNull
    public static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    public static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    @NotNull
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";

    protected KotlinMavenConfigurator(@Nullable String testArtifactId, boolean addJunit, @NotNull String name2, @NotNull String presentableText) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)presentableText, (String)"presentableText");
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name2;
        this.presentableText = presentableText;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module = moduleSourceRootGroup.getBaseModule();
        if (BuildSystemTypeKt.getBuildSystemType(module) != BuildSystemType.Maven) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        PsiFile psi = (PsiFile)ActionsKt.runReadAction(() -> KotlinMavenConfigurator.getStatus$lambda$0(module));
        if (psi == null || !psi.isValid() || !(psi instanceof XmlFile) || ((XmlFile)psi).getVirtualFile() == null) {
            return ConfigureKotlinStatus.BROKEN;
        }
        if (this.isKotlinModule(module)) {
            return (ConfigureKotlinStatus)((Object)ActionsKt.runReadAction(() -> KotlinMavenConfigurator.getStatus$lambda$1(this, module)));
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return BuildSystemTypeKt.getBuildSystemType(module) == BuildSystemType.Maven;
    }

    private final ConfigureKotlinStatus checkKotlinPlugin(Module module) {
        boolean bl;
        block15: {
            Object v3;
            block13: {
                PsiFile psiFile = Companion.findModulePomFile(module);
                XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
                if (xmlFile == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                XmlFile psi = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
                if (pomFile == null) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                PomFile pom = pomFile;
                if (this.hasKotlinPlugin(pom)) {
                    return ConfigureKotlinStatus.CONFIGURED;
                }
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
                MavenProject mavenProject = mavenProjectsManager.findProject(module);
                if (mavenProject == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                MavenProject mavenProject2 = mavenProject;
                MavenId kotlinPluginId = PomFileKt.kotlinPluginId(null);
                Iterable iterable = mavenProject2.getPlugins();
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    MavenPlugin it = (MavenPlugin)t;
                    boolean bl2 = false;
                    if (!it.getMavenId().equals(kotlinPluginId.getGroupId(), kotlinPluginId.getArtifactId())) continue;
                    v3 = t;
                    break block13;
                }
                v3 = null;
            }
            MavenPlugin mavenPlugin = v3;
            if (mavenPlugin == null) {
                return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
            }
            MavenPlugin kotlinPlugin = mavenPlugin;
            List list2 = kotlinPlugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExecutions(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block14: {
                        MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv;
                        boolean bl4 = false;
                        List list3 = it.getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getGoals(...)");
                        Iterable $this$any$iv2 = list3;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String p0 = (String)element$iv2;
                                boolean bl5 = false;
                                boolean $i$f$checkKotlinPlugin$lambda$3$stub_for_inlining = false;
                                if (!this.isRelevantGoal(p0)) continue;
                                bl3 = true;
                                break block14;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final boolean hasKotlinPlugin(PomFile pom) {
        boolean bl;
        block9: {
            MavenDomPlugin mavenDomPlugin = pom.findPlugin(PomFileKt.kotlinPluginId(null));
            if (mavenDomPlugin == null) {
                return false;
            }
            MavenDomPlugin plugin = mavenDomPlugin;
            List list2 = plugin.getExecutions().getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExecutions(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        MavenDomPluginExecution it = (MavenDomPluginExecution)element$iv;
                        boolean bl3 = false;
                        List list3 = it.getGoals().getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getGoals(...)");
                        Iterable $this$any$iv2 = list3;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                MavenDomGoal it2 = (MavenDomGoal)element$iv2;
                                boolean bl4 = false;
                                String string = it2.getStringValue();
                                if (string == null) {
                                    string = "";
                                }
                                if (!this.isRelevantGoal(string)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void configure(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        this.configureAndGetConfiguredModules(project, excludeModules);
    }

    @NotNull
    public Set<Module> configureAndGetConfiguredModules(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return SetsKt.emptySet();
        }
        String string = dialog2.getKotlinVersion();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String kotlinVersion = string;
        KotlinJ2KOnboardingFUSCollector.logStartConfigureKt$default(KotlinJ2KOnboardingFUSCollector.INSTANCE, project, false, 2, null);
        Set configuredModules = new LinkedHashSet();
        WriteCommandAction.runWriteCommandAction((Project)project, () -> KotlinMavenConfigurator.configureAndGetConfiguredModules$lambda$6(project, dialog2, this, kotlinVersion, configuredModules));
        return configuredModules;
    }

    @Override
    public void queueSyncIfNeeded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinProjectConfigurationService.Companion.getInstance(project).queueSync();
    }

    @Override
    @Nullable
    public Object queueSyncAndWaitForProjectToBeConfigured(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        return KotlinMavenConfigurator.queueSyncAndWaitForProjectToBeConfigured$suspendImpl(this, project, $completion);
    }

    static /* synthetic */ Object queueSyncAndWaitForProjectToBeConfigured$suspendImpl(KotlinMavenConfigurator $this, Project project, Continuation<? super Unit> $completion) {
        $this.queueSyncIfNeeded(project);
        Object object = Observation.awaitConfiguration$default((Observation)Observation.INSTANCE, (Project)project, null, $completion, (int)2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    @NotNull
    protected abstract String getStdlibArtifactId(@NotNull Module var1, @NotNull IdeKotlinVersion var2);

    public boolean configureModule(@NotNull Module module, @NotNull PsiFile file, @NotNull IdeKotlinVersion version, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        return this.changePomFile(module, file, version, collector2);
    }

    private final boolean changePomFile(Module module, PsiFile file, IdeKotlinVersion version, NotificationMessageCollector collector2) {
        RepositoryDescription repositoryDescription;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(("Virtual file should exists for psi file " + file.getName()).toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)virtualFile2);
        if (domModel == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinMavenConfigurator.Companion.showErrorMessage(project, null);
            return false;
        }
        Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)file);
        if (pomFile == null) {
            return false;
        }
        PomFile pom = pomFile;
        pom.addProperty(KOTLIN_VERSION_PROPERTY, version.getArtifactVersion());
        pom.addDependency(new MavenId(GROUP_ID, this.getStdlibArtifactId(module, version), "${kotlin.version}"), MavenArtifactScope.COMPILE, null, false, null);
        if (this.testArtifactId != null) {
            pom.addDependency(new MavenId(GROUP_ID, this.testArtifactId, "${kotlin.version}"), MavenArtifactScope.TEST, null, false, null);
        }
        if (this.addJunit) {
            pom.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
        }
        if ((repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version)) != null) {
            pom.addLibraryRepository(repositoryDescription);
            pom.addPluginRepository(repositoryDescription);
        }
        MavenDomPlugin plugin = pom.addPlugin(new MavenId(GROUP_ID, MAVEN_PLUGIN_ID, "${kotlin.version}"));
        this.createExecutions(pom, plugin, module);
        this.configurePlugin(pom, plugin, module, version);
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file));
        Object[] objectArray = new Object[]{virtualFile2.getPath()};
        collector2.addMessage(KotlinMavenBundle.message("file.was.modified", objectArray));
        return true;
    }

    protected void configurePlugin(@NotNull PomFile pom, @NotNull MavenDomPlugin plugin, @NotNull Module module, @NotNull IdeKotlinVersion version) {
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
        Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)goalName, (String)"goalName");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        pomFile.addKotlinExecution(module, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        boolean runtimeUpdateRequired;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (ideKotlinVersion != null && (ideKotlinVersion = ideKotlinVersion.getApiVersion()) != null) {
            IdeKotlinVersion runtimeVersion = ideKotlinVersion;
            boolean bl = false;
            v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired) {
            Object[] objectArray = new Object[]{requiredStdlibVersion};
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature", objectArray), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
            return;
        }
        PsiElement element = KotlinMavenConfigurator.updateLanguageVersion$doUpdateMavenLanguageVersion(module, languageVersion, apiVersion);
        if (element == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)KotlinMavenBundle.message("update.language.version.title", new Object[0]));
        } else {
            new OpenFileDescriptor(module.getProject(), element.getContainingFile().getVirtualFile(), element.getTextRange().getStartOffset()).navigate(true);
        }
    }

    @Override
    @Deprecated(message="Please implement/use the KotlinBuildSystemDependencyManager EP instead.", replaceWith=@ReplaceWith(expression="KotlinBuildSystemDependencyManager.findApplicableConfigurator(module)?.addDependency(module, library.withScope(scope))", imports={}))
    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element, @NotNull ExternalLibraryDescriptor library, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull DependencyScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"suggestScopeByLocation(...)");
        DependencyScope scope2 = dependencyScope;
        JavaProjectModelModificationService.getInstance((Project)module.getProject()).addDependency(module, library, scope2);
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        String messageTitle = AbstractChangeFeatureSupportLevelFix.Companion.getFixText(state, feature.getPresentableName());
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.getRuntimeLibraryVersionOrDefault(module).getApiVersion().compareTo(sinceVersion) < 0) {
            Object[] objectArray = new Object[]{feature.getPresentableName(), sinceVersion};
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("update.language.version.feature.support", objectArray), (String)messageTitle);
            return;
        }
        PsiElement element = this.changeMavenFeatureConfiguration(module, feature, state, messageTitle);
        if (element != null) {
            new OpenFileDescriptor(module.getProject(), element.getContainingFile().getVirtualFile(), element.getTextRange().getStartOffset()).navigate(true);
        }
    }

    private final PsiElement changeMavenFeatureConfiguration(Module module, LanguageFeature feature, LanguageFeature.State state, @NlsContexts.DialogTitle String messageTitle) {
        PsiFile psiFile = Companion.findModulePomFile(module);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
        if (pomFile == null) {
            return null;
        }
        PomFile pom = pomFile;
        PsiElement element = PomFileKt.changeFeatureConfiguration(pom, feature, state);
        if (element == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)KotlinMavenBundle.message("error.failed.update.pom", new Object[0]), (String)messageTitle);
        }
        return element;
    }

    private static final PsiFile getStatus$lambda$0(Module $module) {
        return Companion.findModulePomFile($module);
    }

    private static final ConfigureKotlinStatus getStatus$lambda$1(KotlinMavenConfigurator this$0, Module $module) {
        return this$0.checkKotlinPlugin($module);
    }

    private static final void configureAndGetConfiguredModules$lambda$6(Project $project, ConfigureDialogWithModulesAndVersion $dialog, KotlinMavenConfigurator this$0, String $kotlinVersion, Set $configuredModules) {
        NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create($project);
        for (Module module : MavenModulesRelationshipKt.excludeMavenChildrenModules($project, $dialog.getModulesToConfigure())) {
            PsiFile file = Companion.findModulePomFile(module);
            if (file != null && KotlinMavenConfigurator.Companion.canConfigureFile(file)) {
                boolean configured = this$0.configureModule(module, file, IdeKotlinVersion.Companion.get($kotlinVersion), collector2);
                if (!configured) continue;
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                OpenFileAction.Companion.openFile(virtualFile, $project);
                $configuredModules.add(module);
                continue;
            }
            Object[] objectArray = new Object[]{module.getName()};
            KotlinMavenConfigurator.Companion.showErrorMessage($project, KotlinMavenBundle.message("error.cant.find.pom.for.module", objectArray));
        }
        collector2.showNotification();
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction($project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void undo() {
                KotlinJ2KOnboardingFUSCollector.INSTANCE.logConfigureKtUndone(this.$project);
            }

            public void redo() {
            }
        });
        ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications($project);
    }

    private static final PsiElement updateLanguageVersion$doUpdateMavenLanguageVersion(Module $module, String $languageVersion, String $apiVersion) {
        PsiFile psiFile = Companion.findModulePomFile($module);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psi = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
        if (pomFile == null) {
            return null;
        }
        PomFile pom = pomFile;
        return PomFileKt.changeLanguageVersion(pom, $languageVersion, $apiVersion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "<init>", "()V", "GROUP_ID", "", "MAVEN_PLUGIN_ID", "KOTLIN_VERSION_PROPERTY", "findModulePomFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "canConfigureFile", "", "file", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "kotlin.maven"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiFile findModulePomFile(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            List list2 = MavenProjectsManager.getInstance((Project)module.getProject()).getProjectsFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProjectsFiles(...)");
            List files2 = list2;
            for (VirtualFile file : files2) {
                PsiFile psiFile;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)module.getProject());
                if (!Intrinsics.areEqual((Object)module, (Object)fileModule) || PsiManager.getInstance((Project)module.getProject()).findFile(file) == null || !MavenDomUtil.isProjectFile((PsiFile)psiFile)) continue;
                return psiFile;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file.getVirtualFile(), null);
        }

        private final void showErrorMessage(Project project, @NlsContexts.DialogMessage String message2) {
            String cantConfigureAutomatically = KotlinMavenBundle.message("error.cant.configure.maven.automatically", new Object[0]);
            String seeInstructions = KotlinMavenBundle.message("error.see.installation.instructions", new Object[0]);
            String string = message2;
            Messages.showErrorDialog((Project)project, (String)("<html>" + cantConfigureAutomatically + "<br/>" + (String)(string != null ? string + "</br>" : "") + seeInstructions + "</html>"), (String)KotlinMavenBundle.message("configure.title", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

