/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.maven.KotlinMavenArchetypesProviderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J9\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H#0(H\u0002\u00a2\u0006\u0002\u0010*J+\u0010+\u001a\u0002H#\"\u0004\b\u0000\u0010#*\u00020)2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H#0(H\u0002\u00a2\u0006\u0002\u0010,J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001d\u0010\n\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/maven/KotlinMavenArchetypesProvider;", "Lorg/jetbrains/idea/maven/indices/MavenArchetypesProvider;", "kotlinPluginVersion", "", "predefinedInternalMode", "", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "()V", "Ljava/lang/Boolean;", "versionPrefix", "getVersionPrefix", "()Ljava/lang/String;", "versionPrefix$delegate", "Lkotlin/Lazy;", "fallbackVersion", "internalMode", "getInternalMode", "()Z", "archetypesBlocking", "", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "getArchetypesBlocking", "()Ljava/util/List;", "archetypesBlocking$delegate", "getArchetypes", "", "fallbackArchetypes", "loadVersions", "extractVersions", "root", "Lcom/google/gson/JsonElement;", "chooseVersion", "versions", "connectAndApply", "R", "url", "timeoutSeconds", "", "block", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "use", "(Ljava/net/HttpURLConnection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "version", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nKotlinMavenArchetypesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMavenArchetypesProvider.kt\norg/jetbrains/kotlin/idea/maven/KotlinMavenArchetypesProvider\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n81#2:115\n1557#3:116\n1628#3,3:117\n1557#3:120\n1628#3,3:121\n1557#3:124\n1628#3,3:125\n774#3:128\n865#3,2:129\n1485#3:132\n1510#3,3:133\n1513#3,3:143\n1246#3,4:148\n1971#3,14:165\n58#4:131\n58#4:179\n381#5,7:136\n462#5:146\n412#5:147\n136#6,9:152\n216#6:161\n217#6:163\n145#6:164\n1#7:162\n*S KotlinDebug\n*F\n+ 1 KotlinMavenArchetypesProvider.kt\norg/jetbrains/kotlin/idea/maven/KotlinMavenArchetypesProvider\n*L\n27#1:115\n41#1:116\n41#1:117,3\n55#1:120\n55#1:121,3\n56#1:124\n56#1:125,3\n62#1:128\n62#1:129,2\n64#1:132\n64#1:133,3\n64#1:143,3\n65#1:148,4\n70#1:165,14\n62#1:131\n31#1:179\n64#1:136,7\n65#1:146\n65#1:147\n66#1:152,9\n66#1:161\n66#1:163\n66#1:164\n66#1:162\n*E\n"})
public final class KotlinMavenArchetypesProvider
implements MavenArchetypesProvider {
    @NotNull
    private final String kotlinPluginVersion;
    @Nullable
    private final Boolean predefinedInternalMode;
    @NotNull
    private final Lazy versionPrefix$delegate;
    @NotNull
    private final String fallbackVersion;
    @NotNull
    private final Lazy archetypesBlocking$delegate;

    public KotlinMavenArchetypesProvider(@NotNull String kotlinPluginVersion, @Nullable Boolean predefinedInternalMode) {
        Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.predefinedInternalMode = predefinedInternalMode;
        this.versionPrefix$delegate = LazyKt.lazy(() -> KotlinMavenArchetypesProvider.versionPrefix_delegate$lambda$0(this));
        this.fallbackVersion = "1.0.3";
        this.archetypesBlocking$delegate = LazyKt.lazy(() -> KotlinMavenArchetypesProvider.archetypesBlocking_delegate$lambda$2(this));
    }

    public KotlinMavenArchetypesProvider() {
        this(KotlinIdePlugin.INSTANCE.getVersion(), null);
    }

    private final String getVersionPrefix() {
        Lazy lazy = this.versionPrefix$delegate;
        return (String)lazy.getValue();
    }

    private final boolean getInternalMode() {
        boolean bl;
        Boolean bl2 = this.predefinedInternalMode;
        if (bl2 != null) {
            bl = bl2;
        } else {
            boolean $i$f$isApplicationInternalMode = false;
            bl = ApplicationManager.getApplication().isInternal();
        }
        return bl;
    }

    private final List<MavenArchetype> getArchetypesBlocking() {
        Lazy lazy = this.archetypesBlocking$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<MavenArchetype> getArchetypes() {
        return CollectionsKt.toMutableList((Collection)this.getArchetypesBlocking());
    }

    /*
     * WARNING - void declaration
     */
    private final List<MavenArchetype> fallbackArchetypes() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{"kotlin-archetype-jvm", "kotlin-archetype-js"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MavenArchetype("org.jetbrains.kotlin", (String)it, this.fallbackVersion, null, null));
        }
        return (List)destination$iv$iv;
    }

    private final List<MavenArchetype> loadVersions() {
        return (List)KotlinMavenArchetypesProvider.connectAndApply$default(this, KotlinMavenArchetypesProviderKt.access$getVERSIONS_LIST_URL$p(), 0, arg_0 -> KotlinMavenArchetypesProvider.loadVersions$lambda$5(this, arg_0), 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MavenArchetype> extractVersions(@NotNull JsonElement root) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapValuesTo$iv$iv;
        Object $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        MavenArchetype it;
        Object destination$iv$iv;
        List list2;
        JsonObject it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        JsonArray jsonArray = root.getAsJsonObject().get("response").getAsJsonObject().get("docs").getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
        Iterable $this$map$iv = (Iterable)jsonArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getAsJsonObject());
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (JsonObject)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new MavenArchetype(it2.get("g").getAsString(), it2.get("a").getAsString(), it2.get("v").getAsString(), null, null));
        }
        List versions = (List)destination$iv$iv2;
        boolean bl = false;
        String prefix2 = this.getVersionPrefix();
        if (this.getInternalMode() || prefix2 == null) {
            list2 = versions;
        } else {
            Collection collection2;
            void $this$ifEmpty$iv;
            void $this$filterTo$iv$iv;
            Object item$iv$iv;
            Iterable $this$filter$iv = versions;
            boolean $i$f$filter = false;
            item$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MavenArchetype)element$iv$iv;
                boolean bl2 = false;
                String string = it.version;
                if (!(string != null ? StringsKt.startsWith$default((String)string, (String)prefix2, (boolean)false, (int)2, null) : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$ifEmpty = false;
            if ($this$ifEmpty$iv.isEmpty()) {
                boolean bl3 = false;
                collection2 = versions;
            } else {
                collection2 = $this$ifEmpty$iv;
            }
            list2 = (List)collection2;
        }
        Iterable $this$ifEmpty$iv = list2;
        boolean $i$f$groupBy = false;
        void bl3 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (MavenArchetype)element$iv$iv;
            boolean bl4 = false;
            String string = it.groupId;
            String string2 = it.artifactId;
            String string3 = it.version;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"version");
            key$iv$iv = string + ":" + string2 + ":" + this.versionPrefix(string3);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it3;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl6 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object = $this$getOrPut$iv$iv$iv;
            boolean bl7 = false;
            MavenArchetype mavenArchetype = this.chooseVersion((List)it3.getValue());
            object.put(k, mavenArchetype);
        }
        $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapValuesTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            MavenArchetype it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)iterator2.next();
            boolean bl8 = false;
            Map.Entry it4 = element$iv$iv;
            boolean bl9 = false;
            if ((MavenArchetype)it4.getValue() == null) continue;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MavenArchetype chooseVersion(List<? extends MavenArchetype> versions) {
        Object v0;
        Iterable $this$maxByOrNull$iv = versions;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                MavenArchetype it = (MavenArchetype)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)new MavenVersionComparable(it.version);
                do {
                    Object e$iv = iterator$iv.next();
                    MavenArchetype it2 = (MavenArchetype)e$iv;
                    $i$a$-maxByOrNull-KotlinMavenArchetypesProvider$chooseVersion$1 = false;
                    Comparable v$iv = (Comparable)new MavenVersionComparable(it2.version);
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private final <R> R connectAndApply(String url, int timeoutSeconds, Function1<? super HttpURLConnection, ? extends R> block) {
        HttpURLConnection httpURLConnection = HttpConfigurable.getInstance().openHttpConnection(url);
        Intrinsics.checkNotNullExpressionValue((Object)httpURLConnection, (String)"openHttpConnection(...)");
        return this.use(httpURLConnection, arg_0 -> KotlinMavenArchetypesProvider.connectAndApply$lambda$15(timeoutSeconds, block, arg_0));
    }

    static /* synthetic */ Object connectAndApply$default(KotlinMavenArchetypesProvider kotlinMavenArchetypesProvider, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 15;
        }
        return kotlinMavenArchetypesProvider.connectAndApply(string, n, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R use(HttpURLConnection $this$use, Function1<? super HttpURLConnection, ? extends R> block) {
        Object object;
        try {
            object = block.invoke((Object)$this$use);
        }
        finally {
            $this$use.disconnect();
        }
        return (R)object;
    }

    private final String versionPrefix(String version) {
        MatchResult matchResult = Regex.find$default((Regex)new Regex("^\\d+\\.\\d+\\."), (CharSequence)version, (int)0, (int)2, null);
        return matchResult != null ? matchResult.getValue() : null;
    }

    private static final String versionPrefix_delegate$lambda$0(KotlinMavenArchetypesProvider this$0) {
        return this$0.versionPrefix(this$0.kotlinPluginVersion);
    }

    private static final List archetypesBlocking_delegate$lambda$2(KotlinMavenArchetypesProvider this$0) {
        List<MavenArchetype> list2;
        try {
            Collection<Object> collection;
            Collection $this$ifEmpty$iv = this$0.loadVersions();
            boolean $i$f$ifEmpty = false;
            if ($this$ifEmpty$iv.isEmpty()) {
                boolean bl = false;
                collection = this$0.fallbackArchetypes();
            } else {
                collection = list2;
            }
            list2 = collection;
        }
        catch (Throwable t) {
            list2 = this$0.fallbackArchetypes();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List loadVersions$lambda$5(KotlinMavenArchetypesProvider this$0, HttpURLConnection urlConnection) {
        Intrinsics.checkNotNullParameter((Object)urlConnection, (String)"urlConnection");
        InputStream inputStream = urlConnection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseReader(...)");
            object2 = this$0.extractVersions(jsonElement);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    private static final Object connectAndApply$lambda$15(int $timeoutSeconds, Function1 $block, HttpURLConnection urlConnection) {
        Intrinsics.checkNotNullParameter((Object)urlConnection, (String)"urlConnection");
        int timeout = (int)TimeUnit.SECONDS.toMillis($timeoutSeconds);
        urlConnection.setConnectTimeout(timeout);
        urlConnection.setReadTimeout(timeout);
        urlConnection.connect();
        return $block.invoke((Object)urlConnection);
    }
}

