/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.result;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.AssignToVariableResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ReplaceLoopResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.VariableInitialization;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence.Condition;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/FilterToTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ReplaceLoopResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "indexVariable", "targetCollection", "Lorg/jetbrains/kotlin/psi/KtExpression;", "effectiveCondition", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/Condition;", "isFilterNot", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/Condition;Z)V", "functionName", "", "presentation", "getPresentation", "()Ljava/lang/String;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Companion", "kotlin.idea"})
public final class FilterToTransformation
extends ReplaceLoopResultTransformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @Nullable
    private final KtCallableDeclaration indexVariable;
    @NotNull
    private final KtExpression targetCollection;
    @NotNull
    private final Condition effectiveCondition;
    private final boolean isFilterNot;
    @NotNull
    private final String functionName;

    private FilterToTransformation(KtForExpression loop, KtCallableDeclaration inputVariable, KtCallableDeclaration indexVariable, KtExpression targetCollection, Condition effectiveCondition, boolean isFilterNot) {
        super(loop);
        this.inputVariable = inputVariable;
        this.indexVariable = indexVariable;
        this.targetCollection = targetCollection;
        this.effectiveCondition = effectiveCondition;
        this.isFilterNot = isFilterNot;
        if (this.isFilterNot) {
            boolean bl;
            boolean bl2 = bl = this.indexVariable == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        this.functionName = this.indexVariable != null ? "filterIndexedTo" : (this.isFilterNot ? "filterNotTo" : "filterTo");
    }

    @Override
    @NotNull
    public String getPresentation() {
        return this.functionName + "(){}";
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        boolean reformat = chainedCallGenerator2.getReformat();
        KtLambdaExpression lambda2 = this.indexVariable != null ? UtilsKt.generateLambda(this.inputVariable, this.indexVariable, this.effectiveCondition.asExpression(reformat), reformat) : UtilsKt.generateLambda(this.inputVariable, this.isFilterNot ? this.effectiveCondition.asNegatedExpression(reformat) : this.effectiveCondition.asExpression(reformat), reformat);
        Object[] objectArray = new Object[]{this.targetCollection, lambda2};
        return ChainedCallGenerator.generate$default(chainedCallGenerator2, this.functionName + "($0) $1:'{}'", objectArray, null, false, 12, null);
    }

    public /* synthetic */ FilterToTransformation(KtForExpression loop, KtCallableDeclaration inputVariable, KtCallableDeclaration indexVariable, KtExpression targetCollection, Condition effectiveCondition, boolean isFilterNot, DefaultConstructorMarker $constructor_marker) {
        this(loop, inputVariable, indexVariable, targetCollection, effectiveCondition, isFilterNot);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/FilterToTransformation$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "indexVariable", "targetCollection", "Lorg/jetbrains/kotlin/psi/KtExpression;", "condition", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/sequence/Condition;", "isFilterNot", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResultTransformation create(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @Nullable KtCallableDeclaration indexVariable, @NotNull KtExpression targetCollection, @NotNull Condition condition2, boolean isFilterNot) {
            ResultTransformation resultTransformation;
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            Intrinsics.checkNotNullParameter((Object)inputVariable, (String)"inputVariable");
            Intrinsics.checkNotNullParameter((Object)targetCollection, (String)"targetCollection");
            Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
            VariableInitialization initialization = UtilsKt.findVariableInitializationBeforeLoop(targetCollection, loop, true);
            if (initialization != null && UtilsKt.hasNoSideEffect(initialization.getInitializer())) {
                FilterToTransformation transformation = new FilterToTransformation(loop, inputVariable, indexVariable, initialization.getInitializer(), condition2, isFilterNot, null);
                resultTransformation = AssignToVariableResultTransformation.Companion.createDelegated(transformation, initialization);
            } else {
                resultTransformation = new FilterToTransformation(loop, inputVariable, indexVariable, targetCollection, condition2, isFilterNot, null);
            }
            return resultTransformation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

