/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.framework.FrameworksCompatibilityUtils;
import org.jetbrains.kotlin.idea.framework.JavaFrameworkType;
import org.jetbrains.kotlin.idea.projectConfiguration.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.statistics.WizardStatsService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider;", "Lcom/intellij/framework/addSupport/FrameworkSupportInModuleProvider;", "<init>", "()V", "getFrameworkType", "Lcom/intellij/framework/FrameworkTypeEx;", "createConfigurable", "Lcom/intellij/framework/addSupport/FrameworkSupportInModuleConfigurable;", "model", "Lcom/intellij/ide/util/frameworkSupport/FrameworkSupportModel;", "isEnabledForModuleType", "", "moduleType", "Lcom/intellij/openapi/module/ModuleType;", "canAddSupport", "module", "Lcom/intellij/openapi/module/Module;", "facetsProvider", "Lcom/intellij/openapi/roots/ui/configuration/FacetsProvider;", "kotlin.jvm"})
public final class JavaFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return JavaFrameworkType.Companion.getInstance();
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new FrameworkSupportInModuleConfigurable(model2){
            private JavaRuntimeLibraryDescription description;
            final /* synthetic */ FrameworkSupportModel $model;
            {
                this.$model = $model;
            }

            public CustomLibraryDescription createLibraryDescription() {
                this.description = new JavaRuntimeLibraryDescription(this.$model.getProject());
                return this.description;
            }

            public JComponent createComponent() {
                return null;
            }

            public boolean isOnlyLibraryAdded() {
                return true;
            }

            public void addSupport(Module module, ModifiableRootModel rootModel, ModifiableModelsProvider modifiableModelsProvider) {
                boolean isNewProject;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
                Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
                FrameworksCompatibilityUtils.suggestRemoveIncompatibleFramework(rootModel, JSLibraryStdDescription.Companion.getSUITABLE_LIBRARY_KINDS(), KotlinJvmBundle.message("presentable.name.kotlin.js", new Object[0]));
                JavaRuntimeLibraryDescription javaRuntimeLibraryDescription = this.description;
                Intrinsics.checkNotNull((Object)((Object)javaRuntimeLibraryDescription));
                javaRuntimeLibraryDescription.finishLibConfiguration(module, rootModel, false);
                boolean bl = isNewProject = this.$model.getProject() == null;
                if (isNewProject) {
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    ProjectCodeStyleImporter.INSTANCE.apply(project, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                }
                WizardStatsService.ProjectCreationStats projectCreationStats = new WizardStatsService.ProjectCreationStats("Java", "Kotlin/JVM", "jps", null, 8, null);
                WizardStatsService.INSTANCE.logDataOnProjectGenerated(null, module.getProject(), projectCreationStats);
            }

            public void onFrameworkSelectionChanged(boolean selected) {
                String providerId;
                if (selected && this.$model.isFrameworkSelected(providerId = "kotlin-js-framework-id")) {
                    this.$model.setFrameworkComponentEnabled(providerId, false);
                }
            }
        };
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType<?> moduleType) {
        Intrinsics.checkNotNullParameter(moduleType, (String)"moduleType");
        return moduleType instanceof JavaModuleType;
    }

    public boolean canAddSupport(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)facetsProvider, (String)"facetsProvider");
        return super.canAddSupport(module, facetsProvider) && BuildSystemTypeKt.getBuildSystemType(module) == BuildSystemType.JPS;
    }
}

