/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.EntryChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.LiteralChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.NewLineChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.TemplateChunk;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.TemplateTokenSequence;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J2\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "<init>", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "singleQuotedPaste", "interpolationPrefixLength", "", "tripleQuotedPaste", "begin", "Lcom/intellij/psi/PsiElement;", "beginTp", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nKotlinLiteralCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,206:1\n1317#2,2:207\n1#3:209\n1069#4,2:210\n648#4,5:212\n*S KotlinDebug\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor\n*L\n140#1:207,2\n174#1:210,2\n167#1:212,5\n*E\n"})
public final class KotlinLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(file instanceof KtFile)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean changed2 = false;
        String fileText = ((KtFile)file).getText();
        int deducedBlockSelectionWidth = KotlinLiteralCopyPasteProcessorKt.access$deduceBlockSelectionWidth(startOffsets, endOffsets, text);
        int n = startOffsets.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                buffer.append('\n');
            }
            TextRange fileRange = new TextRange(startOffsets[i2], endOffsets[i2]);
            int givenTextOffset = fileRange.getStartOffset();
            while (givenTextOffset < fileRange.getEndOffset()) {
                TextRange inter;
                PsiElement tpEntry;
                IElementType elTp;
                PsiElement element = ((KtFile)file).findElementAt(givenTextOffset);
                if (element == null) {
                    Intrinsics.checkNotNull((Object)fileText);
                    String string = fileText.substring(givenTextOffset, fileRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    buffer.append(string);
                    break;
                }
                Intrinsics.checkNotNullExpressionValue((Object)element.getNode().getElementType(), (String)"getElementType(...)");
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.ESCAPE_SEQUENCE) && fileRange.contains(FixersUtilKt.getRange((PsiElement)element))) {
                    TextRange textRange = KotlinLiteralCopyPasteProcessorKt.access$getTemplateContentRange(element);
                    boolean bl = textRange != null ? textRange.contains(fileRange) : false;
                    if (bl) {
                        PsiElement psiElement = element.getParent();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry");
                        tpEntry = (KtEscapeStringTemplateEntry)psiElement;
                        changed2 = true;
                        buffer.append(tpEntry.getUnescapedValue());
                        givenTextOffset = PsiUtilsKt.getEndOffset((PsiElement)element);
                        continue;
                    }
                }
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)elTp, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                    TextRange inter2;
                    tpEntry = element.getParent();
                    Intrinsics.checkNotNull((Object)tpEntry);
                    Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange((PsiElement)tpEntry)));
                    Intrinsics.checkNotNull((Object)fileText);
                    String string = fileText.substring(inter2.getStartOffset(), inter2.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    buffer.append(string);
                    givenTextOffset = inter2.getEndOffset();
                    continue;
                }
                Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange((PsiElement)element)));
                Intrinsics.checkNotNull((Object)fileText);
                String string = fileText.substring(inter.getStartOffset(), inter.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                buffer.append(string);
                givenTextOffset = inter.getEndOffset();
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - fileRange.getLength();
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
            }
        }
        return changed2 ? buffer.toString() : null;
    }

    @NotNull
    public String preprocessOnPaste(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(file instanceof KtFile)) {
            return text;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        PsiElement psiElement = ((KtFile)file).findElementAt(selectionModel2.getSelectionStart());
        if (psiElement == null) {
            return text;
        }
        PsiElement begin = psiElement;
        KtStringTemplateExpression ktStringTemplateExpression = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file, selectionModel2.getSelectionStart(), begin);
        if (ktStringTemplateExpression == null) {
            return text;
        }
        KtStringTemplateExpression beginTp = ktStringTemplateExpression;
        KtStringTemplateExpression ktStringTemplateExpression2 = KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral$default(file, selectionModel2.getSelectionEnd(), null, 2, null);
        if (ktStringTemplateExpression2 == null) {
            return text;
        }
        KtStringTemplateExpression endTp = ktStringTemplateExpression2;
        if (KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) != KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)endTp)) {
            return text;
        }
        PsiElement interpolationPrefix = beginTp.getInterpolationPrefix();
        if (!Intrinsics.areEqual((Object)interpolationPrefix, (Object)endTp.getInterpolationPrefix())) {
            return text;
        }
        PsiElement psiElement2 = interpolationPrefix;
        int prefixLength = psiElement2 != null ? psiElement2.getTextLength() : 0;
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) ? this.singleQuotedPaste(text, prefixLength) : this.tripleQuotedPaste(text, prefixLength, begin, beginTp);
    }

    private final String singleQuotedPaste(String text, int interpolationPrefixLength) {
        Object object;
        StringBuilder res = new StringBuilder();
        String interpolationPrefix = StringsKt.repeat((CharSequence)"$", (int)interpolationPrefixLength);
        String lineBreak = "\\n\"+\n " + interpolationPrefix + "\"";
        String additionalEscapedChars = interpolationPrefixLength > 1 ? "\"" : "$\"";
        boolean endsInLineBreak = false;
        Sequence $this$forEach$iv = new TemplateTokenSequence(text, interpolationPrefixLength);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TemplateChunk it = (TemplateChunk)element$iv;
            boolean bl = false;
            TemplateChunk templateChunk = it;
            if (templateChunk instanceof LiteralChunk) {
                v0 = StringUtil.escapeStringCharacters((int)((LiteralChunk)it).getText().length(), (String)((LiteralChunk)it).getText(), (String)additionalEscapedChars, (StringBuilder)res);
            } else if (templateChunk instanceof EntryChunk) {
                v0 = res.append(((EntryChunk)it).getText());
            } else if (templateChunk instanceof NewLineChunk) {
                v0 = res.append(lineBreak);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            endsInLineBreak = it instanceof NewLineChunk;
        }
        if (endsInLineBreak) {
            object = StringsKt.removeSuffix((CharSequence)res, (CharSequence)lineBreak) + "\\n";
        } else {
            String string = res.toString();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final String tripleQuotedPaste(String text, int interpolationPrefixLength, PsiElement begin, KtStringTemplateExpression beginTp) {
        StringBuilder stringBuilder;
        String string;
        String string2;
        TemplateTokenSequence templateTokenSequence;
        block11: {
            boolean bl;
            Object object;
            block7: {
                CharSequence $this$all$iv;
                block10: {
                    block8: {
                        block9: {
                            templateTokenSequence = new TemplateTokenSequence(text, interpolationPrefixLength);
                            PsiElement psiElement = beginTp.getFirstChild();
                            if (!Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)"\"\"\"")) break block8;
                            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)beginTp));
                            Object object2 = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
                            KtCallExpression ktCallExpression = object2 instanceof KtCallExpression ? (KtCallExpression)object2 : null;
                            if (!Intrinsics.areEqual((Object)(ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null), (Object)"trimIndent")) break block8;
                            TemplateChunk templateChunk2 = (TemplateChunk)SequencesKt.firstOrNull((Sequence)templateTokenSequence);
                            templateChunk2 = (TemplateChunk)SequencesKt.lastOrNull((Sequence)templateTokenSequence);
                            if (!Intrinsics.areEqual((Object)(templateChunk != null ? KotlinLiteralCopyPasteProcessor.tripleQuotedPaste$indent(templateChunk) : null), (Object)(templateChunk2 != null ? KotlinLiteralCopyPasteProcessor.tripleQuotedPaste$indent(templateChunk2) : null))) break block8;
                            Object object3 = begin.getParent();
                            if (object3 == null || (object3 = object3.getPrevSibling()) == null || (object3 = object3.getText()) == null) break block9;
                            Object object4 = object = object3;
                            boolean bl2 = false;
                            $this$all$iv = (CharSequence)object4;
                            boolean $i$f$all = false;
                            break block10;
                        }
                        string2 = null;
                        break block11;
                    }
                    string2 = null;
                    break block11;
                }
                for (int j = 0; j < $this$all$iv.length(); ++j) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(j);
                    boolean bl3 = false;
                    if (c == ' ' || c == '\t') continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            string2 = string = bl ? object : null;
        }
        if (string2 == null) {
            string = "";
        }
        String indent = string;
        StringBuilder $this$tripleQuotedPaste_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Regex tripleQuoteRe = new Regex("[\"]{3,}");
        String string3 = "";
        Iterator<TemplateChunk> iterator2 = templateTokenSequence.iterator();
        while (true) {
            void var11_10;
            if (!iterator2.hasNext()) {
                String string4 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                return string4;
            }
            TemplateChunk chunk = iterator2.next();
            TemplateChunk templateChunk = chunk;
            if (templateChunk instanceof LiteralChunk) {
                String escapedDollar = StringsKt.replace$default((String)((LiteralChunk)chunk).getText(), (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
                boolean bl4 = false;
                String replaced = tripleQuoteRe.replace((CharSequence)escapedDollar, KotlinLiteralCopyPasteProcessor::tripleQuotedPaste$lambda$6$lambda$5$lambda$4);
                $this$tripleQuotedPaste_u24lambda_u246.append((String)var11_10);
                $this$tripleQuotedPaste_u24lambda_u246.append(replaced);
                String string5 = "";
                continue;
            }
            if (templateChunk instanceof EntryChunk) {
                $this$tripleQuotedPaste_u24lambda_u246.append((String)var11_10);
                $this$tripleQuotedPaste_u24lambda_u246.append(((EntryChunk)chunk).getText());
                String string6 = "";
                continue;
            }
            if (!(templateChunk instanceof NewLineChunk)) {
                throw new NoWhenBranchMatchedException();
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$tripleQuotedPaste_u24lambda_u246.append('\n'), (String)"append(...)");
            String string7 = indent;
        }
    }

    private static final String tripleQuotedPaste$indent(TemplateChunk $this$tripleQuotedPaste_u24indent) {
        Object object;
        block1: {
            TemplateChunk templateChunk = $this$tripleQuotedPaste_u24indent;
            String $this$takeWhile$iv = templateChunk instanceof LiteralChunk ? ((LiteralChunk)$this$tripleQuotedPaste_u24indent).getText() : (templateChunk instanceof EntryChunk ? ((EntryChunk)$this$tripleQuotedPaste_u24indent).getText() : "");
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string = $this$takeWhile$iv;
                int n2 = 0;
                String string2 = string.substring(n2, index$iv);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block1;
            }
            object = templateChunk;
        }
        return object;
    }

    private static final CharSequence tripleQuotedPaste$lambda$6$lambda$5$lambda$4(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"\"" + StringsKt.repeat((CharSequence)"${'\"'}", (int)(((CharSequence)it.getValue()).length() - 2));
    }
}

