/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineSelectedNodeListenerKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineView;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineSelectedNodeListener;", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;)V", "install", "", "processSelectedNode", "", "setCurrentStackFrame", "executionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineSelectedNodeListener {
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final XDebuggerTree tree;

    public CoroutineSelectedNodeListener(@NotNull DebugProcessImpl debugProcess, @NotNull XDebuggerTree tree2) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        this.debugProcess = debugProcess;
        this.tree = tree2;
    }

    public final void install() {
        new DoubleClickListener(this){
            final /* synthetic */ CoroutineSelectedNodeListener this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return CoroutineSelectedNodeListener.access$processSelectedNode(this.this$0);
            }
        }.installOn((Component)this.tree);
        this.tree.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ CoroutineSelectedNodeListener this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int key = e.getKeyCode();
                switch (key) {
                    case 10: 
                    case 32: 
                    case 39: {
                        CoroutineSelectedNodeListener.access$processSelectedNode(this.this$0);
                    }
                }
            }
        });
    }

    private final boolean processSelectedNode() {
        Object[] objectArray = this.tree.getSelectedNodes(XValueNodeImpl.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        XValueNodeImpl[] selectedNodes = (XValueNodeImpl[])objectArray;
        CoroutineView.CoroutineFrameValue coroutineFrameValue = CoroutineSelectedNodeListenerKt.access$getSingleCoroutineFrameValueContainer(selectedNodes);
        if (coroutineFrameValue == null) {
            return false;
        }
        CoroutineView.CoroutineFrameValue valueContainer = coroutineFrameValue;
        CoroutineStackFrameItem frameItem = valueContainer.getFrameItem();
        DebuggerUtil.invokeInManagerThread(this.debugProcess, arg_0 -> CoroutineSelectedNodeListener.processSelectedNode$lambda$1(frameItem, this, arg_0));
        return true;
    }

    private final void setCurrentStackFrame(XExecutionStack executionStack, XStackFrame stackFrame) {
        XSourcePosition xSourcePosition = stackFrame.getSourcePosition();
        if (xSourcePosition == null || (xSourcePosition = xSourcePosition.getFile()) == null) {
            return;
        }
        XSourcePosition fileToNavigate = xSourcePosition;
        XDebugSession xDebugSession = this.debugProcess.getSession().getXDebugSession();
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session = xDebugSession;
        if (!ClsClassFinder.isKotlinInternalCompiledFile$default((ClsClassFinder)ClsClassFinder.INSTANCE, (VirtualFile)fileToNavigate, null, (int)2, null)) {
            ApplicationManager.getApplication().invokeLater(() -> CoroutineSelectedNodeListener.setCurrentStackFrame$lambda$2(session, executionStack, stackFrame), ModalityState.stateForComponent((Component)((Component)this.tree)));
        }
    }

    private static final Unit processSelectedNode$lambda$1(CoroutineStackFrameItem $frameItem, CoroutineSelectedNodeListener this$0, DebuggerContextImpl it) {
        JavaExecutionStack executionStack;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XStackFrame xStackFrame = $frameItem.createFrame(this$0.debugProcess);
        if (xStackFrame == null) {
            return Unit.INSTANCE;
        }
        XStackFrame frame = xStackFrame;
        if ($frameItem instanceof RunningCoroutineStackFrameItem) {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = ((RunningCoroutineStackFrameItem)$frameItem).getFrame().threadProxy();
            Intrinsics.checkNotNullExpressionValue((Object)threadReferenceProxyImpl, (String)"threadProxy(...)");
            v2 = CoroutineSelectedNodeListenerKt.access$createExecutionStack(threadReferenceProxyImpl, this$0.debugProcess);
        } else {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = CoroutineSelectedNodeListenerKt.access$getSuspendContext(this$0.debugProcess).getThread();
            if (threadReferenceProxyImpl != null) {
                ThreadReferenceProxyImpl it2 = threadReferenceProxyImpl;
                boolean bl = false;
                v2 = CoroutineSelectedNodeListenerKt.access$createExecutionStack(it2, this$0.debugProcess);
            } else {
                v2 = executionStack = null;
            }
        }
        if (executionStack != null) {
            this$0.setCurrentStackFrame((XExecutionStack)executionStack, frame);
        }
        return Unit.INSTANCE;
    }

    private static final void setCurrentStackFrame$lambda$2(XDebugSession $session, XExecutionStack $executionStack, XStackFrame $stackFrame) {
        $session.setCurrentStackFrame($executionStack, $stackFrame, false);
    }

    public static final /* synthetic */ boolean access$processSelectedNode(CoroutineSelectedNodeListener $this) {
        return $this.processSelectedNode();
    }
}

