/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping.filter;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/LocationToken;", "", "lineNumber", "", "inlineVariables", "", "Lcom/sun/jdi/LocalVariable;", "<init>", "(ILjava/util/List;)V", "getLineNumber", "()I", "getInlineVariables", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "kotlin.jvm-debugger.core"})
public final class LocationToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int lineNumber;
    @NotNull
    private final List<LocalVariable> inlineVariables;

    public LocationToken(int lineNumber, @NotNull List<? extends LocalVariable> inlineVariables) {
        Intrinsics.checkNotNullParameter(inlineVariables, (String)"inlineVariables");
        this.lineNumber = lineNumber;
        this.inlineVariables = inlineVariables;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    @NotNull
    public final List<LocalVariable> getInlineVariables() {
        return this.inlineVariables;
    }

    public final int component1() {
        return this.lineNumber;
    }

    @NotNull
    public final List<LocalVariable> component2() {
        return this.inlineVariables;
    }

    @NotNull
    public final LocationToken copy(int lineNumber, @NotNull List<? extends LocalVariable> inlineVariables) {
        Intrinsics.checkNotNullParameter(inlineVariables, (String)"inlineVariables");
        return new LocationToken(lineNumber, inlineVariables);
    }

    public static /* synthetic */ LocationToken copy$default(LocationToken locationToken, int n, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = locationToken.lineNumber;
        }
        if ((n2 & 2) != 0) {
            list2 = locationToken.inlineVariables;
        }
        return locationToken.copy(n, list2);
    }

    @NotNull
    public String toString() {
        return "LocationToken(lineNumber=" + this.lineNumber + ", inlineVariables=" + this.inlineVariables + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.lineNumber);
        result2 = result2 * 31 + ((Object)this.inlineVariables).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocationToken)) {
            return false;
        }
        LocationToken locationToken = (LocationToken)other;
        if (this.lineNumber != locationToken.lineNumber) {
            return false;
        }
        return Intrinsics.areEqual(this.inlineVariables, locationToken.inlineVariables);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/LocationToken$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/LocationToken;", "stackFrame", "Lcom/sun/jdi/StackFrame;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocationToken from(@NotNull StackFrame stackFrame) {
            Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
            Location location = stackFrame.location();
            Intrinsics.checkNotNull((Object)location);
            int lineNumber = SafeUtilKt.safeLineNumber(location, "Java");
            ArrayList methodVariables = new ArrayList(0);
            Object object = SafeUtilKt.safeMethod(location);
            if (object == null || (object = SafeUtilKt.safeVariables((Method)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                LocalVariable variable = (LocalVariable)iterator2.next();
                String name2 = variable.name();
                if (!variable.isVisible(stackFrame)) continue;
                Intrinsics.checkNotNull((Object)name2);
                if (!JvmAbi.isFakeLocalVariableForInline((String)name2)) continue;
                ((Collection)methodVariables).add(variable);
            }
            return new LocationToken(lineNumber, methodVariables);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

