/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineScopeInfo;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.VariableWithLocation;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrameInfo;
import org.jetbrains.kotlin.load.java.JvmAbi;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u0005\u001a,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0002\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0002\u001a.\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0002\u001a&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0013\u001a\u00020\bH\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"INLINE_LAMBDA_REGEX", "Lkotlin/text/Regex;", "computeKotlinStackFrameInfos", "", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;", "Lcom/sun/jdi/StackFrame;", "computeStackFrameInfosWithCallLocations", "location", "Lcom/sun/jdi/Location;", "method", "Lcom/sun/jdi/Method;", "allVisibleVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "computeStackFrameInfos", "sortedVariables", "computeStackFrameInfosUsingScopeNumbers", "fetchCallLocations", "", "kotlinStackFrameInfos", "defaultLocation", "shouldComputeStackFrameInfosUsingTheOldScheme", "", "variables", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nInlineStackTraceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/InlineStackTraceCalculatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,507:1\n774#2:508\n865#2,2:509\n543#2,6:518\n1202#2,2:531\n1230#2,4:533\n1863#2,2:538\n543#2,6:540\n1755#2,3:546\n381#3,7:511\n381#3,7:524\n1#4:537\n*S KotlinDebug\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/InlineStackTraceCalculatorKt\n*L\n123#1:508\n123#1:509,2\n268#1:518,6\n308#1:531,2\n308#1:533,4\n430#1:538,2\n452#1:540,6\n503#1:546,3\n251#1:511,7\n301#1:524,7\n*E\n"})
public final class InlineStackTraceCalculatorKt {
    @NotNull
    private static final Regex INLINE_LAMBDA_REGEX = new Regex(Regex.Companion.escape("$i$a$") + "-(.+)-[^$]+\\$([^$]+)\\$.*");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinStackFrameInfo> computeKotlinStackFrameInfos(@NotNull StackFrame $this$computeKotlinStackFrameInfos) {
        List<KotlinStackFrameInfo> list2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$computeKotlinStackFrameInfos, (String)"<this>");
        Location location = $this$computeKotlinStackFrameInfos.location();
        Intrinsics.checkNotNull((Object)location);
        Method method = SafeUtilKt.safeMethod(location);
        if (method == null) {
            return CollectionsKt.emptyList();
        }
        Method method2 = method;
        Iterable $this$filter$iv = StackFrameUtilsKt.sortedVariablesWithLocation(method2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VariableWithLocation it = (VariableWithLocation)element$iv$iv;
            boolean bl = false;
            if (!it.getVariable().isVisible($this$computeKotlinStackFrameInfos)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allVisibleVariables = (List)destination$iv$iv;
        if (InlineStackTraceCalculatorKt.shouldComputeStackFrameInfosUsingTheOldScheme(allVisibleVariables)) {
            list2 = InlineStackTraceCalculatorKt.computeStackFrameInfosWithCallLocations(location, method2, allVisibleVariables);
        } else {
            list2 = InlineStackTraceCalculatorKt.computeStackFrameInfosUsingScopeNumbers(location, method2, allVisibleVariables);
            if (list2 == null) {
                list2 = InlineStackTraceCalculatorKt.computeStackFrameInfosWithCallLocations(location, method2, allVisibleVariables);
            }
        }
        List<KotlinStackFrameInfo> stackFrameInfos = list2;
        return stackFrameInfos;
    }

    private static final List<KotlinStackFrameInfo> computeStackFrameInfosWithCallLocations(Location location, Method method, List<VariableWithLocation> allVisibleVariables) {
        List<KotlinStackFrameInfo> list2;
        List<KotlinStackFrameInfo> it = list2 = InlineStackTraceCalculatorKt.computeStackFrameInfos(allVisibleVariables);
        boolean bl = false;
        InlineStackTraceCalculatorKt.fetchCallLocations(method, it, location);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinStackFrameInfo> computeStackFrameInfos(List<VariableWithLocation> sortedVariables) {
        int depth;
        Object[] objectArray = new KotlinStackFrameInfo[]{new KotlinStackFrameInfo(null, null, new ArrayList(), 0)};
        List stackFrameInfos = CollectionsKt.mutableListOf((Object[])objectArray);
        Map pendingVariables = new LinkedHashMap();
        Integer[] integerArray = new Integer[]{0};
        List<Integer> activeFrames = CollectionsKt.mutableListOf((Object[])integerArray);
        for (VariableWithLocation entry : sortedVariables) {
            Object object;
            void $this$getOrPut$iv;
            Object object2;
            if (StringsKt.startsWith$default((String)entry.getName(), (String)"$i$f$", (boolean)false, (int)2, null)) {
                depth = activeFrames.size();
                object2 = stackFrameInfos;
                List list2 = (List)pendingVariables.get(depth);
                if (list2 == null) {
                    list2 = new ArrayList();
                }
                object2.add(new KotlinStackFrameInfo(entry, null, list2, depth));
                pendingVariables.remove(depth);
                ((Collection)activeFrames).add(stackFrameInfos.size() - 1);
                continue;
            }
            depth = InlineUtilsKt.getInlineDepth(entry.getName());
            if (StringsKt.startsWith$default((String)entry.getName(), (String)"$i$a$", (boolean)false, (int)2, null)) {
                if (depth + 1 < activeFrames.size()) {
                    activeFrames = activeFrames.subList(0, depth + 1);
                }
                if (depth >= activeFrames.size()) continue;
                object2 = stackFrameInfos;
                KotlinStackFrameInfo kotlinStackFrameInfo = (KotlinStackFrameInfo)stackFrameInfos.get(((Number)activeFrames.get(depth)).intValue());
                List list3 = (List)pendingVariables.get(depth);
                if (list3 == null) {
                    list3 = new ArrayList();
                }
                object2.add(new KotlinStackFrameInfo(entry, kotlinStackFrameInfo, list3, depth));
                pendingVariables.remove(depth);
                activeFrames.set(depth, stackFrameInfos.size() - 1);
                continue;
            }
            if (depth == activeFrames.size() - 1) {
                ((Collection)((KotlinStackFrameInfo)stackFrameInfos.get(((Number)activeFrames.get(depth)).intValue())).getVisibleVariablesWithLocations()).add(entry);
                continue;
            }
            object2 = pendingVariables;
            Integer key$iv = depth;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(entry);
        }
        for (Map.Entry entry : pendingVariables.entrySet()) {
            List<VariableWithLocation> list4;
            KotlinStackFrameInfo kotlinStackFrameInfo;
            Object v4;
            List variables;
            block12: {
                depth = ((Number)entry.getKey()).intValue();
                variables = (List)entry.getValue();
                if (depth < activeFrames.size()) {
                    CollectionsKt.addAll((Collection)((KotlinStackFrameInfo)stackFrameInfos.get(((Number)activeFrames.get(depth)).intValue())).getVisibleVariablesWithLocations(), (Iterable)variables);
                    continue;
                }
                List $this$lastOrNull$iv = stackFrameInfos;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    KotlinStackFrameInfo it = (KotlinStackFrameInfo)element$iv;
                    boolean bl = false;
                    if (!(it.getDepth() == depth)) continue;
                    v4 = element$iv;
                    break block12;
                }
                v4 = null;
            }
            if ((kotlinStackFrameInfo = (KotlinStackFrameInfo)v4) == null || (list4 = kotlinStackFrameInfo.getVisibleVariablesWithLocations()) == null) continue;
            list4.addAll(variables);
        }
        return stackFrameInfos;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinStackFrameInfo> computeStackFrameInfosUsingScopeNumbers(Location location, Method method, List<VariableWithLocation> sortedVariables) {
        void $this$associateByTo$iv$iv;
        List firstFrameVariables = new ArrayList();
        KotlinStackFrameInfo firstFrameInfo = new KotlinStackFrameInfo(null, null, firstFrameVariables, 0);
        Object[] objectArray = new KotlinStackFrameInfo[]{firstFrameInfo};
        List stackFrameInfos = CollectionsKt.mutableListOf((Object[])objectArray);
        Map scopeNumberToVariables = new LinkedHashMap();
        for (VariableWithLocation variableWithLocation : sortedVariables) {
            boolean bl;
            Integer scopeNumber;
            InlineScopeInfo inlineScopeInfo = InlineScopeUtilsKt.getInlineScopeInfo((String)variableWithLocation.getName());
            Integer n = scopeNumber = inlineScopeInfo != null ? Integer.valueOf(inlineScopeInfo.getScopeNumber()) : null;
            if (scopeNumber != null) {
                Object object;
                Map $this$getOrPut$iv = scopeNumberToVariables;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(scopeNumber);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(scopeNumber, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                bl = ((List)object).add(variableWithLocation);
                continue;
            }
            bl = firstFrameVariables.add(variableWithLocation);
        }
        List list2 = DebuggerUtilsEx.allLineLocations((Method)method);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable iterable = list2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable $i$f$getOrPut = iterable;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        InlineScopeInfo inlineScopeInfo = $this$associateByTo$iv$iv.iterator();
        while (inlineScopeInfo.hasNext()) {
            void it;
            Object element$iv$iv = inlineScopeInfo.next();
            Location location2 = (Location)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.lineNumber("Java"), element$iv$iv);
        }
        Map lineNumberToLocation = destination$iv$iv;
        List list3 = new ArrayList();
        List infosAndSurroundingScopeIds = new ArrayList();
        Map scopeNumberToFrameInfo = new LinkedHashMap();
        scopeNumberToFrameInfo.put(0, firstFrameInfo);
        for (VariableWithLocation variable3 : sortedVariables) {
            KotlinStackFrameInfo kotlinStackFrameInfo;
            String name2 = variable3.getName();
            if (!JvmAbi.isFakeLocalVariableForInline((String)name2)) continue;
            if (InlineScopeUtilsKt.getInlineScopeInfo((String)name2) == null) {
                return null;
            }
            int scopeNumber = inlineScopeInfo.component1();
            Integer callSiteLineNumber = inlineScopeInfo.component2();
            Integer surroundingScopeNumber = inlineScopeInfo.component3();
            List list4 = (List)scopeNumberToVariables.get(scopeNumber);
            if (list4 == null) {
                list4 = new ArrayList();
            }
            KotlinStackFrameInfo $this$computeStackFrameInfosUsingScopeNumbers_u24lambda_u246 = kotlinStackFrameInfo = new KotlinStackFrameInfo(variable3, null, list4, -1);
            boolean bl = false;
            $this$computeStackFrameInfosUsingScopeNumbers_u24lambda_u246.setInlineScopeNumber(scopeNumber);
            KotlinStackFrameInfo frameInfo = kotlinStackFrameInfo;
            if (DebuggerUtil.isInlineLambdaMarkerVariableName(name2)) {
                Integer n = surroundingScopeNumber;
                frameInfo.setSurroundingScopeNumber(n != null ? n : -1);
                if (surroundingScopeNumber != null) {
                    infosAndSurroundingScopeIds.add(new Pair((Object)frameInfo, (Object)surroundingScopeNumber));
                } else {
                    frameInfo.setEnclosingStackFrame(firstFrameInfo);
                }
            }
            Integer n = scopeNumber;
            scopeNumberToFrameInfo.put(n, frameInfo);
            ((Collection)list3).add(lineNumberToLocation.get(callSiteLineNumber));
            ((Collection)stackFrameInfos).add(frameInfo);
        }
        for (Pair pair : infosAndSurroundingScopeIds) {
            KotlinStackFrameInfo info2 = (KotlinStackFrameInfo)pair.component1();
            int id = ((Number)pair.component2()).intValue();
            info2.setEnclosingStackFrame((KotlinStackFrameInfo)scopeNumberToFrameInfo.get(id));
        }
        ((Collection)list3).add(location);
        for (Pair pair : CollectionsKt.zip((Iterable)list3, (Iterable)stackFrameInfos)) {
            Location callSiteLocation = (Location)pair.component1();
            KotlinStackFrameInfo frameInfo = (KotlinStackFrameInfo)pair.component2();
            frameInfo.setCallLocation(callSiteLocation);
        }
        return stackFrameInfos;
    }

    /*
     * Unable to fully structure code
     */
    private static final void fetchCallLocations(Method method, List<KotlinStackFrameInfo> kotlinStackFrameInfos, Location defaultLocation) {
        block14: {
            block13: {
                v0 = (KotlinStackFrameInfo)CollectionsKt.lastOrNull(kotlinStackFrameInfos);
                if (v0 != null) {
                    v0.setCallLocation(defaultLocation);
                }
                if (kotlinStackFrameInfos.size() <= 1) {
                    return;
                }
                allLocations = DebuggerUtilsEx.allLineLocations((Method)method);
                if (allLocations == null) {
                    $this$forEach$iv = kotlinStackFrameInfos;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (KotlinStackFrameInfo)element$iv;
                        $i$a$-forEach-InlineStackTraceCalculatorKt$fetchCallLocations$1 = false;
                        it.setCallLocation(defaultLocation);
                    }
                    return;
                }
                startIndex = 0;
                startIndex = 1;
                $i$f$forEach = kotlinStackFrameInfos.get(1).getScopeVariable();
                if ($i$f$forEach == null) break block14;
                it = element$iv = $i$f$forEach;
                $i$a$-takeIf-InlineStackTraceCalculatorKt$fetchCallLocations$2 = false;
                v1 = var6_10 = StringsKt.startsWith$default((String)it.getName(), (String)"$i$f$", (boolean)false, (int)2, null) != false ? element$iv : null;
                if (var6_10 == null) break block14;
                firstInlineScopeVariable = var6_10;
                $i$a$-let-InlineStackTraceCalculatorKt$fetchCallLocations$3 = false;
                startOffset = firstInlineScopeVariable.getLocation();
                callLineNumber = SafeUtilKt.safeLineNumber(startOffset, "KotlinDebug");
                callSourceName = SafeUtilKt.safeSourceName(startOffset, "KotlinDebug");
                if (callLineNumber == -1 || callSourceName == null) break block14;
                $this$lastOrNull$iv = allLocations;
                $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    location = (Location)element$iv;
                    $i$a$-lastOrNull-InlineStackTraceCalculatorKt$fetchCallLocations$3$callLocation$1 = false;
                    if (location.compareTo(startOffset) >= 0) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)location);
                    if (SafeUtilKt.safeLineNumber(location) == callLineNumber && Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(location), (Object)callSourceName)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = element$iv;
                    break block13;
                }
                v3 = null;
            }
            callLocation = v3;
            if (callLocation != null) {
                kotlinStackFrameInfos.get(0).setCallLocation(callLocation);
                ++startIndex;
            }
        }
        var6_11 = kotlinStackFrameInfos.size();
        for (index = startIndex; index < var6_11; ++index) {
            firstInlineScopeVariable = kotlinStackFrameInfos.get(index).getScopeVariable();
            if (firstInlineScopeVariable != null && ($i$a$-let-InlineStackTraceCalculatorKt$fetchCallLocations$3 = firstInlineScopeVariable.getLocation()) != null) {
                p0 = $i$a$-let-InlineStackTraceCalculatorKt$fetchCallLocations$3;
                $i$a$-let-InlineStackTraceCalculatorKt$fetchCallLocations$scopeIndex$1 = false;
                v4 = CollectionsKt.binarySearch$default((List)allLocations, (Comparable)p0, (int)0, (int)0, (int)6, null);
            } else {
                v4 = null;
            }
            scopeIndex = v4;
            prev = kotlinStackFrameInfos.get(index - 1);
            if (scopeIndex == null || new IntRange(-1, 0).contains(scopeIndex.intValue())) {
                prev.setCallLocation(defaultLocation);
                continue;
            }
            locationIndex = scopeIndex > 0 ? scopeIndex - 1 : -scopeIndex.intValue() - 2;
            v5 = allLocations.get(locationIndex);
            Intrinsics.checkNotNullExpressionValue(v5, (String)"get(...)");
            if (DebuggerUtil.isKotlinFakeLineNumber((Location)v5)) {
                locationIndex = RangesKt.coerceAtLeast((int)(locationIndex - 1), (int)0);
            }
            prev.setCallLocation((Location)allLocations.get(locationIndex));
        }
    }

    private static final boolean shouldComputeStackFrameInfosUsingTheOldScheme(List<VariableWithLocation> variables) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = variables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VariableWithLocation it = (VariableWithLocation)element$iv;
                    boolean bl2 = false;
                    String name2 = it.getName();
                    if (!(JvmAbi.isFakeLocalVariableForInline((String)name2) && InlineScopeUtilsKt.getInlineScopeInfo((String)name2) == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Regex access$getINLINE_LAMBDA_REGEX$p() {
        return INLINE_LAMBDA_REGEX;
    }
}

