/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.conversion.copy.ContextDeclarations;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionTargetData;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionTargetDataKt;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor$isParsedAsFile$;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedJavaCode;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedKotlinCode;
import org.jetbrains.kotlin.idea.conversion.copy.DataForConversion;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.JavaContextDeclarationRenderer;
import org.jetbrains.kotlin.idea.conversion.copy.PlainTextPasteImportResolver;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 K2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004HIJKB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JF\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J.\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\"\u00100\u001a\u0004\u0018\u00010-2\u0006\u0010\f\u001a\u00020(2\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001dH\u0002J\"\u00103\u001a\u0004\u0018\u0001042\u0006\u0010+\u001a\u00020,2\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u00107\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u00108\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u00109\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u00108\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010:\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010;\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010<\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010?\u001a\u00020\r2\u0006\u00105\u001a\u0002062\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010@\u001a\u00020A*\u00020$2\u0006\u0010'\u001a\u00020(H\u0002J \u0010B\u001a\u00020C2\u0006\u00105\u001a\u0002062\u0006\u00108\u001a\u0002042\u0006\u0010D\u001a\u00020-H\u0002J \u0010E\u001a\u00020C2\u0006\u0010F\u001a\u0002062\u0006\u0010G\u001a\u0002062\u0006\u00105\u001a\u000206H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\u00020,*\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "javaContextDeclarationRenderer", "Lorg/jetbrains/kotlin/idea/conversion/copy/JavaContextDeclarationRenderer;", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "processTransferableData", "", "project", "Lcom/intellij/openapi/project/Project;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "", "indented", "Lcom/intellij/openapi/util/Ref;", "", "values", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/DataForConversion;", "targetModule", "Lcom/intellij/openapi/module/Module;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "j2kKind", "Lorg/jetbrains/kotlin/j2k/J2kConverterExtension$Kind;", "pasteContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getPasteContext", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "detectPasteTarget", "startOffset", "endOffset", "detectConversionContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "text", "", "isParsedAsJavaCode", "context", "isParsedAsKotlinCode", "isParsedAsJavaFile", "isParsedAsKotlinFile", "isParsedAsFile", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "parseAsFile", "tryResolveImports", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "prepareCopiedJavaCodeByContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/CopiedJavaCode;", "target", "createCopiedJavaCode", "prefix", "templateWithoutPrefix", "MyTransferableData", "KotlinContext", "JavaContext", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertTextJavaCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTextJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,337:1\n17#2,6:338\n1#3:344\n321#4,2:345\n333#4,10:347\n355#4:357\n133#4:366\n12574#5,2:358\n1368#6:360\n1454#6,5:361\n1863#6,2:369\n191#7:367\n191#7:368\n*S KotlinDebug\n*F\n+ 1 ConvertTextJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor\n*L\n150#1:338,6\n247#1:345,2\n247#1:347,10\n247#1:357\n290#1:366\n251#1:358,2\n268#1:360\n268#1:361,5\n140#1:369,2\n295#1:367\n301#1:368\n*E\n"})
public final class ConvertTextJavaCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOG;
    @NotNull
    private final JavaContextDeclarationRenderer javaContextDeclarationRenderer;
    private static boolean conversionPerformed;

    public ConvertTextJavaCopyPasteProcessor() {
        Logger logger = Logger.getInstance(ConvertTextJavaCopyPasteProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.javaContextDeclarationRenderer = new JavaContextDeclarationRenderer();
    }

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        if (file instanceof KtFile) {
            String string = ((KtFile)file).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return CollectionsKt.listOf((Object)new CopiedKotlinCode(string, startOffsets, endOffsets));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                if (content.isDataFlavorSupported(CopiedKotlinCode.Companion.getDATA_FLAVOR()) || content.isDataFlavorSupported(CopiedJavaCode.Companion.getDATA_FLAVOR())) {
                    return CollectionsKt.emptyList();
                }
                Object object = content.getTransferData(DataFlavor.stringFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String text = (String)object;
                return CollectionsKt.listOf((Object)new MyTransferableData(text));
            }
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.LOG.error(e);
        }
        return CollectionsKt.emptyList();
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        if (!KotlinEditorOptions.getInstance().isEnableJavaToKotlinConversion()) {
            return;
        }
        Object object = CollectionsKt.single(values2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor.MyTransferableData");
        String string = TextBlockTransferable.convertLineSeparators((Editor)editor, (String)((MyTransferableData)object).getText(), (Collection)values2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String text = string;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        ConversionTargetData conversionTargetData = ConversionTargetDataKt.getTargetData(project, editor, caretOffset, bounds);
        if (conversionTargetData == null) {
            return;
        }
        ConversionTargetData conversionTargetData2 = conversionTargetData;
        KtFile targetFile = conversionTargetData2.component1();
        RangeMarker targetBounds = conversionTargetData2.component2();
        Document targetDocument = conversionTargetData2.component3();
        psiDocumentManager.commitDocument(targetDocument);
        J2kConverterExtension.Kind j2kKind = ConvertJavaCopyPasteProcessorKt.getJ2kKind(targetFile);
        Module targetModule = GenericPsiUtils.getModule((PsiElement)targetFile);
        KtElement ktElement = this.detectPasteTarget(targetFile, targetBounds.getStartOffset(), targetBounds.getEndOffset());
        if (ktElement == null) {
            return;
        }
        KtElement pasteTarget = ktElement;
        JavaContext javaContext = this.detectConversionContext(this.getPasteContext(pasteTarget), text, project);
        if (javaContext == null) {
            return;
        }
        JavaContext conversionContext = javaContext;
        if (!ConvertJavaCopyPasteProcessorKt.confirmConvertJavaOnPaste(project, true)) {
            return;
        }
        CopiedJavaCode copiedJavaCode = this.prepareCopiedJavaCodeByContext(text, conversionContext, pasteTarget);
        DataForConversion dataForConversion = DataForConversion.Companion.prepare(copiedJavaCode, project);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ConvertTextJavaCopyPasteProcessor.processTransferableData$convert(this, dataForConversion, targetFile, project, targetModule, j2kKind, psiDocumentManager, targetDocument, targetBounds, bounds, editor);
        long conversionTime = System.currentTimeMillis() - start$iv;
        J2KFusCollector.INSTANCE.log(ConversionType.TEXT_EXPRESSION, ConvertJavaCopyPasteProcessorKt.getJ2kKind(targetFile) == J2kConverterExtension.Kind.K1_NEW, conversionTime, ConvertJavaCopyPasteProcessorKt.linesCount(dataForConversion.getElementsAndTexts()), 1);
    }

    private final ConversionResult convertCodeToKotlin(DataForConversion $this$convertCodeToKotlin, Project project, Module targetModule, KtFile targetFile, J2kConverterExtension.Kind j2kKind) {
        return ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin($this$convertCodeToKotlin.getElementsAndTexts(), project, targetModule, targetFile, j2kKind);
    }

    private final KotlinContext getPasteContext(KtElement $this$pasteContext) {
        KtElement ktElement = $this$pasteContext;
        return ktElement instanceof KtFile ? KotlinContext.TOP_LEVEL : (ktElement instanceof KtClassBody ? KotlinContext.CLASS_BODY : (ktElement instanceof KtBlockExpression ? KotlinContext.IN_BLOCK : KotlinContext.EXPRESSION));
    }

    private final KtElement detectPasteTarget(KtFile file, int startOffset, int endOffset) {
        if (ConvertJavaCopyPasteProcessorKt.isNoConversionPosition(file, startOffset)) {
            return null;
        }
        String fileText = file.getText();
        String dummyDeclarationText = "fun dummy(){}";
        Intrinsics.checkNotNull((Object)fileText);
        String string = fileText.substring(0, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = fileText.substring(endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String newFileText = string + " " + dummyDeclarationText + "\n" + string2;
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        LanguageFileType languageFileType = (LanguageFileType)kotlinFileType;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile newFile = this.parseAsFile(newFileText, languageFileType, project);
        Intrinsics.checkNotNull((Object)newFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtPsiFactoryKt.setAnalysisContext((KtFile)((KtFile)newFile), (PsiElement)((PsiElement)file));
        PsiElement psiElement = ((KtFile)newFile).findElementAt(startOffset + 1);
        if (psiElement == null) {
            return null;
        }
        PsiElement funKeyword = psiElement;
        if (!Intrinsics.areEqual((Object)funKeyword.getNode().getElementType(), (Object)KtTokens.FUN_KEYWORD)) {
            return null;
        }
        PsiElement psiElement2 = funKeyword.getParent();
        KtFunction ktFunction = psiElement2 instanceof KtFunction ? (KtFunction)psiElement2 : null;
        if (ktFunction == null) {
            return null;
        }
        KtFunction declaration = ktFunction;
        PsiElement psiElement3 = declaration.getParent();
        return psiElement3 instanceof KtElement ? (KtElement)psiElement3 : null;
    }

    private final JavaContext detectConversionContext(KotlinContext pasteContext, String text, Project project) {
        if (this.isParsedAsKotlinCode(text, pasteContext, project)) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[pasteContext.ordinal()]) {
            case 1: {
                JavaContext javaContext = ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.TOP_LEVEL, this, text, project);
                if (javaContext != null) {
                    JavaContext it = javaContext;
                    boolean bl = false;
                    return it;
                }
                javaContext = ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.CLASS_BODY, this, text, project);
                if (javaContext != null) {
                    JavaContext it = javaContext;
                    boolean bl = false;
                    return it;
                }
                return null;
            }
            case 2: {
                return ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.CLASS_BODY, this, text, project);
            }
            case 3: {
                return ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.IN_BLOCK, this, text, project);
            }
            case 4: {
                return ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.EXPRESSION, this, text, project);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean isParsedAsJavaCode(String text, JavaContext context2, Project project) {
        return switch (WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1 -> this.isParsedAsJavaFile(text, project);
            case 2 -> this.isParsedAsJavaFile("class Dummy { " + text + "\n}", project);
            case 3 -> this.isParsedAsJavaFile("class Dummy { void foo() {" + text + "\n}\n}", project);
            case 4 -> this.isParsedAsJavaFile("class Dummy { Object field = " + text + "; }", project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isParsedAsKotlinCode(String text, KotlinContext context2, Project project) {
        return switch (WhenMappings.$EnumSwitchMapping$0[context2.ordinal()]) {
            case 1 -> this.isParsedAsKotlinFile(text, project);
            case 2 -> this.isParsedAsKotlinFile("class Dummy { " + text + "\n}", project);
            case 3 -> this.isParsedAsKotlinFile("fun foo() {" + text + "\n}", project);
            case 4 -> this.isParsedAsKotlinFile("val v = " + text, project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isParsedAsJavaFile(String text, Project project) {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"INSTANCE");
        return this.isParsedAsFile(text, (LanguageFileType)javaFileType, project);
    }

    private final boolean isParsedAsKotlinFile(String text, Project project) {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return this.isParsedAsFile(text, (LanguageFileType)kotlinFileType, project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isParsedAsFile(String text, LanguageFileType fileType, Project project) {
        boolean hasErrors;
        PsiFile psiFile = this.parseAsFile(text, fileType, project);
        PsiElement $this$anyDescendantOfType_u24default$iv = (PsiElement)psiFile;
        Function1 predicate$iv = isParsedAsFile$$inlined$anyDescendantOfType$default$1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element != null) {
            return false;
        }
        boolean bl = hasErrors = false;
        if (hasErrors) {
            return false;
        }
        if (!(psiFile instanceof PsiJavaFile)) return true;
        PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        Object[] $this$any$iv = psiClassArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            PsiClass it = (PsiClass)element$iv;
            boolean bl2 = false;
            if (it instanceof PsiImplicitClass) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final PsiFile parseAsFile(String text, LanguageFileType fileType, Project project) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    /*
     * WARNING - void declaration
     */
    private final ElementAndTextList tryResolveImports(DataForConversion $this$tryResolveImports, KtFile targetFile) {
        void $this$flatMapTo$iv$iv;
        PlainTextPasteImportResolver importResolver = new PlainTextPasteImportResolver($this$tryResolveImports, targetFile);
        importResolver.addImportsFromTargetFile();
        importResolver.tryResolveReferences();
        Iterable $this$flatMap$iv = importResolver.getAddedImports();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiImportStatementBase importStatement = (PsiImportStatementBase)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{"\n", importStatement};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"\n\n");
        return new ElementAndTextList(list2);
    }

    /*
     * WARNING - void declaration
     */
    private final CopiedJavaCode prepareCopiedJavaCodeByContext(String text, JavaContext context2, KtElement target) {
        String string;
        StringBuilder stringBuilder;
        PsiFile psiFile = target.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile targetFile = (KtFile)psiFile;
        ContextDeclarations contextDeclarations = this.javaContextDeclarationRenderer.render(target);
        String localDeclarations = contextDeclarations.component1();
        String memberDeclarations = contextDeclarations.component2();
        StringBuilder $this$prepareCopiedJavaCodeByContext_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KtPackageDirective ktPackageDirective = targetFile.getPackageDirective();
        if (ktPackageDirective != null) {
            KtPackageDirective it = ktPackageDirective;
            boolean bl2 = false;
            String string2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (((CharSequence)string2).length() > 0) {
                $this$prepareCopiedJavaCodeByContext_u24lambda_u249.append(it.getText());
                $this$prepareCopiedJavaCodeByContext_u24lambda_u249.append(";\n");
            }
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String prefix2 = string3;
        switch (WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                boolean $i$f$ifNotEmpty;
                Object[] $this$ifNotEmpty$iv;
                StringBuilder stringBuilder2;
                void $this$getParentOfType$iv;
                PsiElement psiElement = (PsiElement)target;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
                Object[] lightClass = ktClass != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass)) : null;
                StringBuilder $this$prepareCopiedJavaCodeByContext_u24lambda_u2414 = stringBuilder2 = new StringBuilder();
                boolean bl3 = false;
                $this$prepareCopiedJavaCodeByContext_u24lambda_u2414.append("class ");
                Object object = lightClass;
                if (lightClass == null || (object = object.getName()) == null) {
                    object = "Dummy";
                }
                $this$prepareCopiedJavaCodeByContext_u24lambda_u2414.append((String)object);
                Object[] objectArray = lightClass;
                if (lightClass != null && (objectArray = objectArray.getExtendsListTypes()) != null) {
                    $this$ifNotEmpty$iv = objectArray;
                    $i$f$ifNotEmpty = false;
                    if (!($this$ifNotEmpty$iv.length == 0)) {
                        Object[] $this$prepareCopiedJavaCodeByContext_u24lambda_u2414_u24lambda_u2411 = $this$ifNotEmpty$iv;
                        boolean bl4 = false;
                        StringBuilder cfr_ignored_0 = (StringBuilder)ArraysKt.joinTo$default((Object[])$this$prepareCopiedJavaCodeByContext_u24lambda_u2414_u24lambda_u2411, (Appendable)$this$prepareCopiedJavaCodeByContext_u24lambda_u2414, null, (CharSequence)" extends ", null, (int)0, null, ConvertTextJavaCopyPasteProcessor::prepareCopiedJavaCodeByContext$lambda$14$lambda$11$lambda$10, (int)58, null);
                    }
                }
                Object[] objectArray2 = lightClass;
                if (lightClass != null && (objectArray2 = objectArray2.getImplementsListTypes()) != null) {
                    $this$ifNotEmpty$iv = objectArray2;
                    $i$f$ifNotEmpty = false;
                    if (!($this$ifNotEmpty$iv.length == 0)) {
                        Object[] $this$prepareCopiedJavaCodeByContext_u24lambda_u2414_u24lambda_u2413 = $this$ifNotEmpty$iv;
                        boolean bl5 = false;
                        StringBuilder cfr_ignored_1 = (StringBuilder)ArraysKt.joinTo$default((Object[])$this$prepareCopiedJavaCodeByContext_u24lambda_u2414_u24lambda_u2413, (Appendable)$this$prepareCopiedJavaCodeByContext_u24lambda_u2414, null, (CharSequence)" implements ", null, (int)0, null, ConvertTextJavaCopyPasteProcessor::prepareCopiedJavaCodeByContext$lambda$14$lambda$13$lambda$12, (int)58, null);
                    }
                }
                String string4 = stringBuilder2.toString();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String classDef = string;
        return switch (WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1 -> this.createCopiedJavaCode(prefix2, "$", text);
            case 2 -> this.createCopiedJavaCode(prefix2, classDef + " {\n" + memberDeclarations + " $\n}", text);
            case 3 -> this.createCopiedJavaCode(prefix2, classDef + " {\n" + memberDeclarations + " void foo() {\n" + localDeclarations + " $\n}\n}", text);
            case 4 -> this.createCopiedJavaCode(prefix2, classDef + " {\nObject field = $\n}", text);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final CopiedJavaCode createCopiedJavaCode(String prefix2, String templateWithoutPrefix, String text) {
        boolean bl;
        String template2 = prefix2 + templateWithoutPrefix;
        int index2 = StringsKt.indexOf$default((CharSequence)template2, (String)"$", (int)0, (boolean)false, (int)6, null);
        boolean bl2 = bl = index2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = template2.substring(0, index2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = template2.substring(index2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String fileText = string + text + string2;
        int[] nArray = new int[]{index2};
        int[] nArray2 = nArray;
        nArray = new int[]{index2 + text.length()};
        return new CopiedJavaCode(fileText, nArray2, nArray);
    }

    private static final RangeMarker processTransferableData$convert$lambda$0(KtFile $targetFile, Ref.ObjectRef $convertedImportsText, Document $targetDocument, RangeMarker $targetBounds, String $convertedText, RangeMarker $bounds, Editor $editor) {
        int importsInsertOffset;
        KtImportList ktImportList = $targetFile.getImportList();
        int n = importsInsertOffset = ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0;
        if ($targetFile.getImportDirectives().isEmpty() && importsInsertOffset > 0) {
            $convertedImportsText.element = "\n" + $convertedImportsText.element;
        }
        if (!StringsKt.isBlank((CharSequence)((CharSequence)$convertedImportsText.element))) {
            $targetDocument.insertString(importsInsertOffset, (CharSequence)$convertedImportsText.element);
        }
        int startOffset = $targetBounds.getStartOffset();
        $targetDocument.replaceString(startOffset, $targetBounds.getEndOffset(), (CharSequence)$convertedText);
        int endOffsetAfterCopy = $bounds.getStartOffset() + $convertedText.length();
        $editor.getCaretModel().moveToOffset(endOffsetAfterCopy);
        return $targetDocument.createRangeMarker(startOffset, startOffset + $convertedText.length());
    }

    private static final void processTransferableData$convert(ConvertTextJavaCopyPasteProcessor this$0, DataForConversion dataForConversion, KtFile targetFile, Project $project, Module targetModule, J2kConverterExtension.Kind j2kKind, PsiDocumentManager psiDocumentManager, Document targetDocument, RangeMarker targetBounds, RangeMarker $bounds, Editor $editor) {
        ElementAndTextList additionalImports = this$0.tryResolveImports(dataForConversion, targetFile);
        ProgressManager.checkCanceled();
        Ref.ObjectRef convertedImportsText = new Ref.ObjectRef();
        convertedImportsText.element = ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin(additionalImports, $project, targetModule, targetFile, j2kKind).getText();
        ConversionResult convertedResult = this$0.convertCodeToKotlin(dataForConversion, $project, targetModule, targetFile, j2kKind);
        String convertedText = convertedResult.getText();
        ProgressManager.checkCanceled();
        Object object = ActionsKt.runWriteAction(() -> ConvertTextJavaCopyPasteProcessor.processTransferableData$convert$lambda$0(targetFile, convertedImportsText, targetDocument, targetBounds, convertedText, $bounds, $editor));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        RangeMarker newBounds = (RangeMarker)object;
        psiDocumentManager.commitAllDocuments();
        ProgressManager.checkCanceled();
        if (j2kKind == J2kConverterExtension.Kind.K1_NEW) {
            PostProcessor postProcessor = J2kConverterExtension.createPostProcessor$default(J2kConverterExtension.Companion.extension(J2kConverterExtension.Kind.K1_NEW), false, 1, null);
            Iterable $this$forEach$iv = convertedResult.getImportsToAdd();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FqName fqName2 = (FqName)element$iv;
                boolean bl = false;
                postProcessor.insertImport(targetFile, fqName2);
            }
        }
        ConvertJavaCopyPasteProcessorKt.runPostProcessing($project, targetFile, RangeMarkersKt.getAsTextRange((RangeMarker)newBounds), convertedResult.getConverterContext(), j2kKind);
        conversionPerformed = true;
    }

    private static final JavaContext detectConversionContext$check(JavaContext $this$detectConversionContext_u24check, ConvertTextJavaCopyPasteProcessor this$0, String $text, Project $project) {
        JavaContext javaContext;
        JavaContext it = javaContext = $this$detectConversionContext_u24check;
        boolean bl = false;
        return this$0.isParsedAsJavaCode($text, it, $project) ? javaContext : null;
    }

    private static final CharSequence prepareCopiedJavaCodeByContext$lambda$14$lambda$11$lambda$10(PsiClassType it) {
        String string = it.getCanonicalText(true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        return string;
    }

    private static final CharSequence prepareCopiedJavaCodeByContext$lambda$14$lambda$13$lambda$12(PsiClassType it) {
        String string = it.getCanonicalText(true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$Companion;", "", "<init>", "()V", "conversionPerformed", "", "getConversionPerformed", "()Z", "setConversionPerformed", "(Z)V", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final boolean getConversionPerformed() {
            return conversionPerformed;
        }

        public final void setConversionPerformed(boolean bl) {
            conversionPerformed = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "", "<init>", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "kotlin.idea"})
    private static final class JavaContext
    extends Enum<JavaContext> {
        public static final /* enum */ JavaContext TOP_LEVEL = new JavaContext();
        public static final /* enum */ JavaContext CLASS_BODY = new JavaContext();
        public static final /* enum */ JavaContext IN_BLOCK = new JavaContext();
        public static final /* enum */ JavaContext EXPRESSION = new JavaContext();
        private static final /* synthetic */ JavaContext[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JavaContext[] values() {
            return (JavaContext[])$VALUES.clone();
        }

        public static JavaContext valueOf(String value) {
            return Enum.valueOf(JavaContext.class, value);
        }

        @NotNull
        public static EnumEntries<JavaContext> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = javaContextArray = new JavaContext[]{JavaContext.TOP_LEVEL, JavaContext.CLASS_BODY, JavaContext.IN_BLOCK, JavaContext.EXPRESSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "", "<init>", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "kotlin.idea"})
    private static final class KotlinContext
    extends Enum<KotlinContext> {
        public static final /* enum */ KotlinContext TOP_LEVEL = new KotlinContext();
        public static final /* enum */ KotlinContext CLASS_BODY = new KotlinContext();
        public static final /* enum */ KotlinContext IN_BLOCK = new KotlinContext();
        public static final /* enum */ KotlinContext EXPRESSION = new KotlinContext();
        private static final /* synthetic */ KotlinContext[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KotlinContext[] values() {
            return (KotlinContext[])$VALUES.clone();
        }

        public static KotlinContext valueOf(String value) {
            return Enum.valueOf(KotlinContext.class, value);
        }

        @NotNull
        public static EnumEntries<KotlinContext> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kotlinContextArray = new KotlinContext[]{KotlinContext.TOP_LEVEL, KotlinContext.CLASS_BODY, KotlinContext.IN_BLOCK, KotlinContext.EXPRESSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getFlavor", "Ljava/awt/datatransfer/DataFlavor;", "Companion", "kotlin.idea"})
    private static final class MyTransferableData
    implements TextBlockTransferableData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String text;
        @NotNull
        private static final DataFlavor DATA_FLAVOR = new DataFlavor(ConvertTextJavaCopyPasteProcessor.class, "class: ConvertTextJavaCopyPasteProcessor");

        public MyTransferableData(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData$Companion;", "", "<init>", "()V", "DATA_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getDATA_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DataFlavor getDATA_FLAVOR() {
                return DATA_FLAVOR;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KotlinContext.values().length];
            try {
                nArray[KotlinContext.TOP_LEVEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinContext.CLASS_BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinContext.IN_BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinContext.EXPRESSION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JavaContext.values().length];
            try {
                nArray[JavaContext.TOP_LEVEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaContext.CLASS_BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaContext.IN_BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaContext.EXPRESSION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

