/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinK2FeaturesInK1ModeNotifierKt;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinK2FeaturesInK1ModeNotifier;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectUnsupportedFeatures", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "createNotificationPanel", "fileEditor", "unsupportedFeatures", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nKotlinK2FeaturesInK1ModeNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinK2FeaturesInK1ModeNotifier.kt\norg/jetbrains/kotlin/idea/configuration/KotlinK2FeaturesInK1ModeNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n774#2:78\n865#2,2:79\n*S KotlinDebug\n*F\n+ 1 KotlinK2FeaturesInK1ModeNotifier.kt\norg/jetbrains/kotlin/idea/configuration/KotlinK2FeaturesInK1ModeNotifier\n*L\n48#1:78\n48#1:79,2\n*E\n"})
public final class KotlinK2FeaturesInK1ModeNotifier
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (PropertiesComponent.getInstance().getBoolean("kotlin.k2.features.in.k1.mode.notification.disabled")) {
            return null;
        }
        List<LanguageFeature> unsupportedFeatures = this.collectUnsupportedFeatures(project, file);
        if (unsupportedFeatures.isEmpty()) {
            return null;
        }
        return arg_0 -> KotlinK2FeaturesInK1ModeNotifier.collectNotificationData$lambda$0(this, project, unsupportedFeatures, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LanguageFeature> collectUnsupportedFeatures(Project project, VirtualFile file) {
        void $this$filterTo$iv$iv;
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (!StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile ktFile3 = ktFile2;
        EnumSet enumSet = KotlinK2FeaturesInK1ModeNotifierKt.access$getExperimentalFeaturesWithK2OnlySupport$p();
        Intrinsics.checkNotNullExpressionValue((Object)enumSet, (String)"access$getExperimentalFe\u2026sWithK2OnlySupport$p(...)");
        Iterable $this$filter$iv = enumSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LanguageFeature feature = (LanguageFeature)element$iv$iv;
            boolean bl = false;
            LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)ktFile3);
            Intrinsics.checkNotNull((Object)feature);
            if (!languageVersionSettings.supportsFeature(feature)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final JComponent createNotificationPanel(Project project, FileEditor fileEditor, List<? extends LanguageFeature> unsupportedFeatures) {
        EditorNotificationPanel editorNotificationPanel;
        String featureNames = CollectionsKt.joinToString$default((Iterable)unsupportedFeatures, null, null, null, (int)0, null, KotlinK2FeaturesInK1ModeNotifier::createNotificationPanel$lambda$2, (int)31, null);
        EditorNotificationPanel $this$createNotificationPanel_u24lambda_u247 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        Object[] objectArray = new Object[]{featureNames};
        $this$createNotificationPanel_u24lambda_u247.setText(KotlinProjectConfigurationBundle.message("k1.mode.does.not.support.features.0", objectArray));
        if (VMOptions.canWriteOptions()) {
            $this$createNotificationPanel_u24lambda_u247.createActionLabel(KotlinProjectConfigurationBundle.message("enable.k2.mode", new Object[0]), () -> KotlinK2FeaturesInK1ModeNotifier.createNotificationPanel$lambda$7$lambda$5(project));
        }
        $this$createNotificationPanel_u24lambda_u247.createActionLabel(KotlinProjectConfigurationBundle.message("k1.does.not.support.features.ignore", new Object[0]), () -> KotlinK2FeaturesInK1ModeNotifier.createNotificationPanel$lambda$7$lambda$6(project, fileEditor));
        return (JComponent)editorNotificationPanel;
    }

    private static final JComponent collectNotificationData$lambda$0(KotlinK2FeaturesInK1ModeNotifier this$0, Project $project, List $unsupportedFeatures, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        return this$0.createNotificationPanel($project, fileEditor, $unsupportedFeatures);
    }

    private static final CharSequence createNotificationPanel$lambda$2(LanguageFeature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it.getPresentableName() + "'";
    }

    private static final boolean createNotificationPanel$lambda$7$lambda$5$lambda$3(Configurable configurable) {
        ConfigurableWithId configurableWithId = configurable instanceof ConfigurableWithId ? (ConfigurableWithId)configurable : null;
        return Intrinsics.areEqual((Object)(configurableWithId != null ? configurableWithId.getId() : null), (Object)"preferences.language.Kotlin");
    }

    private static final boolean createNotificationPanel$lambda$7$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void createNotificationPanel$lambda$7$lambda$5(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, arg_0 -> KotlinK2FeaturesInK1ModeNotifier.createNotificationPanel$lambda$7$lambda$5$lambda$4(KotlinK2FeaturesInK1ModeNotifier::createNotificationPanel$lambda$7$lambda$5$lambda$3, arg_0), null);
    }

    private static final void createNotificationPanel$lambda$7$lambda$6(Project $project, FileEditor $fileEditor) {
        PropertiesComponent.getInstance().setValue("kotlin.k2.features.in.k1.mode.notification.disabled", true);
        EditorNotifications.getInstance((Project)$project).updateNotifications($fileEditor.getFile());
    }
}

