/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.ElementFilters;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/utils/MyPsiUtils;", "", "<init>", "()V", "Companion", "kotlin.code-insight.inspections.shared"})
public final class MyPsiUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tJ(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tJ8\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/utils/MyPsiUtils$Companion;", "", "<init>", "()V", "findAllChildren", "", "Lcom/intellij/psi/PsiElement;", "startElement", "condition", "Lkotlin/Function1;", "", "fenceCondition", "findParent", "getFileAndLine", "", "element", "getUrl", "findRunBlockings", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findNonBlockingBuilders", "findSuspendFuns", "getFileForElement", "psiElement", "kotlin.code-insight.inspections.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PsiElement> findAllChildren(@NotNull PsiElement startElement, @NotNull Function1<? super PsiElement, Boolean> condition2, @NotNull Function1<? super PsiElement, Boolean> fenceCondition) {
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter(condition2, (String)"condition");
            Intrinsics.checkNotNullParameter(fenceCondition, (String)"fenceCondition");
            List foundChildren = new ArrayList();
            startElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(startElement, fenceCondition, condition2, foundChildren){
                final /* synthetic */ PsiElement $startElement;
                final /* synthetic */ Function1<PsiElement, Boolean> $fenceCondition;
                final /* synthetic */ Function1<PsiElement, Boolean> $condition;
                final /* synthetic */ List<PsiElement> $foundChildren;
                {
                    this.$startElement = $startElement;
                    this.$fenceCondition = $fenceCondition;
                    this.$condition = $condition;
                    this.$foundChildren = $foundChildren;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!Intrinsics.areEqual((Object)this.$startElement, (Object)element) && ((Boolean)this.$fenceCondition.invoke((Object)element)).booleanValue()) {
                        return;
                    }
                    if (!Intrinsics.areEqual((Object)this.$startElement, (Object)element) && ((Boolean)this.$condition.invoke((Object)element)).booleanValue()) {
                        this.$foundChildren.add(element);
                    }
                    super.visitElement(element);
                }
            });
            return foundChildren;
        }

        @NotNull
        public final List<PsiElement> findAllChildren(@NotNull PsiElement startElement, @NotNull Function1<? super PsiElement, Boolean> condition2) {
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter(condition2, (String)"condition");
            return this.findAllChildren(startElement, condition2, (Function1<? super PsiElement, Boolean>)((Function1)Companion::findAllChildren$lambda$0));
        }

        @Nullable
        public final PsiElement findParent(@NotNull PsiElement startElement, @NotNull Function1<? super PsiElement, Boolean> condition2, @NotNull Function1<? super PsiElement, Boolean> fenceCondition) {
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter(condition2, (String)"condition");
            Intrinsics.checkNotNullParameter(fenceCondition, (String)"fenceCondition");
            for (PsiElement currentElement = startElement; currentElement != null; currentElement = currentElement.getParent()) {
                if (((Boolean)fenceCondition.invoke((Object)currentElement)).booleanValue()) {
                    return null;
                }
                if (!((Boolean)condition2.invoke((Object)currentElement)).booleanValue()) continue;
                return currentElement;
            }
            return null;
        }

        @NotNull
        public final String getFileAndLine(@NotNull PsiElement element) {
            Document document;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Document document2 = document = element.getContainingFile().getViewProvider().getDocument();
            int lineNr = document2 != null ? document2.getLineNumber(element.getTextRange().getStartOffset()) + 1 : -1;
            return element.getContainingFile().getName() + ":" + lineNr;
        }

        @Nullable
        public final String getUrl(@NotNull PsiElement element) {
            PsiFileSystemItem containingFile;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!element.isPhysical()) {
                return null;
            }
            PsiFileSystemItem psiFileSystemItem = containingFile = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : (PsiFileSystemItem)element.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            return element instanceof PsiFileSystemItem ? virtualFile2.getUrl() : virtualFile2.getUrl() + "#" + element.getTextOffset();
        }

        @NotNull
        public final List<PsiElement> findRunBlockings(@NotNull VirtualFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return CollectionsKt.emptyList();
            }
            PsiFile psiFile2 = psiFile;
            return this.findAllChildren((PsiElement)psiFile2, (Function1<? super PsiElement, Boolean>)((Function1)Companion::findRunBlockings$lambda$1));
        }

        @NotNull
        public final List<PsiElement> findNonBlockingBuilders(@NotNull VirtualFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return CollectionsKt.emptyList();
            }
            PsiFile psiFile2 = psiFile;
            return this.findAllChildren((PsiElement)psiFile2, (Function1<? super PsiElement, Boolean>)((Function1)Companion::findNonBlockingBuilders$lambda$2));
        }

        @NotNull
        public final List<PsiElement> findSuspendFuns(@NotNull VirtualFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return CollectionsKt.emptyList();
            }
            PsiFile psiFile2 = psiFile;
            return this.findAllChildren((PsiElement)psiFile2, (Function1<? super PsiElement, Boolean>)((Function1)Companion::findSuspendFuns$lambda$3));
        }

        @NotNull
        public final VirtualFile getFileForElement(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)psiElement, arg_0 -> Companion.getFileForElement$lambda$5(Companion::getFileForElement$lambda$4, arg_0));
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile ktFile2 = (KtFile)psiElement2;
            VirtualFile virtualFile = ktFile2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return virtualFile;
        }

        private static final boolean findAllChildren$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return false;
        }

        private static final boolean findRunBlockings$lambda$1(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ElementFilters.Companion.getRunBlockingBuilderInvocation().isAccepted(it);
        }

        private static final boolean findNonBlockingBuilders$lambda$2(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ElementFilters.Companion.getLaunchBuilder().isAccepted(it) || ElementFilters.Companion.getAsyncBuilder().isAccepted(it);
        }

        private static final boolean findSuspendFuns$lambda$3(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ElementFilters.Companion.getSuspendFun().isAccepted(it);
        }

        private static final boolean getFileForElement$lambda$4(PsiElement it) {
            return it instanceof KtFile;
        }

        private static final boolean getFileForElement$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

