/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.CheckResult;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/PackageNameInspectionLocal;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "parentInspection", "Lcom/intellij/codeInspection/InspectionProfileEntry;", "namingSettings", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "<init>", "(Lcom/intellij/codeInspection/InspectionProfileEntry;Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;)V", "getParentInspection", "()Lcom/intellij/codeInspection/InspectionProfileEntry;", "getNamingSettings", "()Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getShortName", "", "getDisplayName", "RenamePackageFix", "kotlin.code-insight.inspections.shared"})
final class PackageNameInspectionLocal
extends AbstractKotlinInspection {
    @NotNull
    private final InspectionProfileEntry parentInspection;
    @NotNull
    private final NamingConventionInspectionSettings namingSettings;

    public PackageNameInspectionLocal(@NotNull InspectionProfileEntry parentInspection, @NotNull NamingConventionInspectionSettings namingSettings) {
        Intrinsics.checkNotNullParameter((Object)parentInspection, (String)"parentInspection");
        Intrinsics.checkNotNullParameter((Object)namingSettings, (String)"namingSettings");
        this.parentInspection = parentInspection;
        this.namingSettings = namingSettings;
    }

    @NotNull
    public final InspectionProfileEntry getParentInspection() {
        return this.parentInspection;
    }

    @NotNull
    public final NamingConventionInspectionSettings getNamingSettings() {
        return this.namingSettings;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.packageDirectiveVisitor(arg_0 -> PackageNameInspectionLocal.buildVisitor$lambda$0(this, holder, arg_0));
    }

    @NotNull
    public String getShortName() {
        String string = this.parentInspection.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.parentInspection.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    private static final Unit buildVisitor$lambda$0(PackageNameInspectionLocal this$0, ProblemsHolder $holder, KtPackageDirective directive) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        KtExpression ktExpression = directive.getPackageNameExpression();
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression packageNameExpression = ktExpression;
        CheckResult checkResult = NamingConventionInspectionsKt.access$checkPackageDirective(directive, this$0.namingSettings);
        if (checkResult == null) {
            return Unit.INSTANCE;
        }
        CheckResult checkResult2 = checkResult;
        String descriptionTemplate = checkResult2.toProblemTemplateString();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RenamePackageFix()};
        $holder.registerProblem((PsiElement)packageNameExpression, descriptionTemplate, localQuickFixArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/PackageNameInspectionLocal$RenamePackageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "<init>", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "kotlin.code-insight.inspections.shared"})
    private static final class RenamePackageFix
    extends RenameIdentifierFix {
        @Override
        @Nullable
        protected PsiElement getElementToRename(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtPackageDirective ktPackageDirective = element instanceof KtPackageDirective ? (KtPackageDirective)element : null;
            if (ktPackageDirective == null) {
                return null;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            return (PsiElement)JavaPsiFacade.getInstance((Project)((KtPackageDirective)element).getProject()).findPackage(packageDirective.getQualifiedName());
        }
    }
}

