/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.siyeh.ig.BaseGlobalInspection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.CheckResult;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.PackageNameInspectionLocal;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/PackageNameInspection;", "Lcom/siyeh/ig/BaseGlobalInspection;", "<init>", "()V", "DEFAULT_PACKAGE_NAME_PATTERN", "", "namePattern", "getNamePattern$annotations", "getNamePattern", "()Ljava/lang/String;", "setNamePattern", "(Ljava/lang/String;)V", "namingSettings", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "checkElement", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "refEntity", "Lcom/intellij/codeInspection/reference/RefEntity;", "analysisScope", "Lcom/intellij/analysis/AnalysisScope;", "inspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "globalInspectionContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "(Lcom/intellij/codeInspection/reference/RefEntity;Lcom/intellij/analysis/AnalysisScope;Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/codeInspection/GlobalInspectionContext;)[Lcom/intellij/codeInspection/CommonProblemDescriptor;", "readSettings", "", "element", "Lorg/jdom/Element;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getSharedLocalInspectionTool", "Lcom/intellij/codeInspection/LocalInspectionTool;", "kotlin.code-insight.inspections.shared"})
public final class PackageNameInspection
extends BaseGlobalInspection {
    @NotNull
    private final String DEFAULT_PACKAGE_NAME_PATTERN;
    @NotNull
    private String namePattern;
    @NotNull
    private final NamingConventionInspectionSettings namingSettings;

    public PackageNameInspection() {
        this.namePattern = this.DEFAULT_PACKAGE_NAME_PATTERN = "[a-z_][a-zA-Z\\d_]*(\\.[a-z_][a-zA-Z\\d_]*)*";
        this.namingSettings = new NamingConventionInspectionSettings(KotlinBundle.message((String)"text.Package", (Object[])new Object[0]), this.DEFAULT_PACKAGE_NAME_PATTERN, (Function1<? super String, Unit>)((Function1)arg_0 -> PackageNameInspection.namingSettings$lambda$0(this, arg_0)));
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.namePattern = string;
    }

    public static /* synthetic */ void getNamePattern$annotations() {
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        Intrinsics.checkNotNullParameter((Object)refEntity, (String)"refEntity");
        Intrinsics.checkNotNullParameter((Object)analysisScope, (String)"analysisScope");
        Intrinsics.checkNotNullParameter((Object)inspectionManager, (String)"inspectionManager");
        Intrinsics.checkNotNullParameter((Object)globalInspectionContext, (String)"globalInspectionContext");
        RefEntity refEntity2 = refEntity;
        if (refEntity2 instanceof RefFile) {
            KtPackageDirective packageDirective;
            PsiFile psiFile = ((RefFile)refEntity).getPsiElement();
            if (psiFile instanceof KtFile && !InjectedLanguageManager.getInstance((Project)((KtFile)psiFile).getProject()).isInjectedFragment(psiFile) && !PackageUtilsKt.packageMatchesDirectoryOrImplicit((KtFile)psiFile) && (packageDirective = ((KtFile)psiFile).getPackageDirective()) != null) {
                String string = packageDirective.getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
                String qualifiedName = string;
                CheckResult checkResult = NamingConventionInspectionsKt.access$checkPackageDirective(packageDirective, this.namingSettings);
                if (checkResult != null) {
                    CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(checkResult.toErrorMessage(qualifiedName), new QuickFix[0])};
                    return commonProblemDescriptorArray;
                }
            }
        } else if (refEntity2 instanceof RefPackage) {
            String string = StringUtil.getShortName((String)((RefPackage)refEntity).getQualifiedName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
            String name2 = string;
            if (((CharSequence)name2).length() == 0 || Intrinsics.areEqual((Object)InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]), (Object)name2)) {
                return null;
            }
            CheckResult checkResult = NamingConventionInspectionsKt.access$checkQualifiedName(name2, this.namingSettings);
            if (checkResult != null) {
                CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(checkResult.toErrorMessage(name2), new QuickFix[0])};
                return commonProblemDescriptorArray;
            }
        } else {
            return null;
        }
        return null;
    }

    public void readSettings(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readSettings(element);
        this.namingSettings.setNamePattern(this.namePattern);
    }

    @NotNull
    public OptPane getOptionsPane() {
        return this.namingSettings.getOptionsPane();
    }

    @NotNull
    public OptionController getOptionController() {
        return this.namingSettings.getOptionController();
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new PackageNameInspectionLocal((InspectionProfileEntry)this, this.namingSettings);
    }

    private static final Unit namingSettings$lambda$0(PackageNameInspection this$0, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.namePattern = value;
        return Unit.INSTANCE;
    }
}

