/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryUsageIndex;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderExtension;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.UserDataModuleContainer;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.util.MappingIterator;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.util.SeqKt;
import org.jetbrains.kotlin.idea.base.util.SeqScope;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 B2\u00020\u0001:\u0003BCDB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J.\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J(\u0010\u001e\u001a\u00020\u001f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010!\u001a\u00020\u001f2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#\u00a2\u0006\u0002\b%H\u0082\bJ8\u0010&\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0#\u00a2\u0006\u0002\b%2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0(H\u0082\bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010+\u001a\u00020\u001f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140 2\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010-\u001a\u00020\u001f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u000200H\u0002J(\u00101\u001a\u00020\u001f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u000204H\u0002J\u001a\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u0002002\u0006\u00106\u001a\u000207H\u0002J\u001a\u00108\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u0002002\u0006\u00109\u001a\u00020:H\u0002J\u0016\u0010;\u001a\u00020\u001d*\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J \u0010?\u001a\u00020\u001f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140 2\u0006\u0010@\u001a\u00020AH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "libraryInfoCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "getLibraryInfoCache", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "libraryInfoCache$delegate", "collect", "Lkotlin/sequences/Sequence;", "Lkotlin/Result;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "element", "Lcom/intellij/psi/PsiElement;", "config", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLibrarySource", "", "collectByElement", "", "Lorg/jetbrains/kotlin/idea/base/util/SeqScope;", "callExtensions", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProviderExtension;", "Lkotlin/ExtensionFunctionType;", "withCallExtensions", "extensionBlock", "Lkotlin/Function0;", "containingKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectByLightElement", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "collectByFile", "contextByContextualBinaryModule", "collectionRequest", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$VirtualFileCollectionRequest;", "collectSourceRelatedByFile", "collectByOrderEntry", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "collectByLibrary", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "collectBySdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isApplicable", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "contextualModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "collectByUserData", "container", "Lorg/jetbrains/kotlin/idea/base/projectStructure/UserDataModuleContainer;", "Companion", "Configuration", "VirtualFileCollectionRequest", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n209#1,2:522\n199#1,4:524\n213#1,4:528\n199#1,4:532\n218#1:536\n199#1,4:537\n199#1,4:541\n209#1,2:546\n199#1,4:548\n213#1,4:552\n199#1,4:556\n218#1:560\n154#2:545\n31#3,2:561\n1#4:563\n*S KotlinDebug\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider\n*L\n184#1:522,2\n184#1:524,4\n184#1:528,4\n184#1:532,4\n184#1:536\n210#1:537,4\n216#1:541,4\n250#1:546,2\n250#1:548,4\n250#1:552,4\n250#1:556,4\n250#1:560\n226#1:545\n425#1:561,2\n*E\n"})
public final class ModuleInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy fileIndex$delegate;
    @NotNull
    private final Lazy libraryInfoCache$delegate;
    @NotNull
    private static final Logger LOG;

    public ModuleInfoProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fileIndex$delegate = LazyKt.lazy(() -> ModuleInfoProvider.fileIndex_delegate$lambda$0(this));
        this.libraryInfoCache$delegate = LazyKt.lazy(() -> ModuleInfoProvider.libraryInfoCache_delegate$lambda$1(this));
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        return (ProjectFileIndex)lazy.getValue();
    }

    private final LibraryInfoCache getLibraryInfoCache() {
        Lazy lazy = this.libraryInfoCache$delegate;
        return (LibraryInfoCache)lazy.getValue();
    }

    @NotNull
    public final Sequence<Result<IdeaModuleInfo>> collect(@NotNull PsiElement element, @NotNull Configuration config2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return SeqKt.seq(arg_0 -> ModuleInfoProvider.collect$lambda$2(this, element, config2, arg_0));
    }

    public static /* synthetic */ Sequence collect$default(ModuleInfoProvider moduleInfoProvider, PsiElement psiElement, Configuration configuration2, int n, Object object) {
        if ((n & 2) != 0) {
            configuration2 = Configuration.Companion.getDefault();
        }
        return moduleInfoProvider.collect(psiElement, configuration2);
    }

    @NotNull
    public final Sequence<Result<IdeaModuleInfo>> collect(@NotNull VirtualFile virtualFile, boolean isLibrarySource, @NotNull Configuration config2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return SeqKt.seq(arg_0 -> ModuleInfoProvider.collect$lambda$3(this, virtualFile, isLibrarySource, config2, arg_0));
    }

    public static /* synthetic */ Sequence collect$default(ModuleInfoProvider moduleInfoProvider, VirtualFile virtualFile, boolean bl, Configuration configuration2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            configuration2 = Configuration.Companion.getDefault();
        }
        return moduleInfoProvider.collect(virtualFile, bl, configuration2);
    }

    private final void collectByElement(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByElement, PsiElement element, Configuration config2) {
        KtFile containingKtFile;
        ModuleInfo moduleInfo;
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null && (moduleInfo = KotlinProjectStructureUtils.getForcedModuleInfo(containingFile)) instanceof IdeaModuleInfo) {
            ModuleInfoProviderKt.register($this$collectByElement, (IdeaModuleInfo)moduleInfo);
        }
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            this.collectByFile($this$collectByElement, virtualFile, false, config2);
            return;
        }
        if (element instanceof KtLightElement) {
            this.collectByLightElement($this$collectByElement, (KtLightElement)element, config2);
        }
        this.collectByUserData($this$collectByElement, new UserDataModuleContainer.ForElement(element));
        if (containingFile == null) {
            String message2 = "Analyzing element of type " + element.getClass() + " with no containing file";
            ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)new KotlinExceptionWithAttachments(message2).withAttachment("element.kt", (Object)element.getText()));
        }
        KtFile ktFile2 = containingKtFile = containingFile instanceof KtFile ? (KtFile)containingFile : null;
        if (containingKtFile != null) {
            ModuleInfo explicitModuleInfo;
            Object object = ((KtFile)containingFile).getVirtualFile();
            if (object != null && (object = ContextModuleKt.getAnalysisContextModule(object)) != null) {
                Object module = object;
                boolean bl = false;
                ModuleInfoProviderKt.register($this$collectByElement, KotlinProjectStructureUtils.getModuleInfo((KaModule)module));
            }
            PsiElement analysisContext = KtPsiFactoryKt.getAnalysisContext((KtFile)containingKtFile);
            if (analysisContext != null) {
                this.collectByElement($this$collectByElement, analysisContext, config2);
            }
            if (KtPsiFactoryKt.getDoNotAnalyze((KtFile)containingKtFile) != null) {
                return;
            }
            Object object2 = KotlinProjectStructureUtils.getForcedModuleInfo((PsiFile)containingKtFile);
            if (object2 == null) {
                PsiFile bl = containingKtFile.getOriginalFile();
                KtFile ktFile3 = bl instanceof KtFile ? (KtFile)bl : null;
                object2 = ktFile3 != null ? KotlinProjectStructureUtils.getForcedModuleInfo((PsiFile)ktFile3) : null;
            }
            if ((explicitModuleInfo = object2) instanceof IdeaModuleInfo) {
                ModuleInfoProviderKt.register($this$collectByElement, (IdeaModuleInfo)explicitModuleInfo);
            }
            if (containingKtFile instanceof KtCodeFragment) {
                PsiElement context2 = ((KtCodeFragment)containingKtFile).getContext();
                if (context2 != null) {
                    this.collectByElement($this$collectByElement, context2, config2);
                } else {
                    String message3 = "Analyzing code fragment of type " + containingKtFile.getClass() + " with no context";
                    KotlinExceptionWithAttachments error = new KotlinExceptionWithAttachments(message3).withAttachment("file.kt", (Object)((KtCodeFragment)containingKtFile).getText());
                    ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)error);
                }
            }
        }
        if (containingFile != null) {
            VirtualFile virtualFile = containingFile.getOriginalFile().getVirtualFile();
            if (virtualFile != null) {
                boolean bl;
                ModuleInfoProviderExtension extension$iv$iv;
                Iterator iterator2;
                boolean $i$f$callExtensions;
                ModuleInfoProvider this_$iv$iv;
                ModuleInfoProvider this_$iv = this;
                boolean $i$f$withCallExtensions = false;
                if (config2.getPreferModulesFromExtensions()) {
                    this_$iv$iv = this_$iv;
                    $i$f$callExtensions = false;
                    iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                    while (iterator2.hasNext()) {
                        ModuleInfoProviderExtension $this$collectByElement_u24lambda_u245 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                        bl = false;
                        $this$collectByElement_u24lambda_u245.collectByElement($this$collectByElement, element, containingFile, virtualFile);
                    }
                }
                boolean bl2 = false;
                boolean isLibrarySource = containingKtFile != null && this.isLibrarySource(containingKtFile, config2);
                this.collectByFile($this$collectByElement, virtualFile, isLibrarySource, config2);
                if (!config2.getPreferModulesFromExtensions()) {
                    this_$iv$iv = this_$iv;
                    $i$f$callExtensions = false;
                    iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                    while (iterator2.hasNext()) {
                        ModuleInfoProviderExtension $this$collectByElement_u24lambda_u245 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                        bl = false;
                        $this$collectByElement_u24lambda_u245.collectByElement($this$collectByElement, element, containingFile, virtualFile);
                    }
                }
            } else {
                String message4 = "Analyzing element of type " + element.getClass() + " in non-physical file of type " + containingFile.getClass();
                ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)new KotlinExceptionWithAttachments(message4).withAttachment("file.kt", (Object)containingFile.getText()));
            }
        }
    }

    private final void callExtensions(Function1<? super ModuleInfoProviderExtension, Unit> block) {
        boolean $i$f$callExtensions = false;
        for (ModuleInfoProviderExtension extension : this.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList()) {
            block.invoke((Object)extension);
        }
    }

    private final void withCallExtensions(Configuration config2, Function1<? super ModuleInfoProviderExtension, Unit> extensionBlock, Function0<Unit> block) {
        boolean $i$f$callExtensions;
        ModuleInfoProvider this_$iv;
        boolean $i$f$withCallExtensions = false;
        if (config2.getPreferModulesFromExtensions()) {
            this_$iv = this;
            $i$f$callExtensions = false;
            for (ModuleInfoProviderExtension extension$iv : this_$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList()) {
                extensionBlock.invoke((Object)extension$iv);
            }
        }
        block.invoke();
        if (!config2.getPreferModulesFromExtensions()) {
            this_$iv = this;
            $i$f$callExtensions = false;
            for (ModuleInfoProviderExtension extension$iv : this_$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList()) {
                extensionBlock.invoke((Object)extension$iv);
            }
        }
    }

    private final boolean isLibrarySource(KtFile containingKtFile, Configuration config2) {
        boolean isCompiled = containingKtFile.isCompiled();
        return config2.getCreateSourceLibraryInfoForLibraryBinaries() ? isCompiled : !isCompiled;
    }

    private final void collectByLightElement(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByLightElement, KtLightElement<?, ?> element, Configuration config2) {
        KtElement originalElement;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtLightClassForDecompiledDeclaration.class, (boolean)false) != null) {
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                throw new IllegalStateException("Decompiled class should be build from physical file".toString());
            }
            VirtualFile virtualFile2 = virtualFile;
            this.collectByFile($this$collectByLightElement, virtualFile2, false, config2);
        }
        if ((originalElement = element.getKotlinOrigin()) != null) {
            this.collectByElement($this$collectByLightElement, (PsiElement)originalElement, config2);
        } else if (element instanceof KtLightClassForFacade) {
            this.collectByElement($this$collectByLightElement, (PsiElement)CollectionsKt.first((Iterable)((KtLightClassForFacade)element).getFiles()), config2);
        } else {
            KotlinExceptionWithAttachments error = new KotlinExceptionWithAttachments("Light element without origin is referenced by resolve").withAttachment("element.txt", element);
            ModuleInfoProviderKt.reportError($this$collectByLightElement, (Throwable)error);
        }
    }

    private final void collectByFile(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByFile, VirtualFile virtualFile, boolean isLibrarySource, Configuration config2) {
        ModuleInfoProviderExtension extension$iv$iv;
        Iterator iterator2;
        boolean $i$f$callExtensions;
        ModuleInfoProvider this_$iv$iv;
        this.collectByUserData($this$collectByFile, new UserDataModuleContainer.ForVirtualFile(virtualFile, this.project));
        ModuleInfoProvider this_$iv = this;
        boolean $i$f$withCallExtensions = false;
        if (config2.getPreferModulesFromExtensions()) {
            this_$iv$iv = this_$iv;
            $i$f$callExtensions = false;
            iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
            while (iterator2.hasNext()) {
                ModuleInfoProviderExtension $this$collectByFile_u24lambda_u247 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                boolean bl = false;
                $this$collectByFile_u24lambda_u247.collectByFile($this$collectByFile, this.project, virtualFile, isLibrarySource, config2);
            }
        }
        boolean bl = false;
        this.collectSourceRelatedByFile($this$collectByFile, virtualFile, config2);
        HashSet<IdeaModuleInfo> visited = new HashSet<IdeaModuleInfo>();
        VirtualFileCollectionRequest collectionRequest = new VirtualFileCollectionRequest(virtualFile, isLibrarySource, config2, visited, this.project);
        $this$collectByFile.yield((Function0<? super Result<? extends IdeaModuleInfo>>)((Function0)() -> ModuleInfoProvider.collectByFile$lambda$9$lambda$8(this, collectionRequest)));
        $this$collectByFile.yieldAll((Iterable<? super Result<? extends IdeaModuleInfo>>)new Iterable<Result<? extends IdeaModuleInfo>>(this, virtualFile, collectionRequest){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ VirtualFileCollectionRequest $collectionRequest;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$collectionRequest = $collectionRequest;
            }

            public Iterator<Result<IdeaModuleInfo>> iterator() {
                Object object = ActionsKt.runReadAction(() -> collectByFile.2.2.iterator$lambda$0(this.this$0, this.$virtualFile));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                List orderEntries = (List)object;
                Iterator<E> iterator2 = orderEntries.iterator();
                return new MappingIterator<E, T>(iterator2, arg_0 -> collectByFile.2.2.iterator$lambda$1(this.this$0, this.$collectionRequest, arg_0));
            }

            private static final List iterator$lambda$0(ModuleInfoProvider this$0, VirtualFile $virtualFile) {
                return ModuleInfoProvider.access$getFileIndex(this$0).getOrderEntriesForFile($virtualFile);
            }

            private static final Result iterator$lambda$1(ModuleInfoProvider this$0, VirtualFileCollectionRequest $collectionRequest, OrderEntry orderEntry) {
                Result result2;
                Intrinsics.checkNotNull((Object)orderEntry);
                IdeaModuleInfo ideaModuleInfo = ModuleInfoProvider.access$collectByOrderEntry(this$0, $collectionRequest, orderEntry);
                if (ideaModuleInfo != null) {
                    IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
                    IdeaModuleInfo p0 = ideaModuleInfo2;
                    boolean bl = false;
                    boolean $i$f$iterator$lambda$1$stub_for_inlining = false;
                    result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                } else {
                    result2 = null;
                }
                return result2;
            }
        });
        if (!config2.getPreferModulesFromExtensions()) {
            this_$iv$iv = this_$iv;
            $i$f$callExtensions = false;
            iterator2 = this_$iv$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
            while (iterator2.hasNext()) {
                ModuleInfoProviderExtension $this$collectByFile_u24lambda_u247 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                boolean bl2 = false;
                $this$collectByFile_u24lambda_u247.collectByFile($this$collectByFile, this.project, virtualFile, isLibrarySource, config2);
            }
        }
    }

    private final IdeaModuleInfo contextByContextualBinaryModule(VirtualFileCollectionRequest collectionRequest) {
        IdeaModuleInfo ideaModuleInfo = collectionRequest.getConfig().getContextualModuleInfo();
        if (ideaModuleInfo == null) {
            return null;
        }
        IdeaModuleInfo contextualModuleInfo = ideaModuleInfo;
        IdeaModuleInfo ideaModuleInfo2 = contextualModuleInfo;
        GlobalSearchScope contentScope = ideaModuleInfo2 instanceof LibraryInfo || ideaModuleInfo2 instanceof SdkInfo ? contextualModuleInfo.getContentScope() : (ideaModuleInfo2 instanceof LibrarySourceInfo ? ((LibrarySourceInfo)contextualModuleInfo).sourceScope() : null);
        VirtualFile virtualFile = collectionRequest.getVirtualFile();
        if (contentScope == null || !contentScope.contains(virtualFile)) {
            return null;
        }
        IdeaModuleInfo ideaModuleInfo3 = contextualModuleInfo;
        return ideaModuleInfo3 instanceof LibraryInfo ? this.collectByLibrary(collectionRequest, (Library)((LibraryInfo)contextualModuleInfo).getLibrary()) : (ideaModuleInfo3 instanceof LibrarySourceInfo ? this.collectByLibrary(collectionRequest, ((LibrarySourceInfo)contextualModuleInfo).getLibrary()) : (ideaModuleInfo3 instanceof SdkInfo ? this.collectBySdk(collectionRequest, ((SdkInfo)contextualModuleInfo).getSdk()) : null));
    }

    private final void collectSourceRelatedByFile(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectSourceRelatedByFile, VirtualFile virtualFile, Configuration config2) {
        $this$collectSourceRelatedByFile.yieldAll((Iterable<? super Result<? extends IdeaModuleInfo>>)new Iterable<Result<? extends IdeaModuleInfo>>(this, config2, virtualFile){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ Configuration $config;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                this.$virtualFile = $virtualFile;
            }

            public Iterator<Result<IdeaModuleInfo>> iterator() {
                Sequence<T> modules2 = SeqKt.seq(arg_0 -> collectSourceRelatedByFile.1.iterator$lambda$5(this.this$0, this.$config, this.$virtualFile, arg_0));
                Iterator iterator2 = modules2.iterator();
                return new MappingIterator<K, T>(iterator2, arg_0 -> collectSourceRelatedByFile.1.iterator$lambda$6(this.this$0, this.$virtualFile, arg_0));
            }

            private static final Module iterator$lambda$5$lambda$4$lambda$1(ModuleInfoProvider this$0, VirtualFile $virtualFile) {
                return ModuleInfoProvider.access$getFileIndex(this$0).getModuleForFile($virtualFile);
            }

            private static final Module iterator$lambda$5$lambda$4$lambda$3$lambda$2(Module $module) {
                return $module;
            }

            private static final Unit iterator$lambda$5(ModuleInfoProvider this$0, Configuration $config, VirtualFile $virtualFile, SeqScope $this$seq) {
                ModuleInfoProviderExtension extension$iv$iv;
                Iterator<E> iterator2;
                boolean $i$f$callExtensions;
                ModuleInfoProvider this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
                ModuleInfoProvider this_$iv = this$0;
                boolean $i$f$withCallExtensions = false;
                if ($config.getPreferModulesFromExtensions()) {
                    this_$iv$iv = this_$iv;
                    $i$f$callExtensions = false;
                    iterator2 = ModuleInfoProvider.access$getProject$p(this_$iv$iv).getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                    while (iterator2.hasNext()) {
                        ModuleInfoProviderExtension $this$iterator_u24lambda_u245_u24lambda_u240 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                        boolean bl = false;
                        $this$iterator_u24lambda_u245_u24lambda_u240.findContainingModules($this$seq, ModuleInfoProvider.access$getProject$p(this$0), $virtualFile);
                    }
                }
                boolean bl = false;
                Module module = (Module)ActionsKt.runReadAction(() -> collectSourceRelatedByFile.1.iterator$lambda$5$lambda$4$lambda$1(this$0, $virtualFile));
                if (module != null) {
                    Module module2 = module;
                    boolean bl2 = false;
                    $this$seq.yield(() -> collectSourceRelatedByFile.1.iterator$lambda$5$lambda$4$lambda$3$lambda$2(module2));
                }
                if (!$config.getPreferModulesFromExtensions()) {
                    this_$iv$iv = this_$iv;
                    $i$f$callExtensions = false;
                    iterator2 = ModuleInfoProvider.access$getProject$p(this_$iv$iv).getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensionList().iterator();
                    while (iterator2.hasNext()) {
                        ModuleInfoProviderExtension $this$iterator_u24lambda_u245_u24lambda_u240 = extension$iv$iv = (ModuleInfoProviderExtension)iterator2.next();
                        boolean bl3 = false;
                        $this$iterator_u24lambda_u245_u24lambda_u240.findContainingModules($this$seq, ModuleInfoProvider.access$getProject$p(this$0), $virtualFile);
                    }
                }
                return Unit.INSTANCE;
            }

            private static final Result iterator$lambda$6(ModuleInfoProvider this$0, VirtualFile $virtualFile, Module module) {
                Result result2;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                if (module.isDisposed()) {
                    return null;
                }
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)ModuleInfoProvider.access$getProject$p(this$0));
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                ProjectFileIndex projectFileIndex2 = projectFileIndex;
                KotlinSourceRootType sourceRootType = KotlinProjectStructureUtils.getKotlinSourceRootType(projectFileIndex2, $virtualFile);
                ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy = KotlinProjectStructureUtils.asSourceInfo(module, sourceRootType);
                if (moduleSourceInfoWithExpectedBy != null) {
                    ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy2 = moduleSourceInfoWithExpectedBy;
                    ModuleSourceInfoWithExpectedBy p0 = moduleSourceInfoWithExpectedBy2;
                    boolean bl = false;
                    boolean $i$f$iterator$lambda$6$stub_for_inlining = false;
                    result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                } else {
                    result2 = null;
                }
                return result2;
            }
        });
        VirtualFile fileOrigin = ProjectStructureUtils.getOutsiderFileOrigin(this.project, virtualFile);
        if (fileOrigin != null) {
            this.collectSourceRelatedByFile($this$collectSourceRelatedByFile, fileOrigin, config2);
        }
    }

    private final IdeaModuleInfo collectByOrderEntry(VirtualFileCollectionRequest collectionRequest, OrderEntry orderEntry) {
        Sdk sdk;
        Library library;
        if (orderEntry instanceof ModuleOrderEntry) {
            return null;
        }
        ProgressManager.checkCanceled();
        if (!orderEntry.isValid()) {
            return null;
        }
        if (orderEntry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)orderEntry).getLibrary()) != null) {
            return this.collectByLibrary(collectionRequest, library);
        }
        if (orderEntry instanceof JdkOrderEntry && (sdk = ((JdkOrderEntry)orderEntry).getJdk()) != null) {
            Sdk contextSdk;
            IdeaModuleInfo ideaModuleInfo = collectionRequest.getConfig().getContextualModuleInfo();
            Object object = contextSdk = ideaModuleInfo != null ? ideaModuleInfo.sdk() : null;
            if (contextSdk != null && !Intrinsics.areEqual((Object)contextSdk, (Object)sdk)) {
                return null;
            }
            return this.collectBySdk(collectionRequest, sdk);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final IdeaModuleInfo collectByLibrary(VirtualFileCollectionRequest collectionRequest, Library library) {
        block5: {
            block4: {
                config = collectionRequest.getConfig();
                var5_4 = config.getContextualModuleInfo();
                v0 = sourceContext = var5_4 instanceof ModuleSourceInfo != false ? (ModuleSourceInfo)var5_4 : null;
                if (collectionRequest.isLibrarySource()) ** GOTO lbl-1000
                var7_7 = config.getContextualModuleInfo();
                v1 = var7_7 instanceof LibrarySourceInfo != false ? (LibrarySourceInfo)var7_7 : null;
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getLibrary() : null), (Object)library)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = useLibrarySource = false;
                }
                if (useLibrarySource || !collectionRequest.getHasLibraryClassesRootKind()) break block4;
                for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library)) {
                    isNew = collectionRequest.getVisited().add(libraryInfo);
                    if (!isNew || !this.isApplicable(libraryInfo, sourceContext)) continue;
                    return libraryInfo;
                }
                break block5;
            }
            if (!useLibrarySource && !collectionRequest.getHasLibraryFilesRootKind()) break block5;
            for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library)) {
                sourceInfo = libraryInfo.getSourcesModuleInfo();
                isNew = collectionRequest.getVisited().add(sourceInfo);
                if (!isNew || !this.isApplicable(libraryInfo, sourceContext)) continue;
                return sourceInfo;
            }
        }
        return null;
    }

    private final IdeaModuleInfo collectBySdk(VirtualFileCollectionRequest collectionRequest, Sdk sdk) {
        SdkInfo moduleInfo = new SdkInfo(this.project, sdk);
        if (collectionRequest.getVisited().add(moduleInfo)) {
            return moduleInfo;
        }
        return null;
    }

    private final boolean isApplicable(LibraryInfo $this$isApplicable, ModuleSourceInfo contextualModuleInfo) {
        if (contextualModuleInfo == null) {
            return true;
        }
        ComponentManager $this$service$iv = (ComponentManager)$this$isApplicable.getProject();
        boolean $i$f$service = false;
        Class<LibraryUsageIndex> serviceClass$iv = LibraryUsageIndex.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LibraryUsageIndex service2 = (LibraryUsageIndex)object;
        return service2.hasDependentModule($this$isApplicable, contextualModuleInfo.getModule());
    }

    private final void collectByUserData(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByUserData, UserDataModuleContainer container) {
        ModuleInfoProviderKt.register($this$collectByUserData, (Function0<? extends IdeaModuleInfo>)((Function0)() -> ModuleInfoProvider.collectByUserData$lambda$11(container)));
        Library library = container.getCustomLibrary();
        if (library != null) {
            Library library2 = library;
            boolean bl = false;
            for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library2)) {
                ModuleInfoProviderKt.register($this$collectByUserData, libraryInfo);
            }
        }
        ModuleInfoProviderKt.register($this$collectByUserData, (Function0<? extends IdeaModuleInfo>)((Function0)() -> ModuleInfoProvider.collectByUserData$lambda$14(container, this)));
    }

    private static final ProjectFileIndex fileIndex_delegate$lambda$0(ModuleInfoProvider this$0) {
        return ProjectFileIndex.getInstance((Project)this$0.project);
    }

    private static final LibraryInfoCache libraryInfoCache_delegate$lambda$1(ModuleInfoProvider this$0) {
        return LibraryInfoCache.Companion.getInstance(this$0.project);
    }

    private static final Unit collect$lambda$2(ModuleInfoProvider this$0, PsiElement $element, Configuration $config, SeqScope $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        this$0.collectByElement($this$seq, $element, $config);
        return Unit.INSTANCE;
    }

    private static final Unit collect$lambda$3(ModuleInfoProvider this$0, VirtualFile $virtualFile, boolean $isLibrarySource, Configuration $config, SeqScope $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        this$0.collectByFile($this$seq, $virtualFile, $isLibrarySource, $config);
        return Unit.INSTANCE;
    }

    private static final Result collectByFile$lambda$9$lambda$8(ModuleInfoProvider this$0, VirtualFileCollectionRequest $collectionRequest) {
        Result result2;
        IdeaModuleInfo contextualModuleResult;
        IdeaModuleInfo ideaModuleInfo = contextualModuleResult = this$0.contextByContextualBinaryModule($collectionRequest);
        if (ideaModuleInfo != null) {
            IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
            IdeaModuleInfo p0 = ideaModuleInfo2;
            boolean bl = false;
            boolean $i$f$collectByFile$lambda$9$lambda$8$stub_for_inlining = false;
            result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
        } else {
            result2 = null;
        }
        return result2;
    }

    private static final IdeaModuleInfo collectByUserData$lambda$11(UserDataModuleContainer $container) {
        JpsModuleSourceRootType<?> sourceRootType = $container.getCustomSourceRootType();
        if (sourceRootType == null) {
            return null;
        }
        Object object = $container.getModule();
        if (object != null && (object = KotlinProjectStructureUtils.asSourceInfo(object, KotlinProjectStructureUtils.getSourceRootType(sourceRootType))) != null) {
            Object moduleInfo = object;
            boolean bl = false;
            return (IdeaModuleInfo)moduleInfo;
        }
        return null;
    }

    private static final IdeaModuleInfo collectByUserData$lambda$14(UserDataModuleContainer $container, ModuleInfoProvider this$0) {
        SdkInfo sdkInfo;
        Sdk sdk = $container.getCustomSdk();
        if (sdk != null) {
            Sdk it = sdk;
            boolean bl = false;
            sdkInfo = new SdkInfo(this$0.project, it);
        } else {
            sdkInfo = null;
        }
        return sdkInfo;
    }

    public static final /* synthetic */ ProjectFileIndex access$getFileIndex(ModuleInfoProvider $this) {
        return $this.getFileIndex();
    }

    public static final /* synthetic */ IdeaModuleInfo access$collectByOrderEntry(ModuleInfoProvider $this, VirtualFileCollectionRequest collectionRequest, OrderEntry orderEntry) {
        return $this.collectByOrderEntry(collectionRequest, orderEntry);
    }

    static {
        Logger logger = Logger.getInstance(ModuleInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$kotlin_base_project_structure", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider;", "project", "Lcom/intellij/openapi/project/Project;", "findAnchorElement", "Lcom/intellij/psi/PsiElement;", "element", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n31#2,2:522\n154#3:524\n1#4:525\n*S KotlinDebug\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion\n*L\n78#1:522,2\n87#1:524\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$kotlin_base_project_structure() {
            return LOG;
        }

        @NotNull
        public final ModuleInfoProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ModuleInfoProvider> serviceClass$iv = ModuleInfoProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleInfoProvider)object;
        }

        @Nullable
        public final PsiElement findAnchorElement(@NotNull PsiElement element) {
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof PsiDirectory) {
                psiElement = element;
            } else if (!(element instanceof KtLightElement)) {
                psiElement = (PsiElement)element.getContainingFile();
            } else {
                PsiElement $this$getNonStrictParentOfType$iv = element;
                boolean $i$f$getNonStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtLightClassForDecompiledDeclaration.class, (boolean)false) != null) {
                    psiElement = null;
                } else if (element instanceof KtLightClassForFacade) {
                    psiElement = (PsiElement)CollectionsKt.first((Iterable)((KtLightClassForFacade)element).getFiles());
                } else {
                    KtElement ktElement = ((KtLightElement)element).getKotlinOrigin();
                    if (ktElement != null) {
                        PsiElement p0 = (PsiElement)ktElement;
                        boolean $i$f$findAnchorElement$stub_for_inlining = false;
                        boolean bl = false;
                        psiElement = this.findAnchorElement(p0);
                    } else {
                        psiElement = null;
                    }
                }
            }
            return psiElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "", "createSourceLibraryInfoForLibraryBinaries", "", "preferModulesFromExtensions", "contextualModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "<init>", "(ZZLorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)V", "getCreateSourceLibraryInfoForLibraryBinaries", "()Z", "getPreferModulesFromExtensions", "getContextualModuleInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "kotlin.base.project-structure"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean createSourceLibraryInfoForLibraryBinaries;
        private final boolean preferModulesFromExtensions;
        @Nullable
        private final IdeaModuleInfo contextualModuleInfo;
        @NotNull
        private static final Configuration Default = new Configuration(false, false, null, 7, null);

        public Configuration(boolean createSourceLibraryInfoForLibraryBinaries, boolean preferModulesFromExtensions, @Nullable IdeaModuleInfo contextualModuleInfo) {
            this.createSourceLibraryInfoForLibraryBinaries = createSourceLibraryInfoForLibraryBinaries;
            this.preferModulesFromExtensions = preferModulesFromExtensions;
            this.contextualModuleInfo = contextualModuleInfo;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, IdeaModuleInfo ideaModuleInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                ideaModuleInfo = null;
            }
            this(bl, bl2, ideaModuleInfo);
        }

        public final boolean getCreateSourceLibraryInfoForLibraryBinaries() {
            return this.createSourceLibraryInfoForLibraryBinaries;
        }

        public final boolean getPreferModulesFromExtensions() {
            return this.preferModulesFromExtensions;
        }

        @Nullable
        public final IdeaModuleInfo getContextualModuleInfo() {
            return this.contextualModuleInfo;
        }

        public final boolean component1() {
            return this.createSourceLibraryInfoForLibraryBinaries;
        }

        public final boolean component2() {
            return this.preferModulesFromExtensions;
        }

        @Nullable
        public final IdeaModuleInfo component3() {
            return this.contextualModuleInfo;
        }

        @NotNull
        public final Configuration copy(boolean createSourceLibraryInfoForLibraryBinaries, boolean preferModulesFromExtensions, @Nullable IdeaModuleInfo contextualModuleInfo) {
            return new Configuration(createSourceLibraryInfoForLibraryBinaries, preferModulesFromExtensions, contextualModuleInfo);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration2, boolean bl, boolean bl2, IdeaModuleInfo ideaModuleInfo, int n, Object object) {
            if ((n & 1) != 0) {
                bl = configuration2.createSourceLibraryInfoForLibraryBinaries;
            }
            if ((n & 2) != 0) {
                bl2 = configuration2.preferModulesFromExtensions;
            }
            if ((n & 4) != 0) {
                ideaModuleInfo = configuration2.contextualModuleInfo;
            }
            return configuration2.copy(bl, bl2, ideaModuleInfo);
        }

        @NotNull
        public String toString() {
            return "Configuration(createSourceLibraryInfoForLibraryBinaries=" + this.createSourceLibraryInfoForLibraryBinaries + ", preferModulesFromExtensions=" + this.preferModulesFromExtensions + ", contextualModuleInfo=" + this.contextualModuleInfo + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.createSourceLibraryInfoForLibraryBinaries);
            result2 = result2 * 31 + Boolean.hashCode(this.preferModulesFromExtensions);
            result2 = result2 * 31 + (this.contextualModuleInfo == null ? 0 : this.contextualModuleInfo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration2 = (Configuration)other;
            if (this.createSourceLibraryInfoForLibraryBinaries != configuration2.createSourceLibraryInfoForLibraryBinaries) {
                return false;
            }
            if (this.preferModulesFromExtensions != configuration2.preferModulesFromExtensions) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contextualModuleInfo, (Object)configuration2.contextualModuleInfo);
        }

        public Configuration() {
            this(false, false, null, 7, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration$Companion;", "", "<init>", "()V", "Default", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "getDefault", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "kotlin.base.project-structure"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Configuration getDefault() {
                return Default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0012R\u001b\u0010\u001d\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$VirtualFileCollectionRequest;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLibrarySource", "", "config", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "visited", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lkotlin/collections/HashSet;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;Ljava/util/HashSet;Lcom/intellij/openapi/project/Project;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "getConfig", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "getVisited", "()Ljava/util/HashSet;", "getProject", "()Lcom/intellij/openapi/project/Project;", "hasLibraryClassesRootKind", "getHasLibraryClassesRootKind", "hasLibraryClassesRootKind$delegate", "Lkotlin/Lazy;", "hasLibraryFilesRootKind", "getHasLibraryFilesRootKind", "hasLibraryFilesRootKind$delegate", "kotlin.base.project-structure"})
    private static final class VirtualFileCollectionRequest {
        @NotNull
        private final VirtualFile virtualFile;
        private final boolean isLibrarySource;
        @NotNull
        private final Configuration config;
        @NotNull
        private final HashSet<IdeaModuleInfo> visited;
        @NotNull
        private final Project project;
        @NotNull
        private final Lazy hasLibraryClassesRootKind$delegate;
        @NotNull
        private final Lazy hasLibraryFilesRootKind$delegate;

        public VirtualFileCollectionRequest(@NotNull VirtualFile virtualFile, boolean isLibrarySource, @NotNull Configuration config2, @NotNull HashSet<IdeaModuleInfo> visited, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter(visited, (String)"visited");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.virtualFile = virtualFile;
            this.isLibrarySource = isLibrarySource;
            this.config = config2;
            this.visited = visited;
            this.project = project;
            this.hasLibraryClassesRootKind$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VirtualFileCollectionRequest.hasLibraryClassesRootKind_delegate$lambda$0(this));
            this.hasLibraryFilesRootKind$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VirtualFileCollectionRequest.hasLibraryFilesRootKind_delegate$lambda$1(this));
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        public final boolean isLibrarySource() {
            return this.isLibrarySource;
        }

        @NotNull
        public final Configuration getConfig() {
            return this.config;
        }

        @NotNull
        public final HashSet<IdeaModuleInfo> getVisited() {
            return this.visited;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final boolean getHasLibraryClassesRootKind() {
            Lazy lazy = this.hasLibraryClassesRootKind$delegate;
            return (Boolean)lazy.getValue();
        }

        public final boolean getHasLibraryFilesRootKind() {
            Lazy lazy = this.hasLibraryFilesRootKind$delegate;
            return (Boolean)lazy.getValue();
        }

        private static final boolean hasLibraryClassesRootKind_delegate$lambda$0(VirtualFileCollectionRequest this$0) {
            return SourceKindFilterUtils.matches(RootKindFilter.libraryClasses, this$0.project, this$0.virtualFile);
        }

        private static final boolean hasLibraryFilesRootKind_delegate$lambda$1(VirtualFileCollectionRequest this$0) {
            return SourceKindFilterUtils.matches(RootKindFilter.libraryFiles, this$0.project, this$0.virtualFile);
        }
    }
}

