/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirActualizingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirDefaultParametersResolver;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "declaresDefaultValue", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "index", "", "resolve"})
public final class FirDefaultParametersResolver
implements FirSessionComponent {
    public final boolean declaresDefaultValue(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull FirFunction function, @Nullable FirScope originScope, int index2) {
        FirTypeScope firTypeScope;
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (DeclarationUtilsKt.itOrExpectHasDefaultParameterValue(function, index2)) {
            return true;
        }
        if (!(function instanceof FirSimpleFunction)) {
            return false;
        }
        FirNamedFunctionSymbol symbol = ((FirSimpleFunction)function).getSymbol();
        FirScope firScope = originScope;
        if (firScope instanceof FirTypeScope) {
            firTypeScope = (FirTypeScope)originScope;
        } else if (firScope instanceof FirActualizingScope || firScope instanceof FirAbstractImportingScope) {
            FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(function);
            if (firRegularClass == null) {
                return false;
            }
            FirRegularClass containingClass = firRegularClass;
            firTypeScope = FirKotlinScopeProviderKt.scopeForClass(containingClass, ConeSubstitutor.Empty.INSTANCE, session, scopeSession, containingClass.getSymbol().toLookupTag(), null);
        } else {
            return false;
        }
        FirTypeScope typeScope = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(typeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirDefaultParametersResolver.declaresDefaultValue$lambda$0(index2, result2, arg_0)));
        return result2.element;
    }

    private static final ProcessorAction declaresDefaultValue$lambda$0(int $index, Ref.BooleanRef $result, FirNamedFunctionSymbol overridden) {
        Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
        if (DeclarationUtilsKt.itOrExpectHasDefaultParameterValue((FirFunction)overridden.getFir(), $index)) {
            $result.element = true;
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }
}

