/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.backend.common.IrSpecialAnnotationsProvider;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltinSymbolsContainer;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrImplicitCastInserter;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrDataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.utils.ConversionTypeOrigin;
import org.jetbrains.kotlin.fir.backend.utils.OffsetUtilsKt;
import org.jetbrains.kotlin.fir.backend.utils.VariousUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSamConversionExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.stages.FirFakeArgumentForCallableReference;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J/\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\nH\u0002JD\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u00020/*\u0002002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002JD\u00101\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J#\u00103\u001a\u00020\u0016*\u00020\u00162\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0000\u00a2\u0006\u0002\b8J \u00109\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010;*\u00020;H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010>*\u00020>H\u0002J\u001a\u0010?\u001a\u00020;*\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BH\u0002J3\u0010D\u001a\u00020\u0016*\u00020E2\u0006\u00104\u001a\u0002052\u001d\u0010F\u001a\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00160G\u00a2\u0006\u0002\bHH\u0002J\u0017\u0010I\u001a\u0004\u0018\u00010;2\u0006\u0010J\u001a\u00020;H\u0000\u00a2\u0006\u0002\bKJ!\u0010L\u001a\u00020\u0016*\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u0010J\u001a\u00020;H\u0000\u00a2\u0006\u0002\bMJ\u001a\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020Q2\u0006\u00104\u001a\u000205H\u0002J0\u0010R\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010S\u001a\u00020+2\u0006\u0010T\u001a\u00020OH\u0002J(\u0010U\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010T\u001a\u00020OH\u0002J\"\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\f2\n\u0010X\u001a\u0006\u0012\u0002\b\u00030Y2\u0006\u0010Z\u001a\u00020+J\u0014\u0010[\u001a\u00020+*\u00020\u000e2\u0006\u0010\\\u001a\u00020 H\u0002J,\u0010]\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\n\u0010X\u001a\u0006\u0012\u0002\b\u00030Y2\u0006\u0010Z\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010^\u001a\u00020_X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR\u0012\u0010b\u001a\u00020cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u0012\u0010f\u001a\u00020gX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bh\u0010iR\u0012\u0010j\u001a\u00020kX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0012\u0010n\u001a\u00020oX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u0012\u0010r\u001a\u00020sX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bt\u0010uR\u0012\u0010v\u001a\u00020wX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bx\u0010yR\u0012\u0010z\u001a\u00020{X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b|\u0010}R\u0014\u0010~\u001a\u00020\u007fX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0016\u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0016\u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R\u0016\u0010\u008a\u0001\u001a\u00030\u008b\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001R\u001e\u0010\u008e\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u008f\u0001\u0018\u00010BX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001R\u0016\u0010\u0092\u0001\u001a\u00030\u0093\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0016\u0010\u0096\u0001\u001a\u00030\u0097\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u0099\u0001R\u001d\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009c\u00010\u009b\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001R\u0016\u0010\u009f\u0001\u001a\u00030\u00a0\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a1\u0001\u0010\u00a2\u0001R\u0016\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a5\u0001\u0010\u00a6\u0001R\u0016\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a9\u0001\u0010\u00aa\u0001R\u0016\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00ad\u0001\u0010\u00ae\u0001R\u0016\u0010\u00af\u0001\u001a\u00030\u00b0\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b1\u0001\u0010\u00b2\u0001R\u0018\u0010\u00b3\u0001\u001a\u0005\u0018\u00010\u00b4\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b5\u0001\u0010\u00b6\u0001R\u0016\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b9\u0001\u0010\u00ba\u0001R\u0016\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00bd\u0001\u0010\u00be\u0001R\u0016\u0010\u00bf\u0001\u001a\u00030\u00c0\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c1\u0001\u0010\u00c2\u0001\u00a8\u0006\u00c3\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "c", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "samResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "needToGenerateAdaptedCallableReference", "", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "type", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "needToGenerateAdaptedCallableReference$fir2ir", "needSuspendConversion", "needCoercionToUnit", "hasVarargOrDefaultArguments", "generateAdaptedCallableReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "explicitReceiverExpression", "adapteeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "generateAdaptedCallableReference$fir2ir", "findBoundReceiver", "isDispatch", "createAdapterFunctionForCallableReference", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "startOffset", "", "endOffset", "firAdaptee", "boundDispatchReceiver", "boundExtensionReceiver", "createAdapterParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "adapterFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "toIrGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createAdapteeCallForCallableReference", "adaptedType", "applySamConversionIfNeeded", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "applySamConversionIfNeeded$fir2ir", "castArgumentToFunctionalInterfaceForSamType", "argumentConeType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "samType", "removeExternalProjections", "Lorg/jetbrains/kotlin/fir/types/ConeRigidType;", "starProjectionTypeRepresentation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "containingParameterSet", "", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "applyConversionOnVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "conversion", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "getFunctionTypeForPossibleSamType", "parameterType", "getFunctionTypeForPossibleSamType$fir2ir", "applySuspendConversionIfNeeded", "applySuspendConversionIfNeeded$fir2ir", "findInvokeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "expectedFunctionalType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createAdapterFunctionForArgument", "argumentType", "invokeSymbol", "createAdapteeCallForArgument", "generateFunInterfaceConstructorReference", "callableReference", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "irReferenceType", "getArgumentTypeAt", "index", "generateFunInterfaceConstructorAdapter", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtins", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "getBuiltins", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "dataClassMembersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "getDataClassMembersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "filesBeingCompiled", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesBeingCompiled", "()Ljava/util/Set;", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "getFirProvider", "()Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "getIrMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lazyFakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "getLazyFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "specialAnnotationsProvider", "Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "getSpecialAnnotationsProvider", "()Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "getSymbolsMappingForLazyClasses", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nAdapterGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdapterGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 OffsetUtils.kt\norg/jetbrains/kotlin/fir/backend/utils/OffsetUtilsKt\n+ 7 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,798:1\n43#2:799\n40#2:807\n43#2:808\n38#2:809\n39#2:810\n36#2:848\n188#3,3:800\n1557#4:803\n1628#4,3:804\n1567#4:811\n1598#4,4:812\n1557#4:834\n1628#4,3:835\n1567#4:838\n1598#4,4:839\n1557#4:843\n1628#4,3:844\n1872#4,3:849\n1#5:816\n39#6:817\n68#6,16:818\n49#7:847\n*S KotlinDebug\n*F\n+ 1 AdapterGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator\n*L\n86#1:799\n202#1:807\n208#1:808\n209#1:809\n210#1:810\n304#1:848\n116#1:800,3\n190#1:803\n190#1:804,3\n229#1:811\n229#1:812,4\n627#1:834\n627#1:835,3\n651#1:838\n651#1:839,4\n149#1:843\n149#1:844,3\n327#1:849,3\n588#1:817\n588#1:818,16\n303#1:847\n*E\n"})
public final class AdapterGenerator
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents c;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final FirSamResolver samResolver;

    public AdapterGenerator(@NotNull Fir2IrComponents c, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.c = c;
        this.conversionScope = conversionScope;
        this.samResolver = new FirSamResolver(this.getSession(), this.getScopeSession(), null, 4, null);
    }

    public final boolean needToGenerateAdaptedCallableReference$fir2ir(@NotNull FirCallableReferenceAccess callableReferenceAccess, @NotNull IrSimpleType type2, @NotNull FirFunction function) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return this.needSuspendConversion(type2, function) || this.needCoercionToUnit(type2, function) || this.hasVarargOrDefaultArguments(callableReferenceAccess);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needSuspendConversion(IrSimpleType type2, FirFunction function) {
        if (!IrTypeUtilsKt.isSuspendFunction((IrType)((IrType)type2))) return false;
        FirMemberDeclaration $this$isSuspend$iv = function;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) return false;
        return true;
    }

    private final boolean needCoercionToUnit(IrSimpleType type2, FirFunction function) {
        IrType expectedReturnType = IrTypesKt.getTypeOrNull((IrTypeArgument)((IrTypeArgument)CollectionsKt.last((List)type2.getArguments())));
        ConeKotlinType actualReturnType = FirTypeUtilsKt.getConeType(function.getReturnTypeRef());
        IrType irType = expectedReturnType;
        return (irType != null ? IrTypePredicatesKt.isUnit((IrType)irType) : false) && !ConeBuiltinTypeUtilsKt.isUnit(actualReturnType) && !(ToSymbolUtilsKt.toSymbol(actualReturnType, this.c.getSession()) instanceof FirTypeParameterSymbol);
    }

    private final boolean hasVarargOrDefaultArguments(FirCallableReferenceAccess callableReferenceAccess) {
        boolean bl;
        block4: {
            FirNamedReference firNamedReference = callableReferenceAccess.getCalleeReference();
            FirResolvedCallableReference firResolvedCallableReference = firNamedReference instanceof FirResolvedCallableReference ? (FirResolvedCallableReference)firNamedReference : null;
            if (firResolvedCallableReference == null) {
                return false;
            }
            FirResolvedCallableReference calleeReference = firResolvedCallableReference;
            Map<FirValueParameter, ResolvedCallArgument<FirExpression>> $this$any$iv = calleeReference.getMappedArguments();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<FirValueParameter, ResolvedCallArgument<FirExpression>>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<FirValueParameter, ResolvedCallArgument<FirExpression>> element$iv;
                    Map.Entry<FirValueParameter, ResolvedCallArgument<FirExpression>> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    ResolvedCallArgument<FirExpression> value = entry.getValue();
                    if (!(value instanceof ResolvedCallArgument.VarargArgument || value instanceof ResolvedCallArgument.DefaultArgument)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final IrExpression generateAdaptedCallableReference$fir2ir(@NotNull FirCallableReferenceAccess callableReferenceAccess, @Nullable IrExpression explicitReceiverExpression, @NotNull IrFunctionSymbol adapteeSymbol, @NotNull IrSimpleType type2) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
        Intrinsics.checkNotNullParameter((Object)adapteeSymbol, (String)"adapteeSymbol");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Object object = ReferenceUtilsKt.toResolvedCallableReference(callableReferenceAccess);
        Object var6_5 = object != null && (object = ((FirResolvedNamedReference)object).getResolvedSymbol()) != null ? ((FirBasedSymbol)object).getFir() : null;
        FirFunction firAdaptee = var6_5 instanceof FirFunction ? (FirFunction)var6_5 : null;
        IrType expectedReturnType = IrTypesKt.getTypeOrNull((IrTypeArgument)((IrTypeArgument)CollectionsKt.last((List)type2.getArguments())));
        return (IrExpression)OffsetUtilsKt.convertWithOffsets(callableReferenceAccess, (arg_0, arg_1) -> AdapterGenerator.generateAdaptedCallableReference$lambda$6(this, callableReferenceAccess, explicitReceiverExpression, firAdaptee, type2, adapteeSymbol, expectedReturnType, arg_0, arg_1));
    }

    private final IrExpression findBoundReceiver(FirCallableReferenceAccess $this$findBoundReceiver, IrExpression explicitReceiverExpression, boolean isDispatch) {
        FirExpression firReceiver;
        FirExpression firExpression = firReceiver = isDispatch ? $this$findBoundReceiver.getDispatchReceiver() : $this$findBoundReceiver.getExtensionReceiver();
        if (firReceiver == null) {
            return null;
        }
        CallAndReferenceGenerator $this$findBoundReceiver_u24lambda_u247 = this.getCallGenerator();
        boolean bl = false;
        return $this$findBoundReceiver_u24lambda_u247.findIrReceiver$fir2ir($this$findBoundReceiver, explicitReceiverExpression, isDispatch);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createAdapterFunctionForCallableReference(FirCallableReferenceAccess callableReferenceAccess, int startOffset, int endOffset, FirFunction firAdaptee, IrSimpleType type2, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        Collection<IrValueParameter> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Object object;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)((IrTypeArgument)CollectionsKt.last((List)type2.getArguments())));
        Intrinsics.checkNotNull((Object)irType);
        IrType returnType = irType;
        Iterable $this$map$iv = CollectionsKt.dropLast((List)type2.getArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            object = (IrTypeArgument)item$iv$iv2;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
            Intrinsics.checkNotNull((Object)irType2);
            collection2.add(irType2);
        }
        List parameterTypes = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)firAdaptee, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration firMemberAdaptee = firAdaptee;
        Name name2 = firAdaptee instanceof FirConstructor ? SpecialNames.INIT : firAdaptee.getSymbol().getName();
        IrFactory irFactory = (IrFactory)IrFactoryImpl.INSTANCE;
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE();
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        FirMemberDeclaration $this$isInline$iv = firMemberAdaptee;
        boolean $i$f$isInline = false;
        FirMemberDeclaration $this$isSuspend$iv = firMemberAdaptee;
        boolean $i$f$isSuspend = false;
        FirMemberDeclaration $this$isOperator$iv = firMemberAdaptee;
        boolean $i$f$isOperator = false;
        FirMemberDeclaration $this$isInfix$iv = firMemberAdaptee;
        boolean $i$f$isInfix = false;
        Iterable irAdapterFunction = iterable = IrFactory.createSimpleFunction$default((IrFactory)irFactory, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)irDeclarationOrigin, (Name)name2, (DescriptorVisibility)descriptorVisibility, (boolean)$this$isInline$iv.getStatus().isInline(), (boolean)false, (IrType)returnType, (Modality)Modality.FINAL, (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)new IrSimpleFunctionSymbolImpl(null, null, 3, null)), (boolean)false, ($this$isSuspend$iv.getStatus().isSuspend() || IrTypeUtilsKt.isSuspendFunction((IrType)((IrType)type2)) ? 1 : 0) != 0, (boolean)$this$isOperator$iv.getStatus().isOperator(), (boolean)$this$isInfix$iv.getStatus().isInfix(), (boolean)false, null, (boolean)false, (int)98304, null);
        boolean bl = false;
        irAdapterFunction.setDispatchReceiverParameter(null);
        IrExpression irExpression = boundDispatchReceiver;
        if (irExpression == null) {
            irExpression = boundExtensionReceiver;
        }
        IrExpression boundReceiver = irExpression;
        if (boundReceiver == null) {
            irAdapterFunction.setExtensionReceiverParameter(null);
        } else {
            if (boundDispatchReceiver != null && boundExtensionReceiver != null) {
                throw new IllegalStateException(("Bound callable references can't have both receivers: " + UtilsKt.render(callableReferenceAccess)).toString());
            }
            IrFunction irFunction = (IrFunction)irAdapterFunction;
            Name name3 = Name.identifier((String)"receiver");
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            irAdapterFunction.setExtensionReceiverParameter(this.createAdapterParameter(irFunction, name3, boundReceiver.getType(), (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE()));
        }
        item$iv$iv2 = parameterTypes;
        object = irAdapterFunction.getValueParameters();
        Iterable iterable2 = irAdapterFunction;
        boolean $i$f$mapIndexed = false;
        void var20_25 = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv3 : $this$mapIndexedTo$iv$iv) {
            void parameterType;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrType irType3 = (IrType)item$iv$iv3;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            IrFunction irFunction = (IrFunction)irAdapterFunction;
            Name name4 = Name.identifier((String)("" + 'p' + (int)index2));
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            collection.add(this.createAdapterParameter(irFunction, name4, (IrType)parameterType, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE()));
        }
        collection = (List)destination$iv$iv2;
        iterable2.setValueParameters(CollectionsKt.plus((Collection)object, (Iterable)collection));
        IrDeclarationParent irDeclarationParent = this.conversionScope.parent();
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        irAdapterFunction.setParent(irDeclarationParent);
        return iterable;
    }

    private final IrValueParameter createAdapterParameter(IrFunction adapterFunction, Name name2, IrType type2, IrDeclarationOrigin origin) {
        IrValueParameter irValueParameter;
        IrValueParameter irAdapterValueParameter = irValueParameter = IrFactoryImpl.INSTANCE.createValueParameter(adapterFunction.getStartOffset(), adapterFunction.getEndOffset(), origin, name2, type2, false, (IrValueParameterSymbol)new IrValueParameterSymbolImpl(null, null, 3, null), null, false, false, false);
        boolean bl = false;
        irAdapterValueParameter.setParent((IrDeclarationParent)adapterFunction);
        return irValueParameter;
    }

    private final IrGetValue toIrGetValue(IrValueDeclaration $this$toIrGetValue, int startOffset, int endOffset) {
        return (IrGetValue)BuildersKt.IrGetValueImpl$default((int)startOffset, (int)endOffset, (IrType)$this$toIrGetValue.getType(), (IrValueSymbol)$this$toIrGetValue.getSymbol(), null, (int)16, null);
    }

    private final IrExpression createAdapteeCallForCallableReference(FirCallableReferenceAccess callableReferenceAccess, FirFunction firAdaptee, IrFunctionSymbol adapteeSymbol, IrFunction adapterFunction, IrSimpleType adaptedType, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        return (IrExpression)OffsetUtilsKt.convertWithOffsets(callableReferenceAccess, (arg_0, arg_1) -> AdapterGenerator.createAdapteeCallForCallableReference$lambda$14(callableReferenceAccess, this, firAdaptee, adapteeSymbol, boundDispatchReceiver, boundExtensionReceiver, adapterFunction, adaptedType, arg_0, arg_1));
    }

    @NotNull
    public final IrExpression applySamConversionIfNeeded$fir2ir(@NotNull IrExpression $this$applySamConversionIfNeeded, @NotNull FirExpression argument2, @Nullable FirValueParameter parameter) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$applySamConversionIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (parameter == null) {
            return $this$applySamConversionIfNeeded;
        }
        if ($this$applySamConversionIfNeeded instanceof IrVararg) {
            return this.applyConversionOnVararg((IrVararg)$this$applySamConversionIfNeeded, argument2, (Function2<? super IrExpression, ? super FirExpression, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> AdapterGenerator.applySamConversionIfNeeded$lambda$15(this, parameter, arg_0, arg_1)));
        }
        if (!(argument2 instanceof FirSamConversionExpression)) {
            return $this$applySamConversionIfNeeded;
        }
        ConeKotlinType it = FirTypeUtilsKt.getResolvedType(argument2);
        boolean bl = false;
        ConeKotlinType coneKotlinType = this.removeExternalProjections(it);
        if (coneKotlinType == null) {
            coneKotlinType = it;
        }
        ConeKotlinType samFirType = coneKotlinType;
        IrType samType = Fir2IrTypeConverterKt.toIrType(samFirType, this.c, ConversionTypeOrigin.DEFAULT);
        if ($this$applySamConversionIfNeeded instanceof IrBlock && (Intrinsics.areEqual((Object)((IrBlock)$this$applySamConversionIfNeeded).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()) || Intrinsics.areEqual((Object)((IrBlock)$this$applySamConversionIfNeeded).getOrigin(), (Object)IrStatementOrigin.Companion.getSUSPEND_CONVERSION()))) {
            int lastIndex = CollectionsKt.getLastIndex((List)((IrBlock)$this$applySamConversionIfNeeded).getStatements());
            Object e = ((IrBlock)$this$applySamConversionIfNeeded).getStatements().get(lastIndex);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            IrTypeOperatorCallImpl samConversion = AdapterGenerator.applySamConversionIfNeeded$generateSamConversion((IrExpression)e, this, samType, (FirSamConversionExpression)argument2, samFirType);
            ((IrBlock)$this$applySamConversionIfNeeded).getStatements().set(lastIndex, samConversion);
            $this$applySamConversionIfNeeded.setType(samConversion.getType());
            irExpression = $this$applySamConversionIfNeeded;
        } else {
            irExpression = (IrExpression)AdapterGenerator.applySamConversionIfNeeded$generateSamConversion($this$applySamConversionIfNeeded, this, samType, (FirSamConversionExpression)argument2, samFirType);
        }
        return irExpression;
    }

    private final IrExpression castArgumentToFunctionalInterfaceForSamType(IrExpression argument2, ConeKotlinType argumentConeType, ConeKotlinType samType) {
        ConeKotlinType coneKotlinType = this.getFunctionTypeForPossibleSamType$fir2ir(samType);
        if (coneKotlinType == null || (coneKotlinType = Fir2IrTypeConverterKt.approximateForIrOrSelf(coneKotlinType, this.c)) == null) {
            return argument2;
        }
        ConeKotlinType approximatedConeKotlinFunctionType = coneKotlinType;
        ConeKotlinType approximateArgumentConeType = Fir2IrTypeConverterKt.approximateForIrOrSelf(argumentConeType, this.c);
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind$default(approximatedConeKotlinFunctionType, this.getSession(), false, 2, null);
        boolean bl = functionTypeKind != null ? FunctionTypeKindKt.isSuspendOrKSuspendFunction((FunctionTypeKind)functionTypeKind) : false;
        if (bl) {
            FunctionTypeKind functionTypeKind2 = FunctionalTypeUtilsKt.functionTypeKind$default(approximateArgumentConeType, this.getSession(), false, 2, null);
            if (!(functionTypeKind2 != null ? FunctionTypeKindKt.isSuspendOrKSuspendFunction((FunctionTypeKind)functionTypeKind2) : false)) {
                approximatedConeKotlinFunctionType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(approximatedConeKotlinFunctionType, this.getSession());
            }
        }
        if (TypeUtilsKt.isSubtypeOf$default(approximateArgumentConeType, approximatedConeKotlinFunctionType, this.getSession(), false, 4, null)) {
            return argument2;
        }
        IrType irFunctionType = Fir2IrTypeConverterKt.toIrType$default(approximatedConeKotlinFunctionType, this.c, null, 2, null);
        return IrExpressionsKt.implicitCastTo((IrExpression)argument2, (IrType)irFunctionType);
    }

    private final ConeKotlinType removeExternalProjections(ConeKotlinType $this$removeExternalProjections) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$removeExternalProjections;
        if (coneKotlinType2 instanceof ConeRigidType) {
            coneKotlinType = this.removeExternalProjections((ConeRigidType)$this$removeExternalProjections);
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeRigidType coneRigidType;
            ConeRigidType coneRigidType2 = this.removeExternalProjections(((ConeFlexibleType)$this$removeExternalProjections).getLowerBound());
            if (coneRigidType2 == null) {
                coneRigidType2 = ((ConeFlexibleType)$this$removeExternalProjections).getLowerBound();
            }
            if ((coneRigidType = this.removeExternalProjections(((ConeFlexibleType)$this$removeExternalProjections).getUpperBound())) == null) {
                coneRigidType = ((ConeFlexibleType)$this$removeExternalProjections).getUpperBound();
            }
            coneKotlinType = new ConeFlexibleType(coneRigidType2, coneRigidType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    private final ConeRigidType removeExternalProjections(ConeRigidType $this$removeExternalProjections) {
        if (!($this$removeExternalProjections instanceof ConeClassLikeType)) {
            return $this$removeExternalProjections;
        }
        ConeInferenceContext $this$removeExternalProjections_u24lambda_u2418 = TypeComponentsKt.getTypeContext(this.getSession());
        boolean bl = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$removeExternalProjections.getTypeArguments();
        if (coneTypeProjectionArray.length == 0) {
            boolean bl2 = false;
            return $this$removeExternalProjections;
        }
        ConeTypeProjection[] arguments2 = coneTypeProjectionArray;
        List parameters2 = $this$removeExternalProjections_u24lambda_u2418.getParameters(((ConeClassLikeType)$this$removeExternalProjections).getLookupTag());
        Set parameterSet = CollectionsKt.toSet((Iterable)parameters2);
        int n = arguments2.length;
        ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[n];
        for (int j = 0; j < n; ++j) {
            ConeKotlinType coneKotlinType;
            ConeTypeParameterLookupTag parameter;
            int n2 = j;
            ConeTypeProjection argument2 = arguments2[n2];
            if ((ConeTypeParameterLookupTag)CollectionsKt.getOrNull((List)parameters2, (int)n2) == null) {
                return null;
            }
            if (argument2.getKind() == ProjectionKind.IN && this.c.getConfiguration().getCarefulApproximationOfContravariantProjectionForSam()) {
                ConeKotlinType upperBound;
                KotlinTypeMarker kotlinTypeMarker = (KotlinTypeMarker)CollectionsKt.singleOrNull((List)$this$removeExternalProjections_u24lambda_u2418.getUpperBounds(parameter));
                if ((ConeKotlinType)(kotlinTypeMarker != null ? $this$removeExternalProjections_u24lambda_u2418.upperBoundIfFlexible(kotlinTypeMarker) : null) == null) {
                    return null;
                }
                if (!ConeBuiltinTypeUtilsKt.isNullableAny(upperBound)) {
                    return null;
                }
                coneKotlinType = upperBound;
            } else {
                coneKotlinType = argument2 instanceof ConeKotlinTypeProjection ? ((ConeKotlinTypeProjection)argument2).getType() : this.starProjectionTypeRepresentation(parameter.getTypeParameterSymbol(), parameterSet);
            }
            coneKotlinTypeArray[n2] = coneKotlinType;
        }
        ConeKotlinType[] newArguments = coneKotlinTypeArray;
        return ConeTypeUtilsKt.withArguments((ConeClassLikeType)$this$removeExternalProjections, newArguments);
    }

    private final ConeKotlinType starProjectionTypeRepresentation(FirTypeParameterSymbol $this$starProjectionTypeRepresentation, Set<ConeTypeParameterLookupTag> containingParameterSet) {
        ConeInferenceContext coneInferenceContext = TypeComponentsKt.getTypeContext(this.getSession());
        AbstractConeSubstitutor substitutor2 = new AbstractConeSubstitutor(containingParameterSet, coneInferenceContext){
            final /* synthetic */ Set<ConeTypeParameterLookupTag> $containingParameterSet;
            {
                this.$containingParameterSet = $containingParameterSet;
                super($super_call_param$1);
            }

            public ConeKotlinType substituteType(ConeKotlinType type2) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                return null;
            }

            public ConeTypeProjection substituteArgument(ConeTypeProjection projection, int index2) {
                Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
                if (projection instanceof ConeTypeParameterType && this.$containingParameterSet.contains(((ConeTypeParameterType)projection).getLookupTag())) {
                    return ConeStarProjection.INSTANCE;
                }
                return super.substituteArgument(projection, index2);
            }
        };
        return substitutor2.substituteOrSelf(((FirResolvedTypeRef)CollectionsKt.first($this$starProjectionTypeRepresentation.getResolvedBounds())).getConeType());
    }

    private final IrExpression applyConversionOnVararg(IrVararg $this$applyConversionOnVararg, FirExpression argument2, Function2<? super IrExpression, ? super FirExpression, ? extends IrExpression> conversion) {
        if (!(argument2 instanceof FirVarargArgumentsExpression) || ((FirVarargArgumentsExpression)argument2).getArguments().size() != $this$applyConversionOnVararg.getElements().size()) {
            return (IrExpression)$this$applyConversionOnVararg;
        }
        Map argumentMapping2 = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)$this$applyConversionOnVararg.getElements(), (Iterable)((FirVarargArgumentsExpression)argument2).getArguments()));
        $this$applyConversionOnVararg.getElements().replaceAll(arg_0 -> AdapterGenerator.applyConversionOnVararg$lambda$19(argumentMapping2, conversion, arg_0));
        return (IrExpression)$this$applyConversionOnVararg;
    }

    @Nullable
    public final ConeKotlinType getFunctionTypeForPossibleSamType$fir2ir(@NotNull ConeKotlinType parameterType) {
        Intrinsics.checkNotNullParameter((Object)parameterType, (String)"parameterType");
        FirSamResolver.SamConversionInfo samConversionInfo = this.samResolver.getSamInfoForPossibleSamType(parameterType);
        return samConversionInfo != null ? samConversionInfo.getFunctionalType() : null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final IrExpression applySuspendConversionIfNeeded$fir2ir(@NotNull IrExpression $this$applySuspendConversionIfNeeded, @NotNull FirExpression argument, @NotNull ConeKotlinType parameterType) {
        Intrinsics.checkNotNullParameter((Object)$this$applySuspendConversionIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameterType, (String)"parameterType");
        if ($this$applySuspendConversionIfNeeded instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)$this$applySuspendConversionIfNeeded).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE())) {
            return $this$applySuspendConversionIfNeeded;
        }
        if (!FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(parameterType, this.getSession())) {
            return $this$applySuspendConversionIfNeeded;
        }
        expectedFunctionalType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(parameterType, this.getSession());
        if ($this$applySuspendConversionIfNeeded instanceof IrVararg) {
            return this.applyConversionOnVararg((IrVararg)$this$applySuspendConversionIfNeeded, argument, (Function2<? super IrExpression, ? super FirExpression, ? extends IrExpression>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, applySuspendConversionIfNeeded$lambda$20(org.jetbrains.kotlin.fir.backend.generators.AdapterGenerator org.jetbrains.kotlin.fir.types.ConeKotlinType org.jetbrains.kotlin.ir.expressions.IrExpression org.jetbrains.kotlin.fir.expressions.FirExpression ), (Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)((AdapterGenerator)this, (ConeKotlinType)parameterType));
        }
        v0 = this.findInvokeSymbol(expectedFunctionalType, argument);
        if (v0 == null) {
            return $this$applySuspendConversionIfNeeded;
        }
        invokeSymbol = v0;
        v1 = Fir2IrTypeConverterKt.toIrType$default(parameterType, this.c, null, 2, null);
        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        suspendConvertedType = (IrSimpleType)v1;
        $this$convertWithOffsets$iv = argument;
        $i$f$convertWithOffsets = false;
        $this$convertWithOffsets$iv$iv = $this$convertWithOffsets$iv.getSource();
        $i$f$convertWithOffsets = false;
        startOffset$iv$iv = 0;
        endOffset$iv$iv = 0;
        if (OffsetUtilsKt.access$isCompiledElement(KtSourceElementKt.getPsi((AbstractKtSourceElement)((AbstractKtSourceElement)$this$convertWithOffsets$iv$iv)))) ** GOTO lbl-1000
        v2 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v2 != null ? v2.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) ** GOTO lbl-1000
        v3 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v3 != null ? v3.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitThisReceiverExpression.INSTANCE)) lbl-1000:
        // 3 sources

        {
            startOffset$iv$iv = -1;
            endOffset$iv$iv = -1;
        } else {
            v4 = $this$convertWithOffsets$iv$iv;
            if (v4 != null && (v4 = OffsetUtilsKt.startOffsetSkippingComments((AbstractKtSourceElement)v4)) != null) {
                v5 = v4.intValue();
            } else {
                v6 = $this$convertWithOffsets$iv$iv;
                v5 = v6 != null ? v6.getStartOffset() : -1;
            }
            startOffset$iv$iv = v5;
            v7 = $this$convertWithOffsets$iv$iv;
            endOffset$iv$iv = v7 != null ? v7.getEndOffset() : -1;
        }
        var13_13 = endOffset$iv$iv;
        startOffset = startOffset$iv$iv;
        $i$a$-convertWithOffsets-AdapterGenerator$applySuspendConversionIfNeeded$2 = false;
        irAdapterFunction = this.createAdapterFunctionForArgument(startOffset, (int)endOffset, suspendConvertedType, $this$applySuspendConversionIfNeeded.getType(), invokeSymbol);
        irAdapterRef = BuildersKt.IrFunctionReferenceImpl((int)startOffset, (int)endOffset, (IrType)((IrType)suspendConvertedType), (IrFunctionSymbol)((IrFunctionSymbol)irAdapterFunction.getSymbol()), (int)irAdapterFunction.getTypeParameters().size(), null, (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getSUSPEND_CONVERSION()));
        $this$applySuspendConversionIfNeeded_u24lambda_u2423_u24lambda_u2422 = var18_18 = BuildersKt.IrBlockImpl((int)startOffset, (int)endOffset, (IrType)((IrType)suspendConvertedType), (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getSUSPEND_CONVERSION()));
        $i$a$-apply-AdapterGenerator$applySuspendConversionIfNeeded$2$1 = false;
        $this$applySuspendConversionIfNeeded_u24lambda_u2423_u24lambda_u2422.getStatements().add(irAdapterFunction);
        var22_22 = var21_21 = irAdapterRef;
        var23_23 = $this$applySuspendConversionIfNeeded_u24lambda_u2423_u24lambda_u2422.getStatements();
        $i$a$-apply-AdapterGenerator$applySuspendConversionIfNeeded$2$1$1 = false;
        $this$applySuspendConversionIfNeeded_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.setExtensionReceiver($this$applySuspendConversionIfNeeded);
        var23_23.add(var21_21);
        return (IrExpression)((IrElement)var18_18);
    }

    private final IrSimpleFunctionSymbol findInvokeSymbol(ConeClassLikeType expectedFunctionalType, FirExpression argument2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        FirFunctionSymbol firFunctionSymbol;
        FirFunctionSymbol firFunctionSymbol2;
        FirExpression firExpression = argument2 instanceof FirSamConversionExpression ? (FirSamConversionExpression)argument2 : null;
        if (firExpression == null || (firExpression = firExpression.getExpression()) == null) {
            firExpression = argument2;
        }
        ConeKotlinType argumentType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(firExpression), this.getSession(), null, 2, null);
        ConeKotlinType coneKotlinType = FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionType(argumentType, this.getSession(), expectedFunctionalType);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType argumentTypeWithInvoke = coneKotlinType;
        if (FunctionalTypeUtilsKt.isSomeFunctionType(argumentTypeWithInvoke, this.getSession())) {
            ConeClassLikeType coneClassLikeType = argumentTypeWithInvoke instanceof ConeClassLikeType ? (ConeClassLikeType)argumentTypeWithInvoke : null;
            firFunctionSymbol2 = coneClassLikeType != null ? FunctionalTypeUtilsKt.findBaseInvokeSymbol(coneClassLikeType, this.getSession(), this.getScopeSession()) : null;
        } else {
            firFunctionSymbol2 = firFunctionSymbol = FunctionalTypeUtilsKt.findContributedInvokeSymbol(argumentTypeWithInvoke, this.getSession(), this.getScopeSession(), expectedFunctionalType, true);
        }
        if (firFunctionSymbol != null) {
            FirFunctionSymbol it = firFunctionSymbol;
            boolean bl = false;
            IrFunctionSymbol irFunctionSymbol = Fir2IrDeclarationStorage.getIrFunctionSymbol$default(this.getDeclarationStorage(), it, null, false, 6, null);
            irSimpleFunctionSymbol = irFunctionSymbol instanceof IrSimpleFunctionSymbol ? (IrSimpleFunctionSymbol)irFunctionSymbol : null;
        } else {
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createAdapterFunctionForArgument(int startOffset, int endOffset, IrSimpleType type2, IrType argumentType, IrSimpleFunctionSymbol invokeSymbol) {
        Collection<IrValueParameter> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        IrSimpleFunction irSimpleFunction;
        void it;
        void $this$mapTo$iv$iv;
        IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)((IrTypeArgument)CollectionsKt.last((List)type2.getArguments())));
        Intrinsics.checkNotNull((Object)irType);
        IrType returnType = irType;
        Iterable $this$map$iv = CollectionsKt.dropLast((List)type2.getArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
            Intrinsics.checkNotNull((Object)irType2);
            collection2.add(irType2);
        }
        List parameterTypes = (List)destination$iv$iv;
        IrFactory irFactory = (IrFactory)IrFactoryImpl.INSTANCE;
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_FOR_SUSPEND_CONVERSION();
        Name name2 = Name.identifier((String)Scope.inventNameForTemporary$default((Scope)this.conversionScope.scope(), (String)"suspendConversion", null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        IrSimpleFunction irAdapterFunction = irSimpleFunction = IrFactory.createSimpleFunction$default((IrFactory)irFactory, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)irDeclarationOrigin, (Name)name2, (DescriptorVisibility)descriptorVisibility, (boolean)false, (boolean)false, (IrType)returnType, (Modality)Modality.FINAL, (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)new IrSimpleFunctionSymbolImpl(null, null, 3, null)), (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)98304, null);
        boolean bl = false;
        IrFunction irFunction = (IrFunction)irAdapterFunction;
        Name name3 = Name.identifier((String)"$callee");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        irAdapterFunction.setExtensionReceiverParameter(this.createAdapterParameter(irFunction, name3, argumentType, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_SUSPEND_CONVERSION()));
        destination$iv$iv = parameterTypes;
        Collection collection3 = irAdapterFunction.getValueParameters();
        IrSimpleFunction irSimpleFunction2 = irAdapterFunction;
        boolean $i$f$mapIndexed = false;
        it = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parameterType;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrType irType3 = (IrType)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            IrFunction irFunction2 = (IrFunction)irAdapterFunction;
            Name name4 = Name.identifier((String)("" + 'p' + (int)index2));
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            collection.add(this.createAdapterParameter(irFunction2, name4, (IrType)parameterType, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_SUSPEND_CONVERSION()));
        }
        collection = (List)destination$iv$iv2;
        irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)collection3, (Iterable)collection));
        irAdapterFunction.setBody((IrBody)IrFactoryHelpersKt.createBlockBody((IrFactory)((IrFactory)IrFactoryImpl.INSTANCE), (int)startOffset, (int)endOffset, arg_0 -> AdapterGenerator.createAdapterFunctionForArgument$lambda$28$lambda$27(this, startOffset, endOffset, irAdapterFunction, invokeSymbol, returnType, arg_0)));
        IrDeclarationParent irDeclarationParent = this.conversionScope.parent();
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        irAdapterFunction.setParent(irDeclarationParent);
        return irSimpleFunction;
    }

    private final IrExpression createAdapteeCallForArgument(int startOffset, int endOffset, IrFunction adapterFunction, IrSimpleFunctionSymbol invokeSymbol) {
        IrCallImpl irCall = BuildersKt.IrCallImpl$default((int)startOffset, (int)endOffset, (IrType)adapterFunction.getReturnType(), (IrSimpleFunctionSymbol)invokeSymbol, (int)0, null, null, (int)96, null);
        IrValueParameter irValueParameter = adapterFunction.getExtensionReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        irCall.setDispatchReceiver((IrExpression)this.toIrGetValue((IrValueDeclaration)irValueParameter, startOffset, endOffset));
        for (IrValueParameter irAdapterParameter : adapterFunction.getValueParameters()) {
            irCall.putValueArgument(irAdapterParameter.getIndex(), (IrExpression)this.toIrGetValue((IrValueDeclaration)irAdapterParameter, startOffset, endOffset));
        }
        return (IrExpression)irCall;
    }

    @NotNull
    public final IrExpression generateFunInterfaceConstructorReference(@NotNull FirCallableReferenceAccess callableReference, @NotNull FirFunctionSymbol<?> callableSymbol, @NotNull IrType irReferenceType) {
        Intrinsics.checkNotNullParameter((Object)callableReference, (String)"callableReference");
        Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
        Intrinsics.checkNotNullParameter((Object)irReferenceType, (String)"irReferenceType");
        return (IrExpression)OffsetUtilsKt.convertWithOffsets(callableReference, (arg_0, arg_1) -> AdapterGenerator.generateFunInterfaceConstructorReference$lambda$29(this, callableSymbol, irReferenceType, arg_0, arg_1));
    }

    private final IrType getArgumentTypeAt(IrSimpleType $this$getArgumentTypeAt, int index2) {
        Object e = $this$getArgumentTypeAt.getArguments().get(index2);
        IrTypeProjection irTypeProjection = e instanceof IrTypeProjection ? (IrTypeProjection)e : null;
        if (irTypeProjection == null) {
            throw new AssertionError((Object)("Type projection expected at argument " + index2 + ": " + RenderIrElementKt.render$default((IrSimpleType)$this$getArgumentTypeAt, null, (int)1, null)));
        }
        IrTypeProjection irTypeArgument = irTypeProjection;
        return irTypeArgument.getType();
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateFunInterfaceConstructorAdapter(int startOffset, int endOffset, FirFunctionSymbol<?> callableSymbol, IrType irReferenceType) {
        void $this$generateFunInterfaceConstructorAdapter_u24lambda_u2431_u24lambda_u2430;
        IrCallImpl irCallImpl;
        IrSimpleFunction irSimpleFunction;
        IrSimpleType irSimpleType = irReferenceType instanceof IrSimpleType ? (IrSimpleType)irReferenceType : null;
        if (irSimpleType == null) {
            throw new AssertionError((Object)("Class type expected: " + RenderIrElementKt.render$default((IrType)irReferenceType, null, (int)1, null)));
        }
        IrSimpleType irSimpleReferenceType = irSimpleType;
        IrType irSamType = this.getArgumentTypeAt(irSimpleReferenceType, 1);
        IrType irFunctionType = this.getArgumentTypeAt(irSimpleReferenceType, 0);
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.singleOrNull(callableSymbol.getValueParameterSymbols());
        if (firValueParameterSymbol == null) {
            throw new AssertionError((Object)("Single value parameter expected: " + callableSymbol.getValueParameterSymbols()));
        }
        FirValueParameterSymbol functionParameter = firValueParameterSymbol;
        IrFactory irFactory = (IrFactory)IrFactoryImpl.INSTANCE;
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_FOR_FUN_INTERFACE_CONSTRUCTOR();
        Name name2 = callableSymbol.getName();
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        IrSimpleFunction irAdapterFunction = irSimpleFunction = IrFactory.createSimpleFunction$default((IrFactory)irFactory, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)irDeclarationOrigin, (Name)name2, (DescriptorVisibility)descriptorVisibility, (boolean)false, (boolean)false, (IrType)irSamType, (Modality)Modality.FINAL, (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)new IrSimpleFunctionSymbolImpl(null, null, 3, null)), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)98304, null);
        boolean bl = false;
        irAdapterFunction.setDispatchReceiverParameter(null);
        irAdapterFunction.setExtensionReceiverParameter(null);
        IrValueParameter irFunctionParameter = this.createAdapterParameter((IrFunction)irAdapterFunction, functionParameter.getName(), irFunctionType, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE());
        irAdapterFunction.setValueParameters(CollectionsKt.listOf((Object)irFunctionParameter));
        IrCallImpl irCallImpl2 = irCallImpl = BuildersKt.IrCallImplWithShape$default((int)startOffset, (int)endOffset, (IrType)irFunctionType, (IrSimpleFunctionSymbol)this.getBuiltins().getCheckNotNullSymbol(), (int)1, (int)1, (int)0, (boolean)false, (boolean)false, (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getEXCLEXCL()), null, (int)1024, null);
        IrType irType = irSamType;
        IrTypeOperator irTypeOperator = IrTypeOperator.SAM_CONVERSION;
        IrType irType2 = irSamType;
        int n = endOffset;
        int n2 = startOffset;
        IrReturnTargetSymbol irReturnTargetSymbol = (IrReturnTargetSymbol)irAdapterFunction.getSymbol();
        IrType irType3 = this.c.getBuiltins().getNothingType();
        int n3 = endOffset;
        int n4 = startOffset;
        int n5 = endOffset;
        int n6 = startOffset;
        IrFactory irFactory2 = (IrFactory)IrFactoryImpl.INSTANCE;
        IrSimpleFunction irSimpleFunction2 = irAdapterFunction;
        boolean bl2 = false;
        $this$generateFunInterfaceConstructorAdapter_u24lambda_u2431_u24lambda_u2430.putTypeArgument(0, irFunctionType);
        $this$generateFunInterfaceConstructorAdapter_u24lambda_u2431_u24lambda_u2430.putValueArgument(0, (IrExpression)BuildersKt.IrGetValueImpl$default((int)startOffset, (int)endOffset, (IrValueSymbol)((IrValueSymbol)irFunctionParameter.getSymbol()), null, (int)8, null));
        Unit unit = Unit.INSTANCE;
        IrExpression irExpression = (IrExpression)BuildersKt.IrTypeOperatorCallImpl((int)n2, (int)n, (IrType)irType2, (IrTypeOperator)irTypeOperator, (IrType)irType, (IrExpression)((IrExpression)irCallImpl));
        IrReturnTargetSymbol irReturnTargetSymbol2 = irReturnTargetSymbol;
        IrType irType4 = irType3;
        int n7 = n3;
        int n8 = n4;
        irSimpleFunction2.setBody((IrBody)IrFactoryHelpersKt.createBlockBody((IrFactory)irFactory2, (int)n6, (int)n5, (List)CollectionsKt.listOf((Object)new IrReturnImpl(n8, n7, irType4, irReturnTargetSymbol2, irExpression))));
        IrDeclarationParent irDeclarationParent = this.conversionScope.parent();
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        irAdapterFunction.setParent(irDeclarationParent);
        return irSimpleFunction;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.c.getSession();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.c.getScopeSession();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.c.getFirProvider();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.c.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrBuiltinSymbolsContainer getBuiltins() {
        return this.c.getBuiltins();
    }

    @Override
    @Nullable
    public IrSpecialAnnotationsProvider getSpecialAnnotationsProvider() {
        return this.c.getSpecialAnnotationsProvider();
    }

    @Override
    @NotNull
    public KotlinMangler.IrMangler getIrMangler() {
        return this.c.getIrMangler();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.c.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.c.getLock();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.c.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.c.getDeclarationStorage();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.c.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.c.getVisibilityConverter();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.c.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.c.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.c.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public Fir2IrDataClassMembersGenerator getDataClassMembersGenerator() {
        return this.c.getDataClassMembersGenerator();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.c.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.c.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyFakeOverrideGenerator getLazyFakeOverrideGenerator() {
        return this.c.getLazyFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.c.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.c.getExtensions();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.c.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.c.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @Nullable
    public Set<FirFile> getFilesBeingCompiled() {
        return this.c.getFilesBeingCompiled();
    }

    private static final Unit generateAdaptedCallableReference$lambda$6$lambda$1(IrType $expectedReturnType, IrExpression $irCall, AdapterGenerator this$0, int $startOffset, int $endOffset, IrSimpleFunction $irAdapterFunction, IrBlockBody $this$createBlockBody) {
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        IrType irType = $expectedReturnType;
        boolean bl = (irType != null ? IrTypePredicatesKt.isUnit((IrType)irType) : false) ? $this$createBlockBody.getStatements().add(Fir2IrImplicitCastInserter.Companion.coerceToUnitIfNeeded$fir2ir($irCall, this$0.getBuiltins())) : $this$createBlockBody.getStatements().add(new IrReturnImpl($startOffset, $endOffset, this$0.getBuiltins().getNothingType(), (IrReturnTargetSymbol)$irAdapterFunction.getSymbol(), $irCall));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrBlockImpl generateAdaptedCallableReference$lambda$6(AdapterGenerator this$0, FirCallableReferenceAccess $callableReferenceAccess, IrExpression $explicitReceiverExpression, FirFunction $firAdaptee, IrSimpleType $type, IrFunctionSymbol $adapteeSymbol, IrType $expectedReturnType, int startOffset, int endOffset) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        IrExpression boundDispatchReceiver = this$0.findBoundReceiver($callableReferenceAccess, $explicitReceiverExpression, true);
        IrExpression boundExtensionReceiver = this$0.findBoundReceiver($callableReferenceAccess, $explicitReceiverExpression, false);
        FirFunction firFunction = $firAdaptee;
        Intrinsics.checkNotNull((Object)firFunction);
        IrSimpleFunction irAdapterFunction = this$0.createAdapterFunctionForCallableReference($callableReferenceAccess, startOffset, endOffset, firFunction, $type, boundDispatchReceiver, boundExtensionReceiver);
        IrExpression irCall = this$0.createAdapteeCallForCallableReference($callableReferenceAccess, $firAdaptee, $adapteeSymbol, (IrFunction)irAdapterFunction, $type, boundDispatchReceiver, boundExtensionReceiver);
        irAdapterFunction.setBody((IrBody)IrFactoryHelpersKt.createBlockBody((IrFactory)((IrFactory)IrFactoryImpl.INSTANCE), (int)startOffset, (int)endOffset, arg_0 -> AdapterGenerator.generateAdaptedCallableReference$lambda$6$lambda$1($expectedReturnType, irCall, this$0, startOffset, endOffset, irAdapterFunction, arg_0)));
        if (!irAdapterFunction.getTypeParameters().isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Iterable iterable = irAdapterFunction.getTypeParameters();
            StringBuilder stringBuilder = new StringBuilder().append("Internal error: function adapter ").append(irAdapterFunction.getSymbol()).append(" has unexpected type parameters: ");
            boolean $i$f$map = false;
            void var18_21 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSymbol());
            }
            String string = stringBuilder.append((List)destination$iv$iv).append("\nThey should already be used to determine exact return type and value parameters types").toString();
            throw new IllegalArgumentException(string.toString());
        }
        IrFunctionReferenceImpl $this$generateAdaptedCallableReference_u24lambda_u246_u24lambda_u244 = irFunctionReferenceImpl = BuildersKt.IrFunctionReferenceImpl((int)startOffset, (int)endOffset, (IrType)((IrType)$type), (IrFunctionSymbol)((IrFunctionSymbol)irAdapterFunction.getSymbol()), (int)0, null, (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()));
        boolean bl = false;
        IrExpression irExpression = boundDispatchReceiver;
        if (irExpression == null) {
            irExpression = boundExtensionReceiver;
        }
        $this$generateAdaptedCallableReference_u24lambda_u246_u24lambda_u244.setExtensionReceiver(irExpression);
        $this$generateAdaptedCallableReference_u24lambda_u246_u24lambda_u244.setReflectionTarget($adapteeSymbol);
        IrFunctionReferenceImpl irAdapterRef = irFunctionReferenceImpl;
        IrFunctionReferenceImpl $this$generateAdaptedCallableReference_u24lambda_u246_u24lambda_u245 = irFunctionReferenceImpl = BuildersKt.IrBlockImpl((int)startOffset, (int)endOffset, (IrType)((IrType)$type), (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()));
        boolean bl3 = false;
        $this$generateAdaptedCallableReference_u24lambda_u246_u24lambda_u245.getStatements().add(irAdapterFunction);
        $this$generateAdaptedCallableReference_u24lambda_u246_u24lambda_u245.getStatements().add(irAdapterRef);
        return irFunctionReferenceImpl;
    }

    private static final IrGetValue createAdapteeCallForCallableReference$lambda$14$buildIrGetValueArgument(Ref.IntRef adapterParameterIndex, AdapterGenerator this$0, IrFunction $adapterFunction, Ref.IntRef parameterShift, int $startOffset, int $endOffset, FirExpression argument2) {
        FirFakeArgumentForCallableReference firFakeArgumentForCallableReference = argument2 instanceof FirFakeArgumentForCallableReference ? (FirFakeArgumentForCallableReference)argument2 : null;
        int parameterIndex = firFakeArgumentForCallableReference != null ? firFakeArgumentForCallableReference.getIndex() : adapterParameterIndex.element;
        int n = adapterParameterIndex.element;
        adapterParameterIndex.element = n + 1;
        return this$0.toIrGetValue((IrValueDeclaration)$adapterFunction.getValueParameters().get(parameterIndex + parameterShift.element), $startOffset, $endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrExpression createAdapteeCallForCallableReference$lambda$14(FirCallableReferenceAccess $callableReferenceAccess, AdapterGenerator this$0, FirFunction $firAdaptee, IrFunctionSymbol $adapteeSymbol, IrExpression $boundDispatchReceiver, IrExpression $boundExtensionReceiver, IrFunction $adapterFunction, IrSimpleType $adaptedType, int startOffset, int endOffset) {
        Ref.IntRef parameterShift;
        Ref.IntRef adapterParameterIndex;
        IrFunctionAccessExpression irCall;
        ConeSubstitutor substitutor2;
        block29: {
            boolean bl;
            block30: {
                boolean bl2;
                block28: {
                    IrFunctionAccessExpression irFunctionAccessExpression;
                    ConeSubstitutor coneSubstitutor = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default($callableReferenceAccess, this$0.getSession(), false, 2, null);
                    if (coneSubstitutor == null) {
                        coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
                    }
                    substitutor2 = coneSubstitutor;
                    IrType type2 = Fir2IrTypeConverterKt.toIrType$default(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType($firAdaptee.getReturnTypeRef())), (Fir2IrComponents)this$0.getTypeConverter(), null, 2, null);
                    IrFunctionSymbol irFunctionSymbol = $adapteeSymbol;
                    if (irFunctionSymbol instanceof IrConstructorSymbol) {
                        irFunctionAccessExpression = (IrFunctionAccessExpression)BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)startOffset, (int)endOffset, (IrType)type2, (IrConstructorSymbol)((IrConstructorSymbol)$adapteeSymbol), null, (int)16, null);
                    } else if (irFunctionSymbol instanceof IrSimpleFunctionSymbol) {
                        irFunctionAccessExpression = (IrFunctionAccessExpression)BuildersKt.IrCallImpl((int)startOffset, (int)endOffset, (IrType)type2, (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)$adapteeSymbol), (int)$callableReferenceAccess.getTypeArguments().size(), null, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    irCall = irFunctionAccessExpression;
                    adapterParameterIndex = new Ref.IntRef();
                    parameterShift = new Ref.IntRef();
                    if ($boundDispatchReceiver == null && $boundExtensionReceiver == null) break block28;
                    IrValueParameter irValueParameter = $adapterFunction.getExtensionReceiverParameter();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    IrGetValueImpl receiverValue = BuildersKt.IrGetValueImpl((int)startOffset, (int)endOffset, (IrValueSymbol)((IrValueSymbol)irValueParameter.getSymbol()), (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()));
                    if ($boundDispatchReceiver != null) {
                        irCall.setDispatchReceiver((IrExpression)receiverValue);
                    } else {
                        irCall.setExtensionReceiver((IrExpression)receiverValue);
                    }
                    break block29;
                }
                if (!($callableReferenceAccess.getExplicitReceiver() instanceof FirResolvedQualifier)) break block29;
                if (!($firAdaptee instanceof FirConstructor)) break block30;
                Object object = ClassMembersKt.containingClassLookupTag($firAdaptee);
                if (object != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, this$0.getSession())) != null) {
                    FirClassLikeSymbol $this$isInner$iv = (FirClassLikeSymbol)object;
                    boolean $i$f$isInner = false;
                    bl2 = $this$isInner$iv.getRawStatus().isInner();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block29;
            }
            FirMemberDeclaration firMemberDeclaration = $firAdaptee instanceof FirMemberDeclaration ? (FirMemberDeclaration)$firAdaptee : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isStatic$iv = firMemberDeclaration;
                boolean $i$f$isStatic = false;
                bl = $this$isStatic$iv.getStatus().isStatic();
            } else {
                bl = false;
            }
            if (!bl) {
                IrValueParameter adaptedReceiverParameter = (IrValueParameter)$adapterFunction.getValueParameters().get(0);
                IrGetValueImpl adaptedReceiverValue = BuildersKt.IrGetValueImpl$default((int)startOffset, (int)endOffset, (IrType)adaptedReceiverParameter.getType(), (IrValueSymbol)((IrValueSymbol)adaptedReceiverParameter.getSymbol()), null, (int)16, null);
                if ($firAdaptee.getReceiverParameter() != null) {
                    irCall.setExtensionReceiver((IrExpression)adaptedReceiverValue);
                } else {
                    irCall.setDispatchReceiver((IrExpression)adaptedReceiverValue);
                }
                int $i$f$isStatic = parameterShift.element;
                parameterShift.element = $i$f$isStatic + 1;
            }
        }
        FirNamedReference $i$f$isStatic = $callableReferenceAccess.getCalleeReference();
        FirResolvedCallableReference firResolvedCallableReference = $i$f$isStatic instanceof FirResolvedCallableReference ? (FirResolvedCallableReference)$i$f$isStatic : null;
        Map<FirValueParameter, ResolvedCallArgument<FirExpression>> mappedArguments = firResolvedCallableReference != null ? firResolvedCallableReference.getMappedArguments() : null;
        Iterable $this$forEachIndexed$iv = $firAdaptee.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ResolvedCallArgument<FirExpression> mappedArgument;
            void valueParameter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index2 = n;
            boolean bl = false;
            ConeKotlinType coneKotlinType = VariousUtilsKt.getVarargElementType((FirValueParameter)valueParameter);
            IrType varargElementType = coneKotlinType != null ? Fir2IrTypeConverterKt.toIrType$default(coneKotlinType, this$0.c, null, 2, null) : null;
            IrType parameterType = Fir2IrTypeConverterKt.toIrType$default(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(valueParameter.getReturnTypeRef())), (Fir2IrComponents)this$0.getTypeConverter(), null, 2, null);
            Map<FirValueParameter, ResolvedCallArgument<FirExpression>> map = mappedArguments;
            ResolvedCallArgument<FirExpression> resolvedCallArgument = mappedArgument = map != null ? map.get(valueParameter) : null;
            if (mappedArgument instanceof ResolvedCallArgument.VarargArgument) {
                IrVarargImpl irVarargImpl;
                if (((ResolvedCallArgument.VarargArgument)mappedArgument).getArguments().isEmpty()) {
                    irVarargImpl = null;
                } else {
                    IrType reifiedVarargElementType = null;
                    IrType reifiedVarargType = null;
                    IrType irType = varargElementType;
                    boolean bl3 = irType != null ? IrTypeUtilsKt.isTypeParameter((IrType)irType) : false;
                    if (bl3 && parameterType instanceof IrSimpleType && !IrTypeUtilsKt.isPrimitiveArray((IrType)parameterType)) {
                        reifiedVarargElementType = this$0.getArgumentTypeAt($adaptedType, index2);
                        reifiedVarargType = (IrType)new IrSimpleTypeImpl(((IrSimpleType)parameterType).getClassifier(), ((IrSimpleType)parameterType).getNullability(), CollectionsKt.listOf((Object)IrSimpleTypeImplKt.makeTypeProjection((IrType)reifiedVarargElementType, (Variance)Variance.OUT_VARIANCE)), parameterType.getAnnotations(), ((IrSimpleType)parameterType).getAbbreviation());
                    } else {
                        IrType irType2 = varargElementType;
                        Intrinsics.checkNotNull((Object)irType2);
                        reifiedVarargElementType = irType2;
                        reifiedVarargType = parameterType;
                    }
                    IrVarargImpl adaptedValueArgument = BuildersKt.IrVarargImpl((int)startOffset, (int)endOffset, (IrType)reifiedVarargType, (IrType)reifiedVarargElementType);
                    for (FirExpression argument2 : ((ResolvedCallArgument.VarargArgument)mappedArgument).getArguments()) {
                        IrGetValue irValueArgument = AdapterGenerator.createAdapteeCallForCallableReference$lambda$14$buildIrGetValueArgument(adapterParameterIndex, this$0, $adapterFunction, parameterShift, startOffset, endOffset, argument2);
                        IrExpressionsKt.addElement((IrVararg)((IrVararg)adaptedValueArgument), (IrVarargElement)((IrVarargElement)irValueArgument));
                    }
                    irVarargImpl = adaptedValueArgument;
                }
                IrVarargImpl valueArgument = irVarargImpl;
                irCall.putValueArgument(index2, (IrExpression)valueArgument);
                continue;
            }
            if (Intrinsics.areEqual(mappedArgument, (Object)ResolvedCallArgument.DefaultArgument.INSTANCE)) {
                irCall.putValueArgument(index2, null);
                continue;
            }
            if (mappedArgument instanceof ResolvedCallArgument.SimpleArgument) {
                IrGetValue irValueArgument = AdapterGenerator.createAdapteeCallForCallableReference$lambda$14$buildIrGetValueArgument(adapterParameterIndex, this$0, $adapterFunction, parameterShift, startOffset, endOffset, (FirExpression)((ResolvedCallArgument.SimpleArgument)mappedArgument).getCallArgument());
                if (valueParameter.isVararg()) {
                    IrType irType = varargElementType;
                    Intrinsics.checkNotNull((Object)irType);
                    irCall.putValueArgument(index2, (IrExpression)BuildersKt.IrVarargImpl((int)startOffset, (int)endOffset, (IrType)parameterType, (IrType)irType, (List)CollectionsKt.listOf((Object)BuildersKt.IrSpreadElementImpl((int)startOffset, (int)endOffset, (IrExpression)((IrExpression)irValueArgument)))));
                    continue;
                }
                irCall.putValueArgument(index2, (IrExpression)irValueArgument);
                continue;
            }
            if (mappedArgument == null) continue;
            throw new NoWhenBranchMatchedException();
        }
        CallAndReferenceGenerator $this$createAdapteeCallForCallableReference_u24lambda_u2414_u24lambda_u2413 = this$0.getCallGenerator();
        boolean bl = false;
        return $this$createAdapteeCallForCallableReference_u24lambda_u2414_u24lambda_u2413.applyTypeArguments$fir2ir((IrExpression)irCall, $callableReferenceAccess);
    }

    private static final IrExpression applySamConversionIfNeeded$lambda$15(AdapterGenerator this$0, FirValueParameter $parameter, IrExpression $this$applyConversionOnVararg, FirExpression firVarargArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$applyConversionOnVararg, (String)"$this$applyConversionOnVararg");
        Intrinsics.checkNotNullParameter((Object)firVarargArgument, (String)"firVarargArgument");
        return this$0.applySamConversionIfNeeded$fir2ir($this$applyConversionOnVararg, firVarargArgument, $parameter);
    }

    private static final IrTypeOperatorCallImpl applySamConversionIfNeeded$generateSamConversion(IrExpression $this$applySamConversionIfNeeded_u24generateSamConversion, AdapterGenerator this$0, IrType samType, FirSamConversionExpression firSamConversion, ConeKotlinType samFirType) {
        return BuildersKt.IrTypeOperatorCallImpl((int)$this$applySamConversionIfNeeded_u24generateSamConversion.getStartOffset(), (int)$this$applySamConversionIfNeeded_u24generateSamConversion.getEndOffset(), (IrType)samType, (IrTypeOperator)IrTypeOperator.SAM_CONVERSION, (IrType)samType, (IrExpression)this$0.castArgumentToFunctionalInterfaceForSamType($this$applySamConversionIfNeeded_u24generateSamConversion, FirTypeUtilsKt.getResolvedType(firSamConversion.getExpression()), samFirType));
    }

    private static final IrVarargElement applyConversionOnVararg$lambda$19(Map $argumentMapping, Function2 $conversion, IrVarargElement irVarargElement) {
        IrVarargElement irVarargElement2;
        Intrinsics.checkNotNullParameter((Object)irVarargElement, (String)"irVarargElement");
        if (irVarargElement instanceof IrExpression) {
            FirExpression firExpression = (FirExpression)$argumentMapping.get(irVarargElement);
            if (firExpression == null) {
                throw new IllegalStateException(("Can't find the original FirExpression for " + RenderIrElementKt.render$default((IrElement)((IrElement)irVarargElement), null, (int)1, null)).toString());
            }
            FirExpression firVarargArgument = firExpression;
            irVarargElement2 = (IrVarargElement)$conversion.invoke((Object)irVarargElement, (Object)firVarargArgument);
        } else {
            irVarargElement2 = irVarargElement;
        }
        return irVarargElement2;
    }

    private static final IrExpression applySuspendConversionIfNeeded$lambda$20(AdapterGenerator this$0, ConeKotlinType $parameterType, IrExpression $this$applyConversionOnVararg, FirExpression firVarargArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$applyConversionOnVararg, (String)"$this$applyConversionOnVararg");
        Intrinsics.checkNotNullParameter((Object)firVarargArgument, (String)"firVarargArgument");
        return this$0.applySuspendConversionIfNeeded$fir2ir($this$applyConversionOnVararg, firVarargArgument, $parameterType);
    }

    private static final Unit createAdapterFunctionForArgument$lambda$28$lambda$27(AdapterGenerator this$0, int $startOffset, int $endOffset, IrSimpleFunction $irAdapterFunction, IrSimpleFunctionSymbol $invokeSymbol, IrType $returnType, IrBlockBody $this$createBlockBody) {
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        IrExpression irCall = this$0.createAdapteeCallForArgument($startOffset, $endOffset, (IrFunction)$irAdapterFunction, $invokeSymbol);
        boolean bl = IrTypePredicatesKt.isUnit((IrType)$returnType) ? $this$createBlockBody.getStatements().add(irCall) : $this$createBlockBody.getStatements().add(new IrReturnImpl($startOffset, $endOffset, this$0.getBuiltins().getNothingType(), (IrReturnTargetSymbol)$irAdapterFunction.getSymbol(), irCall));
        return Unit.INSTANCE;
    }

    private static final IrBlockImpl generateFunInterfaceConstructorReference$lambda$29(AdapterGenerator this$0, FirFunctionSymbol $callableSymbol, IrType $irReferenceType, int startOffset, int endOffset) {
        IrSimpleFunction irAdapterFun = this$0.generateFunInterfaceConstructorAdapter(startOffset, endOffset, $callableSymbol, $irReferenceType);
        IrFunctionReferenceImpl irAdapterRef = BuildersKt.IrFunctionReferenceImpl((int)startOffset, (int)endOffset, (IrType)$irReferenceType, (IrFunctionSymbol)((IrFunctionSymbol)irAdapterFun.getSymbol()), (int)irAdapterFun.getTypeParameters().size(), (IrFunctionSymbol)((IrFunctionSymbol)irAdapterFun.getSymbol()), (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE()));
        Object[] objectArray = new IrElement[]{irAdapterFun, irAdapterRef};
        return BuildersKt.IrBlockImpl((int)startOffset, (int)endOffset, (IrType)$irReferenceType, (IrStatementOrigin)((IrStatementOrigin)IrStatementOrigin.Companion.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE()), (List)CollectionsKt.listOf((Object[])objectArray));
    }
}

