/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinIndentationAdjuster;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProviderKt;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider;", "<init>", "()V", "indentionSettings", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinIndentationAdjuster;", "editor", "Lcom/intellij/openapi/editor/Editor;", "mapType", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "isSuitableForLanguage", "", "language", "Lcom/intellij/lang/Language;", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "offset", "", "getIndent", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator;", "KotlinElement", "Companion", "kotlin.base.code-insight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinLangLineIndentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLangLineIndentProvider.kt\norg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,900:1\n1#2:901\n*E\n"})
public abstract class KotlinLangLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP;
    @NotNull
    private static final HashSet<SemanticEditorPosition.SyntaxElement> CONTROL_FLOW_KEYWORDS;
    @NotNull
    private static final SemanticEditorPosition.SyntaxElement[] WHITE_SPACE_OR_COMMENT_BIT_SET;
    @NotNull
    private static final List<Pair<SemanticEditorPosition.SyntaxElement, SemanticEditorPosition.SyntaxElement>> PARENTHESES;

    @NotNull
    public abstract KotlinIndentationAdjuster indentionSettings(@NotNull Editor var1);

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return SYNTAX_MAP.get(tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language.isKindOf((Language)KotlinLanguage.INSTANCE);
    }

    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return offset > 0 && this.getPosition(editor, offset - 1).isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.RegularStringPart) ? LineIndentProvider.DO_NOT_ADJUST : super.getLineIndent(project, editor, language, offset);
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        IndentCalculator indentCalculator;
        SemanticEditorPosition after;
        SemanticEditorPosition semanticEditorPosition;
        SemanticEditorPosition before2;
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory factory;
        block31: {
            Indent indent;
            SemanticEditorPosition currentPosition;
            KotlinIndentationAdjuster settings;
            block33: {
                block32: {
                    block30: {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                        factory = new JavaLikeLangLineIndentProvider.IndentCalculatorFactory(project, editor);
                        settings = this.indentionSettings(editor);
                        currentPosition = this.getPosition(editor, offset);
                        if (!currentPosition.matchesRule(KotlinLangLineIndentProvider::getIndent$lambda$0)) {
                            return null;
                        }
                        SemanticEditorPosition.SyntaxElement[] syntaxElementArray = WHITE_SPACE_OR_COMMENT_BIT_SET;
                        before2 = currentPosition.beforeOptionalMix(Arrays.copyOf(syntaxElementArray, syntaxElementArray.length));
                        semanticEditorPosition = WHITE_SPACE_OR_COMMENT_BIT_SET;
                        after = currentPosition.afterOptionalMix(Arrays.copyOf(semanticEditorPosition, ((SemanticEditorPosition.SyntaxElement[])semanticEditorPosition).length));
                        if (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace) && !currentPosition.hasLineBreaksAfter(offset)) {
                            SemanticEditorPosition it = currentPosition.after();
                            boolean bl = false;
                            if (!(it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment) && it.isAtMultiline())) {
                                Intrinsics.checkNotNull((Object)before2);
                                Intrinsics.checkNotNull((Object)after);
                                SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace;
                                SemanticEditorPosition.SyntaxElement syntaxElement2 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace;
                                Indent indent2 = Indent.getNoneIndent();
                                Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getNoneIndent(...)");
                                return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForBrace(factory, before2, after, syntaxElement, syntaxElement2, indent2);
                            }
                        }
                        if (before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                            Intrinsics.checkNotNull((Object)before2);
                            Intrinsics.checkNotNull((Object)after);
                            SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace;
                            SemanticEditorPosition.SyntaxElement syntaxElement3 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace;
                            Indent indent3 = Indent.getNormalIndent();
                            Intrinsics.checkNotNullExpressionValue((Object)indent3, (String)"getNormalIndent(...)");
                            return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForBrace(factory, before2, after, syntaxElement, syntaxElement3, indent3);
                        }
                        if (before2.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Arrow)) {
                            Intrinsics.checkNotNull((Object)before2);
                            Intrinsics.checkNotNull((Object)after);
                            return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForArrow(factory, before2, after);
                        }
                        if (!after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Arrow)) break block30;
                        Intrinsics.checkNotNull((Object)after);
                        IndentCalculator arrowCalculator = KotlinLangLineIndentProvider.Companion.createIndentCalculatorForArrowInsideWhenEntry(factory, after, settings);
                        if (arrowCalculator != null) {
                            return arrowCalculator;
                        }
                        break block31;
                    }
                    if (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket) && !currentPosition.hasLineBreaksAfter(offset)) {
                        Intrinsics.checkNotNull((Object)before2);
                        Intrinsics.checkNotNull((Object)after);
                        SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket;
                        SemanticEditorPosition.SyntaxElement syntaxElement4 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket;
                        Indent indent4 = Indent.getNoneIndent();
                        Intrinsics.checkNotNullExpressionValue((Object)indent4, (String)"getNoneIndent(...)");
                        return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForBrace(factory, before2, after, syntaxElement, syntaxElement4, indent4);
                    }
                    if (before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket) && after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket)) {
                        Intrinsics.checkNotNull((Object)before2);
                        indent = KotlinLangLineIndentProvider.Companion.isSimilarToFunctionInvocation(before2) ? Indent.getContinuationIndent() : Indent.getNormalIndent();
                        Intrinsics.checkNotNull((Object)indent);
                        return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, before2.getStartOffset());
                    }
                    if (before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) && before2.before().isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Quest)) {
                        Indent indent5 = Indent.getNoneIndent();
                        Intrinsics.checkNotNullExpressionValue((Object)indent5, (String)"getNoneIndent(...)");
                        return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent5, before2.getStartOffset());
                    }
                    if (before2.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryOpen)) {
                        indent = !currentPosition.hasLineBreaksAfter(offset) && after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryClose) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                        Intrinsics.checkNotNull((Object)indent);
                        return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, before2.getStartOffset());
                    }
                    indent = new Indent[]{JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword};
                    if (before2.isAtAnyOf((SemanticEditorPosition.SyntaxElement[])indent)) break block32;
                    Intrinsics.checkNotNull((Object)before2);
                    if (!KotlinLangLineIndentProvider.Companion.isFinallyKeyword(before2)) break block33;
                }
                return factory.createIndentCalculator(Indent.getNoneIndent(), IndentCalculator.LINE_BEFORE);
            }
            if (after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryClose)) {
                indent = currentPosition.hasEmptyLineAfter(offset) ? Indent.getNormalIndent() : Indent.getNoneIndent();
                after.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryOpen, (SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryClose);
                Intrinsics.checkNotNull((Object)indent);
                return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, after.getStartOffset());
            }
            if (before2.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Eq)) {
                SemanticEditorPosition semanticEditorPosition2 = KotlinLangLineIndentProvider.Companion.beforeIgnoringWhiteSpaceOrComment(before2);
                Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition2, (String)"access$beforeIgnoringWhiteSpaceOrComment(...)");
                SemanticEditorPosition declaration = KotlinLangLineIndentProvider.Companion.findFunctionOrPropertyOrMultiDeclarationBefore(semanticEditorPosition2);
                if (declaration != null) {
                    Indent indent6 = settings.getContinuationIndentForExpressionBodies() ? Indent.getContinuationIndent() : Indent.getNormalIndent();
                    Intrinsics.checkNotNull((Object)indent6);
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent6, declaration.getStartOffset());
                }
            } else if (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                Intrinsics.checkNotNull((Object)currentPosition);
                Intrinsics.checkNotNull((Object)after);
                semanticEditorPosition = KotlinLangLineIndentProvider.Companion.createIndentCalculatorForParenthesis(factory, before2, currentPosition, after, offset, settings);
                if (semanticEditorPosition != null) {
                    SemanticEditorPosition it = semanticEditorPosition;
                    boolean bl = false;
                    return it;
                }
            } else if ((after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot) || after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Quest) && after.after().isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot)) && (semanticEditorPosition = KotlinLangLineIndentProvider.Companion.createIndentCalculatorForDot(factory, before2, settings)) != null) {
                SemanticEditorPosition it = semanticEditorPosition;
                boolean bl = false;
                return it;
            }
        }
        Intrinsics.checkNotNull((Object)before2);
        semanticEditorPosition = KotlinLangLineIndentProvider.Companion.findFunctionOrPropertyOrMultiDeclarationBefore(before2);
        if (semanticEditorPosition != null) {
            SemanticEditorPosition it = semanticEditorPosition;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)after);
            Indent indent = KotlinLangLineIndentProvider.Companion.similarToPropertyAccessorKeyword(after) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            Intrinsics.checkNotNull((Object)indent);
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, it.getStartOffset());
        }
        semanticEditorPosition = KotlinLangLineIndentProvider.Companion.findContextReceiverListBefore(before2);
        if (semanticEditorPosition != null) {
            SemanticEditorPosition it = semanticEditorPosition;
            boolean bl = false;
            Indent indent = Indent.getNoneIndent();
            Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getNoneIndent(...)");
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, it.getStartOffset());
        }
        SemanticEditorPosition semanticEditorPosition3 = KotlinLangLineIndentProvider.Companion.controlFlowStatementBefore(before2);
        if (semanticEditorPosition3 != null) {
            Indent indent;
            SemanticEditorPosition controlFlowKeywordPosition = semanticEditorPosition3;
            boolean bl = false;
            if (KotlinLangLineIndentProvider.Companion.similarToCatchKeyword(controlFlowKeywordPosition)) {
                indent = before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) ? Indent.getNoneIndent() : Indent.getNormalIndent();
            } else if (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                indent = before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) ? Indent.getNormalIndent() : Indent.getContinuationIndent();
            } else {
                SemanticEditorPosition.SyntaxElement[] syntaxElementArray = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, KotlinElement.Arrow};
                indent = after.isAtAnyOf(syntaxElementArray) || KotlinLangLineIndentProvider.Companion.isWhileInsideDoWhile(controlFlowKeywordPosition) ? Indent.getNoneIndent() : Indent.getNormalIndent();
            }
            Indent indent7 = indent;
            Intrinsics.checkNotNull((Object)indent7);
            indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent7, controlFlowKeywordPosition.getStartOffset());
        } else {
            indentCalculator = null;
        }
        return indentCalculator;
    }

    private static final boolean getIndent$lambda$0(SemanticEditorPosition it) {
        return it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && it.isAtMultiline();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)KtTokens.WHITE_SPACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace), TuplesKt.to((Object)KtTokens.EOL_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment), TuplesKt.to((Object)KtTokens.BLOCK_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment), TuplesKt.to((Object)KtTokens.DOC_COMMENT, (Object)((Object)KotlinElement.KDoc)), TuplesKt.to((Object)KtTokens.ARROW, (Object)((Object)KotlinElement.Arrow)), TuplesKt.to((Object)KtTokens.LONG_TEMPLATE_ENTRY_START, (Object)((Object)KotlinElement.TemplateEntryOpen)), TuplesKt.to((Object)KtTokens.LONG_TEMPLATE_ENTRY_END, (Object)((Object)KotlinElement.TemplateEntryClose)), TuplesKt.to((Object)KtTokens.INTERPOLATION_PREFIX, (Object)((Object)KotlinElement.OpenQuote)), TuplesKt.to((Object)KtTokens.OPEN_QUOTE, (Object)((Object)KotlinElement.OpenQuote)), TuplesKt.to((Object)KtTokens.CLOSING_QUOTE, (Object)((Object)KotlinElement.ClosingQuote)), TuplesKt.to((Object)KtTokens.LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace), TuplesKt.to((Object)KtTokens.RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)KtTokens.LPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis), TuplesKt.to((Object)KtTokens.RPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis), TuplesKt.to((Object)KtTokens.LBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket), TuplesKt.to((Object)KtTokens.RBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket), TuplesKt.to((Object)KtTokens.LT, (Object)((Object)KotlinElement.OpenTypeBrace)), TuplesKt.to((Object)KtTokens.GT, (Object)((Object)KotlinElement.CloseTypeBrace)), TuplesKt.to((Object)KtTokens.IF_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword), TuplesKt.to((Object)KtTokens.ELSE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword), TuplesKt.to((Object)KtTokens.WHEN_KEYWORD, (Object)((Object)KotlinElement.WhenKeyword)), TuplesKt.to((Object)KtTokens.TRY_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword), TuplesKt.to((Object)KtTokens.WHILE_KEYWORD, (Object)((Object)KotlinElement.WhileKeyword)), TuplesKt.to((Object)KtTokens.DO_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword), TuplesKt.to((Object)KtTokens.FOR_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword), TuplesKt.to((Object)KtTokens.REGULAR_STRING_PART, (Object)((Object)KotlinElement.RegularStringPart)), TuplesKt.to((Object)KtTokens.IDENTIFIER, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.GET_KEYWORD, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.SET_KEYWORD, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.CONSTRUCTOR_KEYWORD, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.CATCH_KEYWORD, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.CONTEXT_KEYWORD, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.FUN_KEYWORD, (Object)((Object)KotlinElement.FunctionKeyword)), TuplesKt.to((Object)KtTokens.DOT, (Object)((Object)KotlinElement.Dot)), TuplesKt.to((Object)KtTokens.QUEST, (Object)((Object)KotlinElement.Quest)), TuplesKt.to((Object)KtTokens.COMMA, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma), TuplesKt.to((Object)KtTokens.COLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon), TuplesKt.to((Object)KtTokens.EQ, (Object)((Object)KotlinElement.Eq)), TuplesKt.to((Object)KtTokens.VAL_KEYWORD, (Object)((Object)KotlinElement.Val)), TuplesKt.to((Object)KtTokens.VAR_KEYWORD, (Object)((Object)KotlinElement.Var)), TuplesKt.to((Object)KtTokens.INTEGER_LITERAL, (Object)((Object)KotlinElement.Literal)), TuplesKt.to((Object)KtTokens.FLOAT_LITERAL, (Object)((Object)KotlinElement.Literal)), TuplesKt.to((Object)KtTokens.CHARACTER_LITERAL, (Object)((Object)KotlinElement.Literal))};
        SYNTAX_MAP = MapsKt.hashMapOf((Pair[])objectArray);
        objectArray = new SemanticEditorPosition.SyntaxElement[]{KotlinElement.WhenKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword, KotlinElement.WhileKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword};
        CONTROL_FLOW_KEYWORDS = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment};
        WHITE_SPACE_OR_COMMENT_BIT_SET = objectArray;
        objectArray = new Pair[]{TuplesKt.to((Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis), TuplesKt.to((Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket)};
        PARENTHESES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010\u001a\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001f\u0010 \u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0082\u0010J6\u0010\"\u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00152\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00152\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\u0015H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0015H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00152\u0006\u00104\u001a\u00020\u0015H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00102\u001a\u00020\u0015H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00152\u0006\u00102\u001a\u00020\u0015H\u0002J\u0018\u00107\u001a\u0002012\u0006\u00102\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0002J\f\u00108\u001a\u000201*\u00020\u0015H\u0002J\f\u00109\u001a\u000201*\u00020\u0015H\u0002J\u0014\u0010:\u001a\u000201*\u00020\u00152\u0006\u0010;\u001a\u000201H\u0002J\u0010\u0010<\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u0010=\u001a\u00020&2\u0006\u00104\u001a\u00020\u0015H\u0002J\f\u0010>\u001a\u000201*\u00020\u0015H\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0002J\f\u0010@\u001a\u000201*\u00020\u0015H\u0002J\f\u0010A\u001a\u000201*\u00020\u0015H\u0002J\f\u0010B\u001a\u000201*\u00020\u0015H\u0002J\f\u0010C\u001a\u000201*\u00020\u0015H\u0002J\f\u0010D\u001a\u000201*\u00020\u0015H\u0002J\f\u0010E\u001a\u00020F*\u00020\u0015H\u0002J\f\u0010G\u001a\u00020F*\u00020\u0015H\u0002J\f\u0010H\u001a\u00020F*\u00020\u0015H\u0002J\f\u0010I\u001a\u00020F*\u00020\u0015H\u0002J\u0019\u0010J\u001a\n K*\u0004\u0018\u00010\u00150\u0015*\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010LJ\u0019\u0010M\u001a\n K*\u0004\u0018\u00010\u00150\u0015*\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010LJ\f\u0010N\u001a\u000201*\u00020\u0015H\u0002J\f\u0010O\u001a\u000201*\u00020\u0015H\u0002J\f\u0010P\u001a\u000201*\u00020\u0015H\u0002J\f\u0010Q\u001a\u000201*\u00020\u0015H\u0002J\f\u0010R\u001a\u000201*\u00020\u0015H\u0002J\f\u0010S\u001a\u000201*\u00020\u0015H\u0002J\u001c\u0010S\u001a\u000201*\u00020\u00152\u0006\u00102\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider$Companion;", "", "<init>", "()V", "SYNTAX_MAP", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "CONTROL_FLOW_KEYWORDS", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "WHITE_SPACE_OR_COMMENT_BIT_SET", "", "[Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "PARENTHESES", "", "Lkotlin/Pair;", "createIndentCalculatorForArrow", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider$IndentCalculatorFactory;", "arrowPosition", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition;", "after", "createIndentCalculatorForArrowInsideWhenEntry", "settings", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinIndentationAdjuster;", "createIndentCalculatorForBrace", "before", "leftBraceType", "rightBraceType", "defaultIndent", "Lcom/intellij/formatting/Indent;", "createIndentCalculatorForDot", "beforeDotPosition", "createIndentCalculatorForParenthesis", "currentPosition", "rightParenthesis", "offset", "", "findContextReceiverListBefore", "findFunctionOrPropertyOrMultiDeclarationBefore", "endOfDeclaration", "findMultiDeclarationBeforeAssignment", "findPropertyDeclarationBeforeAssignment", "findFunctionDeclarationBeforeBody", "findPropertyKeywordBeforeIdentifier", "identifierPosition", "findFunctionKeywordBeforeIdentifier", "isSimilarToFunctionInvocation", "", "leftParenthesis", "findCalleeOrReference", "position", "findCalleeOrReferenceBeforeLeftParenthesis", "moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible", "isDestructuringDeclaration", "moveBeforeParametersIfPossible", "moveBeforeParameterIfPossible", "moveBeforeTypeQualifierIfPossible", "canStartWithTypeParameter", "createAlignMultilineIndent", "calculateLineOffset", "isWhileInsideDoWhile", "controlFlowStatementBefore", "isControlFlowKeyword", "similarToCatchKeyword", "similarToPropertyAccessorKeyword", "isCatchKeyword", "isFinallyKeyword", "moveBeforeWhileThisIsWhiteSpaceOrComment", "", "moveAfterWhileThisIsWhiteSpaceOrComment", "moveBeforeIgnoringWhiteSpaceOrComment", "moveAfterIgnoringWhiteSpaceOrComment", "beforeIgnoringWhiteSpaceOrComment", "kotlin.jvm.PlatformType", "(Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition;)Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition;", "afterIgnoringWhiteSpaceOrComment", "moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment", "isIdentifier", "isVarOrVal", "moveBeforeBlockIfPossible", "moveBeforeTypeParametersIfPossible", "moveBeforeParenthesesIfPossible", "kotlin.base.code-insight.minimal"})
    @SourceDebugExtension(value={"SMAP\nKotlinLangLineIndentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLangLineIndentProvider.kt\norg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,900:1\n1#2:901\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final IndentCalculator createIndentCalculatorForArrow(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForArrow, SemanticEditorPosition arrowPosition, SemanticEditorPosition after) {
            IndentCalculator indentCalculator;
            SemanticEditorPosition leftBrace = arrowPosition.copyAnd(arg_0 -> Companion.createIndentCalculatorForArrow$lambda$1(Companion::createIndentCalculatorForArrow$lambda$0, arg_0));
            if (leftBrace.isAtEnd()) {
                return null;
            }
            Indent normalIndent = Indent.getNormalIndent();
            Intrinsics.checkNotNull((Object)leftBrace);
            if (this.controlFlowStatementBefore(leftBrace) != null) {
                Intrinsics.checkNotNull((Object)normalIndent);
                indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForArrow, normalIndent, arrowPosition.getStartOffset());
            } else {
                SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace;
                SemanticEditorPosition.SyntaxElement syntaxElement2 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace;
                Intrinsics.checkNotNull((Object)normalIndent);
                indentCalculator = this.createIndentCalculatorForBrace($this$createIndentCalculatorForArrow, leftBrace, after, syntaxElement, syntaxElement2, normalIndent);
            }
            return indentCalculator;
        }

        private final IndentCalculator createIndentCalculatorForArrowInsideWhenEntry(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForArrowInsideWhenEntry, SemanticEditorPosition arrowPosition, KotlinIndentationAdjuster settings) {
            IndentCalculator indentCalculator;
            SemanticEditorPosition leftBrace = arrowPosition.copyAnd(arg_0 -> Companion.createIndentCalculatorForArrowInsideWhenEntry$lambda$3(Companion::createIndentCalculatorForArrowInsideWhenEntry$lambda$2, arg_0));
            Indent indent = settings.getIndentBeforeArrowOnNewLine() ? Indent.getNormalIndent() : Indent.getNoneIndent();
            Intrinsics.checkNotNull((Object)leftBrace);
            SemanticEditorPosition controlFlowStatementBefore = this.controlFlowStatementBefore(leftBrace);
            if (controlFlowStatementBefore != null && controlFlowStatementBefore.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.WhenKeyword)) {
                Intrinsics.checkNotNull((Object)indent);
                indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForArrowInsideWhenEntry, indent, arrowPosition.getStartOffset());
            } else {
                indentCalculator = null;
            }
            return indentCalculator;
        }

        private final IndentCalculator createIndentCalculatorForBrace(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForBrace, SemanticEditorPosition before2, SemanticEditorPosition after, SemanticEditorPosition.SyntaxElement leftBraceType, SemanticEditorPosition.SyntaxElement rightBraceType, Indent defaultIndent) {
            Object object;
            block9: {
                SemanticEditorPosition leftBrace;
                block8: {
                    SemanticEditorPosition semanticEditorPosition;
                    SemanticEditorPosition leftAnchor;
                    SemanticEditorPosition semanticEditorPosition2;
                    SemanticEditorPosition beforeLeftBrace;
                    leftBrace = before2.copyAnd(arg_0 -> Companion.createIndentCalculatorForBrace$lambda$5(arg_0 -> Companion.createIndentCalculatorForBrace$lambda$4(leftBraceType, rightBraceType, arg_0), arg_0));
                    if (leftBrace.isAtEnd()) {
                        return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForBrace, defaultIndent, 0);
                    }
                    boolean hasCommaAfterClosingBrace = this.afterIgnoringWhiteSpaceOrComment(after).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
                    if (hasCommaAfterClosingBrace) {
                        boolean isEmptyBlock;
                        boolean bl = isEmptyBlock = before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) && after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
                        if (!isEmptyBlock) {
                            Intrinsics.checkNotNull((Object)leftBrace);
                            return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForBrace, this.createAlignMultilineIndent(leftBrace), leftBrace.getStartOffset());
                        }
                    }
                    if ((beforeLeftBrace = leftBrace.copyAnd(arg_0 -> Companion.createIndentCalculatorForBrace$lambda$7(Companion::createIndentCalculatorForBrace$lambda$6, arg_0))).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                        beforeLeftBrace.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
                        semanticEditorPosition2 = beforeLeftBrace;
                    } else {
                        Intrinsics.checkNotNull((Object)beforeLeftBrace);
                        semanticEditorPosition2 = this.findFunctionDeclarationBeforeBody(beforeLeftBrace);
                    }
                    if ((object = (leftAnchor = semanticEditorPosition2)) == null) break block8;
                    SemanticEditorPosition it = semanticEditorPosition = object;
                    boolean bl = false;
                    object = !it.isAtEnd() ? semanticEditorPosition : null;
                    if (object != null) break block9;
                }
                object = leftBrace;
            }
            SemanticEditorPosition resultPosition = object;
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForBrace, defaultIndent, resultPosition.getStartOffset());
        }

        private final IndentCalculator createIndentCalculatorForDot(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForDot, SemanticEditorPosition beforeDotPosition, KotlinIndentationAdjuster settings) {
            IndentCalculator indentCalculator;
            SemanticEditorPosition copyOfCalleeOrReference;
            SemanticEditorPosition calleeOrReference;
            Companion companion = this;
            while (true) {
                SemanticEditorPosition semanticEditorPosition = calleeOrReference = beforeDotPosition.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Literal) ? beforeDotPosition : (beforeDotPosition.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.ClosingQuote) ? beforeDotPosition.before().findLeftParenthesisBackwardsSkippingNested((SemanticEditorPosition.SyntaxElement)KotlinElement.OpenQuote, (SemanticEditorPosition.SyntaxElement)KotlinElement.ClosingQuote) : companion.findCalleeOrReference(beforeDotPosition));
                if (!(semanticEditorPosition != null ? !semanticEditorPosition.isAtEnd() : false)) {
                    return null;
                }
                copyOfCalleeOrReference = calleeOrReference.copy();
                calleeOrReference.moveBefore();
                if (!companion.moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment(calleeOrReference) || calleeOrReference.isAtEnd()) {
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForDot, KotlinLangLineIndentProviderKt.access$getIndentForChainedCalls(settings), copyOfCalleeOrReference.getStartOffset());
                }
                if (!calleeOrReference.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot)) break;
                SemanticEditorPosition before2 = calleeOrReference.copyAnd(arg_0 -> Companion.createIndentCalculatorForDot$lambda$9(createIndentCalculatorForDot.before.1.INSTANCE, arg_0));
                if (before2.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Quest)) {
                    before2.moveBefore();
                }
                Intrinsics.checkNotNull((Object)before2);
                if (!companion.moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment(before2)) {
                    Indent indent = Indent.getNoneIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getNoneIndent(...)");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForDot, indent, calleeOrReference.getStartOffset());
                }
                Companion companion2 = companion;
                JavaLikeLangLineIndentProvider.IndentCalculatorFactory indentCalculatorFactory = $this$createIndentCalculatorForDot;
                SemanticEditorPosition semanticEditorPosition2 = before2;
                KotlinIndentationAdjuster kotlinIndentationAdjuster = settings;
                companion = companion2;
                $this$createIndentCalculatorForDot = indentCalculatorFactory;
                beforeDotPosition = semanticEditorPosition2;
                settings = kotlinIndentationAdjuster;
            }
            if (settings.getAlignMultilineParametersInCalls() && calleeOrReference.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                Indent indent = KotlinLangLineIndentProviderKt.access$getIndentForChainedCalls(settings);
                CharSequence charSequence = " ";
                int n = copyOfCalleeOrReference.getStartOffset();
                Intrinsics.checkNotNull((Object)copyOfCalleeOrReference);
                indentCalculator = $this$createIndentCalculatorForDot.createIndentCalculatorWithCustomBaseIndent(indent, StringsKt.repeat((CharSequence)charSequence, (int)(n - companion.calculateLineOffset(copyOfCalleeOrReference))));
            } else {
                indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForDot, KotlinLangLineIndentProviderKt.access$getIndentForChainedCalls(settings), calleeOrReference.getStartOffset());
            }
            return indentCalculator;
        }

        private final IndentCalculator createIndentCalculatorForParenthesis(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForParenthesis, SemanticEditorPosition before2, SemanticEditorPosition currentPosition, SemanticEditorPosition rightParenthesis, int offset, KotlinIndentationAdjuster settings) {
            IndentCalculator indentCalculator;
            Indent indent;
            Indent indent2;
            boolean bl = rightParenthesis.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            SemanticEditorPosition leftParenthesis = currentPosition.findLeftParenthesisBackwardsSkippingNested((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            if (!leftParenthesis.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                return null;
            }
            boolean hasLineBreaksAfter = currentPosition.hasLineBreaksAfter(offset);
            Intrinsics.checkNotNull((Object)leftParenthesis);
            SemanticEditorPosition semanticEditorPosition = this.beforeIgnoringWhiteSpaceOrComment(leftParenthesis);
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition, (String)"beforeIgnoringWhiteSpaceOrComment(...)");
            SemanticEditorPosition semanticEditorPosition2 = this.findFunctionKeywordBeforeIdentifier(semanticEditorPosition);
            if (semanticEditorPosition2 != null) {
                SemanticEditorPosition it = semanticEditorPosition2;
                boolean bl2 = false;
                return org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider$Companion.createIndentCalculatorForParenthesis$createIndent(before2, hasLineBreaksAfter, leftParenthesis, settings, $this$createIndentCalculatorForParenthesis, true, it.getStartOffset());
            }
            if (this.isSimilarToFunctionInvocation(leftParenthesis)) {
                return org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider$Companion.createIndentCalculatorForParenthesis$createIndent(before2, hasLineBreaksAfter, leftParenthesis, settings, $this$createIndentCalculatorForParenthesis, false, leftParenthesis.getStartOffset());
            }
            if (this.isDestructuringDeclaration(leftParenthesis, rightParenthesis)) {
                semanticEditorPosition2 = before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma) || hasLineBreaksAfter ? Indent.getNormalIndent() : Indent.getNoneIndent();
                Intrinsics.checkNotNull((Object)semanticEditorPosition2);
                return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, (Indent)semanticEditorPosition2, leftParenthesis.getStartOffset());
            }
            SemanticEditorPosition keyword = this.beforeIgnoringWhiteSpaceOrComment(leftParenthesis);
            boolean bl3 = false;
            if (keyword.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword) && !before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                indent2 = settings.getContinuationIndentInIfCondition() ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            } else {
                Intrinsics.checkNotNull((Object)keyword);
                indent2 = Companion.isControlFlowKeyword(keyword) ? (hasLineBreaksAfter ? Indent.getNormalIndent() : Indent.getNoneIndent()) : null;
            }
            Indent indent3 = indent = indent2;
            if (indent3 != null) {
                Indent it = indent3;
                boolean bl4 = false;
                return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, it, keyword.getStartOffset());
            }
            if (settings.getAlignWhenMultilineBinaryExpression() && !hasLineBreaksAfter) {
                SemanticEditorPosition anchor = before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) ? leftParenthesis : this.afterIgnoringWhiteSpaceOrComment(leftParenthesis);
                Intrinsics.checkNotNull((Object)anchor);
                indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, this.createAlignMultilineIndent(anchor), anchor.getStartOffset());
            } else {
                Indent indent4 = Indent.getContinuationIndent();
                Intrinsics.checkNotNullExpressionValue((Object)indent4, (String)"getContinuationIndent(...)");
                indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, indent4, leftParenthesis.getStartOffset());
            }
            return indentCalculator;
        }

        private final SemanticEditorPosition findContextReceiverListBefore(SemanticEditorPosition before2) {
            SemanticEditorPosition semanticEditorPosition;
            if (!before2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                return null;
            }
            SemanticEditorPosition $this$findContextReceiverListBefore_u24lambda_u2413 = semanticEditorPosition = before2.copy();
            boolean bl = false;
            $this$findContextReceiverListBefore_u24lambda_u2413.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            SemanticEditorPosition probableContextReceiverKeyword = semanticEditorPosition;
            if (probableContextReceiverKeyword.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier) && probableContextReceiverKeyword.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                Intrinsics.checkNotNull((Object)probableContextReceiverKeyword);
                if (Intrinsics.areEqual((Object)KotlinLangLineIndentProviderKt.access$textOfCurrentPosition(probableContextReceiverKeyword), (Object)KtTokens.CONTEXT_KEYWORD.getValue())) {
                    return probableContextReceiverKeyword;
                }
            }
            return null;
        }

        private final SemanticEditorPosition findFunctionOrPropertyOrMultiDeclarationBefore(SemanticEditorPosition endOfDeclaration) {
            SemanticEditorPosition semanticEditorPosition = this.findFunctionDeclarationBeforeBody(endOfDeclaration);
            if (semanticEditorPosition == null && (semanticEditorPosition = this.findPropertyDeclarationBeforeAssignment(endOfDeclaration)) == null) {
                semanticEditorPosition = this.findMultiDeclarationBeforeAssignment(endOfDeclaration);
            }
            return semanticEditorPosition;
        }

        private final SemanticEditorPosition findMultiDeclarationBeforeAssignment(SemanticEditorPosition rightParenthesis) {
            SemanticEditorPosition semanticEditorPosition;
            if (!rightParenthesis.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                return null;
            }
            SemanticEditorPosition $this$findMultiDeclarationBeforeAssignment_u24lambda_u2415 = rightParenthesis.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$findMultiDeclarationBeforeAssignment_u24lambda_u2415);
            if (!Companion.moveBeforeParenthesesIfPossible($this$findMultiDeclarationBeforeAssignment_u24lambda_u2415)) {
                return null;
            }
            SemanticEditorPosition it = semanticEditorPosition = $this$findMultiDeclarationBeforeAssignment_u24lambda_u2415;
            boolean bl2 = false;
            return Companion.isVarOrVal($this$findMultiDeclarationBeforeAssignment_u24lambda_u2415) ? semanticEditorPosition : null;
        }

        private final SemanticEditorPosition findPropertyDeclarationBeforeAssignment(SemanticEditorPosition endOfDeclaration) {
            SemanticEditorPosition semanticEditorPosition;
            if (endOfDeclaration.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier) && (semanticEditorPosition = this.findPropertyKeywordBeforeIdentifier(endOfDeclaration)) != null) {
                SemanticEditorPosition it = semanticEditorPosition;
                boolean bl = false;
                return it;
            }
            SemanticEditorPosition $this$findPropertyDeclarationBeforeAssignment_u24lambda_u2417 = endOfDeclaration.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$findPropertyDeclarationBeforeAssignment_u24lambda_u2417);
            if (Companion.moveBeforeTypeQualifierIfPossible($this$findPropertyDeclarationBeforeAssignment_u24lambda_u2417, true)) {
                if (!$this$findPropertyDeclarationBeforeAssignment_u24lambda_u2417.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
                    return null;
                }
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$findPropertyDeclarationBeforeAssignment_u24lambda_u2417);
            }
            return Companion.findPropertyKeywordBeforeIdentifier($this$findPropertyDeclarationBeforeAssignment_u24lambda_u2417);
        }

        private final SemanticEditorPosition findFunctionDeclarationBeforeBody(SemanticEditorPosition endOfDeclaration) {
            SemanticEditorPosition $this$findFunctionDeclarationBeforeBody_u24lambda_u2418 = endOfDeclaration.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$findFunctionDeclarationBeforeBody_u24lambda_u2418);
            if (Companion.moveBeforeTypeQualifierIfPossible($this$findFunctionDeclarationBeforeBody_u24lambda_u2418, true)) {
                if (!$this$findFunctionDeclarationBeforeBody_u24lambda_u2418.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
                    return null;
                }
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$findFunctionDeclarationBeforeBody_u24lambda_u2418);
            }
            if (!Companion.moveBeforeParenthesesIfPossible($this$findFunctionDeclarationBeforeBody_u24lambda_u2418)) {
                return null;
            }
            return Companion.findFunctionKeywordBeforeIdentifier($this$findFunctionDeclarationBeforeBody_u24lambda_u2418);
        }

        private final SemanticEditorPosition findPropertyKeywordBeforeIdentifier(SemanticEditorPosition identifierPosition) {
            SemanticEditorPosition semanticEditorPosition;
            if (!identifierPosition.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return null;
            }
            SemanticEditorPosition $this$findPropertyKeywordBeforeIdentifier_u24lambda_u2420 = identifierPosition.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$findPropertyKeywordBeforeIdentifier_u24lambda_u2420);
            if (!Companion.moveBeforeTypeQualifierIfPossible($this$findPropertyKeywordBeforeIdentifier_u24lambda_u2420, false)) {
                return null;
            }
            Companion.moveBeforeTypeParametersIfPossible($this$findPropertyKeywordBeforeIdentifier_u24lambda_u2420);
            SemanticEditorPosition it = semanticEditorPosition = $this$findPropertyKeywordBeforeIdentifier_u24lambda_u2420;
            boolean bl2 = false;
            return Companion.isVarOrVal(it) ? semanticEditorPosition : null;
        }

        private final SemanticEditorPosition findFunctionKeywordBeforeIdentifier(SemanticEditorPosition identifierPosition) {
            SemanticEditorPosition semanticEditorPosition;
            if (identifierPosition.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.FunctionKeyword)) {
                return identifierPosition;
            }
            SemanticEditorPosition $this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422 = identifierPosition.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422);
            Companion.moveBeforeWhileThisIsWhiteSpaceOrComment($this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422);
            if ($this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot)) {
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422);
                if (!Companion.moveBeforeTypeQualifierIfPossible($this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422, true)) {
                    return null;
                }
                return $this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.FunctionKeyword) ? $this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422 : null;
            }
            if (!$this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return null;
            }
            if (!Companion.moveBeforeTypeQualifierIfPossible($this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422, false)) {
                return null;
            }
            Companion.moveBeforeTypeParametersIfPossible($this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422);
            SemanticEditorPosition it = semanticEditorPosition = $this$findFunctionKeywordBeforeIdentifier_u24lambda_u2422;
            boolean bl2 = false;
            return it.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.FunctionKeyword) ? semanticEditorPosition : null;
        }

        private final boolean isSimilarToFunctionInvocation(SemanticEditorPosition leftParenthesis) {
            return this.findCalleeOrReferenceBeforeLeftParenthesis(leftParenthesis) != null;
        }

        private final SemanticEditorPosition findCalleeOrReference(SemanticEditorPosition position) {
            if (position.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return position.copy();
            }
            for (Pair pair : PARENTHESES) {
                SemanticEditorPosition.SyntaxElement left = (SemanticEditorPosition.SyntaxElement)pair.component1();
                SemanticEditorPosition.SyntaxElement right = (SemanticEditorPosition.SyntaxElement)pair.component2();
                if (position.isAt(left)) {
                    return this.findCalleeOrReferenceBeforeLeftParenthesis(position);
                }
                if (!position.isAt(right)) continue;
                SemanticEditorPosition leftParenthesis = position.copyAnd(arg_0 -> Companion.findCalleeOrReference$lambda$24(arg_0 -> Companion.findCalleeOrReference$lambda$23(left, right, arg_0), arg_0));
                Intrinsics.checkNotNull((Object)leftParenthesis);
                return this.moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible(leftParenthesis);
            }
            return null;
        }

        private final SemanticEditorPosition findCalleeOrReferenceBeforeLeftParenthesis(SemanticEditorPosition leftParenthesis) {
            SemanticEditorPosition p0 = leftParenthesis.copy();
            boolean $i$f$findCalleeOrReferenceBeforeLeftParenthesis$stub_for_inlining = false;
            boolean bl = false;
            return this.moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible(p0);
        }

        private final SemanticEditorPosition moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible(SemanticEditorPosition leftParenthesis) {
            SemanticEditorPosition.SyntaxElement[] syntaxElementArray;
            SemanticEditorPosition $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427 = leftParenthesis;
            boolean bl = false;
            SemanticEditorPosition semanticEditorPosition = new SemanticEditorPosition[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace};
            boolean canBeWithTypeBraces = leftParenthesis.isAtAnyOf((SemanticEditorPosition.SyntaxElement[])semanticEditorPosition);
            $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427.moveBefore();
            if (!Companion.moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment($this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427) || $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427.isAtEnd()) {
                return null;
            }
            if ($this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.CloseTypeBrace) && canBeWithTypeBraces) {
                $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)KotlinElement.OpenTypeBrace, (SemanticEditorPosition.SyntaxElement)KotlinElement.CloseTypeBrace);
                SemanticEditorPosition it = semanticEditorPosition = $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427;
                boolean bl2 = false;
                return Companion.moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment($this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427) && Companion.isIdentifier($this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427) ? semanticEditorPosition : null;
            }
            SemanticEditorPosition it = semanticEditorPosition = $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427;
            boolean bl3 = false;
            return Companion.isIdentifier($this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427) || $this$moveToCalleeOrReferenceBeforeLeftParenthesisIfPossible_u24lambda_u2427.isAtAnyOf(syntaxElementArray = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket}) ? semanticEditorPosition : null;
        }

        private final boolean isDestructuringDeclaration(SemanticEditorPosition leftParenthesis, SemanticEditorPosition rightParenthesis) {
            SemanticEditorPosition $this$isDestructuringDeclaration_u24lambda_u2428 = leftParenthesis.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$isDestructuringDeclaration_u24lambda_u2428);
            Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$isDestructuringDeclaration_u24lambda_u2428);
            if (Companion.isVarOrVal($this$isDestructuringDeclaration_u24lambda_u2428)) {
                return true;
            }
            if (!Companion.moveBeforeParametersIfPossible(rightParenthesis)) {
                return false;
            }
            return $this$isDestructuringDeclaration_u24lambda_u2428.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        }

        private final boolean moveBeforeParametersIfPossible(SemanticEditorPosition $this$moveBeforeParametersIfPossible) {
            while (!$this$moveBeforeParametersIfPossible.isAtEnd()) {
                if (!this.moveBeforeParameterIfPossible($this$moveBeforeParametersIfPossible)) {
                    return false;
                }
                if (!$this$moveBeforeParametersIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
                    return true;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeParametersIfPossible);
            }
            return false;
        }

        private final boolean moveBeforeParameterIfPossible(SemanticEditorPosition $this$moveBeforeParameterIfPossible) {
            if ($this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                return this.moveBeforeParenthesesIfPossible($this$moveBeforeParameterIfPossible);
            }
            if (!this.moveBeforeTypeQualifierIfPossible($this$moveBeforeParameterIfPossible, true)) {
                return false;
            }
            if ($this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeParameterIfPossible);
                if ($this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                    return this.moveBeforeParenthesesIfPossible($this$moveBeforeParameterIfPossible);
                }
                if (!$this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                    return false;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeParameterIfPossible);
            }
            return true;
        }

        private final boolean moveBeforeTypeQualifierIfPossible(SemanticEditorPosition $this$moveBeforeTypeQualifierIfPossible, boolean canStartWithTypeParameter) {
            if (!canStartWithTypeParameter && !$this$moveBeforeTypeQualifierIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return false;
            }
            while (!$this$moveBeforeTypeQualifierIfPossible.isAtEnd()) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)KotlinElement.Quest);
                spreadBuilder.addSpread((Object)WHITE_SPACE_OR_COMMENT_BIT_SET);
                $this$moveBeforeTypeQualifierIfPossible.moveBeforeOptionalMix((SemanticEditorPosition.SyntaxElement[])spreadBuilder.toArray((Object[])new SemanticEditorPosition.SyntaxElement[spreadBuilder.size()]));
                this.moveBeforeTypeParametersIfPossible($this$moveBeforeTypeQualifierIfPossible);
                if (!$this$moveBeforeTypeQualifierIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                    return false;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeTypeQualifierIfPossible);
                if (!$this$moveBeforeTypeQualifierIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot)) {
                    return true;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeTypeQualifierIfPossible);
            }
            return false;
        }

        private final Indent createAlignMultilineIndent(SemanticEditorPosition position) {
            int beforeLineStart = this.calculateLineOffset(position);
            int beforeLineWithoutIndentStart = CharArrayUtil.shiftForward((CharSequence)position.getChars(), (int)beforeLineStart, (String)" \t");
            Indent indent = Indent.getSpaceIndent((int)(position.getStartOffset() - beforeLineWithoutIndentStart));
            Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getSpaceIndent(...)");
            return indent;
        }

        private final int calculateLineOffset(SemanticEditorPosition position) {
            return CharArrayUtil.shiftBackwardUntil((CharSequence)position.getChars(), (int)position.getStartOffset(), (String)"\n") + 1;
        }

        private final boolean isWhileInsideDoWhile(SemanticEditorPosition $this$isWhileInsideDoWhile) {
            if (!$this$isWhileInsideDoWhile.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.WhileKeyword)) {
                return false;
            }
            SemanticEditorPosition $this$isWhileInsideDoWhile_u24lambda_u2429 = $this$isWhileInsideDoWhile.copy();
            boolean bl = false;
            $this$isWhileInsideDoWhile_u24lambda_u2429.moveBefore();
            int whileKeywordLevel = 1;
            while (!$this$isWhileInsideDoWhile_u24lambda_u2429.isAtEnd()) {
                if ($this$isWhileInsideDoWhile_u24lambda_u2429.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    return false;
                }
                if ($this$isWhileInsideDoWhile_u24lambda_u2429.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword)) {
                    if (--whileKeywordLevel == 0) {
                        return true;
                    }
                    $this$isWhileInsideDoWhile_u24lambda_u2429.moveBefore();
                    continue;
                }
                if ($this$isWhileInsideDoWhile_u24lambda_u2429.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.WhileKeyword)) {
                    ++whileKeywordLevel;
                    $this$isWhileInsideDoWhile_u24lambda_u2429.moveBefore();
                    continue;
                }
                if ($this$isWhileInsideDoWhile_u24lambda_u2429.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) {
                    $this$isWhileInsideDoWhile_u24lambda_u2429.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
                    continue;
                }
                $this$isWhileInsideDoWhile_u24lambda_u2429.moveBefore();
            }
            return false;
        }

        private final SemanticEditorPosition controlFlowStatementBefore(SemanticEditorPosition $this$controlFlowStatementBefore) {
            SemanticEditorPosition semanticEditorPosition;
            SemanticEditorPosition $this$controlFlowStatementBefore_u24lambda_u2431 = $this$controlFlowStatementBefore.copy();
            boolean bl = false;
            if ($this$controlFlowStatementBefore_u24lambda_u2431.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                Intrinsics.checkNotNull((Object)$this$controlFlowStatementBefore_u24lambda_u2431);
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$controlFlowStatementBefore_u24lambda_u2431);
            }
            Intrinsics.checkNotNull((Object)$this$controlFlowStatementBefore_u24lambda_u2431);
            if (Companion.isControlFlowKeyword($this$controlFlowStatementBefore_u24lambda_u2431)) {
                return $this$controlFlowStatementBefore_u24lambda_u2431;
            }
            if (!Companion.moveBeforeParenthesesIfPossible($this$controlFlowStatementBefore_u24lambda_u2431)) {
                return null;
            }
            SemanticEditorPosition it = semanticEditorPosition = $this$controlFlowStatementBefore_u24lambda_u2431;
            boolean bl2 = false;
            return Companion.isControlFlowKeyword($this$controlFlowStatementBefore_u24lambda_u2431) ? semanticEditorPosition : null;
        }

        private final boolean isControlFlowKeyword(SemanticEditorPosition $this$isControlFlowKeyword) {
            return CollectionsKt.contains((Iterable)CONTROL_FLOW_KEYWORDS, (Object)$this$isControlFlowKeyword.getCurrElement()) || this.isCatchKeyword($this$isControlFlowKeyword) || this.isFinallyKeyword($this$isControlFlowKeyword);
        }

        private final boolean similarToCatchKeyword(SemanticEditorPosition $this$similarToCatchKeyword) {
            return Intrinsics.areEqual((Object)KotlinLangLineIndentProviderKt.access$textOfCurrentPosition($this$similarToCatchKeyword), (Object)KtTokens.CATCH_KEYWORD.getValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean similarToPropertyAccessorKeyword(SemanticEditorPosition $this$similarToPropertyAccessorKeyword) {
            if (!$this$similarToPropertyAccessorKeyword.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) return false;
            String text = KotlinLangLineIndentProviderKt.access$textOfCurrentPosition($this$similarToPropertyAccessorKeyword);
            boolean bl = false;
            if (Intrinsics.areEqual((Object)text, (Object)KtTokens.GET_KEYWORD.getValue())) return true;
            if (!Intrinsics.areEqual((Object)text, (Object)KtTokens.SET_KEYWORD.getValue())) return false;
            return true;
        }

        private final boolean isCatchKeyword(SemanticEditorPosition $this$isCatchKeyword) {
            SemanticEditorPosition $this$isCatchKeyword_u24lambda_u2433 = $this$isCatchKeyword.copy();
            boolean bl = false;
            do {
                if (!$this$isCatchKeyword_u24lambda_u2433.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)$this$isCatchKeyword_u24lambda_u2433);
                if (!Companion.similarToCatchKeyword($this$isCatchKeyword_u24lambda_u2433)) {
                    return false;
                }
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$isCatchKeyword_u24lambda_u2433);
                if (!Companion.moveBeforeBlockIfPossible($this$isCatchKeyword_u24lambda_u2433)) {
                    return false;
                }
                if ($this$isCatchKeyword_u24lambda_u2433.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword)) {
                    return true;
                }
                if (Companion.moveBeforeParenthesesIfPossible($this$isCatchKeyword_u24lambda_u2433)) continue;
                return false;
            } while (!$this$isCatchKeyword_u24lambda_u2433.isAtEnd());
            return false;
        }

        private final boolean isFinallyKeyword(SemanticEditorPosition $this$isFinallyKeyword) {
            if (!$this$isFinallyKeyword.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)KotlinLangLineIndentProviderKt.access$textOfCurrentPosition($this$isFinallyKeyword), (Object)KtTokens.FINALLY_KEYWORD.getValue())) {
                return false;
            }
            SemanticEditorPosition $this$isFinallyKeyword_u24lambda_u2434 = $this$isFinallyKeyword.copy();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$isFinallyKeyword_u24lambda_u2434);
            Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$isFinallyKeyword_u24lambda_u2434);
            if (!Companion.moveBeforeBlockIfPossible($this$isFinallyKeyword_u24lambda_u2434)) {
                return false;
            }
            if ($this$isFinallyKeyword_u24lambda_u2434.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword)) {
                return true;
            }
            if (!Companion.moveBeforeParenthesesIfPossible($this$isFinallyKeyword_u24lambda_u2434)) {
                return false;
            }
            return Companion.isCatchKeyword($this$isFinallyKeyword_u24lambda_u2434);
        }

        private final void moveBeforeWhileThisIsWhiteSpaceOrComment(SemanticEditorPosition $this$moveBeforeWhileThisIsWhiteSpaceOrComment) {
            SemanticEditorPosition.SyntaxElement[] syntaxElementArray = WHITE_SPACE_OR_COMMENT_BIT_SET;
            $this$moveBeforeWhileThisIsWhiteSpaceOrComment.moveBeforeOptionalMix(Arrays.copyOf(syntaxElementArray, syntaxElementArray.length));
        }

        private final void moveAfterWhileThisIsWhiteSpaceOrComment(SemanticEditorPosition $this$moveAfterWhileThisIsWhiteSpaceOrComment) {
            SemanticEditorPosition.SyntaxElement[] syntaxElementArray = WHITE_SPACE_OR_COMMENT_BIT_SET;
            $this$moveAfterWhileThisIsWhiteSpaceOrComment.moveAfterOptionalMix(Arrays.copyOf(syntaxElementArray, syntaxElementArray.length));
        }

        private final void moveBeforeIgnoringWhiteSpaceOrComment(SemanticEditorPosition $this$moveBeforeIgnoringWhiteSpaceOrComment) {
            $this$moveBeforeIgnoringWhiteSpaceOrComment.moveBefore();
            this.moveBeforeWhileThisIsWhiteSpaceOrComment($this$moveBeforeIgnoringWhiteSpaceOrComment);
        }

        private final void moveAfterIgnoringWhiteSpaceOrComment(SemanticEditorPosition $this$moveAfterIgnoringWhiteSpaceOrComment) {
            $this$moveAfterIgnoringWhiteSpaceOrComment.moveAfter();
            this.moveAfterWhileThisIsWhiteSpaceOrComment($this$moveAfterIgnoringWhiteSpaceOrComment);
        }

        private final SemanticEditorPosition beforeIgnoringWhiteSpaceOrComment(SemanticEditorPosition $this$beforeIgnoringWhiteSpaceOrComment) {
            return $this$beforeIgnoringWhiteSpaceOrComment.copyAnd(arg_0 -> Companion.beforeIgnoringWhiteSpaceOrComment$lambda$36(Companion::beforeIgnoringWhiteSpaceOrComment$lambda$35, arg_0));
        }

        private final SemanticEditorPosition afterIgnoringWhiteSpaceOrComment(SemanticEditorPosition $this$afterIgnoringWhiteSpaceOrComment) {
            return $this$afterIgnoringWhiteSpaceOrComment.copyAnd(arg_0 -> Companion.afterIgnoringWhiteSpaceOrComment$lambda$38(Companion::afterIgnoringWhiteSpaceOrComment$lambda$37, arg_0));
        }

        private final boolean moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment(SemanticEditorPosition $this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment) {
            while (!$this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAtEnd()) {
                if ($this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && $this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAtMultiline()) {
                    return false;
                }
                SemanticEditorPosition.SyntaxElement[] syntaxElementArray = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace};
                if (!$this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAtAnyOf(syntaxElementArray)) break;
                $this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.moveBefore();
            }
            return true;
        }

        private final boolean isIdentifier(SemanticEditorPosition $this$isIdentifier) {
            return $this$isIdentifier.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier) || $this$isIdentifier.isAt((IElementType)KtTokens.THIS_KEYWORD);
        }

        private final boolean isVarOrVal(SemanticEditorPosition $this$isVarOrVal) {
            SemanticEditorPosition.SyntaxElement[] syntaxElementArray = new SemanticEditorPosition.SyntaxElement[]{KotlinElement.Var, KotlinElement.Val};
            return $this$isVarOrVal.isAtAnyOf(syntaxElementArray);
        }

        private final boolean moveBeforeBlockIfPossible(SemanticEditorPosition $this$moveBeforeBlockIfPossible) {
            return this.moveBeforeParenthesesIfPossible($this$moveBeforeBlockIfPossible, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        }

        private final boolean moveBeforeTypeParametersIfPossible(SemanticEditorPosition $this$moveBeforeTypeParametersIfPossible) {
            return this.moveBeforeParenthesesIfPossible($this$moveBeforeTypeParametersIfPossible, KotlinElement.OpenTypeBrace, KotlinElement.CloseTypeBrace);
        }

        private final boolean moveBeforeParenthesesIfPossible(SemanticEditorPosition $this$moveBeforeParenthesesIfPossible) {
            return this.moveBeforeParenthesesIfPossible($this$moveBeforeParenthesesIfPossible, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        }

        private final boolean moveBeforeParenthesesIfPossible(SemanticEditorPosition $this$moveBeforeParenthesesIfPossible, SemanticEditorPosition.SyntaxElement leftParenthesis, SemanticEditorPosition.SyntaxElement rightParenthesis) {
            if (!$this$moveBeforeParenthesesIfPossible.isAt(rightParenthesis)) {
                return false;
            }
            $this$moveBeforeParenthesesIfPossible.moveBeforeParentheses(leftParenthesis, rightParenthesis);
            this.moveBeforeWhileThisIsWhiteSpaceOrComment($this$moveBeforeParenthesesIfPossible);
            return true;
        }

        private static final Unit createIndentCalculatorForArrow$lambda$0(SemanticEditorPosition it) {
            it.moveToLeftParenthesisBackwardsSkippingNested((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            return Unit.INSTANCE;
        }

        private static final void createIndentCalculatorForArrow$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit createIndentCalculatorForArrowInsideWhenEntry$lambda$2(SemanticEditorPosition it) {
            it.moveToLeftParenthesisBackwardsSkippingNested((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            return Unit.INSTANCE;
        }

        private static final void createIndentCalculatorForArrowInsideWhenEntry$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit createIndentCalculatorForBrace$lambda$4(SemanticEditorPosition.SyntaxElement $leftBraceType, SemanticEditorPosition.SyntaxElement $rightBraceType, SemanticEditorPosition it) {
            it.moveToLeftParenthesisBackwardsSkippingNested($leftBraceType, $rightBraceType);
            return Unit.INSTANCE;
        }

        private static final void createIndentCalculatorForBrace$lambda$5(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit createIndentCalculatorForBrace$lambda$6(SemanticEditorPosition it) {
            Intrinsics.checkNotNull((Object)it);
            Companion.moveBeforeIgnoringWhiteSpaceOrComment(it);
            return Unit.INSTANCE;
        }

        private static final void createIndentCalculatorForBrace$lambda$7(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void createIndentCalculatorForDot$lambda$9(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final IndentCalculator createIndentCalculatorForParenthesis$createIndent(SemanticEditorPosition $before, boolean hasLineBreaksAfter, SemanticEditorPosition leftParenthesis, KotlinIndentationAdjuster $settings, JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this_createIndentCalculatorForParenthesis, boolean isParameterList, int baseLineOffset) {
            Indent indent;
            if ($before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma) || hasLineBreaksAfter) {
                Intrinsics.checkNotNull((Object)leftParenthesis);
                SemanticEditorPosition firstElement = Companion.afterIgnoringWhiteSpaceOrComment(leftParenthesis);
                if (!firstElement.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) && (isParameterList && $settings.getAlignMultilineParameters() || !isParameterList && $settings.getAlignMultilineParametersInCalls())) {
                    Intrinsics.checkNotNull((Object)firstElement);
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this_createIndentCalculatorForParenthesis, Companion.createAlignMultilineIndent(firstElement), firstElement.getStartOffset());
                }
                indent = isParameterList && $settings.getContinuationIndentInParameterLists() || !isParameterList && $settings.getContinuationIndentInArgumentLists() ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            } else if ($settings.getAlignWhenMultilineFunctionParentheses()) {
                Intrinsics.checkNotNull((Object)leftParenthesis);
                indent = Companion.createAlignMultilineIndent(leftParenthesis);
            } else {
                indent = Indent.getNoneIndent();
            }
            Indent indent2 = indent;
            Intrinsics.checkNotNull((Object)indent2);
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this_createIndentCalculatorForParenthesis, indent2, baseLineOffset);
        }

        private static final Unit findCalleeOrReference$lambda$23(SemanticEditorPosition.SyntaxElement $left, SemanticEditorPosition.SyntaxElement $right, SemanticEditorPosition it) {
            it.moveBeforeParentheses($left, $right);
            it.moveAfter();
            return Unit.INSTANCE;
        }

        private static final void findCalleeOrReference$lambda$24(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit beforeIgnoringWhiteSpaceOrComment$lambda$35(SemanticEditorPosition it) {
            Intrinsics.checkNotNull((Object)it);
            Companion.moveBeforeIgnoringWhiteSpaceOrComment(it);
            return Unit.INSTANCE;
        }

        private static final void beforeIgnoringWhiteSpaceOrComment$lambda$36(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit afterIgnoringWhiteSpaceOrComment$lambda$37(SemanticEditorPosition it) {
            Intrinsics.checkNotNull((Object)it);
            Companion.moveAfterIgnoringWhiteSpaceOrComment(it);
            return Unit.INSTANCE;
        }

        private static final void afterIgnoringWhiteSpaceOrComment$lambda$38(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0016\b\u0082\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider$KotlinElement;", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "", "<init>", "(Ljava/lang/String;I)V", "TemplateEntryOpen", "TemplateEntryClose", "Arrow", "WhenKeyword", "WhileKeyword", "RegularStringPart", "KDoc", "Identifier", "OpenTypeBrace", "CloseTypeBrace", "FunctionKeyword", "Dot", "Quest", "Eq", "Val", "Var", "OpenQuote", "ClosingQuote", "Literal", "kotlin.base.code-insight.minimal"})
    private static final class KotlinElement
    extends Enum<KotlinElement>
    implements SemanticEditorPosition.SyntaxElement {
        public static final /* enum */ KotlinElement TemplateEntryOpen = new KotlinElement();
        public static final /* enum */ KotlinElement TemplateEntryClose = new KotlinElement();
        public static final /* enum */ KotlinElement Arrow = new KotlinElement();
        public static final /* enum */ KotlinElement WhenKeyword = new KotlinElement();
        public static final /* enum */ KotlinElement WhileKeyword = new KotlinElement();
        public static final /* enum */ KotlinElement RegularStringPart = new KotlinElement();
        public static final /* enum */ KotlinElement KDoc = new KotlinElement();
        public static final /* enum */ KotlinElement Identifier = new KotlinElement();
        public static final /* enum */ KotlinElement OpenTypeBrace = new KotlinElement();
        public static final /* enum */ KotlinElement CloseTypeBrace = new KotlinElement();
        public static final /* enum */ KotlinElement FunctionKeyword = new KotlinElement();
        public static final /* enum */ KotlinElement Dot = new KotlinElement();
        public static final /* enum */ KotlinElement Quest = new KotlinElement();
        public static final /* enum */ KotlinElement Eq = new KotlinElement();
        public static final /* enum */ KotlinElement Val = new KotlinElement();
        public static final /* enum */ KotlinElement Var = new KotlinElement();
        public static final /* enum */ KotlinElement OpenQuote = new KotlinElement();
        public static final /* enum */ KotlinElement ClosingQuote = new KotlinElement();
        public static final /* enum */ KotlinElement Literal = new KotlinElement();
        private static final /* synthetic */ KotlinElement[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KotlinElement[] values() {
            return (KotlinElement[])$VALUES.clone();
        }

        public static KotlinElement valueOf(String value) {
            return Enum.valueOf(KotlinElement.class, value);
        }

        @NotNull
        public static EnumEntries<KotlinElement> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kotlinElementArray = new KotlinElement[]{KotlinElement.TemplateEntryOpen, KotlinElement.TemplateEntryClose, KotlinElement.Arrow, KotlinElement.WhenKeyword, KotlinElement.WhileKeyword, KotlinElement.RegularStringPart, KotlinElement.KDoc, KotlinElement.Identifier, KotlinElement.OpenTypeBrace, KotlinElement.CloseTypeBrace, KotlinElement.FunctionKeyword, KotlinElement.Dot, KotlinElement.Quest, KotlinElement.Eq, KotlinElement.Val, KotlinElement.Var, KotlinElement.OpenQuote, KotlinElement.ClosingQuote, KotlinElement.Literal};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

