/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Crypt32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinCrypt;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.win32.Crypt32Ext;

public class Crypt32ExtUtil {
    private static final Logger LOGGER = Logger.getLogger(Crypt32ExtUtil.class.getName());
    private static final Map<String, Integer> customTrustedCertificatesLocations = Map.of("CERT_SYSTEM_STORE_LOCAL_MACHINE", 131072, "CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY", 524288, "CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE", 589824, "CERT_SYSTEM_STORE_CURRENT_USER", 65536, "CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY", 458752);

    public static Collection<X509Certificate> getCustomTrustedRootCertificates() {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        for (Map.Entry<String, Integer> entry : customTrustedCertificatesLocations.entrySet()) {
            List<X509Certificate> list = Crypt32ExtUtil.gatherEnterpriseCertsForLocation(entry.getValue(), "ROOT");
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder();
                message.append("Received ").append(list.size()).append(" certificates from store ROOT / ").append(entry.getKey());
                for (X509Certificate certificate : list) {
                    message.append("\n  ROOT/").append(entry.getKey()).append(": ").append(certificate.getSubjectDN());
                }
                LOGGER.fine(message.toString());
            }
            result.addAll(list);
        }
        return result;
    }

    public static void CertCloseStore(WinCrypt.HCERTSTORE handle) {
        if (!Crypt32.INSTANCE.CertCloseStore(handle, 0)) {
            throw new IllegalStateException("CertCloseStore: " + Kernel32Util.formatMessage((int)Native.getLastError()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<X509Certificate> gatherEnterpriseCertsForLocation(int location, String store_name) {
        int flags = location | 0x4000 | 0x8000;
        WinCrypt.HCERTSTORE hcertstore = Crypt32Ext.INSTANCE.CertOpenStore(new WTypes.LPSTR(new Pointer(13L)), 0, new WinCrypt.HCRYPTPROV_LEGACY(0L), flags, new WTypes.LPWSTR(store_name));
        if (hcertstore == null) {
            int errorCode = Native.getLastError();
            if (errorCode == 18 || errorCode == 2) {
                return Collections.emptyList();
            }
            throw new Win32Exception(errorCode);
        }
        try {
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            WinCrypt.CERT_CONTEXT.ByReference prev = null;
            while (true) {
                WinCrypt.CERT_CONTEXT.ByReference certificate;
                if ((certificate = Crypt32.INSTANCE.CertEnumCertificatesInStore(hcertstore, prev == null ? null : prev.getPointer())) == null) {
                    int errorCode = Native.getLastError();
                    if (errorCode == -2146885628 || errorCode == 18) break;
                    throw new Win32Exception(errorCode);
                }
                byte[] bytes = certificate.pbCertEncoded.getByteArray(0L, certificate.cbCertEncoded);
                try {
                    X509Certificate x509 = NativeTrustedRootsInternalUtils.parseCertificate(bytes);
                    result.add(x509);
                }
                catch (Throwable parsingException) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse one of the certificatesfrom store '" + store_name + "'", parsingException));
                }
                prev = certificate;
            }
            ArrayList<X509Certificate> arrayList = result;
            return arrayList;
        }
        finally {
            Crypt32ExtUtil.CertCloseStore(hcertstore);
        }
    }
}

