/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = publicKeyEncSessionPacket;
    }

    private boolean confirmCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        return byArray[byArray.length - 2] == (byte)(n >> 8) && byArray[byArray.length - 1] == (byte)n;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 3) {
            byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
            return byArray[0];
        }
        if (this.keyData.getVersion() == 6) {
            return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + this.keyData.getVersion());
    }

    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (this.keyData.getAlgorithm() == 25 || this.keyData.getAlgorithm() == 26) {
            return new PGPSessionKey(byArray[0] & 0xFF, Arrays.copyOfRange(byArray, 1, byArray.length));
        }
        if (!this.confirmCheckSum(byArray)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return new PGPSessionKey(byArray[0] & 0xFF, Arrays.copyOfRange(byArray, 1, byArray.length - 2));
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        return this.getDataStream(publicKeyDataDecryptorFactory, this.getSessionKey(publicKeyDataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        return this.getDataStream(sessionKeyDataDecryptorFactory, sessionKeyDataDecryptorFactory.getSessionKey());
    }

    private InputStream getDataStream(PGPDataDecryptorFactory pGPDataDecryptorFactory, PGPSessionKey pGPSessionKey) throws PGPException {
        if (pGPSessionKey.getAlgorithm() != 0) {
            try {
                if (this.encData instanceof AEADEncDataPacket) {
                    AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
                    if (aEADEncDataPacket.getAlgorithm() != pGPSessionKey.getAlgorithm()) {
                        throw new PGPException("session key and AEAD algorithm mismatch");
                    }
                    PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(aEADEncDataPacket, pGPSessionKey);
                    BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                    this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
                } else {
                    boolean bl = this.encData instanceof SymmetricEncIntegrityPacket;
                    PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(bl, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                    BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                    this.processSymmetricEncIntegrityPacketDataStream(bl, pGPDataDecryptor, bCPGInputStream);
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }

    @Override
    public int getAlgorithm() {
        return this.keyData.getAlgorithm();
    }

    @Override
    public int getVersion() {
        return this.keyData.getVersion();
    }
}

