/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.schemaGenerators;

import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a_\u0010\u0000\u001a\u00020\u00012Q\u0010\u0002\u001aM\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00010\u0003H\u0080\b\u00f8\u0001\u0000\u001aq\u0010\r\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\b2K\u0010\u0002\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00010\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u001a&\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\bH\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"processConfigurationTypes", "", "processor", "Lkotlin/Function3;", "Lcom/intellij/execution/configurations/ConfigurationType;", "Lkotlin/ParameterName;", "name", "configurationType", "", "propertyName", "", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "factories", "processFactories", "typeDefinitionId", "factoryPropertyName", "factoryDefinitionId", "factory", "([Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function3;)V", "rcTypeIdToPropertyName", "rcFactoryIdToPropertyName", "idToPropertyName", "string", "", "generateTypeDefinitionId", "getTypeDescription", "type", "typePropertyName", "intellij.configurationScript"})
public final class RunConfigurationJsonSchemaGeneratorKt {
    public static final void processConfigurationTypes(@NotNull Function3<? super ConfigurationType, ? super CharSequence, ? super ConfigurationFactory[], Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        boolean $i$f$processConfigurationTypes = false;
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            CharSequence propertyName;
            Intrinsics.checkNotNull((Object)type);
            if (RunConfigurationJsonSchemaGeneratorKt.rcTypeIdToPropertyName(type) == null) continue;
            ConfigurationFactory[] factories = type.getConfigurationFactories();
            Intrinsics.checkNotNull((Object)factories);
            if (factories.length == 0) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + type.getDisplayName() + "\" is not valid: factory list is empty");
                continue;
            }
            processor.invoke((Object)type, (Object)propertyName, (Object)factories);
        }
    }

    private static final void processFactories(ConfigurationFactory[] factories, CharSequence typeDefinitionId, Function3<? super CharSequence, ? super CharSequence, ? super ConfigurationFactory, Unit> processor) {
        boolean $i$f$processFactories = false;
        for (ConfigurationFactory factory : factories) {
            CharSequence factoryPropertyName;
            if (RunConfigurationJsonSchemaGeneratorKt.rcFactoryIdToPropertyName(factory) == null) continue;
            String factoryDefinitionId = typeDefinitionId + "-" + factoryPropertyName + "Factory";
            processor.invoke((Object)factoryPropertyName, (Object)factoryDefinitionId, (Object)factory);
        }
    }

    @Nullable
    public static final CharSequence rcTypeIdToPropertyName(@NotNull ConfigurationType configurationType) {
        Intrinsics.checkNotNullParameter((Object)configurationType, (String)"configurationType");
        String string = configurationType.getTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTag(...)");
        CharSequence charSequence = RunConfigurationJsonSchemaGeneratorKt.idToPropertyName(string, configurationType, null);
        if (charSequence == null) {
            return null;
        }
        CharSequence result = charSequence;
        if (StringUtil.equals((CharSequence)result, (CharSequence)"templates")) {
            IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + configurationType.getDisplayName() + "\" has forbidden id");
        }
        return result;
    }

    @Nullable
    public static final CharSequence rcFactoryIdToPropertyName(@NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        String string = factory.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return RunConfigurationJsonSchemaGeneratorKt.idToPropertyName(string, null, factory);
    }

    private static final CharSequence idToPropertyName(String string, ConfigurationType configurationType, ConfigurationFactory factory) {
        if (Intrinsics.areEqual((Object)string, (Object)"JetRunConfigurationType")) {
            return "kotlin";
        }
        String result = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"Type"), (CharSequence)"RunConfiguration"), (CharSequence)"Configuration");
        if (((CharSequence)result).length() == 0) {
            if (factory == null) {
                Logger logger = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
                ConfigurationType configurationType2 = configurationType;
                Intrinsics.checkNotNull((Object)configurationType2);
                logger.error("Configuration type \"" + configurationType2.getDisplayName() + "\" is not valid: id is empty");
            } else {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration factory \"" + factory.getName() + "\" is not valid: id is empty");
            }
            return null;
        }
        StringBuilder builder = null;
        int i = 0;
        boolean isAllUpperCased = true;
        while (i < result.length()) {
            char ch = result.charAt(i);
            if (ch == '.' || ch == ' ' || ch == '-' || ch == '_') {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(result, 0, i);
                }
                if (++i == result.length()) break;
                builder.append(Character.toUpperCase(result.charAt(i)));
                ++i;
                continue;
            }
            if (ch == '#') {
                ++i;
                continue;
            }
            if (ch == '\"' || ch == '\'' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\b' || ch == '/' || ch == '\\') {
                if (factory == null) {
                    Logger logger = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
                    ConfigurationType configurationType3 = configurationType;
                    Intrinsics.checkNotNull((Object)configurationType3);
                    logger.error("Configuration type \"" + configurationType3.getId() + "\" is not valid: contains invalid symbol \"" + ch + "\"");
                } else {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration factory \"" + factory.getName() + "\" is not valid: contains invalid symbol \"" + ch + "\"");
                }
                return null;
            }
            if (i == 0) {
                if (Character.isUpperCase(ch)) {
                    if (builder == null) {
                        builder = new StringBuilder();
                        builder.append(result, 0, i);
                    }
                    builder.append(Character.toLowerCase(ch));
                } else {
                    isAllUpperCased = false;
                }
            } else if (builder != null) {
                builder.append(ch);
            }
            if (!Character.isUpperCase(ch)) {
                isAllUpperCased = false;
            }
            ++i;
        }
        if (isAllUpperCased) {
            if (builder == null) {
                String string2 = result.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                return string2;
            }
            int n = ((CharSequence)builder).length();
            for (int i2 = 0; i2 < n; ++i2) {
                builder.setCharAt(i2, Character.toLowerCase(builder.charAt(i2)));
            }
            return builder;
        }
        StringBuilder stringBuilder = builder;
        return stringBuilder != null ? (CharSequence)stringBuilder : (CharSequence)result;
    }

    private static final String generateTypeDefinitionId(CharSequence propertyName) {
        CharSequence charSequence = propertyName;
        int n = 1;
        int n2 = charSequence.length();
        return Character.toUpperCase(propertyName.charAt(0)) + ((Object)charSequence.subSequence(n, n2)).toString() + "Type";
    }

    private static final String getTypeDescription(ConfigurationType type, CharSequence typePropertyName) {
        String description = type.getConfigurationTypeDescription();
        return StringUtil.equals((CharSequence)typePropertyName, (CharSequence)description) ? null : description;
    }

    public static final /* synthetic */ String access$generateTypeDefinitionId(CharSequence propertyName) {
        return RunConfigurationJsonSchemaGeneratorKt.generateTypeDefinitionId(propertyName);
    }

    public static final /* synthetic */ String access$getTypeDescription(ConfigurationType type, CharSequence typePropertyName) {
        return RunConfigurationJsonSchemaGeneratorKt.getTypeDescription(type, typePropertyName);
    }
}

