/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;", "Lcom/intellij/openapi/Disposable;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "colorStartKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "colorEndKey", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;Lcom/intellij/openapi/editor/colors/ColorKey;Lcom/intellij/openapi/editor/colors/ColorKey;)V", "getColorStartKey", "()Lcom/intellij/openapi/editor/colors/ColorKey;", "getColorEndKey", "texture", "Ljava/awt/TexturePaint;", "colorStart", "Ljava/awt/Color;", "getColorStart", "()Ljava/awt/Color;", "colorEnd", "getColorEnd", "getTexture", "Ljava/awt/Paint;", "graphics", "Ljava/awt/Graphics2D;", "width", "", "getGradientRange", "Lkotlin/Pair;", "dispose", "", "intellij.terminal"})
public final class GradientTextureCache
implements Disposable {
    @NotNull
    private final EditorColorsScheme scheme;
    @NotNull
    private final ColorKey colorStartKey;
    @NotNull
    private final ColorKey colorEndKey;
    @Nullable
    private TexturePaint texture;

    public GradientTextureCache(@NotNull EditorColorsScheme scheme, @NotNull ColorKey colorStartKey, @NotNull ColorKey colorEndKey) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)colorStartKey, (String)"colorStartKey");
        Intrinsics.checkNotNullParameter((Object)colorEndKey, (String)"colorEndKey");
        this.scheme = scheme;
        this.colorStartKey = colorStartKey;
        this.colorEndKey = colorEndKey;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> GradientTextureCache._init_$lambda$0(this, arg_0));
        Topic topic2 = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> GradientTextureCache._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final ColorKey getColorStartKey() {
        return this.colorStartKey;
    }

    @NotNull
    public final ColorKey getColorEndKey() {
        return this.colorEndKey;
    }

    private final Color getColorStart() {
        return this.scheme.getColor(this.colorStartKey);
    }

    private final Color getColorEnd() {
        return this.scheme.getColor(this.colorEndKey);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    public final Paint getTexture(@NotNull Graphics2D graphics, int width) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        int realWidth = (int)Math.floor(JBUIScale.sysScale((Graphics2D)graphics) * (float)width);
        TexturePaint texturePaint = this.texture;
        if (!(texturePaint != null && (bufferedImage = texturePaint.getImage()) != null ? realWidth == bufferedImage.getWidth() : false)) {
            TexturePaint texturePaint2;
            GradientTextureCache gradientTextureCache = this;
            Pair<Color, Color> pair = this.getGradientRange();
            if (pair != null) {
                void it;
                Pair<Color, Color> pair2 = pair;
                GradientTextureCache gradientTextureCache2 = gradientTextureCache;
                boolean bl = false;
                texturePaint2 = AppUIUtil.createHorizontalGradientTexture$default((AppUIUtil)AppUIUtil.INSTANCE, (Graphics)graphics, (Color)((Color)it.getFirst()), (Color)((Color)it.getSecond()), (int)width, (int)0, (int)0, (int)48, null);
                gradientTextureCache = gradientTextureCache2;
            } else {
                texturePaint2 = null;
            }
            gradientTextureCache.texture = texturePaint2;
        }
        return this.texture;
    }

    private final Pair<Color, Color> getGradientRange() {
        Pair pair;
        Color resolvedColorStart = this.getColorStart();
        Color resolvedColorEnd = this.getColorEnd();
        if (resolvedColorStart != null || resolvedColorEnd != null) {
            Color color;
            Color color2 = resolvedColorStart;
            if (color2 == null) {
                Color color3 = resolvedColorEnd;
                color2 = color3;
                Intrinsics.checkNotNull((Object)color3);
            }
            if ((color = resolvedColorEnd) == null) {
                Color color4 = resolvedColorStart;
                color = color4;
                Intrinsics.checkNotNull((Object)color4);
            }
            pair = TuplesKt.to((Object)color2, (Object)color);
        } else {
            pair = null;
        }
        return pair;
    }

    public void dispose() {
        this.texture = null;
    }

    private static final void _init_$lambda$0(GradientTextureCache this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.texture = null;
    }

    private static final void _init_$lambda$1(GradientTextureCache this$0, EditorColorsScheme it) {
        this$0.texture = null;
    }
}

