/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.ChangeListDescriptionCleaner;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.SingleChangeListCommitMessagePolicy;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/commit/CommitChangeListDialogWorkflow;", "Lcom/intellij/vcs/commit/AbstractCommitWorkflow;", "project", "Lcom/intellij/openapi/project/Project;", "initialCommitMessage", "", "initiallyIncluded", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Collection;)V", "getInitiallyIncluded", "()Ljava/util/Collection;", "isPartialCommitEnabled", "", "()Z", "commitMessagePolicy", "Lcom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy;", "getCommitMessagePolicy$intellij_platform_vcs_impl", "()Lcom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy;", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "getCommitState", "()Lcom/intellij/vcs/commit/ChangeListCommitState;", "setCommitState", "(Lcom/intellij/vcs/commit/ChangeListCommitState;)V", "addCommonResultHandlers", "", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "committer", "Lcom/intellij/vcs/commit/Committer;", "intellij.platform.vcs.impl"})
public abstract class CommitChangeListDialogWorkflow
extends AbstractCommitWorkflow {
    @NotNull
    private final Collection<Object> initiallyIncluded;
    @NotNull
    private final SingleChangeListCommitMessagePolicy commitMessagePolicy;
    public ChangeListCommitState commitState;

    public CommitChangeListDialogWorkflow(@NotNull Project project, @Nullable String initialCommitMessage, @NotNull Collection<? extends Object> initiallyIncluded) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(initiallyIncluded, (String)"initiallyIncluded");
        super(project);
        this.initiallyIncluded = initiallyIncluded;
        this.commitMessagePolicy = new SingleChangeListCommitMessagePolicy(project, initialCommitMessage);
    }

    @NotNull
    public final Collection<Object> getInitiallyIncluded() {
        return this.initiallyIncluded;
    }

    public abstract boolean isPartialCommitEnabled();

    @NotNull
    public final SingleChangeListCommitMessagePolicy getCommitMessagePolicy$intellij_platform_vcs_impl() {
        return this.commitMessagePolicy;
    }

    @NotNull
    public final ChangeListCommitState getCommitState() {
        ChangeListCommitState changeListCommitState = this.commitState;
        if (changeListCommitState != null) {
            return changeListCommitState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commitState");
        return null;
    }

    public final void setCommitState(@NotNull ChangeListCommitState changeListCommitState) {
        Intrinsics.checkNotNullParameter((Object)changeListCommitState, (String)"<set-?>");
        this.commitState = changeListCommitState;
    }

    @Override
    protected void addCommonResultHandlers(@NotNull CommitSessionInfo sessionInfo, @NotNull Committer committer) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        super.addCommonResultHandlers(sessionInfo, committer);
        committer.addResultHandler(new ChangeListDescriptionCleaner(this.commitMessagePolicy, this.getCommitState()));
    }
}

