/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends DumbAwareAction {
    private static final int MANY_CHANGES_THRESHOLD = 1000;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile editorFile;
        if (e == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        DataContext context = e.getDataContext();
        boolean isVisible = project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        boolean isEnabled = this.isEnabled(context);
        e.getPresentation().setEnabled(isEnabled);
        e.getPresentation().setVisible(isVisible);
        if (isEnabled && isVisible && VcsContextUtil.selectedFilePathsIterable(context).isEmpty() && (editorFile = TabbedShowHistoryAction.getEditorFile(context)) != null) {
            e.getPresentation().setText(ActionsBundle.message((String)"action.Vcs.ShowTabbedFileHistory.for.file.text", (Object[])new Object[]{editorFile.getName()}));
        }
    }

    protected boolean isEnabled(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        List selectedFiles = TabbedShowHistoryAction.getSelectedPaths(context).take(1000).toList();
        if (selectedFiles.isEmpty()) {
            return false;
        }
        List<FilePath> symlinkedPaths = TabbedShowHistoryAction.getContextSymlinkedPaths(project, TabbedShowHistoryAction.getSelectedFile(context));
        if (symlinkedPaths != null && TabbedShowHistoryAction.canShowNewFileHistory(project, symlinkedPaths)) {
            return true;
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, selectedFiles)) {
            return ContainerUtil.all((Collection)selectedFiles, path -> AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)path));
        }
        if (selectedFiles.size() == 1) {
            FilePath selectedPath = (FilePath)ContainerUtil.getFirstItem((List)selectedFiles);
            if (selectedPath == null) {
                return false;
            }
            VirtualFile fileOrParent = TabbedShowHistoryAction.getExistingFileOrParent(selectedPath);
            if (fileOrParent == null) {
                return false;
            }
            if (TabbedShowHistoryAction.canShowOldFileHistory(project, selectedPath, fileOrParent)) {
                return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)selectedPath);
            }
        }
        return false;
    }

    private static boolean canShowOldFileHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        AbstractVcs vcs;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(3);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(4);
        }
        if (fileOrParent == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(5);
        }
        if ((vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project)) == null) {
            return false;
        }
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        VcsLogFileHistoryProvider historyProvider;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(7);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)project.getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(paths, null);
    }

    @Nullable
    private static VirtualFile getExistingFileOrParent(@NotNull FilePath selectedPath) {
        if (selectedPath == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(8);
        }
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)selectedPath.getVirtualFile(), (Object)selectedPath.getVirtualFileParent());
    }

    @Nullable
    private static List<FilePath> getContextSymlinkedPaths(@NotNull Project project, @Nullable VirtualFile file) {
        VirtualFile vcsFile;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(9);
        }
        return (vcsFile = VcsUtil.resolveSymlink((Project)project, (VirtualFile)file)) != null ? Collections.singletonList(VcsUtil.getFilePath((VirtualFile)vcsFile)) : null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(10);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<FilePath> symlinkedPaths = TabbedShowHistoryAction.getContextSymlinkedPaths(project, TabbedShowHistoryAction.getSelectedFile(e.getDataContext()));
        if (symlinkedPaths != null && TabbedShowHistoryAction.canShowNewFileHistory(project, symlinkedPaths)) {
            TabbedShowHistoryAction.showNewFileHistory(project, symlinkedPaths);
            return;
        }
        List selectedFiles = TabbedShowHistoryAction.getSelectedPaths(e.getDataContext()).toList();
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, selectedFiles)) {
            TabbedShowHistoryAction.showNewFileHistory(project, selectedFiles);
            return;
        }
        if (selectedFiles.size() == 1) {
            FilePath path = (FilePath)ContainerUtil.getOnlyItem((Collection)selectedFiles);
            VirtualFile fileOrParent = TabbedShowHistoryAction.getExistingFileOrParent(path);
            if (fileOrParent == null) {
                return;
            }
            AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project);
            if (vcs == null) {
                return;
            }
            TabbedShowHistoryAction.showOldFileHistory(project, vcs, path);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(11);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(12);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)project.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(paths, null);
    }

    private static void showOldFileHistory(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull FilePath path) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(13);
        }
        if (vcs == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(14);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(15);
        }
        VcsHistoryProvider provider = Objects.requireNonNull(vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(provider, vcs.getAnnotationProvider(), path, vcs);
    }

    @NotNull
    private static JBIterable<FilePath> getSelectedPaths(@NotNull DataContext context) {
        JBIterable<FilePath> paths;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(16);
        }
        if ((paths = VcsContextUtil.selectedFilePathsIterable(context)).isNotEmpty()) {
            JBIterable<FilePath> jBIterable = paths;
            if (jBIterable == null) {
                TabbedShowHistoryAction.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        VirtualFile file = TabbedShowHistoryAction.getEditorFile(context);
        if (file != null) {
            JBIterable jBIterable = JBIterable.of((Object)VcsUtil.getFilePath((VirtualFile)file));
            if (jBIterable == null) {
                TabbedShowHistoryAction.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull DataContext context) {
        VirtualFile file;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(20);
        }
        if ((file = VcsContextUtil.selectedFile(context)) != null) {
            return file;
        }
        return TabbedShowHistoryAction.getEditorFile(context);
    }

    @Nullable
    private static VirtualFile getEditorFile(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(21);
        }
        if ((project = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return null;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length == 0) {
            return null;
        }
        VirtualFile selectedFile = selectedFiles[0];
        if (!selectedFile.isInLocalFileSystem()) {
            return null;
        }
        return selectedFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrParent";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canShowOldFileHistory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canShowNewFileHistory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExistingFileOrParent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContextSymlinkedPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showNewFileHistory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showOldFileHistory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

