/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ChangeListTodosPanel
extends TodoPanel {
    private final Alarm myAlarm;

    public ChangeListTodosPanel(@NotNull TodoView todoView, @NotNull TodoPanelSettings settings, @NotNull Content content) {
        if (todoView == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(1);
        }
        if (content == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(2);
        }
        super(todoView, settings, false, content);
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListManagerListener(), (Disposable)this);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    private void rebuildWithAlarm() {
        this.rebuildWithAlarm(this.myAlarm);
    }

    private void updateTabName() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> this.setDisplayName(ChangeListTodosPanel.getTabName(this.myProject)));
    }

    @NotNull
    @NlsContexts.TabTitle
    static String getTabName(@NotNull Project project) {
        ChangeListManager changeListManager;
        if (project == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(3);
        }
        if ((changeListManager = ChangeListManager.getInstance((Project)project)).areChangeListsEnabled()) {
            String suffix;
            LocalChangeList list = changeListManager.getDefaultChangeList();
            String changelistName = list.getName().trim();
            Object object = StringUtil.endsWithIgnoreCase((String)changelistName, (String)(suffix = VcsBundle.message((String)"todo.tab.title.changelist.suffix", (Object[])new Object[0]))) ? changelistName : changelistName + " " + suffix;
            if (object == null) {
                ChangeListTodosPanel.$$$reportNull$$$0(4);
            }
            return object;
        }
        String string = VcsBundle.message((String)"todo.tab.title.all.changes", (Object[])new Object[0]);
        if (string == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/ChangeListTodosPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/ChangeListTodosPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTabName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private final class MyChangeListManagerListener
    extends ChangeListAdapter {
        private MyChangeListManagerListener() {
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangeListTodosPanel.this.rebuildWithAlarm();
            ChangeListTodosPanel.this.updateTabName();
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            ChangeListTodosPanel.this.updateTabName();
        }

        public void changesMoved(Collection<? extends Change> changes, ChangeList fromList, ChangeList toList) {
            ChangeListTodosPanel.this.rebuildWithAlarm();
        }

        public void allChangeListsMappingsChanged() {
            ChangeListTodosPanel.this.updateTabName();
        }
    }
}

