/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public final class ShellVariablesRegistryImpl
implements ShellVariablesRegistry {
    private final Function<String, Collection<TextMateShellVariable>> ADD_VARIABLE_FACTORY = key -> Collections.synchronizedList(new CopyOnWriteArrayList());
    @NotNull
    private final Map<String, Collection<TextMateShellVariable>> myVariables = new ConcurrentHashMap<String, Collection<TextMateShellVariable>>();

    public void addVariable(@NotNull TextMateShellVariable variable) {
        if (variable == null) {
            ShellVariablesRegistryImpl.$$$reportNull$$$0(0);
        }
        if (!variable.name.isEmpty()) {
            this.myVariables.computeIfAbsent(variable.name, this.ADD_VARIABLE_FACTORY).add(variable);
        }
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariableValue(@NotNull String name, @Nullable TextMateScope scope) {
        if (name == null) {
            ShellVariablesRegistryImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            return null;
        }
        Collection<TextMateShellVariable> variables = this.myVariables.get(name);
        if (variables == null) {
            return null;
        }
        return new TextMateScopeComparator<TextMateShellVariable>(scope, TextMateShellVariable::getScopeSelector).max(variables);
    }

    public void clear() {
        this.myVariables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

