/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.IconUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollectorKt;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeFileNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.PresentationKt;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNodeBase;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNodeBaseKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeFileNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNodeBase;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode$PrimaryData;", "parent", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "primaryData", "<init>", "(Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode$PrimaryData;)V", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "computeModelTreeNode", "getExcludeActionsDescriptors", "", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode$ExcludeActionDescriptor;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "doUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "modelTreeNode", "getName", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaUiTreeFileNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaUiTreeFileNode.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeFileNode\n+ 2 QodanaUiTreeNodeBase.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNodeBase\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n53#2:91\n1#3:92\n*S KotlinDebug\n*F\n+ 1 QodanaUiTreeFileNode.kt\norg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeFileNode\n*L\n47#1:91\n*E\n"})
public final class QodanaUiTreeFileNode
extends QodanaUiTreeNodeBase<QodanaTreeFileNode, QodanaTreeFileNode.PrimaryData> {
    public QodanaUiTreeFileNode(@NotNull QodanaUiTreeNode<?, ?> parent, @NotNull QodanaTreeFileNode.PrimaryData primaryData) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)primaryData, (String)"primaryData");
        super(parent, (QodanaTreeNode.PrimaryData)primaryData);
    }

    @Nullable
    public Navigatable getNavigatable() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        QodanaTreeFileNode qodanaTreeFileNode = (QodanaTreeFileNode)this.getModelTreeNode();
        if (qodanaTreeFileNode == null) {
            return null;
        }
        QodanaTreeFileNode modelTreeNode = qodanaTreeFileNode;
        Navigatable navigatable2 = super.getNavigatable();
        if (navigatable2 == null) {
            return null;
        }
        Navigatable nodeNavigatable = navigatable2;
        return new Navigatable(nodeNavigatable, project2, modelTreeNode){
            private final /* synthetic */ Navigatable $$delegate_0;
            final /* synthetic */ Navigatable $nodeNavigatable;
            final /* synthetic */ Project $project;
            final /* synthetic */ QodanaTreeFileNode $modelTreeNode;
            {
                this.$nodeNavigatable = $nodeNavigatable;
                this.$project = $project;
                this.$modelTreeNode = $modelTreeNode;
                this.$$delegate_0 = $nodeNavigatable;
            }

            public void navigate(boolean requestFocus) {
                QodanaPluginStatsCounterCollector.PROBLEM_NAVIGATED.log(this.$project, (Object)((Object)QodanaPluginStatsCounterCollectorKt.toSelectedNodeType(this.$modelTreeNode)), (Object)this.$modelTreeNode.getProblemsCount());
                this.$nodeNavigatable.navigate(requestFocus);
            }

            public boolean canNavigateToSource() {
                return this.$nodeNavigatable.canNavigateToSource();
            }

            public boolean canNavigate() {
                return this.$nodeNavigatable.canNavigate();
            }
        };
    }

    @Override
    @Nullable
    public QodanaTreeFileNode computeModelTreeNode() {
        QodanaUiTreeNodeBase this_$iv = this;
        boolean $i$f$computeModelTreeNodeThroughParent = false;
        return (QodanaTreeFileNode)QodanaUiTreeNodeBase.access$computeModelTreeNodeThroughParentViaClazz(this_$iv, QodanaTreeFileNode.class);
    }

    @Override
    @NotNull
    public List<QodanaUiTreeNode.ExcludeActionDescriptor> getExcludeActionsDescriptors() {
        Path file = ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).getFile();
        return QodanaUiTreeNodeBaseKt.excludeActionsDescriptorsForPathNode(this, file, (Function0<String>)((Function0)() -> QodanaUiTreeFileNode.getExcludeActionsDescriptors$lambda$0(file)), (Function1<? super String, String>)((Function1)arg_0 -> QodanaUiTreeFileNode.getExcludeActionsDescriptors$lambda$1(file, arg_0)));
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        QodanaTreeFileNode qodanaTreeFileNode = (QodanaTreeFileNode)this.getModelTreeNode();
        return qodanaTreeFileNode != null ? qodanaTreeFileNode.getVirtualFile() : null;
    }

    @Override
    public void doUpdate(@NotNull Project project, @NotNull PresentationData presentation, @NotNull QodanaTreeFileNode modelTreeNode) {
        Path path;
        VirtualFile virtualFile;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)modelTreeNode, (String)"modelTreeNode");
                virtualFile = modelTreeNode.getVirtualFile();
                presentation.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)project));
                Path parentDirectoryPath = ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).getFile().getParent();
                Path parentNodePath = ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).getParentPath();
                path = parentDirectoryPath;
                if (path == null) break block6;
                Path it = path;
                boolean bl = false;
                Path path2 = parentNodePath.relativize(it);
                path = path2;
                if (path2 != null) break block7;
            }
            Path path3 = Paths.get("", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        }
        Path pathFromParentNodePathToDirectory = path;
        if (modelTreeNode.getExcluded()) {
            presentation.addText(virtualFile.getPresentableName(), SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            if (pathFromParentNodePathToDirectory.getNameCount() != 0) {
                PresentationKt.appendGrayedText(presentation, ((Object)pathFromParentNodePathToDirectory).toString());
            }
            String string = QodanaBundle.message("qodana.TreeNode.excluded", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_BOLD_ATTRIBUTES");
            PresentationKt.appendText(presentation, string, simpleTextAttributes);
            return;
        }
        presentation.addText(virtualFile.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (pathFromParentNodePathToDirectory.getNameCount() != 0) {
            PresentationKt.appendGrayedText(presentation, ((Object)pathFromParentNodePathToDirectory).toString());
        }
        PresentationKt.appendProblemsCount(presentation, modelTreeNode.getProblemsCount());
    }

    @NotNull
    public String getName() {
        return ((QodanaTreeFileNode.PrimaryData)this.getPrimaryData()).toString();
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.NEVER;
    }

    private static final String getExcludeActionsDescriptors$lambda$0(Path $file) {
        Object[] objectArray = new Object[]{$file.getFileName()};
        String string = QodanaBundle.message("action.Qodana.ProblemTree.ExcludeFile.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String getExcludeActionsDescriptors$lambda$1(Path $file, String inspectionId) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        Object[] objectArray = new Object[]{inspectionId, $file.getFileName()};
        String string = QodanaBundle.message("action.Qodana.ProblemTree.ExcludeFileForInspection.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

