/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.layout.CollapsedBorderSide;
import com.openhtmltopdf.layout.InlinePaintable;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.OperatorClip;
import com.openhtmltopdf.render.OperatorSetClip;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListOperation;
import com.openhtmltopdf.render.displaylist.PaintBackgroundAndBorders;
import com.openhtmltopdf.render.displaylist.PaintFixedLayer;
import com.openhtmltopdf.render.displaylist.PaintInlineContent;
import com.openhtmltopdf.render.displaylist.PaintLayerBackgroundAndBorder;
import com.openhtmltopdf.render.displaylist.PaintListMarkers;
import com.openhtmltopdf.render.displaylist.PaintPopClipRect;
import com.openhtmltopdf.render.displaylist.PaintPopTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintPushClipRect;
import com.openhtmltopdf.render.displaylist.PaintPushTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintReplacedElement;
import com.openhtmltopdf.render.displaylist.PaintReplacedElements;
import com.openhtmltopdf.render.displaylist.PaintRootElementBackground;
import com.openhtmltopdf.render.displaylist.TransformCreator;
import com.openhtmltopdf.render.simplepainter.SimplePainter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class DisplayListPainter {
    private void debugOnly(String msg, Object arg) {
    }

    private void clip(RenderingContext c, OperatorClip clip) {
        this.debugOnly("clipping", clip.getClip());
        c.getOutputDevice().pushClip(clip.getClip());
    }

    private void setClip(RenderingContext c, OperatorSetClip setclip) {
        this.debugOnly("popping clip", null);
        c.getOutputDevice().popClip();
    }

    private void updateTableHeaderFooterPosition(RenderingContext c, BlockBox container) {
        TableBox table;
        if (container.getStyle().isTable() && (table = (TableBox)container).hasContentLimitContainer()) {
            table.updateHeaderFooterPosition(c);
        }
    }

    private void paintBackgroundAndBorders(RenderingContext c, List<DisplayListItem> blocks, Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders) {
        for (DisplayListItem dli : blocks) {
            List<CollapsedBorderSide> borders;
            TableCellBox cell;
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            BlockBox box = (BlockBox)dli;
            Object outerToken = c.getOutputDevice().startStructure(StructureType.BLOCK, box);
            Object innerToken = c.getOutputDevice().startStructure(StructureType.BACKGROUND, box);
            this.updateTableHeaderFooterPosition(c, box);
            this.debugOnly("painting bg", box);
            box.paintBackground(c);
            box.paintBorder(c);
            if (collapsedTableBorders != null && box instanceof TableCellBox && (cell = (TableCellBox)box).hasCollapsedPaintingBorder() && (borders = collapsedTableBorders.get(cell)) != null) {
                for (CollapsedBorderSide border : borders) {
                    border.getCell().paintCollapsedBorder(c, border.getSide());
                }
            }
            c.getOutputDevice().endStructure(innerToken);
            c.getOutputDevice().endStructure(outerToken);
        }
    }

    private void paintListMarkers(RenderingContext c, List<DisplayListItem> blocks) {
        for (DisplayListItem dli : blocks) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            Object token = c.getOutputDevice().startStructure(StructureType.LIST_MARKER, (Box)dli);
            ((BlockBox)dli).paintListMarker(c);
            c.getOutputDevice().endStructure(token);
        }
    }

    private void paintInlineContent(RenderingContext c, List<DisplayListItem> inlines) {
        for (DisplayListItem dli : inlines) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            if (dli instanceof BlockBox) {
                BlockBox bb = (BlockBox)dli;
                if (bb.getStyle().requiresLayer()) continue;
                List<PageBox> pageBoxes = bb.getContainingLayer().getPages();
                DisplayListCollector dlCollector = new DisplayListCollector(pageBoxes);
                DisplayListContainer.DisplayListPageContainer pageInstructions = dlCollector.collectInlineBlock(c, bb, EnumSet.noneOf(DisplayListCollector.CollectFlags.class), c.getShadowPageNumber());
                this.paint(c, pageInstructions);
                continue;
            }
            InlinePaintable paintable = (InlinePaintable)((Object)dli);
            Object token = c.getOutputDevice().startStructure(StructureType.INLINE, (Box)dli);
            paintable.paintInline(c);
            c.getOutputDevice().endStructure(token);
        }
    }

    private void paintReplacedElements(RenderingContext c, List<DisplayListItem> replaceds) {
        for (DisplayListItem dli : replaceds) {
            if (dli instanceof OperatorClip) {
                OperatorClip clip = (OperatorClip)dli;
                this.clip(c, clip);
                continue;
            }
            if (dli instanceof OperatorSetClip) {
                OperatorSetClip setClip = (OperatorSetClip)dli;
                this.setClip(c, setClip);
                continue;
            }
            BlockBox box = (BlockBox)dli;
            this.paintReplacedElement(c, box);
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        Object outerToken = c.getOutputDevice().startStructure(StructureType.REPLACED, replaced);
        c.getOutputDevice().paintReplacedElement(c, replaced);
        c.getOutputDevice().endStructure(outerToken);
    }

    private void pushTransform(RenderingContext c, Box master, int shadowPage) {
        AffineTransform transform2 = TransformCreator.createPageCoordinatesTranform(c, master, c.getPage(), shadowPage);
        this.debugOnly("pushing transform", transform2);
        c.getOutputDevice().pushTransformLayer(transform2);
    }

    private void popTransform(RenderingContext c, Box master) {
        this.debugOnly("popping transform", null);
        c.getOutputDevice().popTransformLayer();
    }

    private void pushClipRect(RenderingContext c, Rectangle clip) {
        this.debugOnly("pushing clip rect", clip);
        c.getOutputDevice().pushClip(clip);
    }

    private void popClipRect(RenderingContext c) {
        this.debugOnly("popping clip rect", null);
        c.getOutputDevice().popClip();
    }

    private void paintFixed(RenderingContext c, Layer layer) {
        layer.positionFixedLayer(c);
        if (c.getShadowPageNumber() == -1) {
            SimplePainter painter = new SimplePainter(c.getPage().getMarginBorderPadding(c, 1), c.getPage().getMarginBorderPadding(c, 3));
            painter.paintLayer(c, layer);
        } else {
            Rectangle shadowRect = c.getPage().getDocumentCoordinatesContentBoundsForInsertedPage(c, c.getShadowPageNumber());
            c.getOutputDevice().translate(shadowRect.x, 0.0);
            SimplePainter painter = new SimplePainter(shadowRect.x, c.getPage().getMarginBorderPadding(c, 3));
            painter.paintLayer(c, layer);
            c.getOutputDevice().translate(-shadowRect.x, 0.0);
        }
    }

    public void paint(RenderingContext c, DisplayListContainer.DisplayListPageContainer pageOperations) {
        for (DisplayListOperation op : pageOperations.getOperations()) {
            Object token;
            DisplayListOperation dlo;
            if (op instanceof PaintRootElementBackground) {
                dlo = (PaintRootElementBackground)op;
                token = c.getOutputDevice().startStructure(StructureType.BACKGROUND, ((PaintRootElementBackground)dlo).getRoot());
                ((PaintRootElementBackground)dlo).getRoot().paintRootElementBackground(c);
                c.getOutputDevice().endStructure(token);
                continue;
            }
            if (op instanceof PaintLayerBackgroundAndBorder) {
                dlo = (PaintLayerBackgroundAndBorder)op;
                Object outerToken = c.getOutputDevice().startStructure(StructureType.LAYER, ((PaintLayerBackgroundAndBorder)dlo).getMaster());
                Object innerToken = c.getOutputDevice().startStructure(StructureType.BACKGROUND, ((PaintLayerBackgroundAndBorder)dlo).getMaster());
                ((PaintLayerBackgroundAndBorder)dlo).getMaster().paintBackground(c);
                ((PaintLayerBackgroundAndBorder)dlo).getMaster().paintBorder(c);
                c.getOutputDevice().endStructure(innerToken);
                c.getOutputDevice().endStructure(outerToken);
                continue;
            }
            if (op instanceof PaintReplacedElement) {
                dlo = (PaintReplacedElement)op;
                this.paintReplacedElement(c, ((PaintReplacedElement)dlo).getMaster());
                continue;
            }
            if (op instanceof PaintBackgroundAndBorders) {
                dlo = (PaintBackgroundAndBorders)op;
                this.paintBackgroundAndBorders(c, ((PaintBackgroundAndBorders)dlo).getBlocks(), ((PaintBackgroundAndBorders)dlo).getCollapedTableBorders());
                continue;
            }
            if (op instanceof PaintListMarkers) {
                dlo = (PaintListMarkers)op;
                this.paintListMarkers(c, ((PaintListMarkers)dlo).getBlocks());
                continue;
            }
            if (op instanceof PaintInlineContent) {
                dlo = (PaintInlineContent)op;
                this.paintInlineContent(c, ((PaintInlineContent)dlo).getInlines());
                continue;
            }
            if (op instanceof PaintReplacedElements) {
                dlo = (PaintReplacedElements)op;
                this.paintReplacedElements(c, ((PaintReplacedElements)dlo).getReplaceds());
                continue;
            }
            if (op instanceof PaintPushTransformLayer) {
                dlo = (PaintPushTransformLayer)op;
                this.pushTransform(c, ((PaintPushTransformLayer)dlo).getMaster(), ((PaintPushTransformLayer)dlo).getShadowPageNumber());
                continue;
            }
            if (op instanceof PaintPopTransformLayer) {
                dlo = (PaintPopTransformLayer)op;
                this.popTransform(c, ((PaintPopTransformLayer)dlo).getMaster());
                continue;
            }
            if (op instanceof PaintFixedLayer) {
                dlo = (PaintFixedLayer)op;
                token = c.getOutputDevice().startStructure(StructureType.RUNNING, ((PaintFixedLayer)dlo).getLayer().getMaster());
                this.paintFixed(c, ((PaintFixedLayer)dlo).getLayer());
                c.getOutputDevice().endStructure(token);
                continue;
            }
            if (op instanceof PaintPushClipRect) {
                dlo = (PaintPushClipRect)op;
                this.pushClipRect(c, ((PaintPushClipRect)dlo).getClipBox());
                continue;
            }
            if (!(op instanceof PaintPopClipRect)) continue;
            this.popClipRect(c);
        }
    }
}

