/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallsiteRedirectionTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "defaultThrowableConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "isSecondaryConstructorCall", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)Z", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "replaceSecondaryConstructorWithFactoryFunction", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "newTarget", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nSecondaryCtorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecondaryCtorLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CallsiteRedirectionTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1#2:332\n*E\n"})
final class CallsiteRedirectionTransformer
extends IrTransformer<IrFunction> {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrConstructorSymbol defaultThrowableConstructor;

    public CallsiteRedirectionTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.defaultThrowableConstructor = this.context.getDefaultThrowableCtor();
    }

    private final boolean isSecondaryConstructorCall(IrConstructor $this$isSecondaryConstructorCall) {
        return !$this$isSecondaryConstructorCall.isPrimary() && !Intrinsics.areEqual((Object)$this$isSecondaryConstructorCall, (Object)this.defaultThrowableConstructor) && !$this$isSecondaryConstructorCall.isExternal() && !this.context.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$isSecondaryConstructorCall)));
    }

    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable IrFunction data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return super.visitFunction(declaration, (Object)declaration);
    }

    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrFunction data) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitConstructorCall(expression2, (Object)data);
        IrConstructor target = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isSecondaryConstructorCall(target)) {
            IrSimpleFunction factory = SecondaryCtorLoweringKt.access$buildConstructorFactory(this.context, target, IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)target)));
            irElement = (IrElement)this.replaceSecondaryConstructorWithFactoryFunction((IrFunctionAccessExpression)expression2, factory.getSymbol());
        } else {
            irElement = (IrElement)expression2;
        }
        return irElement;
    }

    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrFunction data) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDelegatingConstructorCall(expression2, (Object)data);
        IrConstructor target = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isSecondaryConstructorCall(target)) {
            IrCall irCall;
            IrGetValueImpl irGetValueImpl;
            IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)target));
            IrSimpleFunction delegate = SecondaryCtorLoweringKt.access$buildConstructorDelegate(this.context, target, klass);
            IrCall newCall = this.replaceSecondaryConstructorWithFactoryFunction((IrFunctionAccessExpression)expression2, delegate.getSymbol());
            IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u240 = expression2;
            boolean bl = false;
            IrFunction irFunction = data;
            if (irFunction instanceof IrConstructor) {
                IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)((IrConstructor)data)).getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                IrValueParameter thisReceiver = irValueParameter;
                irGetValueImpl = BuildersKt.IrGetValueImpl$default((int)$this$visitDelegatingConstructorCall_u24lambda_u240.getStartOffset(), (int)$this$visitDelegatingConstructorCall_u24lambda_u240.getEndOffset(), (IrType)thisReceiver.getType(), (IrValueSymbol)((IrValueSymbol)thisReceiver.getSymbol()), null, (int)16, null);
            } else if (irFunction instanceof IrSimpleFunction) {
                IrValueParameter lastValueParameter = (IrValueParameter)CollectionsKt.last((List)((IrSimpleFunction)data).getValueParameters());
                irGetValueImpl = BuildersKt.IrGetValueImpl$default((int)$this$visitDelegatingConstructorCall_u24lambda_u240.getStartOffset(), (int)$this$visitDelegatingConstructorCall_u24lambda_u240.getEndOffset(), (IrType)lastValueParameter.getType(), (IrValueSymbol)((IrValueSymbol)lastValueParameter.getSymbol()), null, (int)16, null);
            } else {
                if (irFunction == null) {
                    CompilationExceptionKt.compilationException((String)"Parent function can't be null", (IrElement)((IrElement)expression2));
                    throw new KotlinNothingValueException();
                }
                throw new NoWhenBranchMatchedException();
            }
            IrGetValueImpl readThis = irGetValueImpl;
            IrCall $this$visitDelegatingConstructorCall_u24lambda_u241 = irCall = newCall;
            boolean bl2 = false;
            $this$visitDelegatingConstructorCall_u24lambda_u241.putValueArgument(expression2.getValueArgumentsCount(), (IrExpression)readThis);
            irElement = (IrElement)irCall;
        } else {
            irElement = (IrElement)expression2;
        }
        return irElement;
    }

    private final IrCall replaceSecondaryConstructorWithFactoryFunction(IrFunctionAccessExpression call2, IrSimpleFunctionSymbol newTarget) {
        IrClassSymbol irClassSymbol;
        IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)((IrFunctionSymbol)call2.getSymbol()).getOwner()));
        IrClassSymbol irClassSymbol2 = irClassSymbol = irClass.getSymbol();
        IrStatementOrigin irStatementOrigin = null;
        int n = call2.getTypeArgumentsCount();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = newTarget;
        IrType irType = call2.getType();
        int n2 = call2.getEndOffset();
        int n3 = call2.getStartOffset();
        boolean bl = false;
        boolean bl2 = this.context.getEs6mode() && ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement(call2);
        IrClassSymbol $this$replaceSecondaryConstructorWithFactoryFunction_u24lambda_u243 = irClassSymbol = BuildersKt.IrCallImpl$default((int)n3, (int)n2, (IrType)irType, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, (int)n, irStatementOrigin, (IrClassSymbol)(bl2 ? irClassSymbol : null), (int)32, null);
        boolean bl3 = false;
        IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)$this$replaceSecondaryConstructorWithFactoryFunction_u24lambda_u243), (IrMemberAccessExpression)((IrMemberAccessExpression)call2), (int)0, (int)2, null);
        int n4 = call2.getValueArgumentsCount();
        for (int i = 0; i < n4; ++i) {
            $this$replaceSecondaryConstructorWithFactoryFunction_u24lambda_u243.putValueArgument(i, call2.getValueArgument(i));
        }
        return (IrCall)irClassSymbol;
    }
}

