/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import com.intellij.rt.coverage.util.classFinder.ClassPathEntry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private final ClassFilter myFilter;
    private final Set<ClassLoader> myClassloaders;

    /*
     * WARNING - void declaration
     */
    public ClassFinder(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        this(new ClassFilter.PatternFilter((List<Pattern>)var1_1, (List<Pattern>)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassFinder(ClassFilter filter) {
        void var1_1;
        this.myFilter = var1_1;
        this.myClassloaders = new HashSet<ClassLoader>();
    }

    /*
     * WARNING - void declaration
     */
    public void addClassLoader(ClassLoader cl) {
        if (cl != null) {
            if (cl.getClass().getName().equals("jetbrains.buildServer.agent.AgentClassLoader")) {
                return;
            }
            if (cl instanceof URLClassLoader) {
                this.myClassloaders.add(cl);
            }
            if (cl.getParent() != null) {
                void var1_1;
                this.addClassLoader(var1_1.getParent());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void iterateMatchedClasses(ClassEntry.Consumer consumer) {
        for (ClassPathEntry entry : this.getClassPathEntries()) {
            try {
                entry.iterateMatchedClasses(this.myFilter, consumer);
            }
            catch (IOException e) {
                void var3_4;
                ErrorReporter.info("Error during iterating classes.", (Throwable)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<ClassPathEntry> getClassPathEntries() {
        void var1_1;
        HashSet<ClassPathEntry> result = new HashSet<ClassPathEntry>();
        result.addAll(ClassFinder.extractEntries(System.getProperty("java.class.path")));
        result.addAll(ClassFinder.extractEntries(System.getProperty("sun.boot.class.path")));
        this.collectClassloaderEntries(result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void collectClassloaderEntries(Set<ClassPathEntry> result) {
        for (ClassLoader classLoader : this.myClassloaders) {
            URL[] cl = (URL[])classLoader;
            try {
                URL[] uRLArray = cl.getURLs();
                cl = uRLArray;
                cl = uRLArray;
                int n = uRLArray.length;
                for (int i = 0; i < n; ++i) {
                    URL url = cl[i];
                    if (!"file".equals(url.getProtocol())) continue;
                    String path = this.fixPath(url.getPath());
                    result.add(new ClassPathEntry(path));
                }
            }
            catch (Exception e) {
                void var3_4;
                ErrorReporter.info("Exception occurred on trying collect ClassPath URLs. One of possible reasons is shutting down Tomcat before finishing tests. Coverage won't be affected but some of uncovered classes could be missing from the report.", (Throwable)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String fixPath(String path) {
        void var2_2;
        String result = path;
        try {
            result = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            void var3_3;
            void var1_1;
            ErrorReporter.info("Could not decode the path: " + (String)var1_1 + ", error: " + e.getMessage(), (Throwable)var3_3);
        }
        if (result.isEmpty()) {
            return result;
        }
        if (result.charAt(0) == '/' && result.length() > 3 && result.charAt(2) == ':') {
            result = result.substring(1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<ClassPathEntry> extractEntries(String classPath) {
        void var1_1;
        String[] stringArray;
        if (classPath == null) {
            return Collections.emptyList();
        }
        String[] entries = classPath.split(System.getProperty("path.separator"));
        HashSet<ClassPathEntry> result = new HashSet<ClassPathEntry>();
        for (String entry : stringArray) {
            result.add(new ClassPathEntry(entry));
        }
        return var1_1;
    }

    public Set<ClassLoader> getClassloaders() {
        return this.myClassloaders;
    }
}

