/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] a;
    private static final String[] b;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 55660994942714L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.a(-1781241300 - -16389, -1781241300 - -28126, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.a(-1781241300 - -16388, 1781241300 - 17864, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 47903748457630L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.X();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.a(1978239510 - 4543, -1978239510 - -20600, (int)l2) + string + WindowsNamedPipeAgentIpc.a(1978239510 - 4544, -1978239510 - -18811, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.a(1978239510 - 4549, -1978239510 - -12037, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 129989472250635L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.X();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24555), -2007992400 - -((char)-10176), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24554), 2007992400 - (char)-16343, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24553), 2007992400 - (char)-7996, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24552), 2007992400 - (char)-29377, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24551), 2007992400 - (char)-27318, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24553), 2007992400 - (char)-7996, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-2007992400 - -((char)-24550), 2007992400 - (char)-9002, (int)l2));
            if (ActionTimestamp.w() != null) {
                SshAgentIpcService.w(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 32948178976217L;
                    n3 = SshAgentIpcService.X();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 77414090486922L;
                int n3 = SshAgentIpcService.X();
                this.assertConnectionThread();
                n2 = n3;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1599971490 - 22616, 1599971490 - 30512, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22613, 1599971490 - 32003, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22614, 1599971490 - 11674, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1599971490 - 22616, 1599971490 - 30512, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22611, 1599971490 - (char)-29341, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1599971490 - 22616, 1599971490 - 30512, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22612, -1599971490 - -15230, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22609, -1599971490 - -((char)-31955), (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22614, 1599971490 - 11674, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1599971490 - 22616, 1599971490 - 30512, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.a(1599971490 - 22620, -1599971490 - -((char)-26449), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1599971490 - 22610, 1599971490 - (char)-31270, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 135381653987201L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(0x99FF66 + (char)-4287, 0x99FF66 + (char)-19013, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 103442621111625L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1666161840 + (char)-12354, -1666161840 + -((char)-19920), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u009d\u00f3\u00a2\u00fc\u00c5\"@\u00e4\u00bc\u00d7\u00de\u0003+\u00ea\u00aa\u008f\u00936\u00d6\u0014\u00d2CK\u00ec\u00e3\u00e2\u00f9y\tb\u00ada\u0087_\u00fe\u00b2\u00f4W=\u0085";
                        var4_3 = "\u009d\u00f3\u00a2\u00fc\u00c5\"@\u00e4\u00bc\u00d7\u00de\u0003+\u00ea\u00aa\u008f\u00936\u00d6\u0014\u00d2CK\u00ec\u00e3\u00e2\u00f9y\tb\u00ada\u0087_\u00fe\u00b2\u00f4W=\u0085".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 64;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 111;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 48;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 96;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 76;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 34;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 108;
                                        break;
                                    }
                                    default: {
                                        v11 = 34;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFF126) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 140;
                            case 1 -> 177;
                            case 2 -> 158;
                            case 3 -> 181;
                            case 4 -> 86;
                            case 5 -> 195;
                            case 6 -> 168;
                            case 7 -> 218;
                            case 8 -> 49;
                            case 9 -> 17;
                            case 10 -> 123;
                            case 11 -> 25;
                            case 12 -> 112;
                            case 13 -> 232;
                            case 14 -> 227;
                            case 15 -> 236;
                            case 16 -> 15;
                            case 17 -> 54;
                            case 18 -> 3;
                            case 19 -> 81;
                            case 20 -> 24;
                            case 21 -> 144;
                            case 22 -> 174;
                            case 23 -> 141;
                            case 24 -> 13;
                            case 25 -> 48;
                            case 26 -> 201;
                            case 27 -> 207;
                            case 28 -> 22;
                            case 29 -> 7;
                            case 30 -> 75;
                            case 31 -> 210;
                            case 32 -> 206;
                            case 33 -> 238;
                            case 34 -> 247;
                            case 35 -> 47;
                            case 36 -> 164;
                            case 37 -> 88;
                            case 38 -> 57;
                            case 39 -> 159;
                            case 40 -> 126;
                            case 41 -> 229;
                            case 42 -> 240;
                            case 43 -> 124;
                            case 44 -> 219;
                            case 45 -> 153;
                            case 46 -> 253;
                            case 47 -> 252;
                            case 48 -> 32;
                            case 49 -> 163;
                            case 50 -> 136;
                            case 51 -> 216;
                            case 52 -> 180;
                            case 53 -> 224;
                            case 54 -> 191;
                            case 55 -> 67;
                            case 56 -> 2;
                            case 57 -> 233;
                            case 58 -> 5;
                            case 59 -> 37;
                            case 60 -> 169;
                            case 61 -> 8;
                            case 62 -> 43;
                            case 63 -> 255;
                            case 64 -> 254;
                            case 65 -> 0;
                            case 66 -> 92;
                            case 67 -> 237;
                            case 68 -> 71;
                            case 69 -> 220;
                            case 70 -> 80;
                            case 71 -> 46;
                            case 72 -> 183;
                            case 73 -> 129;
                            case 74 -> 73;
                            case 75 -> 91;
                            case 76 -> 166;
                            case 77 -> 185;
                            case 78 -> 107;
                            case 79 -> 63;
                            case 80 -> 151;
                            case 81 -> 42;
                            case 82 -> 203;
                            case 83 -> 176;
                            case 84 -> 250;
                            case 85 -> 109;
                            case 86 -> 102;
                            case 87 -> 58;
                            case 88 -> 139;
                            case 89 -> 156;
                            case 90 -> 104;
                            case 91 -> 70;
                            case 92 -> 11;
                            case 93 -> 184;
                            case 94 -> 72;
                            case 95 -> 115;
                            case 96 -> 90;
                            case 97 -> 173;
                            case 98 -> 170;
                            case 99 -> 26;
                            case 100 -> 100;
                            case 101 -> 138;
                            case 102 -> 132;
                            case 103 -> 94;
                            case 104 -> 157;
                            case 105 -> 204;
                            case 106 -> 40;
                            case 107 -> 172;
                            case 108 -> 98;
                            case 109 -> 29;
                            case 110 -> 175;
                            case 111 -> 119;
                            case 112 -> 44;
                            case 113 -> 10;
                            case 114 -> 146;
                            case 115 -> 68;
                            case 116 -> 27;
                            case 117 -> 179;
                            case 118 -> 212;
                            case 119 -> 241;
                            case 120 -> 242;
                            case 121 -> 103;
                            case 122 -> 161;
                            case 123 -> 190;
                            case 124 -> 95;
                            case 125 -> 84;
                            case 126 -> 135;
                            case 127 -> 97;
                            case 128 -> 55;
                            case 129 -> 106;
                            case 130 -> 130;
                            case 131 -> 76;
                            case 132 -> 33;
                            case 133 -> 101;
                            case 134 -> 200;
                            case 135 -> 35;
                            case 136 -> 213;
                            case 137 -> 78;
                            case 138 -> 182;
                            case 139 -> 56;
                            case 140 -> 116;
                            case 141 -> 21;
                            case 142 -> 194;
                            case 143 -> 79;
                            case 144 -> 202;
                            case 145 -> 118;
                            case 146 -> 162;
                            case 147 -> 197;
                            case 148 -> 120;
                            case 149 -> 186;
                            case 150 -> 192;
                            case 151 -> 167;
                            case 152 -> 239;
                            case 153 -> 39;
                            case 154 -> 52;
                            case 155 -> 16;
                            case 156 -> 249;
                            case 157 -> 171;
                            case 158 -> 18;
                            case 159 -> 243;
                            case 160 -> 99;
                            case 161 -> 143;
                            case 162 -> 187;
                            case 163 -> 12;
                            case 164 -> 60;
                            case 165 -> 246;
                            case 166 -> 111;
                            case 167 -> 154;
                            case 168 -> 114;
                            case 169 -> 96;
                            case 170 -> 189;
                            case 171 -> 121;
                            case 172 -> 199;
                            case 173 -> 160;
                            case 174 -> 248;
                            case 175 -> 125;
                            case 176 -> 82;
                            case 177 -> 211;
                            case 178 -> 196;
                            case 179 -> 193;
                            case 180 -> 155;
                            case 181 -> 62;
                            case 182 -> 6;
                            case 183 -> 110;
                            case 184 -> 226;
                            case 185 -> 178;
                            case 186 -> 134;
                            case 187 -> 222;
                            case 188 -> 137;
                            case 189 -> 225;
                            case 190 -> 30;
                            case 191 -> 1;
                            case 192 -> 74;
                            case 193 -> 83;
                            case 194 -> 61;
                            case 195 -> 105;
                            case 196 -> 38;
                            case 197 -> 133;
                            case 198 -> 127;
                            case 199 -> 198;
                            case 200 -> 108;
                            case 201 -> 145;
                            case 202 -> 28;
                            case 203 -> 122;
                            case 204 -> 23;
                            case 205 -> 31;
                            case 206 -> 221;
                            case 207 -> 234;
                            case 208 -> 93;
                            case 209 -> 188;
                            case 210 -> 131;
                            case 211 -> 59;
                            case 212 -> 69;
                            case 213 -> 244;
                            case 214 -> 215;
                            case 215 -> 231;
                            case 216 -> 223;
                            case 217 -> 34;
                            case 218 -> 51;
                            case 219 -> 14;
                            case 220 -> 208;
                            case 221 -> 235;
                            case 222 -> 217;
                            case 223 -> 148;
                            case 224 -> 36;
                            case 225 -> 209;
                            case 226 -> 150;
                            case 227 -> 117;
                            case 228 -> 50;
                            case 229 -> 165;
                            case 230 -> 205;
                            case 231 -> 19;
                            case 232 -> 113;
                            case 233 -> 66;
                            case 234 -> 64;
                            case 235 -> 20;
                            case 236 -> 230;
                            case 237 -> 228;
                            case 238 -> 251;
                            case 239 -> 147;
                            case 240 -> 149;
                            case 241 -> 41;
                            case 242 -> 9;
                            case 243 -> 245;
                            case 244 -> 45;
                            case 245 -> 128;
                            case 246 -> 89;
                            case 247 -> 87;
                            case 248 -> 53;
                            case 249 -> 85;
                            case 250 -> 142;
                            case 251 -> 65;
                            case 252 -> 77;
                            case 253 -> 214;
                            case 254 -> 152;
                            default -> 4;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.w(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 129767592026591L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.X();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-549838650 + -((char)-31833), -549838650 + -9375, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.a(-549838650 + -((char)-31821), 549838650 + 19998, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.a(-549838650 + -((char)-31808), -549838650 + -8806, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-549838650 + -((char)-31833), -549838650 + -9375, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.a(-549838650 + -((char)-31821), 549838650 + 19998, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.a(-549838650 + -((char)-31809), -549838650 + -((char)-29633), (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 84440606203034L;
                        int n3 = SshAgentIpcService.X();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.a(1549116330 + 31899, 1549116330 + (char)-21472, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.a(1549116330 + 31898, 1549116330 + 31123, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 75280793852794L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = SshAgentIpcService.X();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21684), -1392880890 + -((char)-29564), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21680), 1392880890 + 27395, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21665), 1392880890 + (char)-16058, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21680), 1392880890 + 27395, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21686), -1392880890 + -((char)-18930), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21684), -1392880890 + -((char)-29564), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21680), 1392880890 + 27395, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21664), -1392880890 + -((char)-23450), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21684), -1392880890 + -((char)-29564), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21680), 1392880890 + 27395, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21667), 1392880890 + 31246, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21684), -1392880890 + -((char)-29564), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21680), 1392880890 + 27395, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1392880890 + -((char)-21666), 1392880890 + (char)-27505, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 36697916876084L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.w();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16450, 1716361650 - (char)-7962, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16454, -1716230580 + -((char)-871), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16435, 1716361650 - (char)-19430, (int)l2) + this.state + WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16434, 1716361650 - (char)-23598, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16450, 1716361650 - (char)-7962, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16454, -1716230580 + -((char)-871), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16433, -1716361650 - -((char)-22777), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16450, 1716361650 - (char)-7962, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16454, -1716230580 + -((char)-871), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16432, -1716361650 - -((char)-8814), (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16450, 1716361650 - (char)-7962, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16454, -1716230580 + -((char)-871), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16431, -1716361650 - -((char)-23947), (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16450, 1716361650 - (char)-7962, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16454, -1716230580 + -((char)-871), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(1716361650 - (char)-16430, 1716361650 - (char)-23870, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "y%1\u00bd\u00dd 8\u009b\u0014s\u00cfH\u0007\f\u00ff\u00adz\u00c3\u00aaO\u00ad\u001d\u0091\u0083{\u0095\u0087[O\u0006\u000bc\u007fu~x\u0018\u00859\u00f6\u00e9Y\u00e7\u0005\u00b9\u001e\u00af\u00fb}\u00edt\u00cfE\u00b5)q\u0007>0\u00ab\u00e2\tf\u0092\u0014-n\u00e0\u00fb\u0011\u00fd\u0005\u0015\f\u00bc\u0098\u001c\bc\u00dbr\u0013\u00e7\u00d3y\u0007\u0005+\u00c2{A\u00e4\u001e;\u009cl\u00ee\u009b\u00c3\u00ffG\u00e4d\u00ef\u0083#\u008b\u00b4\u00de;\u00cbr\u00af\u00f2\n>h\u00a7PT\u00f4~\u00d3\u0010U\u00f3E\u00c6\u00e9\u00f4GX\u008e5/T=$\u00d8\u00b4\tt\u00f6\u0080\u00b0\u00aft\u00e5\u001c\u00d0\u0010L>f\u007f\u008d\u00c3\u00cb\u00be\u001f\u00e9\u001d\u00cf{W\u0010\u00da?\u00ca\u00f9ZBP_\u0003\u00b8\nJw\u00bd\u008f\u00ba\u001c\u00c1\u00ebM\u0015\u00ba\u0090\u00fa\t\u0010Q\u00b7\u0087\u00bc3\u008c\u00f1\u00ffI\u009f\u00cc)\u00f9\u00det->\u00a3\u00b7\u00c3\u0087c\u00e9\u00842\u00b1\u00f3\b,\u00ab\u0007\u0088\u0080{P+Qr@\b\u00ec\u0090\u0083z\u00d9\u00fe\u00be\u00a2\fu\u00ca\u00a0*\u00a0\u0096\u007f\u00a8\u00a0c\u00b8\u009aFO\u00a6\u00e7\u00a7H'b\u009e\u0003\u00a9\u00c6\u0007/\u00e5\u0017\fv\u0093\u00a6\u00ce\u00f4&\u0086\u00b9\u0096\u00a9\u008ct\u00ed\u00bc\u0010\u00c5In\u000e6{p\u008f<\u00d2\u0094\u00a1\u00de\u009bE>=/~6[{W\u00fb\f\u0080\u009f\u00c6\u000b\u00b0\u001f \u00b3\u00de\u00c2z\fZ\r\u001fJ.B\u00b8^\tG\u001e\u00f3O\r\u00e6\u007f:4YP\u00d3bf;\u00b3\u00d0\u00f4\u001b\u0013\u00d4Ps\u00b6\u00c1\u000b\u00aa\u00b7[\u0085\u00dfc\u0090\u0016]\u00b8\r\u0015@\u0091\u0006Bs\u00f3\u00e9yL\u00b5\u00e7r\u009c\u0004U\u00c8\u0087uE\u00cb\u00e9)\u0018\u0014\b\u00ff\u0017\u00e1n\u0003\u00d6\u00ec\u00a9\u0092\u00ef\u00be\u00b8\u00cc\u009e\u00e9`\u0086\u008b\u00d7\u0000`n\u00c8\u00adSs\"C(\u00ddv\u00fa\u00b8\u00fb\u00bc\u0014\f\u0002\u0007\u00c6 \u00d9c\t/6\u0007\u008d\u0000\u00d4\u000bO\u00cd\u00e8(\u00a6C\u00934\u00d4\u00f2\u00e0Fw\u0093\u00b7K\u000f\u0004\u00e6\u0018R\u00deW#\f]\u009f\u00fa\r'w\u00d5\u001f\u0092\u0015'\u00ec\u00fcBDV^2\u00a3\u000f(\u0086\f\u00a5\u00cf\u00ac&N\u00da\u001f\u00a3\u008b-H<\"\u0005\u00a2\u00ab)c;\u00e0X\u0007\u0087\u0093\u00ff\u00ab\u001fT6\u00e8\u009f$\n\u00e9F\u00ec\u0002`\u00d0\u00a1\u008e\u00d6\u00abU\u001e1C\u000e\u008c\u0016\u0098\u00b7]\u00eet\u0006\u0090\u0016\u00ea\u00aa\bf\u001b{>a\u00b7\u0099[y\u00ecf\u00cc\u00b9\u00f02\u001bA\u00a0\u00e2\u00e7\u00d8\u0099M\u0000\u000bl\u00d7p\u0002\n\u00e6M\u0016\u00dec\u0092\u00f5\u00ff\\\u00cc\u00181\u00b9(J\u00b1X]\u00d2\u00fc\u00c2(\u00ae\u00b9\u0083\u00cc\u0092$\u00a0\u00d7\b\u00d4yc\u0010)[X`v\u001a\u00d0\u00cf%\u00e2(/\n;\u00a4\u00bd\u00f4@\u009bd\r1\u00b6\u001e@\u00d8^\u00e6mI\u00b9\u00bf\u00cag\u00f4x|u\u0000\u00c5\u009b8";
                var4_3 = "y%1\u00bd\u00dd 8\u009b\u0014s\u00cfH\u0007\f\u00ff\u00adz\u00c3\u00aaO\u00ad\u001d\u0091\u0083{\u0095\u0087[O\u0006\u000bc\u007fu~x\u0018\u00859\u00f6\u00e9Y\u00e7\u0005\u00b9\u001e\u00af\u00fb}\u00edt\u00cfE\u00b5)q\u0007>0\u00ab\u00e2\tf\u0092\u0014-n\u00e0\u00fb\u0011\u00fd\u0005\u0015\f\u00bc\u0098\u001c\bc\u00dbr\u0013\u00e7\u00d3y\u0007\u0005+\u00c2{A\u00e4\u001e;\u009cl\u00ee\u009b\u00c3\u00ffG\u00e4d\u00ef\u0083#\u008b\u00b4\u00de;\u00cbr\u00af\u00f2\n>h\u00a7PT\u00f4~\u00d3\u0010U\u00f3E\u00c6\u00e9\u00f4GX\u008e5/T=$\u00d8\u00b4\tt\u00f6\u0080\u00b0\u00aft\u00e5\u001c\u00d0\u0010L>f\u007f\u008d\u00c3\u00cb\u00be\u001f\u00e9\u001d\u00cf{W\u0010\u00da?\u00ca\u00f9ZBP_\u0003\u00b8\nJw\u00bd\u008f\u00ba\u001c\u00c1\u00ebM\u0015\u00ba\u0090\u00fa\t\u0010Q\u00b7\u0087\u00bc3\u008c\u00f1\u00ffI\u009f\u00cc)\u00f9\u00det->\u00a3\u00b7\u00c3\u0087c\u00e9\u00842\u00b1\u00f3\b,\u00ab\u0007\u0088\u0080{P+Qr@\b\u00ec\u0090\u0083z\u00d9\u00fe\u00be\u00a2\fu\u00ca\u00a0*\u00a0\u0096\u007f\u00a8\u00a0c\u00b8\u009aFO\u00a6\u00e7\u00a7H'b\u009e\u0003\u00a9\u00c6\u0007/\u00e5\u0017\fv\u0093\u00a6\u00ce\u00f4&\u0086\u00b9\u0096\u00a9\u008ct\u00ed\u00bc\u0010\u00c5In\u000e6{p\u008f<\u00d2\u0094\u00a1\u00de\u009bE>=/~6[{W\u00fb\f\u0080\u009f\u00c6\u000b\u00b0\u001f \u00b3\u00de\u00c2z\fZ\r\u001fJ.B\u00b8^\tG\u001e\u00f3O\r\u00e6\u007f:4YP\u00d3bf;\u00b3\u00d0\u00f4\u001b\u0013\u00d4Ps\u00b6\u00c1\u000b\u00aa\u00b7[\u0085\u00dfc\u0090\u0016]\u00b8\r\u0015@\u0091\u0006Bs\u00f3\u00e9yL\u00b5\u00e7r\u009c\u0004U\u00c8\u0087uE\u00cb\u00e9)\u0018\u0014\b\u00ff\u0017\u00e1n\u0003\u00d6\u00ec\u00a9\u0092\u00ef\u00be\u00b8\u00cc\u009e\u00e9`\u0086\u008b\u00d7\u0000`n\u00c8\u00adSs\"C(\u00ddv\u00fa\u00b8\u00fb\u00bc\u0014\f\u0002\u0007\u00c6 \u00d9c\t/6\u0007\u008d\u0000\u00d4\u000bO\u00cd\u00e8(\u00a6C\u00934\u00d4\u00f2\u00e0Fw\u0093\u00b7K\u000f\u0004\u00e6\u0018R\u00deW#\f]\u009f\u00fa\r'w\u00d5\u001f\u0092\u0015'\u00ec\u00fcBDV^2\u00a3\u000f(\u0086\f\u00a5\u00cf\u00ac&N\u00da\u001f\u00a3\u008b-H<\"\u0005\u00a2\u00ab)c;\u00e0X\u0007\u0087\u0093\u00ff\u00ab\u001fT6\u00e8\u009f$\n\u00e9F\u00ec\u0002`\u00d0\u00a1\u008e\u00d6\u00abU\u001e1C\u000e\u008c\u0016\u0098\u00b7]\u00eet\u0006\u0090\u0016\u00ea\u00aa\bf\u001b{>a\u00b7\u0099[y\u00ecf\u00cc\u00b9\u00f02\u001bA\u00a0\u00e2\u00e7\u00d8\u0099M\u0000\u000bl\u00d7p\u0002\n\u00e6M\u0016\u00dec\u0092\u00f5\u00ff\\\u00cc\u00181\u00b9(J\u00b1X]\u00d2\u00fc\u00c2(\u00ae\u00b9\u0083\u00cc\u0092$\u00a0\u00d7\b\u00d4yc\u0010)[X`v\u001a\u00d0\u00cf%\u00e2(/\n;\u00a4\u00bd\u00f4@\u009bd\r1\u00b6\u001e@\u00d8^\u00e6mI\u00b9\u00bf\u00cag\u00f4x|u\u0000\u00c5\u009b8".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 120;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = ">\u00c1\u00e4e\u0004,\u00eba\u0081\u001d\u001c\u00de\u00a5\u008b\u008fBPZ<\u00ea\u00d9\u007f\u00c8'\u00ee\u00a9\u0007\u0011\u00f1\u00f5\u00fb\u00bb\u0099\u0012\u00ae%\u0094j\u00ba";
                    var4_3 = ">\u00c1\u00e4e\u0004,\u00eba\u0081\u001d\u001c\u00de\u00a5\u008b\u008fBPZ<\u00ea\u00d9\u007f\u00c8'\u00ee\u00a9\u0007\u0011\u00f1\u00f5\u00fb\u00bb\u0099\u0012\u00ae%\u0094j\u00ba".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 80;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 72;
                            break;
                        }
                        case 1: {
                            v15 = 99;
                            break;
                        }
                        case 2: {
                            v15 = 110;
                            break;
                        }
                        case 3: {
                            v15 = 35;
                            break;
                        }
                        case 4: {
                            v15 = 111;
                            break;
                        }
                        case 5: {
                            v15 = 44;
                            break;
                        }
                        default: {
                            v15 = 55;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.a = var5;
        WindowsNamedPipeAgentIpc.b = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String a(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x7CCB) & 0xFFFF;
        if (b[n5] == null) {
            int n6;
            char[] cArray = a[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 163;
                case 1 -> 38;
                case 2 -> 148;
                case 3 -> 119;
                case 4 -> 134;
                case 5 -> 79;
                case 6 -> 206;
                case 7 -> 147;
                case 8 -> 197;
                case 9 -> 164;
                case 10 -> 4;
                case 11 -> 233;
                case 12 -> 15;
                case 13 -> 179;
                case 14 -> 90;
                case 15 -> 209;
                case 16 -> 107;
                case 17 -> 127;
                case 18 -> 126;
                case 19 -> 200;
                case 20 -> 94;
                case 21 -> 121;
                case 22 -> 178;
                case 23 -> 65;
                case 24 -> 184;
                case 25 -> 150;
                case 26 -> 149;
                case 27 -> 28;
                case 28 -> 172;
                case 29 -> 115;
                case 30 -> 35;
                case 31 -> 86;
                case 32 -> 215;
                case 33 -> 103;
                case 34 -> 255;
                case 35 -> 19;
                case 36 -> 211;
                case 37 -> 166;
                case 38 -> 219;
                case 39 -> 253;
                case 40 -> 70;
                case 41 -> 26;
                case 42 -> 40;
                case 43 -> 78;
                case 44 -> 96;
                case 45 -> 91;
                case 46 -> 173;
                case 47 -> 12;
                case 48 -> 100;
                case 49 -> 144;
                case 50 -> 140;
                case 51 -> 186;
                case 52 -> 14;
                case 53 -> 99;
                case 54 -> 83;
                case 55 -> 30;
                case 56 -> 196;
                case 57 -> 22;
                case 58 -> 152;
                case 59 -> 177;
                case 60 -> 192;
                case 61 -> 250;
                case 62 -> 214;
                case 63 -> 251;
                case 64 -> 157;
                case 65 -> 129;
                case 66 -> 201;
                case 67 -> 236;
                case 68 -> 243;
                case 69 -> 54;
                case 70 -> 220;
                case 71 -> 62;
                case 72 -> 42;
                case 73 -> 183;
                case 74 -> 216;
                case 75 -> 59;
                case 76 -> 82;
                case 77 -> 185;
                case 78 -> 168;
                case 79 -> 76;
                case 80 -> 245;
                case 81 -> 88;
                case 82 -> 146;
                case 83 -> 195;
                case 84 -> 0;
                case 85 -> 114;
                case 86 -> 247;
                case 87 -> 169;
                case 88 -> 232;
                case 89 -> 182;
                case 90 -> 61;
                case 91 -> 222;
                case 92 -> 45;
                case 93 -> 188;
                case 94 -> 34;
                case 95 -> 235;
                case 96 -> 36;
                case 97 -> 158;
                case 98 -> 240;
                case 99 -> 204;
                case 100 -> 80;
                case 101 -> 11;
                case 102 -> 98;
                case 103 -> 210;
                case 104 -> 53;
                case 105 -> 50;
                case 106 -> 101;
                case 107 -> 131;
                case 108 -> 135;
                case 109 -> 71;
                case 110 -> 187;
                case 111 -> 171;
                case 112 -> 117;
                case 113 -> 154;
                case 114 -> 203;
                case 115 -> 212;
                case 116 -> 110;
                case 117 -> 63;
                case 118 -> 205;
                case 119 -> 5;
                case 120 -> 49;
                case 121 -> 33;
                case 122 -> 193;
                case 123 -> 116;
                case 124 -> 221;
                case 125 -> 16;
                case 126 -> 176;
                case 127 -> 17;
                case 128 -> 252;
                case 129 -> 249;
                case 130 -> 242;
                case 131 -> 223;
                case 132 -> 118;
                case 133 -> 74;
                case 134 -> 58;
                case 135 -> 254;
                case 136 -> 52;
                case 137 -> 23;
                case 138 -> 231;
                case 139 -> 67;
                case 140 -> 2;
                case 141 -> 180;
                case 142 -> 189;
                case 143 -> 47;
                case 144 -> 112;
                case 145 -> 136;
                case 146 -> 208;
                case 147 -> 181;
                case 148 -> 123;
                case 149 -> 25;
                case 150 -> 132;
                case 151 -> 170;
                case 152 -> 237;
                case 153 -> 120;
                case 154 -> 162;
                case 155 -> 153;
                case 156 -> 226;
                case 157 -> 43;
                case 158 -> 39;
                case 159 -> 24;
                case 160 -> 44;
                case 161 -> 77;
                case 162 -> 51;
                case 163 -> 151;
                case 164 -> 229;
                case 165 -> 6;
                case 166 -> 248;
                case 167 -> 227;
                case 168 -> 32;
                case 169 -> 142;
                case 170 -> 241;
                case 171 -> 20;
                case 172 -> 60;
                case 173 -> 46;
                case 174 -> 199;
                case 175 -> 122;
                case 176 -> 230;
                case 177 -> 48;
                case 178 -> 56;
                case 179 -> 175;
                case 180 -> 125;
                case 181 -> 102;
                case 182 -> 73;
                case 183 -> 13;
                case 184 -> 130;
                case 185 -> 66;
                case 186 -> 159;
                case 187 -> 161;
                case 188 -> 109;
                case 189 -> 217;
                case 190 -> 224;
                case 191 -> 27;
                case 192 -> 55;
                case 193 -> 124;
                case 194 -> 228;
                case 195 -> 105;
                case 196 -> 246;
                case 197 -> 141;
                case 198 -> 64;
                case 199 -> 213;
                case 200 -> 69;
                case 201 -> 81;
                case 202 -> 108;
                case 203 -> 234;
                case 204 -> 143;
                case 205 -> 3;
                case 206 -> 167;
                case 207 -> 160;
                case 208 -> 1;
                case 209 -> 75;
                case 210 -> 95;
                case 211 -> 89;
                case 212 -> 165;
                case 213 -> 225;
                case 214 -> 218;
                case 215 -> 29;
                case 216 -> 138;
                case 217 -> 68;
                case 218 -> 113;
                case 219 -> 9;
                case 220 -> 156;
                case 221 -> 207;
                case 222 -> 145;
                case 223 -> 111;
                case 224 -> 137;
                case 225 -> 238;
                case 226 -> 97;
                case 227 -> 194;
                case 228 -> 198;
                case 229 -> 244;
                case 230 -> 191;
                case 231 -> 139;
                case 232 -> 57;
                case 233 -> 41;
                case 234 -> 190;
                case 235 -> 87;
                case 236 -> 93;
                case 237 -> 106;
                case 238 -> 31;
                case 239 -> 174;
                case 240 -> 7;
                case 241 -> 84;
                case 242 -> 92;
                case 243 -> 8;
                case 244 -> 104;
                case 245 -> 128;
                case 246 -> 202;
                case 247 -> 239;
                case 248 -> 10;
                case 249 -> 72;
                case 250 -> 85;
                case 251 -> 21;
                case 252 -> 37;
                case 253 -> 133;
                case 254 -> 18;
                default -> 155;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.b[n5] = new String(cArray).intern();
        }
        return b[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 5857096098280L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1239266850 + -30028, -1239266850 + -((char)-21643), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 97735419988940L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.w();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-855756030 + -29771, -855756030 + -20510, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-855756030 + -29774, 855756030 + (char)-21192, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-855756030 + -29773, 855756030 + (char)-23186, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00eb\u00ddXN\u0094\u008f\u00c3\u001d\u0010;W\u00b3\u00beS*\u00c2\u00f0*\u001bW\u00f5\u00e3\u00c2p|";
                    var4_3 = "\u00eb\u00ddXN\u0094\u008f\u00c3\u001d\u0010;W\u00b3\u00beS*\u00c2\u00f0*\u001bW\u00f5\u00e3\u00c2p|".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 88;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008b\u00c6\u00a2\u00dbM5E\u00adl\u00daFi\u008e\u00c5\"\u00f02\u00beN\u00b76\u00ae}s\u00c2\u00cbR\u00d4\u001fL\u00e8\u0001\u0088d\u00c7Es\u009bw\u0088+\u000f\"\u00fdQ\u00b0\r\u001b\u00c3\u00de\u00911K{\u00f6=\u009aq^";
                        var4_3 = "\u008b\u00c6\u00a2\u00dbM5E\u00adl\u00daFi\u008e\u00c5\"\u00f02\u00beN\u00b76\u00ae}s\u00c2\u00cbR\u00d4\u001fL\u00e8\u0001\u0088d\u00c7Es\u009bw\u0088+\u000f\"\u00fdQ\u00b0\r\u001b\u00c3\u00de\u00911K{\u00f6=\u009aq^".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 5;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 57;
                                break;
                            }
                            case 1: {
                                v15 = 20;
                                break;
                            }
                            case 2: {
                                v15 = 95;
                                break;
                            }
                            case 3: {
                                v15 = 5;
                                break;
                            }
                            case 4: {
                                v15 = 9;
                                break;
                            }
                            case 5: {
                                v15 = 29;
                                break;
                            }
                            default: {
                                v15 = 13;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x357A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 50;
                    case 1 -> 82;
                    case 2 -> 237;
                    case 3 -> 108;
                    case 4 -> 31;
                    case 5 -> 248;
                    case 6 -> 210;
                    case 7 -> 214;
                    case 8 -> 114;
                    case 9 -> 48;
                    case 10 -> 98;
                    case 11 -> 219;
                    case 12 -> 21;
                    case 13 -> 242;
                    case 14 -> 148;
                    case 15 -> 224;
                    case 16 -> 180;
                    case 17 -> 222;
                    case 18 -> 57;
                    case 19 -> 104;
                    case 20 -> 165;
                    case 21 -> 183;
                    case 22 -> 230;
                    case 23 -> 211;
                    case 24 -> 162;
                    case 25 -> 177;
                    case 26 -> 160;
                    case 27 -> 193;
                    case 28 -> 163;
                    case 29 -> 159;
                    case 30 -> 173;
                    case 31 -> 84;
                    case 32 -> 171;
                    case 33 -> 112;
                    case 34 -> 153;
                    case 35 -> 125;
                    case 36 -> 200;
                    case 37 -> 234;
                    case 38 -> 204;
                    case 39 -> 86;
                    case 40 -> 38;
                    case 41 -> 62;
                    case 42 -> 206;
                    case 43 -> 111;
                    case 44 -> 26;
                    case 45 -> 156;
                    case 46 -> 15;
                    case 47 -> 184;
                    case 48 -> 198;
                    case 49 -> 41;
                    case 50 -> 179;
                    case 51 -> 250;
                    case 52 -> 209;
                    case 53 -> 151;
                    case 54 -> 18;
                    case 55 -> 118;
                    case 56 -> 75;
                    case 57 -> 130;
                    case 58 -> 46;
                    case 59 -> 229;
                    case 60 -> 129;
                    case 61 -> 140;
                    case 62 -> 191;
                    case 63 -> 19;
                    case 64 -> 228;
                    case 65 -> 109;
                    case 66 -> 56;
                    case 67 -> 220;
                    case 68 -> 134;
                    case 69 -> 119;
                    case 70 -> 22;
                    case 71 -> 164;
                    case 72 -> 149;
                    case 73 -> 121;
                    case 74 -> 28;
                    case 75 -> 170;
                    case 76 -> 136;
                    case 77 -> 81;
                    case 78 -> 221;
                    case 79 -> 47;
                    case 80 -> 65;
                    case 81 -> 132;
                    case 82 -> 101;
                    case 83 -> 202;
                    case 84 -> 212;
                    case 85 -> 58;
                    case 86 -> 155;
                    case 87 -> 35;
                    case 88 -> 30;
                    case 89 -> 74;
                    case 90 -> 235;
                    case 91 -> 53;
                    case 92 -> 244;
                    case 93 -> 126;
                    case 94 -> 203;
                    case 95 -> 5;
                    case 96 -> 64;
                    case 97 -> 143;
                    case 98 -> 1;
                    case 99 -> 87;
                    case 100 -> 76;
                    case 101 -> 192;
                    case 102 -> 207;
                    case 103 -> 83;
                    case 104 -> 187;
                    case 105 -> 110;
                    case 106 -> 3;
                    case 107 -> 225;
                    case 108 -> 68;
                    case 109 -> 8;
                    case 110 -> 169;
                    case 111 -> 185;
                    case 112 -> 103;
                    case 113 -> 94;
                    case 114 -> 223;
                    case 115 -> 24;
                    case 116 -> 116;
                    case 117 -> 107;
                    case 118 -> 146;
                    case 119 -> 49;
                    case 120 -> 97;
                    case 121 -> 93;
                    case 122 -> 12;
                    case 123 -> 240;
                    case 124 -> 167;
                    case 125 -> 40;
                    case 126 -> 72;
                    case 127 -> 59;
                    case 128 -> 63;
                    case 129 -> 168;
                    case 130 -> 190;
                    case 131 -> 236;
                    case 132 -> 227;
                    case 133 -> 66;
                    case 134 -> 195;
                    case 135 -> 152;
                    case 136 -> 60;
                    case 137 -> 128;
                    case 138 -> 135;
                    case 139 -> 141;
                    case 140 -> 157;
                    case 141 -> 113;
                    case 142 -> 13;
                    case 143 -> 246;
                    case 144 -> 45;
                    case 145 -> 6;
                    case 146 -> 36;
                    case 147 -> 181;
                    case 148 -> 174;
                    case 149 -> 80;
                    case 150 -> 172;
                    case 151 -> 161;
                    case 152 -> 197;
                    case 153 -> 70;
                    case 154 -> 92;
                    case 155 -> 255;
                    case 156 -> 0;
                    case 157 -> 16;
                    case 158 -> 33;
                    case 159 -> 55;
                    case 160 -> 91;
                    case 161 -> 2;
                    case 162 -> 213;
                    case 163 -> 7;
                    case 164 -> 120;
                    case 165 -> 89;
                    case 166 -> 52;
                    case 167 -> 25;
                    case 168 -> 147;
                    case 169 -> 39;
                    case 170 -> 217;
                    case 171 -> 189;
                    case 172 -> 188;
                    case 173 -> 139;
                    case 174 -> 37;
                    case 175 -> 90;
                    case 176 -> 166;
                    case 177 -> 251;
                    case 178 -> 88;
                    case 179 -> 178;
                    case 180 -> 131;
                    case 181 -> 34;
                    case 182 -> 127;
                    case 183 -> 51;
                    case 184 -> 175;
                    case 185 -> 71;
                    case 186 -> 85;
                    case 187 -> 216;
                    case 188 -> 150;
                    case 189 -> 115;
                    case 190 -> 138;
                    case 191 -> 73;
                    case 192 -> 27;
                    case 193 -> 215;
                    case 194 -> 231;
                    case 195 -> 247;
                    case 196 -> 10;
                    case 197 -> 145;
                    case 198 -> 199;
                    case 199 -> 106;
                    case 200 -> 194;
                    case 201 -> 124;
                    case 202 -> 79;
                    case 203 -> 238;
                    case 204 -> 100;
                    case 205 -> 4;
                    case 206 -> 99;
                    case 207 -> 29;
                    case 208 -> 54;
                    case 209 -> 14;
                    case 210 -> 252;
                    case 211 -> 218;
                    case 212 -> 137;
                    case 213 -> 249;
                    case 214 -> 144;
                    case 215 -> 95;
                    case 216 -> 158;
                    case 217 -> 78;
                    case 218 -> 226;
                    case 219 -> 44;
                    case 220 -> 69;
                    case 221 -> 154;
                    case 222 -> 9;
                    case 223 -> 232;
                    case 224 -> 253;
                    case 225 -> 201;
                    case 226 -> 67;
                    case 227 -> 133;
                    case 228 -> 105;
                    case 229 -> 123;
                    case 230 -> 186;
                    case 231 -> 233;
                    case 232 -> 17;
                    case 233 -> 243;
                    case 234 -> 205;
                    case 235 -> 20;
                    case 236 -> 142;
                    case 237 -> 239;
                    case 238 -> 176;
                    case 239 -> 77;
                    case 240 -> 102;
                    case 241 -> 32;
                    case 242 -> 182;
                    case 243 -> 11;
                    case 244 -> 122;
                    case 245 -> 96;
                    case 246 -> 254;
                    case 247 -> 241;
                    case 248 -> 42;
                    case 249 -> 117;
                    case 250 -> 61;
                    case 251 -> 196;
                    case 252 -> 245;
                    case 253 -> 23;
                    case 254 -> 208;
                    default -> 43;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 107258725186923L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = " fB\u0011ex$y\t'lQ\u001b(:9e*";
                    var5_4 = " fB\u0011ex$y\t'lQ\u001b(:9e*".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 9;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 66;
                                    break;
                                }
                                case 1: {
                                    v11 = 10;
                                    break;
                                }
                                case 2: {
                                    v11 = 57;
                                    break;
                                }
                                case 3: {
                                    v11 = 118;
                                    break;
                                }
                                case 4: {
                                    v11 = 9;
                                    break;
                                }
                                case 5: {
                                    v11 = 29;
                                    break;
                                }
                                default: {
                                    v11 = 30;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 22327939128224L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "aJ/i!kG\u0004gT#s\nkK(s-i_AJ!\tkK(s-i_M@\rlM5~'dEMG2t&m";
                    var5_4 = "aJ/i!kG\u0004gT#s\nkK(s-i_AJ!\tkK(s-i_M@\rlM5~'dEMG2t&m".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0002!@\u0007H\r%\u0006\u0002!@\u0007D\u0007";
                        var5_4 = "\u0002!@\u0007H\r%\u0006\u0002!@\u0007D\u0007".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 43;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 106;
                                break;
                            }
                            case 1: {
                                v15 = 102;
                                break;
                            }
                            case 2: {
                                v15 = 4;
                                break;
                            }
                            case 3: {
                                v15 = 95;
                                break;
                            }
                            case 4: {
                                v15 = 10;
                                break;
                            }
                            case 5: {
                                v15 = 72;
                                break;
                            }
                            default: {
                                v15 = 105;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 116031062617624L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1773901380 - (char)-24683, -1773901380 - -((char)-17565), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 60113683927437L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "J>\u001a\u00de\u0017\u00032\u000b\u00a1\u0005 \u009cqN\u0099\r\u00ed\u00ad\u00fe\"\u009dN\u00db\u00f9\u00eb\u00ee\u00a4^\u0019\u0010\u009c\u00e4\u0017\u00e0\u009f\u0083\u00b0}O\u00fa\u00d3\u0091\u0011\u00a5\u0096\u00bb\u0005\u00bcc\u00e2\u00b1\u00eb3\u00f6\u00cc\u00ba3\u00ff\u00bd\u008c\u00ae\u00b5}\u0007HM\u00cf1\u00e9\u000b^\u00d5\u00fa\n\u00ba\u00af\u00af\u00ebL\u0095\u0086\u0094p\u0080\u00bef\u001e\u00f4\u00f8\u00fe\u00e7\u00a4W\u00ba\u00a0jFs\u008e\u00d72\u00f1jW";
                    var4_3 = "J>\u001a\u00de\u0017\u00032\u000b\u00a1\u0005 \u009cqN\u0099\r\u00ed\u00ad\u00fe\"\u009dN\u00db\u00f9\u00eb\u00ee\u00a4^\u0019\u0010\u009c\u00e4\u0017\u00e0\u009f\u0083\u00b0}O\u00fa\u00d3\u0091\u0011\u00a5\u0096\u00bb\u0005\u00bcc\u00e2\u00b1\u00eb3\u00f6\u00cc\u00ba3\u00ff\u00bd\u008c\u00ae\u00b5}\u0007HM\u00cf1\u00e9\u000b^\u00d5\u00fa\n\u00ba\u00af\u00af\u00ebL\u0095\u0086\u0094p\u0080\u00bef\u001e\u00f4\u00f8\u00fe\u00e7\u00a4W\u00ba\u00a0jFs\u008e\u00d72\u00f1jW".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 22;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e7We\u008b\u00cc\u00f3\u00c7n\u00bc\u0085\u00b0c`\u00e6\u00a5\u00ceL\u001d\u0098\u00cd\u00b8\u00f3]N\u00d5\u0004a\u000bF\u0019\u00cc\u0019\u00f2\u0016\u00f1\u0094\u00e4W\u00003GF\u00a7\u0018 \u00c2\u00f0\u00b8\u00dcl\u00a1\u00d9\u000et\u00fa\u00d2\u008f_[\u0004Y\u00b6\u00ae\u00b9\u0013\u00d3g\u00e6\u0015x\u00f0\u00dc5):\u00dc\u00e3\u00d5\u00bd\\D\u0006JB]ZT'1>\u00b6\u009c\u009b";
                        var4_3 = "\u00e7We\u008b\u00cc\u00f3\u00c7n\u00bc\u0085\u00b0c`\u00e6\u00a5\u00ceL\u001d\u0098\u00cd\u00b8\u00f3]N\u00d5\u0004a\u000bF\u0019\u00cc\u0019\u00f2\u0016\u00f1\u0094\u00e4W\u00003GF\u00a7\u0018 \u00c2\u00f0\u00b8\u00dcl\u00a1\u00d9\u000et\u00fa\u00d2\u008f_[\u0004Y\u00b6\u00ae\u00b9\u0013\u00d3g\u00e6\u0015x\u00f0\u00dc5):\u00dc\u00e3\u00d5\u00bd\\D\u0006JB]ZT'1>\u00b6\u009c\u009b".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 101;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 38;
                                break;
                            }
                            case 1: {
                                v15 = 80;
                                break;
                            }
                            case 2: {
                                v15 = 107;
                                break;
                            }
                            case 3: {
                                v15 = 34;
                                break;
                            }
                            case 4: {
                                v15 = 80;
                                break;
                            }
                            case 5: {
                                v15 = 28;
                                break;
                            }
                            default: {
                                v15 = 74;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD8B7) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 156;
                    case 1 -> 186;
                    case 2 -> 127;
                    case 3 -> 115;
                    case 4 -> 240;
                    case 5 -> 182;
                    case 6 -> 205;
                    case 7 -> 46;
                    case 8 -> 95;
                    case 9 -> 69;
                    case 10 -> 214;
                    case 11 -> 131;
                    case 12 -> 171;
                    case 13 -> 124;
                    case 14 -> 58;
                    case 15 -> 10;
                    case 16 -> 200;
                    case 17 -> 67;
                    case 18 -> 18;
                    case 19 -> 152;
                    case 20 -> 51;
                    case 21 -> 50;
                    case 22 -> 133;
                    case 23 -> 30;
                    case 24 -> 128;
                    case 25 -> 44;
                    case 26 -> 246;
                    case 27 -> 54;
                    case 28 -> 148;
                    case 29 -> 13;
                    case 30 -> 175;
                    case 31 -> 203;
                    case 32 -> 98;
                    case 33 -> 143;
                    case 34 -> 62;
                    case 35 -> 167;
                    case 36 -> 107;
                    case 37 -> 33;
                    case 38 -> 61;
                    case 39 -> 198;
                    case 40 -> 91;
                    case 41 -> 22;
                    case 42 -> 206;
                    case 43 -> 81;
                    case 44 -> 75;
                    case 45 -> 232;
                    case 46 -> 12;
                    case 47 -> 220;
                    case 48 -> 199;
                    case 49 -> 76;
                    case 50 -> 34;
                    case 51 -> 80;
                    case 52 -> 238;
                    case 53 -> 243;
                    case 54 -> 204;
                    case 55 -> 141;
                    case 56 -> 103;
                    case 57 -> 178;
                    case 58 -> 210;
                    case 59 -> 47;
                    case 60 -> 181;
                    case 61 -> 215;
                    case 62 -> 237;
                    case 63 -> 40;
                    case 64 -> 116;
                    case 65 -> 19;
                    case 66 -> 110;
                    case 67 -> 140;
                    case 68 -> 244;
                    case 69 -> 201;
                    case 70 -> 57;
                    case 71 -> 253;
                    case 72 -> 195;
                    case 73 -> 149;
                    case 74 -> 193;
                    case 75 -> 160;
                    case 76 -> 35;
                    case 77 -> 56;
                    case 78 -> 157;
                    case 79 -> 31;
                    case 80 -> 111;
                    case 81 -> 173;
                    case 82 -> 112;
                    case 83 -> 192;
                    case 84 -> 23;
                    case 85 -> 16;
                    case 86 -> 8;
                    case 87 -> 7;
                    case 88 -> 36;
                    case 89 -> 230;
                    case 90 -> 59;
                    case 91 -> 229;
                    case 92 -> 151;
                    case 93 -> 216;
                    case 94 -> 187;
                    case 95 -> 174;
                    case 96 -> 245;
                    case 97 -> 138;
                    case 98 -> 123;
                    case 99 -> 71;
                    case 100 -> 234;
                    case 101 -> 3;
                    case 102 -> 99;
                    case 103 -> 172;
                    case 104 -> 227;
                    case 105 -> 219;
                    case 106 -> 242;
                    case 107 -> 222;
                    case 108 -> 109;
                    case 109 -> 70;
                    case 110 -> 108;
                    case 111 -> 129;
                    case 112 -> 252;
                    case 113 -> 83;
                    case 114 -> 55;
                    case 115 -> 179;
                    case 116 -> 169;
                    case 117 -> 150;
                    case 118 -> 159;
                    case 119 -> 176;
                    case 120 -> 102;
                    case 121 -> 177;
                    case 122 -> 236;
                    case 123 -> 101;
                    case 124 -> 125;
                    case 125 -> 5;
                    case 126 -> 105;
                    case 127 -> 119;
                    case 128 -> 86;
                    case 129 -> 97;
                    case 130 -> 164;
                    case 131 -> 24;
                    case 132 -> 139;
                    case 133 -> 117;
                    case 134 -> 60;
                    case 135 -> 163;
                    case 136 -> 235;
                    case 137 -> 250;
                    case 138 -> 45;
                    case 139 -> 208;
                    case 140 -> 168;
                    case 141 -> 1;
                    case 142 -> 120;
                    case 143 -> 224;
                    case 144 -> 166;
                    case 145 -> 226;
                    case 146 -> 209;
                    case 147 -> 239;
                    case 148 -> 9;
                    case 149 -> 155;
                    case 150 -> 135;
                    case 151 -> 106;
                    case 152 -> 197;
                    case 153 -> 90;
                    case 154 -> 114;
                    case 155 -> 73;
                    case 156 -> 82;
                    case 157 -> 228;
                    case 158 -> 42;
                    case 159 -> 37;
                    case 160 -> 147;
                    case 161 -> 130;
                    case 162 -> 94;
                    case 163 -> 136;
                    case 164 -> 43;
                    case 165 -> 121;
                    case 166 -> 218;
                    case 167 -> 32;
                    case 168 -> 189;
                    case 169 -> 65;
                    case 170 -> 88;
                    case 171 -> 217;
                    case 172 -> 63;
                    case 173 -> 122;
                    case 174 -> 38;
                    case 175 -> 223;
                    case 176 -> 146;
                    case 177 -> 100;
                    case 178 -> 74;
                    case 179 -> 196;
                    case 180 -> 194;
                    case 181 -> 225;
                    case 182 -> 191;
                    case 183 -> 39;
                    case 184 -> 153;
                    case 185 -> 17;
                    case 186 -> 25;
                    case 187 -> 2;
                    case 188 -> 6;
                    case 189 -> 142;
                    case 190 -> 134;
                    case 191 -> 188;
                    case 192 -> 183;
                    case 193 -> 233;
                    case 194 -> 254;
                    case 195 -> 0;
                    case 196 -> 207;
                    case 197 -> 4;
                    case 198 -> 145;
                    case 199 -> 165;
                    case 200 -> 68;
                    case 201 -> 92;
                    case 202 -> 49;
                    case 203 -> 247;
                    case 204 -> 14;
                    case 205 -> 185;
                    case 206 -> 212;
                    case 207 -> 85;
                    case 208 -> 89;
                    case 209 -> 161;
                    case 210 -> 79;
                    case 211 -> 26;
                    case 212 -> 53;
                    case 213 -> 118;
                    case 214 -> 21;
                    case 215 -> 78;
                    case 216 -> 64;
                    case 217 -> 241;
                    case 218 -> 213;
                    case 219 -> 202;
                    case 220 -> 137;
                    case 221 -> 48;
                    case 222 -> 15;
                    case 223 -> 249;
                    case 224 -> 11;
                    case 225 -> 29;
                    case 226 -> 154;
                    case 227 -> 190;
                    case 228 -> 66;
                    case 229 -> 251;
                    case 230 -> 144;
                    case 231 -> 162;
                    case 232 -> 96;
                    case 233 -> 84;
                    case 234 -> 27;
                    case 235 -> 87;
                    case 236 -> 113;
                    case 237 -> 231;
                    case 238 -> 184;
                    case 239 -> 93;
                    case 240 -> 158;
                    case 241 -> 20;
                    case 242 -> 221;
                    case 243 -> 72;
                    case 244 -> 28;
                    case 245 -> 52;
                    case 246 -> 255;
                    case 247 -> 180;
                    case 248 -> 211;
                    case 249 -> 41;
                    case 250 -> 77;
                    case 251 -> 170;
                    case 252 -> 248;
                    case 253 -> 104;
                    case 254 -> 132;
                    default -> 126;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 61676126318823L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(395962470 - 20055, 395962470 - 22322, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 111269260979831L;
                    int n3 = SshAgentIpcService.X();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-456778950 - -10596, -456778950 + -4619, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 75413529286230L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "F\u00c4\u00ef.\u00a0\u0003D\u00e6\u00f9";
                var4_3 = "F\u00c4\u00ef.\u00a0\u0003D\u00e6\u00f9".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 95;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 29;
                                break;
                            }
                            case 1: {
                                v11 = 79;
                                break;
                            }
                            case 2: {
                                v11 = 24;
                                break;
                            }
                            case 3: {
                                v11 = 14;
                                break;
                            }
                            case 4: {
                                v11 = 87;
                                break;
                            }
                            case 5: {
                                v11 = 126;
                                break;
                            }
                            default: {
                                v11 = 81;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2AE8) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 208;
                    case 1 -> 3;
                    case 2 -> 61;
                    case 3 -> 182;
                    case 4 -> 110;
                    case 5 -> 254;
                    case 6 -> 227;
                    case 7 -> 189;
                    case 8 -> 247;
                    case 9 -> 123;
                    case 10 -> 77;
                    case 11 -> 223;
                    case 12 -> 26;
                    case 13 -> 67;
                    case 14 -> 159;
                    case 15 -> 235;
                    case 16 -> 168;
                    case 17 -> 83;
                    case 18 -> 183;
                    case 19 -> 184;
                    case 20 -> 233;
                    case 21 -> 58;
                    case 22 -> 74;
                    case 23 -> 194;
                    case 24 -> 178;
                    case 25 -> 92;
                    case 26 -> 216;
                    case 27 -> 185;
                    case 28 -> 245;
                    case 29 -> 242;
                    case 30 -> 152;
                    case 31 -> 32;
                    case 32 -> 252;
                    case 33 -> 30;
                    case 34 -> 240;
                    case 35 -> 23;
                    case 36 -> 206;
                    case 37 -> 132;
                    case 38 -> 229;
                    case 39 -> 121;
                    case 40 -> 190;
                    case 41 -> 214;
                    case 42 -> 116;
                    case 43 -> 13;
                    case 44 -> 51;
                    case 45 -> 139;
                    case 46 -> 2;
                    case 47 -> 114;
                    case 48 -> 62;
                    case 49 -> 34;
                    case 50 -> 128;
                    case 51 -> 217;
                    case 52 -> 138;
                    case 53 -> 248;
                    case 54 -> 134;
                    case 55 -> 133;
                    case 56 -> 85;
                    case 57 -> 129;
                    case 58 -> 19;
                    case 59 -> 212;
                    case 60 -> 144;
                    case 61 -> 166;
                    case 62 -> 50;
                    case 63 -> 126;
                    case 64 -> 149;
                    case 65 -> 234;
                    case 66 -> 140;
                    case 67 -> 237;
                    case 68 -> 70;
                    case 69 -> 225;
                    case 70 -> 203;
                    case 71 -> 219;
                    case 72 -> 59;
                    case 73 -> 145;
                    case 74 -> 250;
                    case 75 -> 49;
                    case 76 -> 130;
                    case 77 -> 60;
                    case 78 -> 24;
                    case 79 -> 37;
                    case 80 -> 27;
                    case 81 -> 192;
                    case 82 -> 33;
                    case 83 -> 5;
                    case 84 -> 171;
                    case 85 -> 161;
                    case 86 -> 40;
                    case 87 -> 224;
                    case 88 -> 100;
                    case 89 -> 101;
                    case 90 -> 8;
                    case 91 -> 188;
                    case 92 -> 53;
                    case 93 -> 55;
                    case 94 -> 136;
                    case 95 -> 148;
                    case 96 -> 181;
                    case 97 -> 125;
                    case 98 -> 239;
                    case 99 -> 255;
                    case 100 -> 20;
                    case 101 -> 204;
                    case 102 -> 105;
                    case 103 -> 39;
                    case 104 -> 71;
                    case 105 -> 196;
                    case 106 -> 151;
                    case 107 -> 118;
                    case 108 -> 177;
                    case 109 -> 31;
                    case 110 -> 201;
                    case 111 -> 163;
                    case 112 -> 113;
                    case 113 -> 213;
                    case 114 -> 103;
                    case 115 -> 164;
                    case 116 -> 170;
                    case 117 -> 211;
                    case 118 -> 1;
                    case 119 -> 111;
                    case 120 -> 6;
                    case 121 -> 175;
                    case 122 -> 91;
                    case 123 -> 47;
                    case 124 -> 198;
                    case 125 -> 72;
                    case 126 -> 18;
                    case 127 -> 28;
                    case 128 -> 14;
                    case 129 -> 68;
                    case 130 -> 52;
                    case 131 -> 46;
                    case 132 -> 86;
                    case 133 -> 97;
                    case 134 -> 9;
                    case 135 -> 191;
                    case 136 -> 35;
                    case 137 -> 243;
                    case 138 -> 89;
                    case 139 -> 174;
                    case 140 -> 99;
                    case 141 -> 205;
                    case 142 -> 104;
                    case 143 -> 38;
                    case 144 -> 124;
                    case 145 -> 98;
                    case 146 -> 119;
                    case 147 -> 65;
                    case 148 -> 88;
                    case 149 -> 25;
                    case 150 -> 221;
                    case 151 -> 141;
                    case 152 -> 112;
                    case 153 -> 95;
                    case 154 -> 21;
                    case 155 -> 207;
                    case 156 -> 120;
                    case 157 -> 109;
                    case 158 -> 238;
                    case 159 -> 222;
                    case 160 -> 79;
                    case 161 -> 45;
                    case 162 -> 66;
                    case 163 -> 43;
                    case 164 -> 200;
                    case 165 -> 241;
                    case 166 -> 36;
                    case 167 -> 165;
                    case 168 -> 179;
                    case 169 -> 158;
                    case 170 -> 162;
                    case 171 -> 115;
                    case 172 -> 142;
                    case 173 -> 253;
                    case 174 -> 17;
                    case 175 -> 82;
                    case 176 -> 93;
                    case 177 -> 90;
                    case 178 -> 64;
                    case 179 -> 84;
                    case 180 -> 209;
                    case 181 -> 76;
                    case 182 -> 11;
                    case 183 -> 230;
                    case 184 -> 29;
                    case 185 -> 81;
                    case 186 -> 16;
                    case 187 -> 107;
                    case 188 -> 202;
                    case 189 -> 80;
                    case 190 -> 146;
                    case 191 -> 15;
                    case 192 -> 7;
                    case 193 -> 232;
                    case 194 -> 150;
                    case 195 -> 4;
                    case 196 -> 228;
                    case 197 -> 180;
                    case 198 -> 160;
                    case 199 -> 173;
                    case 200 -> 48;
                    case 201 -> 102;
                    case 202 -> 122;
                    case 203 -> 244;
                    case 204 -> 96;
                    case 205 -> 156;
                    case 206 -> 127;
                    case 207 -> 226;
                    case 208 -> 197;
                    case 209 -> 199;
                    case 210 -> 137;
                    case 211 -> 78;
                    case 212 -> 210;
                    case 213 -> 12;
                    case 214 -> 75;
                    case 215 -> 143;
                    case 216 -> 41;
                    case 217 -> 154;
                    case 218 -> 167;
                    case 219 -> 249;
                    case 220 -> 176;
                    case 221 -> 169;
                    case 222 -> 10;
                    case 223 -> 215;
                    case 224 -> 42;
                    case 225 -> 0;
                    case 226 -> 108;
                    case 227 -> 246;
                    case 228 -> 193;
                    case 229 -> 87;
                    case 230 -> 22;
                    case 231 -> 147;
                    case 232 -> 195;
                    case 233 -> 172;
                    case 234 -> 73;
                    case 235 -> 63;
                    case 236 -> 131;
                    case 237 -> 106;
                    case 238 -> 218;
                    case 239 -> 94;
                    case 240 -> 117;
                    case 241 -> 135;
                    case 242 -> 44;
                    case 243 -> 186;
                    case 244 -> 251;
                    case 245 -> 231;
                    case 246 -> 54;
                    case 247 -> 236;
                    case 248 -> 220;
                    case 249 -> 187;
                    case 250 -> 153;
                    case 251 -> 157;
                    case 252 -> 56;
                    case 253 -> 69;
                    case 254 -> 57;
                    default -> 155;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

