/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\u0005H\u0014J\b\u0010(\u001a\u00020\u0005H\u0014J\b\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0013\u0010\"\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubCreateGistDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "secret", "", "openInBrowser", "copyLink", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ZZZ)V", "fileNameField", "Lcom/intellij/ui/components/JBTextField;", "descriptionField", "Lcom/intellij/ui/components/JBTextArea;", "secretCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "browserCheckBox", "copyLinkCheckBox", "accounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "accountsModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "kotlin.jvm.PlatformType", "getFileName", "()Ljava/lang/String;", "description", "getDescription", "isSecret", "()Z", "isOpenInBrowser", "isCopyURL", "account", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getHelpId", "getDimensionServiceKey", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubCreateGistDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubCreateGistDialog.kt\norg/jetbrains/plugins/github/ui/GithubCreateGistDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class GithubCreateGistDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @Nullable
    private final JBTextField fileNameField;
    @NotNull
    private final JBTextArea descriptionField;
    @NotNull
    private final JBCheckBox secretCheckBox;
    @NotNull
    private final JBCheckBox browserCheckBox;
    @NotNull
    private final JBCheckBox copyLinkCheckBox;
    @NotNull
    private final Set<GithubAccount> accounts;
    @NotNull
    private final CollectionComboBoxModel<GithubAccount> accountsModel;

    /*
     * WARNING - void declaration
     */
    public GithubCreateGistDialog(@NotNull Project project, @NlsSafe @Nullable String fileName, boolean secret, boolean openInBrowser, boolean copyLink) {
        void $this$descriptionField_u24lambda_u240;
        JBTextArea jBTextArea;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
        this.project = project;
        this.fileNameField = fileName != null ? new JBTextField(fileName) : null;
        JBTextArea jBTextArea2 = jBTextArea = new JBTextArea();
        GithubCreateGistDialog githubCreateGistDialog = this;
        boolean bl = false;
        $this$descriptionField_u24lambda_u240.setLineWrap(true);
        githubCreateGistDialog.descriptionField = jBTextArea;
        this.secretCheckBox = new JBCheckBox(GithubBundle.message("create.gist.dialog.secret", new Object[0]), secret);
        this.browserCheckBox = new JBCheckBox(GithubBundle.message("create.gist.dialog.open.browser", new Object[0]), openInBrowser);
        this.copyLinkCheckBox = new JBCheckBox(GithubBundle.message("create.gist.dialog.copy.url", new Object[0]), copyLink);
        this.accounts = GHAccountsUtil.getAccounts();
        List list = CollectionsKt.toMutableList((Collection)this.accounts);
        GithubAccount githubAccount = GHAccountsUtil.getDefaultAccount(this.project);
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.firstOrNull((Iterable)this.accounts));
        }
        this.accountsModel = new CollectionComboBoxModel(list, (Object)githubAccount);
        this.setTitle(GithubBundle.message("create.gist.dialog.title", new Object[0]));
        this.init();
    }

    @Nullable
    public final String getFileName() {
        JBTextField jBTextField = this.fileNameField;
        return jBTextField != null ? jBTextField.getText() : null;
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final boolean isSecret() {
        return this.secretCheckBox.isSelected();
    }

    public final boolean isOpenInBrowser() {
        return this.browserCheckBox.isSelected();
    }

    public final boolean isCopyURL() {
        return this.copyLinkCheckBox.isSelected();
    }

    @Nullable
    public final GithubAccount getAccount() {
        return (GithubAccount)((Object)this.accountsModel.getSelected());
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel(arg_0 -> GithubCreateGistDialog.createCenterPanel$lambda$7(this, arg_0));
    }

    @NotNull
    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.descriptionField;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$2$lambda$1(JBTextField $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$it).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3(GithubCreateGistDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GithubBundle.message("create.gist.dialog.description.field", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).align((Align)AlignY.TOP.INSTANCE);
        $this$row.scrollCell((JComponent)this$0.descriptionField).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4(GithubCreateGistDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.secretCheckBox);
        $this$row.cell((JComponent)this$0.browserCheckBox);
        $this$row.cell((JComponent)this$0.copyLinkCheckBox);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$7$lambda$6$lambda$5(GithubCreateGistDialog this$0, ValidationInfoBuilder $this$validationOnApply, ComboBox it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.accountsModel.getSelected() == null) {
            String string = GithubBundle.message("dialog.message.account.cannot.be.empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validationOnApply.error(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(GithubCreateGistDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.accountsModel), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubCreateGistDialog.createCenterPanel$lambda$7$lambda$6$lambda$5(this$0, arg_0, arg_1)).resizableColumn();
        if (this$0.accountsModel.getSize() == 0) {
            $this$row.cell((JComponent)GHAccountsUtil.INSTANCE.createAddAccountLink(this$0.project, this$0.accountsModel));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7(GithubCreateGistDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        JBTextField jBTextField = this$0.fileNameField;
        if (jBTextField != null) {
            JBTextField it = jBTextField;
            boolean bl = false;
            String string = GithubBundle.message("create.gist.dialog.filename.field", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> GithubCreateGistDialog.createCenterPanel$lambda$7$lambda$2$lambda$1(it, arg_0));
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GithubCreateGistDialog.createCenterPanel$lambda$7$lambda$3(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED).resizableRow();
        $this$panel.row("", arg_0 -> GithubCreateGistDialog.createCenterPanel$lambda$7$lambda$4(this$0, arg_0));
        if (this$0.accountsModel.getSize() != 1) {
            String string = GithubBundle.message("create.gist.dialog.create.for.field", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> GithubCreateGistDialog.createCenterPanel$lambda$7$lambda$6(this$0, arg_0));
        }
        return Unit.INSTANCE;
    }
}

