/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.lib.ResolverFactory;
import com.intellij.debugger.streams.resolve.ResolvedStreamCall;
import com.intellij.debugger.streams.resolve.ResolvedStreamChain;
import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.resolve.impl.ResolvedIntermediateCallImpl;
import com.intellij.debugger.streams.resolve.impl.ResolvedStreamChainImpl;
import com.intellij.debugger.streams.resolve.impl.ResolvedTerminatorCallImpl;
import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.FirstStateImpl;
import com.intellij.debugger.streams.trace.impl.IntermediateStateImpl;
import com.intellij.debugger.streams.trace.impl.TerminationStateImpl;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TracingResultImpl
implements TracingResult {
    private final TraceElement myStreamResult;
    private final List<TraceInfo> myTrace;
    private final boolean myIsResultException;
    private final StreamChain mySourceChain;

    TracingResultImpl(@NotNull StreamChain chain, @NotNull TraceElement streamResult, @NotNull List<TraceInfo> trace, boolean isResultException) {
        if (chain == null) {
            TracingResultImpl.$$$reportNull$$$0(0);
        }
        if (streamResult == null) {
            TracingResultImpl.$$$reportNull$$$0(1);
        }
        if (trace == null) {
            TracingResultImpl.$$$reportNull$$$0(2);
        }
        this.myStreamResult = streamResult;
        this.myTrace = trace;
        this.mySourceChain = chain;
        this.myIsResultException = isResultException;
    }

    @Override
    @NotNull
    public TraceElement getResult() {
        TraceElement traceElement = this.myStreamResult;
        if (traceElement == null) {
            TracingResultImpl.$$$reportNull$$$0(3);
        }
        return traceElement;
    }

    @Override
    public boolean exceptionThrown() {
        return this.myIsResultException;
    }

    @Override
    @NotNull
    public List<TraceInfo> getTrace() {
        List<TraceInfo> list = this.myTrace;
        if (list == null) {
            TracingResultImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public ResolvedTracingResult resolve(@NotNull ResolverFactory resolverFactory2) {
        if (resolverFactory2 == null) {
            TracingResultImpl.$$$reportNull$$$0(5);
        }
        assert (this.myTrace.size() == this.mySourceChain.length());
        List resolvedTraces = ContainerUtil.map(this.myTrace, x -> resolverFactory2.getResolver(x.getCall().getName()).resolve((TraceInfo)x));
        TraceInfo firstCallTrace = this.myTrace.get(0);
        List<IntermediateStreamCall> intermediateCalls = this.mySourceChain.getIntermediateCalls();
        ResolvedStreamChainImpl.Builder chainBuilder = new ResolvedStreamChainImpl.Builder();
        List<TraceElement> valuesBeforeFirstCall = TraceUtil.sortedByTime(firstCallTrace.getValuesOrderBefore().values());
        FirstStateImpl firstState = new FirstStateImpl(valuesBeforeFirstCall, firstCallTrace.getCall(), ((ValuesOrderResolver.Result)resolvedTraces.get(0)).getDirectOrder());
        if (intermediateCalls.isEmpty()) {
            chainBuilder.setTerminator(this.buildResolvedTerminationCall(this.myTrace.get(0), firstState, ((ValuesOrderResolver.Result)resolvedTraces.get(0)).getReverseOrder()));
        } else {
            int i;
            ArrayList<IntermediateStateImpl> states = new ArrayList<IntermediateStateImpl>();
            for (i = 0; i < intermediateCalls.size() - 1; ++i) {
                states.add(new IntermediateStateImpl(TraceUtil.sortedByTime(this.myTrace.get(i).getValuesOrderAfter().values()), intermediateCalls.get(i), intermediateCalls.get(i + 1), ((ValuesOrderResolver.Result)resolvedTraces.get(i)).getReverseOrder(), ((ValuesOrderResolver.Result)resolvedTraces.get(i + 1)).getDirectOrder()));
            }
            states.add(new IntermediateStateImpl(TraceUtil.sortedByTime(this.myTrace.get(this.myTrace.size() - 1).getValuesOrderBefore().values()), intermediateCalls.get(intermediateCalls.size() - 1), this.mySourceChain.getTerminationCall(), ((ValuesOrderResolver.Result)resolvedTraces.get(resolvedTraces.size() - 2)).getReverseOrder(), ((ValuesOrderResolver.Result)resolvedTraces.get(resolvedTraces.size() - 1)).getDirectOrder()));
            chainBuilder.addIntermediate(new ResolvedIntermediateCallImpl(intermediateCalls.get(0), firstState, (PrevAwareState)states.get(0)));
            for (i = 1; i < states.size(); ++i) {
                chainBuilder.addIntermediate(new ResolvedIntermediateCallImpl(intermediateCalls.get(i), (NextAwareState)states.get(i - 1), (PrevAwareState)states.get(i)));
            }
            chainBuilder.setTerminator(this.buildResolvedTerminationCall(this.myTrace.get(this.myTrace.size() - 1), (NextAwareState)states.get(states.size() - 1), ((ValuesOrderResolver.Result)resolvedTraces.get(resolvedTraces.size() - 1)).getReverseOrder()));
        }
        return new MyResolvedResult(chainBuilder.build());
    }

    private ResolvedStreamCall.Terminator buildResolvedTerminationCall(@NotNull TraceInfo terminatorTrace, @NotNull NextAwareState previousState, @NotNull Map<TraceElement, List<TraceElement>> terminationToPrevMapping) {
        if (terminatorTrace == null) {
            TracingResultImpl.$$$reportNull$$$0(6);
        }
        if (previousState == null) {
            TracingResultImpl.$$$reportNull$$$0(7);
        }
        if (terminationToPrevMapping == null) {
            TracingResultImpl.$$$reportNull$$$0(8);
        }
        List<TraceElement> after = TraceUtil.sortedByTime(terminatorTrace.getValuesOrderAfter().values());
        TerminationStateImpl terminatorState = new TerminationStateImpl(this.myStreamResult, previousState.getNextCall(), after, terminationToPrevMapping);
        return new ResolvedTerminatorCallImpl(this.mySourceChain.getTerminationCall(), previousState, terminatorState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/TracingResultImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminatorTrace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationToPrevMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/TracingResultImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildResolvedTerminationCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private class MyResolvedResult
    implements ResolvedTracingResult {
        @NotNull
        private final ResolvedStreamChain myChain;

        MyResolvedResult(ResolvedStreamChain resolvedStreamChain) {
            if (resolvedStreamChain == null) {
                MyResolvedResult.$$$reportNull$$$0(0);
            }
            this.myChain = resolvedStreamChain;
        }

        @Override
        @NotNull
        public ResolvedStreamChain getResolvedChain() {
            ResolvedStreamChain resolvedStreamChain = this.myChain;
            if (resolvedStreamChain == null) {
                MyResolvedResult.$$$reportNull$$$0(1);
            }
            return resolvedStreamChain;
        }

        @Override
        @NotNull
        public StreamChain getSourceChain() {
            StreamChain streamChain = TracingResultImpl.this.mySourceChain;
            if (streamChain == null) {
                MyResolvedResult.$$$reportNull$$$0(2);
            }
            return streamChain;
        }

        @Override
        public boolean exceptionThrown() {
            return TracingResultImpl.this.myIsResultException;
        }

        @Override
        @NotNull
        public TraceElement getResult() {
            TraceElement traceElement = TracingResultImpl.this.myStreamResult;
            if (traceElement == null) {
                MyResolvedResult.$$$reportNull$$$0(3);
            }
            return traceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedStreamChain";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/trace/impl/TracingResultImpl$MyResolvedResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/trace/impl/TracingResultImpl$MyResolvedResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolvedChain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceChain";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

