/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerGlobals;

public class Maven40TransferListenerAdapter
implements TransferListener {
    protected final MavenServerConsoleIndicatorImpl myIndicator;

    public Maven40TransferListenerAdapter(MavenServerConsoleIndicatorImpl indicator) {
        this.myIndicator = indicator;
    }

    private void checkCanceled() {
        if (this.myIndicator.isCanceled()) {
            throw new MavenProcessCanceledRuntimeException();
        }
    }

    private static String formatResourceName(TransferEvent event) {
        TransferResource resource = event.getResource();
        File file = resource.getFile();
        return (file == null ? resource.getResourceName() : file.getName()) + " [" + resource.getRepositoryUrl() + "]";
    }

    public void transferInitiated(TransferEvent event) {
        this.checkCanceled();
        String eventString = Maven40TransferListenerAdapter.formatResourceName(event);
        this.myIndicator.debug(eventString);
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.transferProgressed(event);
    }

    public void transferProgressed(TransferEvent event) {
        this.checkCanceled();
        TransferResource r = event.getResource();
        long totalLength = r.getContentLength();
        String sizeInfo = totalLength <= 0L ? StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / ?" : StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / " + StringUtilRt.formatFileSize((long)totalLength);
        this.myIndicator.debug(Maven40TransferListenerAdapter.formatResourceName(event) + "  (" + sizeInfo + ')');
        if (totalLength > 0L) {
            this.myIndicator.debug(String.valueOf(Math.floor(100.0 * (double)event.getTransferredBytes() / (double)totalLength)) + "%");
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.myIndicator.warn("Checksum failed: " + Maven40TransferListenerAdapter.formatResourceName(event));
    }

    public void transferSucceeded(TransferEvent event) {
        this.myIndicator.debug("Finished (" + StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + ") " + Maven40TransferListenerAdapter.formatResourceName(event));
        MavenServerGlobals.getDownloadListener().artifactDownloaded(event.getResource().getFile(), event.getResource().getResourceName());
    }

    public void transferFailed(TransferEvent event) {
        if (this.myIndicator.isCanceled()) {
            this.myIndicator.info("Canceling...");
            return;
        }
        this.myIndicator.warn("Failed to download " + Maven40TransferListenerAdapter.formatResourceName(event));
    }
}

